///////////////////////////////////////////////////////////
//  Copyright (c) 1995/2006 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /    Vendor      : Xilinx 
// \  \    \/     Version     : 9.2.2i (J.39)
//  \  \          Description : Xilinx Functional Simulation Library Component
//  /  /                        PCI Express
// /__/   /\      Filename    : X_PCIE_INTERNAL_1_1.v
// \  \  /  \     Timestamp   : Thu Dec 8 2005       
//  \__\/\__ \                    
//                                 
//  Revision:
//    12/08/05 - Initial version.
//    01/09/06 - Added case statement, specify block
//    01/23/06 - Parameter MC updates CR#224562
//    02/23/06 - CR#226003 - Added integer, real parameter type
//             - Updated Header
//    03/29/06 - CR#228056 - Fixed input and ouput connectivity.
//    04/24/06 - CR#230393 - Updated parameters, timing according to the spreadsheets
//    04/28/06 - CR#230712 - Spreadsheet update
//    05/23/06 - CR#231962 - Add buffers for connectivity
//    06/22/06 - CR#233879 - Add parameter bus range
//             - CR#229760 - Missing PERIOD checks added
//    08/14/06 - CR#421379 - PCIE updated to PCIE_INTERNAL_1_1
//                         - spreadsheet updates for parameter default values
//    09/15/06 - CR#423947 - Recrem checks added
//    10/26/06 -           - replaced zero_delay with CLK_DELAY to be consistent with writers (PPC440 update)
//                         - in_delay 50 to 0
//                         - removed recrem checks being printed as $setuphold checks - writer bug
//    06/18/07 - CR#441402 - Negative setup/hold timing check support
//    08/09/07 - CR#446045 - Update assign section to match setuphold _delay to avoid multiple drivers
//  End Revision
///////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module X_PCIE_INTERNAL_1_1 (
	BUSMASTERENABLE,
	CRMDOHOTRESETN,
	CRMPWRSOFTRESETN,
	CRMRXHOTRESETN,
	DLLTXPMDLLPOUTSTANDING,
	INTERRUPTDISABLE,
	IOSPACEENABLE,
	L0ASAUTONOMOUSINITCOMPLETED,
	L0ATTENTIONINDICATORCONTROL,
	L0CFGLOOPBACKACK,
	L0COMPLETERID,
	L0CORRERRMSGRCVD,
	L0DLLASRXSTATE,
	L0DLLASTXSTATE,
	L0DLLERRORVECTOR,
	L0DLLRXACKOUTSTANDING,
	L0DLLTXNONFCOUTSTANDING,
	L0DLLTXOUTSTANDING,
	L0DLLVCSTATUS,
	L0DLUPDOWN,
	L0ERRMSGREQID,
	L0FATALERRMSGRCVD,
	L0FIRSTCFGWRITEOCCURRED,
	L0FWDCORRERROUT,
	L0FWDFATALERROUT,
	L0FWDNONFATALERROUT,
	L0LTSSMSTATE,
	L0MACENTEREDL0,
	L0MACLINKTRAINING,
	L0MACLINKUP,
	L0MACNEGOTIATEDLINKWIDTH,
	L0MACNEWSTATEACK,
	L0MACRXL0SSTATE,
	L0MACUPSTREAMDOWNSTREAM,
	L0MCFOUND,
	L0MSIENABLE0,
	L0MULTIMSGEN0,
	L0NONFATALERRMSGRCVD,
	L0PMEACK,
	L0PMEEN,
	L0PMEREQOUT,
	L0POWERCONTROLLERCONTROL,
	L0POWERINDICATORCONTROL,
	L0PWRINHIBITTRANSFERS,
	L0PWRL1STATE,
	L0PWRL23READYDEVICE,
	L0PWRL23READYSTATE,
	L0PWRSTATE0,
	L0PWRTURNOFFREQ,
	L0PWRTXL0SSTATE,
	L0RECEIVEDASSERTINTALEGACYINT,
	L0RECEIVEDASSERTINTBLEGACYINT,
	L0RECEIVEDASSERTINTCLEGACYINT,
	L0RECEIVEDASSERTINTDLEGACYINT,
	L0RECEIVEDDEASSERTINTALEGACYINT,
	L0RECEIVEDDEASSERTINTBLEGACYINT,
	L0RECEIVEDDEASSERTINTCLEGACYINT,
	L0RECEIVEDDEASSERTINTDLEGACYINT,
	L0RXBEACON,
	L0RXDLLFCCMPLMCCRED,
	L0RXDLLFCCMPLMCUPDATE,
	L0RXDLLFCNPOSTBYPCRED,
	L0RXDLLFCNPOSTBYPUPDATE,
	L0RXDLLFCPOSTORDCRED,
	L0RXDLLFCPOSTORDUPDATE,
	L0RXDLLPM,
	L0RXDLLPMTYPE,
	L0RXDLLSBFCDATA,
	L0RXDLLSBFCUPDATE,
	L0RXDLLTLPECRCOK,
	L0RXDLLTLPEND,
	L0RXMACLINKERROR,
	L0STATSCFGOTHERRECEIVED,
	L0STATSCFGOTHERTRANSMITTED,
	L0STATSCFGRECEIVED,
	L0STATSCFGTRANSMITTED,
	L0STATSDLLPRECEIVED,
	L0STATSDLLPTRANSMITTED,
	L0STATSOSRECEIVED,
	L0STATSOSTRANSMITTED,
	L0STATSTLPRECEIVED,
	L0STATSTLPTRANSMITTED,
	L0TOGGLEELECTROMECHANICALINTERLOCK,
	L0TRANSFORMEDVC,
	L0TXDLLFCCMPLMCUPDATED,
	L0TXDLLFCNPOSTBYPUPDATED,
	L0TXDLLFCPOSTORDUPDATED,
	L0TXDLLPMUPDATED,
	L0TXDLLSBFCUPDATED,
	L0UCBYPFOUND,
	L0UCORDFOUND,
	L0UNLOCKRECEIVED,
	LLKRX4DWHEADERN,
	LLKRXCHCOMPLETIONAVAILABLEN,
	LLKRXCHCOMPLETIONPARTIALN,
	LLKRXCHCONFIGAVAILABLEN,
	LLKRXCHCONFIGPARTIALN,
	LLKRXCHNONPOSTEDAVAILABLEN,
	LLKRXCHNONPOSTEDPARTIALN,
	LLKRXCHPOSTEDAVAILABLEN,
	LLKRXCHPOSTEDPARTIALN,
	LLKRXDATA,
	LLKRXECRCBADN,
	LLKRXEOFN,
	LLKRXEOPN,
	LLKRXPREFERREDTYPE,
	LLKRXSOFN,
	LLKRXSOPN,
	LLKRXSRCDSCN,
	LLKRXSRCLASTREQN,
	LLKRXSRCRDYN,
	LLKRXVALIDN,
	LLKTCSTATUS,
	LLKTXCHANSPACE,
	LLKTXCHCOMPLETIONREADYN,
	LLKTXCHNONPOSTEDREADYN,
	LLKTXCHPOSTEDREADYN,
	LLKTXCONFIGREADYN,
	LLKTXDSTRDYN,
	MAXPAYLOADSIZE,
	MAXREADREQUESTSIZE,
	MEMSPACEENABLE,
	MGMTPSO,
	MGMTRDATA,
	MGMTSTATSCREDIT,
	MIMDLLBRADD,
	MIMDLLBREN,
	MIMDLLBWADD,
	MIMDLLBWDATA,
	MIMDLLBWEN,
	MIMRXBRADD,
	MIMRXBREN,
	MIMRXBWADD,
	MIMRXBWDATA,
	MIMRXBWEN,
	MIMTXBRADD,
	MIMTXBREN,
	MIMTXBWADD,
	MIMTXBWDATA,
	MIMTXBWEN,
	PARITYERRORRESPONSE,
	PIPEDESKEWLANESL0,
	PIPEDESKEWLANESL1,
	PIPEDESKEWLANESL2,
	PIPEDESKEWLANESL3,
	PIPEDESKEWLANESL4,
	PIPEDESKEWLANESL5,
	PIPEDESKEWLANESL6,
	PIPEDESKEWLANESL7,
	PIPEPOWERDOWNL0,
	PIPEPOWERDOWNL1,
	PIPEPOWERDOWNL2,
	PIPEPOWERDOWNL3,
	PIPEPOWERDOWNL4,
	PIPEPOWERDOWNL5,
	PIPEPOWERDOWNL6,
	PIPEPOWERDOWNL7,
	PIPERESETL0,
	PIPERESETL1,
	PIPERESETL2,
	PIPERESETL3,
	PIPERESETL4,
	PIPERESETL5,
	PIPERESETL6,
	PIPERESETL7,
	PIPERXPOLARITYL0,
	PIPERXPOLARITYL1,
	PIPERXPOLARITYL2,
	PIPERXPOLARITYL3,
	PIPERXPOLARITYL4,
	PIPERXPOLARITYL5,
	PIPERXPOLARITYL6,
	PIPERXPOLARITYL7,
	PIPETXCOMPLIANCEL0,
	PIPETXCOMPLIANCEL1,
	PIPETXCOMPLIANCEL2,
	PIPETXCOMPLIANCEL3,
	PIPETXCOMPLIANCEL4,
	PIPETXCOMPLIANCEL5,
	PIPETXCOMPLIANCEL6,
	PIPETXCOMPLIANCEL7,
	PIPETXDATAKL0,
	PIPETXDATAKL1,
	PIPETXDATAKL2,
	PIPETXDATAKL3,
	PIPETXDATAKL4,
	PIPETXDATAKL5,
	PIPETXDATAKL6,
	PIPETXDATAKL7,
	PIPETXDATAL0,
	PIPETXDATAL1,
	PIPETXDATAL2,
	PIPETXDATAL3,
	PIPETXDATAL4,
	PIPETXDATAL5,
	PIPETXDATAL6,
	PIPETXDATAL7,
	PIPETXDETECTRXLOOPBACKL0,
	PIPETXDETECTRXLOOPBACKL1,
	PIPETXDETECTRXLOOPBACKL2,
	PIPETXDETECTRXLOOPBACKL3,
	PIPETXDETECTRXLOOPBACKL4,
	PIPETXDETECTRXLOOPBACKL5,
	PIPETXDETECTRXLOOPBACKL6,
	PIPETXDETECTRXLOOPBACKL7,
	PIPETXELECIDLEL0,
	PIPETXELECIDLEL1,
	PIPETXELECIDLEL2,
	PIPETXELECIDLEL3,
	PIPETXELECIDLEL4,
	PIPETXELECIDLEL5,
	PIPETXELECIDLEL6,
	PIPETXELECIDLEL7,
	SERRENABLE,
	URREPORTINGENABLE,

	AUXPOWER,
	CFGNEGOTIATEDLINKWIDTH,
	COMPLIANCEAVOID,
	CRMCFGBRIDGEHOTRESET,
	CRMCORECLK,
	CRMCORECLKDLO,
	CRMCORECLKRXO,
	CRMCORECLKTXO,
	CRMLINKRSTN,
	CRMMACRSTN,
	CRMMGMTRSTN,
	CRMNVRSTN,
	CRMTXHOTRESETN,
	CRMURSTN,
	CRMUSERCFGRSTN,
	CRMUSERCLK,
	CRMUSERCLKRXO,
	CRMUSERCLKTXO,
	CROSSLINKSEED,
	L0ACKNAKTIMERADJUSTMENT,
	L0ALLDOWNPORTSINL1,
	L0ALLDOWNRXPORTSINL0S,
	L0ASE,
	L0ASPORTCOUNT,
	L0ASTURNPOOLBITSCONSUMED,
	L0ATTENTIONBUTTONPRESSED,
	L0CFGASSPANTREEOWNEDSTATE,
	L0CFGASSTATECHANGECMD,
	L0CFGDISABLESCRAMBLE,
	L0CFGEXTENDEDSYNC,
	L0CFGL0SENTRYENABLE,
	L0CFGL0SENTRYSUP,
	L0CFGL0SEXITLAT,
	L0CFGLINKDISABLE,
	L0CFGLOOPBACKMASTER,
	L0CFGNEGOTIATEDMAXP,
	L0CFGVCENABLE,
	L0CFGVCID,
	L0DLLHOLDLINKUP,
	L0ELECTROMECHANICALINTERLOCKENGAGED,
	L0FWDASSERTINTALEGACYINT,
	L0FWDASSERTINTBLEGACYINT,
	L0FWDASSERTINTCLEGACYINT,
	L0FWDASSERTINTDLEGACYINT,
	L0FWDCORRERRIN,
	L0FWDDEASSERTINTALEGACYINT,
	L0FWDDEASSERTINTBLEGACYINT,
	L0FWDDEASSERTINTCLEGACYINT,
	L0FWDDEASSERTINTDLEGACYINT,
	L0FWDFATALERRIN,
	L0FWDNONFATALERRIN,
	L0LEGACYINTFUNCT0,
	L0MRLSENSORCLOSEDN,
	L0MSIREQUEST0,
	L0PACKETHEADERFROMUSER,
	L0PMEREQIN,
	L0PORTNUMBER,
	L0POWERFAULTDETECTED,
	L0PRESENCEDETECTSLOTEMPTYN,
	L0PWRNEWSTATEREQ,
	L0PWRNEXTLINKSTATE,
	L0REPLAYTIMERADJUSTMENT,
	L0ROOTTURNOFFREQ,
	L0RXTLTLPNONINITIALIZEDVC,
	L0SENDUNLOCKMESSAGE,
	L0SETCOMPLETERABORTERROR,
	L0SETCOMPLETIONTIMEOUTCORRERROR,
	L0SETCOMPLETIONTIMEOUTUNCORRERROR,
	L0SETDETECTEDCORRERROR,
	L0SETDETECTEDFATALERROR,
	L0SETDETECTEDNONFATALERROR,
	L0SETLINKDETECTEDPARITYERROR,
	L0SETLINKMASTERDATAPARITY,
	L0SETLINKRECEIVEDMASTERABORT,
	L0SETLINKRECEIVEDTARGETABORT,
	L0SETLINKSIGNALLEDTARGETABORT,
	L0SETLINKSYSTEMERROR,
	L0SETUNEXPECTEDCOMPLETIONCORRERROR,
	L0SETUNEXPECTEDCOMPLETIONUNCORRERROR,
	L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR,
	L0SETUNSUPPORTEDREQUESTOTHERERROR,
	L0SETUSERDETECTEDPARITYERROR,
	L0SETUSERMASTERDATAPARITY,
	L0SETUSERRECEIVEDMASTERABORT,
	L0SETUSERRECEIVEDTARGETABORT,
	L0SETUSERSIGNALLEDTARGETABORT,
	L0SETUSERSYSTEMERROR,
	L0TLASFCCREDSTARVATION,
	L0TLLINKRETRAIN,
	L0TRANSACTIONSPENDING,
	L0TXBEACON,
	L0TXCFGPM,
	L0TXCFGPMTYPE,
	L0TXTLFCCMPLMCCRED,
	L0TXTLFCCMPLMCUPDATE,
	L0TXTLFCNPOSTBYPCRED,
	L0TXTLFCNPOSTBYPUPDATE,
	L0TXTLFCPOSTORDCRED,
	L0TXTLFCPOSTORDUPDATE,
	L0TXTLSBFCDATA,
	L0TXTLSBFCUPDATE,
	L0TXTLTLPDATA,
	L0TXTLTLPEDB,
	L0TXTLTLPENABLE,
	L0TXTLTLPEND,
	L0TXTLTLPLATENCY,
	L0TXTLTLPREQ,
	L0TXTLTLPREQEND,
	L0TXTLTLPWIDTH,
	L0UPSTREAMRXPORTINL0S,
	L0VC0PREVIEWEXPAND,
	L0WAKEN,
	LLKRXCHFIFO,
	LLKRXCHTC,
	LLKRXDSTCONTREQN,
	LLKRXDSTREQN,
	LLKTX4DWHEADERN,
	LLKTXCHFIFO,
	LLKTXCHTC,
	LLKTXCOMPLETEN,
	LLKTXCREATEECRCN,
	LLKTXDATA,
	LLKTXENABLEN,
	LLKTXEOFN,
	LLKTXEOPN,
	LLKTXSOFN,
	LLKTXSOPN,
	LLKTXSRCDSCN,
	LLKTXSRCRDYN,
	MAINPOWER,
	MGMTADDR,
	MGMTBWREN,
	MGMTRDEN,
	MGMTSTATSCREDITSEL,
	MGMTWDATA,
	MGMTWREN,
	MIMDLLBRDATA,
	MIMRXBRDATA,
	MIMTXBRDATA,
	PIPEPHYSTATUSL0,
	PIPEPHYSTATUSL1,
	PIPEPHYSTATUSL2,
	PIPEPHYSTATUSL3,
	PIPEPHYSTATUSL4,
	PIPEPHYSTATUSL5,
	PIPEPHYSTATUSL6,
	PIPEPHYSTATUSL7,
	PIPERXCHANISALIGNEDL0,
	PIPERXCHANISALIGNEDL1,
	PIPERXCHANISALIGNEDL2,
	PIPERXCHANISALIGNEDL3,
	PIPERXCHANISALIGNEDL4,
	PIPERXCHANISALIGNEDL5,
	PIPERXCHANISALIGNEDL6,
	PIPERXCHANISALIGNEDL7,
	PIPERXDATAKL0,
	PIPERXDATAKL1,
	PIPERXDATAKL2,
	PIPERXDATAKL3,
	PIPERXDATAKL4,
	PIPERXDATAKL5,
	PIPERXDATAKL6,
	PIPERXDATAKL7,
	PIPERXDATAL0,
	PIPERXDATAL1,
	PIPERXDATAL2,
	PIPERXDATAL3,
	PIPERXDATAL4,
	PIPERXDATAL5,
	PIPERXDATAL6,
	PIPERXDATAL7,
	PIPERXELECIDLEL0,
	PIPERXELECIDLEL1,
	PIPERXELECIDLEL2,
	PIPERXELECIDLEL3,
	PIPERXELECIDLEL4,
	PIPERXELECIDLEL5,
	PIPERXELECIDLEL6,
	PIPERXELECIDLEL7,
	PIPERXSTATUSL0,
	PIPERXSTATUSL1,
	PIPERXSTATUSL2,
	PIPERXSTATUSL3,
	PIPERXSTATUSL4,
	PIPERXSTATUSL5,
	PIPERXSTATUSL6,
	PIPERXSTATUSL7,
	PIPERXVALIDL0,
	PIPERXVALIDL1,
	PIPERXVALIDL2,
	PIPERXVALIDL3,
	PIPERXVALIDL4,
	PIPERXVALIDL5,
	PIPERXVALIDL6,
	PIPERXVALIDL7

);

parameter LOC = "UNPLACED";

parameter AERCAPABILITYECRCCHECKCAPABLE = "FALSE";
parameter AERCAPABILITYECRCGENCAPABLE = "FALSE";
parameter BAR0EXIST = "TRUE";
parameter BAR0PREFETCHABLE = "TRUE";
parameter BAR1EXIST = "FALSE";
parameter BAR1PREFETCHABLE = "FALSE";
parameter BAR2EXIST = "FALSE";
parameter BAR2PREFETCHABLE = "FALSE";
parameter BAR3EXIST = "FALSE";
parameter BAR3PREFETCHABLE = "FALSE";
parameter BAR4EXIST = "FALSE";
parameter BAR4PREFETCHABLE = "FALSE";
parameter BAR5EXIST = "FALSE";
parameter BAR5PREFETCHABLE = "FALSE";
parameter CLKDIVIDED = "FALSE";
parameter DUALCOREENABLE = "FALSE";
parameter DUALCORESLAVE = "FALSE";
parameter INFINITECOMPLETIONS = "TRUE";
parameter ISSWITCH = "FALSE";
parameter LINKSTATUSSLOTCLOCKCONFIG = "FALSE";
parameter LLKBYPASS = "FALSE";
parameter PBCAPABILITYSYSTEMALLOCATED = "FALSE";
parameter PCIECAPABILITYSLOTIMPL = "FALSE";
parameter PMCAPABILITYD1SUPPORT = "FALSE";
parameter PMCAPABILITYD2SUPPORT = "FALSE";
parameter PMCAPABILITYDSI = "TRUE";
parameter RAMSHARETXRX = "FALSE";
parameter RESETMODE = "FALSE";
parameter RETRYREADADDRPIPE = "FALSE";
parameter RETRYREADDATAPIPE = "FALSE";
parameter RETRYWRITEPIPE = "FALSE";
parameter RXREADADDRPIPE = "FALSE";
parameter RXREADDATAPIPE = "FALSE";
parameter RXWRITEPIPE = "FALSE";
parameter SELECTASMODE = "FALSE";
parameter SELECTDLLIF = "FALSE";
parameter SLOTCAPABILITYATTBUTTONPRESENT = "FALSE";
parameter SLOTCAPABILITYATTINDICATORPRESENT = "FALSE";
parameter SLOTCAPABILITYHOTPLUGCAPABLE = "FALSE";
parameter SLOTCAPABILITYHOTPLUGSURPRISE = "FALSE";
parameter SLOTCAPABILITYMSLSENSORPRESENT = "FALSE";
parameter SLOTCAPABILITYPOWERCONTROLLERPRESENT = "FALSE";
parameter SLOTCAPABILITYPOWERINDICATORPRESENT = "FALSE";
parameter SLOTIMPLEMENTED = "FALSE";
parameter TXREADADDRPIPE = "FALSE";
parameter TXREADDATAPIPE = "FALSE";
parameter TXWRITEPIPE = "FALSE";
parameter UPSTREAMFACING = "TRUE";
parameter XLINKSUPPORTED = "FALSE";
parameter [10:0] VC0TOTALCREDITSCD = 11'h0;
parameter [10:0] VC0TOTALCREDITSPD = 11'h34;
parameter [10:0] VC1TOTALCREDITSCD = 11'h0;
parameter [10:0] VC1TOTALCREDITSPD = 11'h0;
parameter [11:0] AERBASEPTR = 12'h110;
parameter [11:0] AERCAPABILITYNEXTPTR = 12'h138;
parameter [11:0] DSNBASEPTR = 12'h148;
parameter [11:0] DSNCAPABILITYNEXTPTR = 12'h154;
parameter [11:0] EXTCFGXPCAPPTR = 12'h0;
parameter [11:0] MSIBASEPTR = 12'h48;
parameter [11:0] PBBASEPTR = 12'h138;
parameter [11:0] PBCAPABILITYNEXTPTR = 12'h148;
parameter [11:0] PMBASEPTR = 12'h40;
parameter [11:0] RETRYRAMSIZE = 12'h9;
parameter [11:0] VCBASEPTR = 12'h154;
parameter [11:0] VCCAPABILITYNEXTPTR = 12'h0;
parameter [12:0] SLOTCAPABILITYPHYSICALSLOTNUM = 13'h0;
parameter [12:0] VC0RXFIFOBASEC = 13'h98;
parameter [12:0] VC0RXFIFOBASENP = 13'h80;
parameter [12:0] VC0RXFIFOBASEP = 13'h0;
parameter [12:0] VC0RXFIFOLIMITC = 13'h117;
parameter [12:0] VC0RXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0RXFIFOLIMITP = 13'h7f;
parameter [12:0] VC0TXFIFOBASEC = 13'h98;
parameter [12:0] VC0TXFIFOBASENP = 13'h80;
parameter [12:0] VC0TXFIFOBASEP = 13'h0;
parameter [12:0] VC0TXFIFOLIMITC = 13'h117;
parameter [12:0] VC0TXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0TXFIFOLIMITP = 13'h7f;
parameter [12:0] VC1RXFIFOBASEC = 13'h118;
parameter [12:0] VC1RXFIFOBASENP = 13'h118;
parameter [12:0] VC1RXFIFOBASEP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITC = 13'h118;
parameter [12:0] VC1RXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITP = 13'h118;
parameter [12:0] VC1TXFIFOBASEC = 13'h118;
parameter [12:0] VC1TXFIFOBASENP = 13'h118;
parameter [12:0] VC1TXFIFOBASEP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITC = 13'h118;
parameter [12:0] VC1TXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITP = 13'h118;
parameter [15:0] DEVICEID = 16'h5050;
parameter [15:0] SUBSYSTEMID = 16'h5050;
parameter [15:0] SUBSYSTEMVENDORID = 16'h10EE;
parameter [15:0] VENDORID = 16'h10EE;
parameter [1:0] LINKCAPABILITYASPMSUPPORT = 2'h1;
parameter [1:0] PBCAPABILITYDW0DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW0PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW1DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW1PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW2DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW2PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW3DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW3PMSTATE = 2'h0;
parameter [1:0] PMSTATUSCONTROLDATASCALE = 2'h0;
parameter [1:0] SLOTCAPABILITYSLOTPOWERLIMITSCALE = 2'h0;
parameter [23:0] CLASSCODE = 24'h058000;
parameter [2:0] CONFIGROUTING = 3'h1;
parameter [2:0] DEVICECAPABILITYENDPOINTL0SLATENCY = 3'h0;
parameter [2:0] DEVICECAPABILITYENDPOINTL1LATENCY = 3'h0;
parameter [2:0] MSICAPABILITYMULTIMSGCAP = 3'h0;
parameter [2:0] PBCAPABILITYDW0PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW0POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW0TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW1PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW1POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW1TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW2PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW2POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW2TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW3PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW3POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW3TYPE = 3'h0;
parameter [2:0] PMCAPABILITYAUXCURRENT = 3'h0;
parameter [2:0] PORTVCCAPABILITYEXTENDEDVCCOUNT = 3'h0;
parameter [31:0] CARDBUSCISPOINTER = 32'h0;
parameter [3:0] XPDEVICEPORTTYPE = 4'h0;
parameter [4:0] PCIECAPABILITYINTMSGNUM = 5'h0;
parameter [4:0] PMCAPABILITYPMESUPPORT = 5'h0;
parameter [5:0] BAR0MASKWIDTH = 6'h14;
parameter [5:0] BAR1MASKWIDTH = 6'h0;
parameter [5:0] BAR2MASKWIDTH = 6'h0;
parameter [5:0] BAR3MASKWIDTH = 6'h0;
parameter [5:0] BAR4MASKWIDTH = 6'h0;
parameter [5:0] BAR5MASKWIDTH = 6'h0;
parameter [5:0] LINKCAPABILITYMAXLINKWIDTH = 6'h01;
parameter [63:0] DEVICESERIALNUMBER = 64'hE000000001000A35;
parameter [6:0] VC0TOTALCREDITSCH = 7'h0;
parameter [6:0] VC0TOTALCREDITSNPH = 7'h08;
parameter [6:0] VC0TOTALCREDITSPH = 7'h08;
parameter [6:0] VC1TOTALCREDITSCH = 7'h0;
parameter [6:0] VC1TOTALCREDITSNPH = 7'h0;
parameter [6:0] VC1TOTALCREDITSPH = 7'h0;
parameter [7:0] ACTIVELANESIN = 8'h1;
parameter [7:0] CAPABILITIESPOINTER = 8'h40;
parameter [7:0] EXTCFGCAPPTR = 8'h0;
parameter [7:0] HEADERTYPE = 8'h0;
parameter [7:0] INTERRUPTPIN = 8'h0;
parameter [7:0] MSICAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PBCAPABILITYDW0BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW1BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW2BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW3BASEPOWER = 8'h0;
parameter [7:0] PCIECAPABILITYNEXTPTR = 8'h0;
parameter [7:0] PMCAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PMDATA0 = 8'h0;
parameter [7:0] PMDATA1 = 8'h0;
parameter [7:0] PMDATA2 = 8'h0;
parameter [7:0] PMDATA3 = 8'h0;
parameter [7:0] PMDATA4 = 8'h0;
parameter [7:0] PMDATA5 = 8'h0;
parameter [7:0] PMDATA6 = 8'h0;
parameter [7:0] PMDATA7 = 8'h0;
parameter [7:0] PMDATA8 = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBCAP = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBTABLEOFFSET = 8'h0;
parameter [7:0] REVISIONID = 8'h0;
parameter [7:0] SLOTCAPABILITYSLOTPOWERLIMITVALUE = 8'h0;
parameter [7:0] XPBASEPTR = 8'h60;
parameter integer BAR0ADDRWIDTH = 0;
parameter integer BAR0IOMEMN = 0;
parameter integer BAR1ADDRWIDTH = 0;
parameter integer BAR1IOMEMN = 0;
parameter integer BAR2ADDRWIDTH = 0;
parameter integer BAR2IOMEMN = 0;
parameter integer BAR3ADDRWIDTH = 0;
parameter integer BAR3IOMEMN = 0;
parameter integer BAR4ADDRWIDTH = 0;
parameter integer BAR4IOMEMN = 0;
parameter integer BAR5IOMEMN = 0;
parameter integer DUALROLECFGCNTRLROOTEPN = 0;
parameter integer L0SEXITLATENCY = 7;
parameter integer L0SEXITLATENCYCOMCLK = 7;
parameter integer L1EXITLATENCY = 7;
parameter integer L1EXITLATENCYCOMCLK = 7;
parameter integer LOWPRIORITYVCCOUNT = 0;
parameter integer PCIEREVISION = 1;
parameter integer PMDATASCALE0 = 0;
parameter integer PMDATASCALE1 = 0;
parameter integer PMDATASCALE2 = 0;
parameter integer PMDATASCALE3 = 0;
parameter integer PMDATASCALE4 = 0;
parameter integer PMDATASCALE5 = 0;
parameter integer PMDATASCALE6 = 0;
parameter integer PMDATASCALE7 = 0;
parameter integer PMDATASCALE8 = 0;
parameter integer RETRYRAMREADLATENCY = 3;
parameter integer RETRYRAMWIDTH = 0;
parameter integer RETRYRAMWRITELATENCY = 1;
parameter integer TLRAMREADLATENCY = 3;
parameter integer TLRAMWIDTH = 0;
parameter integer TLRAMWRITELATENCY = 1;
parameter integer TXTSNFTS = 255;
parameter integer TXTSNFTSCOMCLK = 255;
parameter integer XPMAXPAYLOAD = 0;
parameter integer XPRCBCONTROL = 0;

localparam in_delay = 0;
localparam out_delay = 0;
localparam CLK_DELAY = 0;

output BUSMASTERENABLE;
output CRMDOHOTRESETN;
output CRMPWRSOFTRESETN;
output CRMRXHOTRESETN;
output DLLTXPMDLLPOUTSTANDING;
output INTERRUPTDISABLE;
output IOSPACEENABLE;
output L0ASAUTONOMOUSINITCOMPLETED;
output L0CFGLOOPBACKACK;
output L0CORRERRMSGRCVD;
output L0DLLASTXSTATE;
output L0DLLRXACKOUTSTANDING;
output L0DLLTXNONFCOUTSTANDING;
output L0DLLTXOUTSTANDING;
output L0FATALERRMSGRCVD;
output L0FIRSTCFGWRITEOCCURRED;
output L0FWDCORRERROUT;
output L0FWDFATALERROUT;
output L0FWDNONFATALERROUT;
output L0MACENTEREDL0;
output L0MACLINKTRAINING;
output L0MACLINKUP;
output L0MACNEWSTATEACK;
output L0MACRXL0SSTATE;
output L0MACUPSTREAMDOWNSTREAM;
output L0MSIENABLE0;
output L0NONFATALERRMSGRCVD;
output L0PMEACK;
output L0PMEEN;
output L0PMEREQOUT;
output L0POWERCONTROLLERCONTROL;
output L0PWRINHIBITTRANSFERS;
output L0PWRL1STATE;
output L0PWRL23READYDEVICE;
output L0PWRL23READYSTATE;
output L0PWRTURNOFFREQ;
output L0PWRTXL0SSTATE;
output L0RECEIVEDASSERTINTALEGACYINT;
output L0RECEIVEDASSERTINTBLEGACYINT;
output L0RECEIVEDASSERTINTCLEGACYINT;
output L0RECEIVEDASSERTINTDLEGACYINT;
output L0RECEIVEDDEASSERTINTALEGACYINT;
output L0RECEIVEDDEASSERTINTBLEGACYINT;
output L0RECEIVEDDEASSERTINTCLEGACYINT;
output L0RECEIVEDDEASSERTINTDLEGACYINT;
output L0RXBEACON;
output L0RXDLLPM;
output L0RXDLLSBFCUPDATE;
output L0RXDLLTLPECRCOK;
output L0STATSCFGOTHERRECEIVED;
output L0STATSCFGOTHERTRANSMITTED;
output L0STATSCFGRECEIVED;
output L0STATSCFGTRANSMITTED;
output L0STATSDLLPRECEIVED;
output L0STATSDLLPTRANSMITTED;
output L0STATSOSRECEIVED;
output L0STATSOSTRANSMITTED;
output L0STATSTLPRECEIVED;
output L0STATSTLPTRANSMITTED;
output L0TOGGLEELECTROMECHANICALINTERLOCK;
output L0TXDLLPMUPDATED;
output L0TXDLLSBFCUPDATED;
output L0UNLOCKRECEIVED;
output LLKRX4DWHEADERN;
output LLKRXCHCONFIGAVAILABLEN;
output LLKRXCHCONFIGPARTIALN;
output LLKRXECRCBADN;
output LLKRXEOFN;
output LLKRXEOPN;
output LLKRXSOFN;
output LLKRXSOPN;
output LLKRXSRCDSCN;
output LLKRXSRCLASTREQN;
output LLKRXSRCRDYN;
output LLKTXCONFIGREADYN;
output LLKTXDSTRDYN;
output MEMSPACEENABLE;
output MIMDLLBREN;
output MIMDLLBWEN;
output MIMRXBREN;
output MIMRXBWEN;
output MIMTXBREN;
output MIMTXBWEN;
output PARITYERRORRESPONSE;
output PIPEDESKEWLANESL0;
output PIPEDESKEWLANESL1;
output PIPEDESKEWLANESL2;
output PIPEDESKEWLANESL3;
output PIPEDESKEWLANESL4;
output PIPEDESKEWLANESL5;
output PIPEDESKEWLANESL6;
output PIPEDESKEWLANESL7;
output PIPERESETL0;
output PIPERESETL1;
output PIPERESETL2;
output PIPERESETL3;
output PIPERESETL4;
output PIPERESETL5;
output PIPERESETL6;
output PIPERESETL7;
output PIPERXPOLARITYL0;
output PIPERXPOLARITYL1;
output PIPERXPOLARITYL2;
output PIPERXPOLARITYL3;
output PIPERXPOLARITYL4;
output PIPERXPOLARITYL5;
output PIPERXPOLARITYL6;
output PIPERXPOLARITYL7;
output PIPETXCOMPLIANCEL0;
output PIPETXCOMPLIANCEL1;
output PIPETXCOMPLIANCEL2;
output PIPETXCOMPLIANCEL3;
output PIPETXCOMPLIANCEL4;
output PIPETXCOMPLIANCEL5;
output PIPETXCOMPLIANCEL6;
output PIPETXCOMPLIANCEL7;
output PIPETXDATAKL0;
output PIPETXDATAKL1;
output PIPETXDATAKL2;
output PIPETXDATAKL3;
output PIPETXDATAKL4;
output PIPETXDATAKL5;
output PIPETXDATAKL6;
output PIPETXDATAKL7;
output PIPETXDETECTRXLOOPBACKL0;
output PIPETXDETECTRXLOOPBACKL1;
output PIPETXDETECTRXLOOPBACKL2;
output PIPETXDETECTRXLOOPBACKL3;
output PIPETXDETECTRXLOOPBACKL4;
output PIPETXDETECTRXLOOPBACKL5;
output PIPETXDETECTRXLOOPBACKL6;
output PIPETXDETECTRXLOOPBACKL7;
output PIPETXELECIDLEL0;
output PIPETXELECIDLEL1;
output PIPETXELECIDLEL2;
output PIPETXELECIDLEL3;
output PIPETXELECIDLEL4;
output PIPETXELECIDLEL5;
output PIPETXELECIDLEL6;
output PIPETXELECIDLEL7;
output SERRENABLE;
output URREPORTINGENABLE;
output [11:0] MGMTSTATSCREDIT;
output [11:0] MIMDLLBRADD;
output [11:0] MIMDLLBWADD;
output [12:0] L0COMPLETERID;
output [12:0] MIMRXBRADD;
output [12:0] MIMRXBWADD;
output [12:0] MIMTXBRADD;
output [12:0] MIMTXBWADD;
output [15:0] L0ERRMSGREQID;
output [15:0] LLKRXPREFERREDTYPE;
output [16:0] MGMTPSO;
output [18:0] L0RXDLLSBFCDATA;
output [19:0] L0RXDLLFCNPOSTBYPCRED;
output [1:0] L0ATTENTIONINDICATORCONTROL;
output [1:0] L0DLLASRXSTATE;
output [1:0] L0POWERINDICATORCONTROL;
output [1:0] L0PWRSTATE0;
output [1:0] L0RXDLLTLPEND;
output [1:0] L0RXMACLINKERROR;
output [1:0] LLKRXVALIDN;
output [1:0] PIPEPOWERDOWNL0;
output [1:0] PIPEPOWERDOWNL1;
output [1:0] PIPEPOWERDOWNL2;
output [1:0] PIPEPOWERDOWNL3;
output [1:0] PIPEPOWERDOWNL4;
output [1:0] PIPEPOWERDOWNL5;
output [1:0] PIPEPOWERDOWNL6;
output [1:0] PIPEPOWERDOWNL7;
output [23:0] L0RXDLLFCCMPLMCCRED;
output [23:0] L0RXDLLFCPOSTORDCRED;
output [2:0] L0MCFOUND;
output [2:0] L0MULTIMSGEN0;
output [2:0] L0RXDLLPMTYPE;
output [2:0] L0TRANSFORMEDVC;
output [2:0] MAXPAYLOADSIZE;
output [2:0] MAXREADREQUESTSIZE;
output [31:0] MGMTRDATA;
output [3:0] L0LTSSMSTATE;
output [3:0] L0MACNEGOTIATEDLINKWIDTH;
output [3:0] L0UCBYPFOUND;
output [3:0] L0UCORDFOUND;
output [63:0] LLKRXDATA;
output [63:0] MIMDLLBWDATA;
output [63:0] MIMRXBWDATA;
output [63:0] MIMTXBWDATA;
output [6:0] L0DLLERRORVECTOR;
output [7:0] L0DLLVCSTATUS;
output [7:0] L0DLUPDOWN;
output [7:0] L0RXDLLFCCMPLMCUPDATE;
output [7:0] L0RXDLLFCNPOSTBYPUPDATE;
output [7:0] L0RXDLLFCPOSTORDUPDATE;
output [7:0] L0TXDLLFCCMPLMCUPDATED;
output [7:0] L0TXDLLFCNPOSTBYPUPDATED;
output [7:0] L0TXDLLFCPOSTORDUPDATED;
output [7:0] LLKRXCHCOMPLETIONAVAILABLEN;
output [7:0] LLKRXCHCOMPLETIONPARTIALN;
output [7:0] LLKRXCHNONPOSTEDAVAILABLEN;
output [7:0] LLKRXCHNONPOSTEDPARTIALN;
output [7:0] LLKRXCHPOSTEDAVAILABLEN;
output [7:0] LLKRXCHPOSTEDPARTIALN;
output [7:0] LLKTCSTATUS;
output [7:0] LLKTXCHCOMPLETIONREADYN;
output [7:0] LLKTXCHNONPOSTEDREADYN;
output [7:0] LLKTXCHPOSTEDREADYN;
output [7:0] PIPETXDATAL0;
output [7:0] PIPETXDATAL1;
output [7:0] PIPETXDATAL2;
output [7:0] PIPETXDATAL3;
output [7:0] PIPETXDATAL4;
output [7:0] PIPETXDATAL5;
output [7:0] PIPETXDATAL6;
output [7:0] PIPETXDATAL7;
output [9:0] LLKTXCHANSPACE;

input AUXPOWER;
input COMPLIANCEAVOID;
input CRMCFGBRIDGEHOTRESET;
input CRMCORECLK;
input CRMCORECLKDLO;
input CRMCORECLKRXO;
input CRMCORECLKTXO;
input CRMLINKRSTN;
input CRMMACRSTN;
input CRMMGMTRSTN;
input CRMNVRSTN;
input CRMTXHOTRESETN;
input CRMURSTN;
input CRMUSERCFGRSTN;
input CRMUSERCLK;
input CRMUSERCLKRXO;
input CRMUSERCLKTXO;
input CROSSLINKSEED;
input L0ALLDOWNPORTSINL1;
input L0ALLDOWNRXPORTSINL0S;
input L0ASE;
input L0ATTENTIONBUTTONPRESSED;
input L0CFGASSPANTREEOWNEDSTATE;
input L0CFGDISABLESCRAMBLE;
input L0CFGEXTENDEDSYNC;
input L0CFGL0SENTRYENABLE;
input L0CFGL0SENTRYSUP;
input L0CFGLINKDISABLE;
input L0CFGLOOPBACKMASTER;
input L0DLLHOLDLINKUP;
input L0ELECTROMECHANICALINTERLOCKENGAGED;
input L0FWDASSERTINTALEGACYINT;
input L0FWDASSERTINTBLEGACYINT;
input L0FWDASSERTINTCLEGACYINT;
input L0FWDASSERTINTDLEGACYINT;
input L0FWDCORRERRIN;
input L0FWDDEASSERTINTALEGACYINT;
input L0FWDDEASSERTINTBLEGACYINT;
input L0FWDDEASSERTINTCLEGACYINT;
input L0FWDDEASSERTINTDLEGACYINT;
input L0FWDFATALERRIN;
input L0FWDNONFATALERRIN;
input L0LEGACYINTFUNCT0;
input L0MRLSENSORCLOSEDN;
input L0PMEREQIN;
input L0POWERFAULTDETECTED;
input L0PRESENCEDETECTSLOTEMPTYN;
input L0PWRNEWSTATEREQ;
input L0ROOTTURNOFFREQ;
input L0SENDUNLOCKMESSAGE;
input L0SETCOMPLETERABORTERROR;
input L0SETCOMPLETIONTIMEOUTCORRERROR;
input L0SETCOMPLETIONTIMEOUTUNCORRERROR;
input L0SETDETECTEDCORRERROR;
input L0SETDETECTEDFATALERROR;
input L0SETDETECTEDNONFATALERROR;
input L0SETLINKDETECTEDPARITYERROR;
input L0SETLINKMASTERDATAPARITY;
input L0SETLINKRECEIVEDMASTERABORT;
input L0SETLINKRECEIVEDTARGETABORT;
input L0SETLINKSIGNALLEDTARGETABORT;
input L0SETLINKSYSTEMERROR;
input L0SETUNEXPECTEDCOMPLETIONCORRERROR;
input L0SETUNEXPECTEDCOMPLETIONUNCORRERROR;
input L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR;
input L0SETUNSUPPORTEDREQUESTOTHERERROR;
input L0SETUSERDETECTEDPARITYERROR;
input L0SETUSERMASTERDATAPARITY;
input L0SETUSERRECEIVEDMASTERABORT;
input L0SETUSERRECEIVEDTARGETABORT;
input L0SETUSERSIGNALLEDTARGETABORT;
input L0SETUSERSYSTEMERROR;
input L0TLASFCCREDSTARVATION;
input L0TLLINKRETRAIN;
input L0TRANSACTIONSPENDING;
input L0TXBEACON;
input L0TXCFGPM;
input L0TXTLSBFCUPDATE;
input L0TXTLTLPEDB;
input L0TXTLTLPREQ;
input L0TXTLTLPREQEND;
input L0TXTLTLPWIDTH;
input L0UPSTREAMRXPORTINL0S;
input L0VC0PREVIEWEXPAND;
input L0WAKEN;
input LLKRXDSTCONTREQN;
input LLKRXDSTREQN;
input LLKTX4DWHEADERN;
input LLKTXCOMPLETEN;
input LLKTXCREATEECRCN;
input LLKTXEOFN;
input LLKTXEOPN;
input LLKTXSOFN;
input LLKTXSOPN;
input LLKTXSRCDSCN;
input LLKTXSRCRDYN;
input MAINPOWER;
input MGMTRDEN;
input MGMTWREN;
input PIPEPHYSTATUSL0;
input PIPEPHYSTATUSL1;
input PIPEPHYSTATUSL2;
input PIPEPHYSTATUSL3;
input PIPEPHYSTATUSL4;
input PIPEPHYSTATUSL5;
input PIPEPHYSTATUSL6;
input PIPEPHYSTATUSL7;
input PIPERXCHANISALIGNEDL0;
input PIPERXCHANISALIGNEDL1;
input PIPERXCHANISALIGNEDL2;
input PIPERXCHANISALIGNEDL3;
input PIPERXCHANISALIGNEDL4;
input PIPERXCHANISALIGNEDL5;
input PIPERXCHANISALIGNEDL6;
input PIPERXCHANISALIGNEDL7;
input PIPERXDATAKL0;
input PIPERXDATAKL1;
input PIPERXDATAKL2;
input PIPERXDATAKL3;
input PIPERXDATAKL4;
input PIPERXDATAKL5;
input PIPERXDATAKL6;
input PIPERXDATAKL7;
input PIPERXELECIDLEL0;
input PIPERXELECIDLEL1;
input PIPERXELECIDLEL2;
input PIPERXELECIDLEL3;
input PIPERXELECIDLEL4;
input PIPERXELECIDLEL5;
input PIPERXELECIDLEL6;
input PIPERXELECIDLEL7;
input PIPERXVALIDL0;
input PIPERXVALIDL1;
input PIPERXVALIDL2;
input PIPERXVALIDL3;
input PIPERXVALIDL4;
input PIPERXVALIDL5;
input PIPERXVALIDL6;
input PIPERXVALIDL7;
input [10:0] MGMTADDR;
input [11:0] L0ACKNAKTIMERADJUSTMENT;
input [11:0] L0REPLAYTIMERADJUSTMENT;
input [127:0] L0PACKETHEADERFROMUSER;
input [159:0] L0TXTLFCCMPLMCCRED;
input [159:0] L0TXTLFCPOSTORDCRED;
input [15:0] L0TXTLFCCMPLMCUPDATE;
input [15:0] L0TXTLFCNPOSTBYPUPDATE;
input [15:0] L0TXTLFCPOSTORDUPDATE;
input [18:0] L0TXTLSBFCDATA;
input [191:0] L0TXTLFCNPOSTBYPCRED;
input [1:0] L0PWRNEXTLINKSTATE;
input [1:0] L0TXTLTLPENABLE;
input [1:0] L0TXTLTLPEND;
input [1:0] LLKRXCHFIFO;
input [1:0] LLKTXCHFIFO;
input [1:0] LLKTXENABLEN;
input [23:0] L0CFGVCID;
input [2:0] L0ASTURNPOOLBITSCONSUMED;
input [2:0] L0CFGL0SEXITLAT;
input [2:0] L0CFGNEGOTIATEDMAXP;
input [2:0] L0TXCFGPMTYPE;
input [2:0] LLKRXCHTC;
input [2:0] LLKTXCHTC;
input [2:0] PIPERXSTATUSL0;
input [2:0] PIPERXSTATUSL1;
input [2:0] PIPERXSTATUSL2;
input [2:0] PIPERXSTATUSL3;
input [2:0] PIPERXSTATUSL4;
input [2:0] PIPERXSTATUSL5;
input [2:0] PIPERXSTATUSL6;
input [2:0] PIPERXSTATUSL7;
input [31:0] MGMTWDATA;
input [3:0] L0CFGASSTATECHANGECMD;
input [3:0] L0MSIREQUEST0;
input [3:0] L0TXTLTLPLATENCY;
input [3:0] MGMTBWREN;
input [5:0] CFGNEGOTIATEDLINKWIDTH;
input [63:0] L0TXTLTLPDATA;
input [63:0] LLKTXDATA;
input [63:0] MIMDLLBRDATA;
input [63:0] MIMRXBRDATA;
input [63:0] MIMTXBRDATA;
input [6:0] MGMTSTATSCREDITSEL;
input [7:0] L0ASPORTCOUNT;
input [7:0] L0CFGVCENABLE;
input [7:0] L0PORTNUMBER;
input [7:0] L0RXTLTLPNONINITIALIZEDVC;
input [7:0] PIPERXDATAL0;
input [7:0] PIPERXDATAL1;
input [7:0] PIPERXDATAL2;
input [7:0] PIPERXDATAL3;
input [7:0] PIPERXDATAL4;
input [7:0] PIPERXDATAL5;
input [7:0] PIPERXDATAL6;
input [7:0] PIPERXDATAL7;

reg AERCAPABILITYECRCCHECKCAPABLE_BINARY;
reg AERCAPABILITYECRCGENCAPABLE_BINARY;
reg BAR0ADDRWIDTH_BINARY;
reg BAR0EXIST_BINARY;
reg BAR0IOMEMN_BINARY;
reg BAR0PREFETCHABLE_BINARY;
reg BAR1ADDRWIDTH_BINARY;
reg BAR1EXIST_BINARY;
reg BAR1IOMEMN_BINARY;
reg BAR1PREFETCHABLE_BINARY;
reg BAR2ADDRWIDTH_BINARY;
reg BAR2EXIST_BINARY;
reg BAR2IOMEMN_BINARY;
reg BAR2PREFETCHABLE_BINARY;
reg BAR3ADDRWIDTH_BINARY;
reg BAR3EXIST_BINARY;
reg BAR3IOMEMN_BINARY;
reg BAR3PREFETCHABLE_BINARY;
reg BAR4ADDRWIDTH_BINARY;
reg BAR4EXIST_BINARY;
reg BAR4IOMEMN_BINARY;
reg BAR4PREFETCHABLE_BINARY;
reg BAR5EXIST_BINARY;
reg BAR5IOMEMN_BINARY;
reg BAR5PREFETCHABLE_BINARY;
reg CLKDIVIDED_BINARY;
reg DUALCOREENABLE_BINARY;
reg DUALCORESLAVE_BINARY;
reg DUALROLECFGCNTRLROOTEPN_BINARY;
reg INFINITECOMPLETIONS_BINARY;
reg ISSWITCH_BINARY;
reg LINKSTATUSSLOTCLOCKCONFIG_BINARY;
reg LLKBYPASS_BINARY;
reg PBCAPABILITYSYSTEMALLOCATED_BINARY;
reg PCIECAPABILITYSLOTIMPL_BINARY;
reg PCIEREVISION_BINARY;
reg PMCAPABILITYD1SUPPORT_BINARY;
reg PMCAPABILITYD2SUPPORT_BINARY;
reg PMCAPABILITYDSI_BINARY;
reg RAMSHARETXRX_BINARY;
reg RESETMODE_BINARY;
reg RETRYRAMWIDTH_BINARY;
reg RETRYREADADDRPIPE_BINARY;
reg RETRYREADDATAPIPE_BINARY;
reg RETRYWRITEPIPE_BINARY;
reg RXREADADDRPIPE_BINARY;
reg RXREADDATAPIPE_BINARY;
reg RXWRITEPIPE_BINARY;
reg SELECTASMODE_BINARY;
reg SELECTDLLIF_BINARY;
reg SLOTCAPABILITYATTBUTTONPRESENT_BINARY;
reg SLOTCAPABILITYATTINDICATORPRESENT_BINARY;
reg SLOTCAPABILITYHOTPLUGCAPABLE_BINARY;
reg SLOTCAPABILITYHOTPLUGSURPRISE_BINARY;
reg SLOTCAPABILITYMSLSENSORPRESENT_BINARY;
reg SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY;
reg SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY;
reg SLOTIMPLEMENTED_BINARY;
reg TLRAMWIDTH_BINARY;
reg TXREADADDRPIPE_BINARY;
reg TXREADDATAPIPE_BINARY;
reg TXWRITEPIPE_BINARY;
reg UPSTREAMFACING_BINARY;
reg XLINKSUPPORTED_BINARY;
reg XPRCBCONTROL_BINARY;
reg [1:0] PMDATASCALE0_BINARY;
reg [1:0] PMDATASCALE1_BINARY;
reg [1:0] PMDATASCALE2_BINARY;
reg [1:0] PMDATASCALE3_BINARY;
reg [1:0] PMDATASCALE4_BINARY;
reg [1:0] PMDATASCALE5_BINARY;
reg [1:0] PMDATASCALE6_BINARY;
reg [1:0] PMDATASCALE7_BINARY;
reg [1:0] PMDATASCALE8_BINARY;
reg [2:0] L0SEXITLATENCYCOMCLK_BINARY;
reg [2:0] L0SEXITLATENCY_BINARY;
reg [2:0] L1EXITLATENCYCOMCLK_BINARY;
reg [2:0] L1EXITLATENCY_BINARY;
reg [2:0] LOWPRIORITYVCCOUNT_BINARY;
reg [2:0] RETRYRAMREADLATENCY_BINARY;
reg [2:0] RETRYRAMWRITELATENCY_BINARY;
reg [2:0] TLRAMREADLATENCY_BINARY;
reg [2:0] TLRAMWRITELATENCY_BINARY;
reg [2:0] XPMAXPAYLOAD_BINARY;
reg [7:0] TXTSNFTSCOMCLK_BINARY;
reg [7:0] TXTSNFTS_BINARY;

tri0 GSR = glbl.GSR;
reg notifier;

wire BUSMASTERENABLE_OUT;
wire CRMDOHOTRESETN_OUT;
wire CRMPWRSOFTRESETN_OUT;
wire CRMRXHOTRESETN_OUT;
wire DLLTXPMDLLPOUTSTANDING_OUT;
wire INTERRUPTDISABLE_OUT;
wire IOSPACEENABLE_OUT;
wire L0ASAUTONOMOUSINITCOMPLETED_OUT;
wire L0CFGLOOPBACKACK_OUT;
wire L0CORRERRMSGRCVD_OUT;
wire L0DLLASTXSTATE_OUT;
wire L0DLLRXACKOUTSTANDING_OUT;
wire L0DLLTXNONFCOUTSTANDING_OUT;
wire L0DLLTXOUTSTANDING_OUT;
wire L0FATALERRMSGRCVD_OUT;
wire L0FIRSTCFGWRITEOCCURRED_OUT;
wire L0FWDCORRERROUT_OUT;
wire L0FWDFATALERROUT_OUT;
wire L0FWDNONFATALERROUT_OUT;
wire L0MACENTEREDL0_OUT;
wire L0MACLINKTRAINING_OUT;
wire L0MACLINKUP_OUT;
wire L0MACNEWSTATEACK_OUT;
wire L0MACRXL0SSTATE_OUT;
wire L0MACUPSTREAMDOWNSTREAM_OUT;
wire L0MSIENABLE0_OUT;
wire L0NONFATALERRMSGRCVD_OUT;
wire L0PMEACK_OUT;
wire L0PMEEN_OUT;
wire L0PMEREQOUT_OUT;
wire L0POWERCONTROLLERCONTROL_OUT;
wire L0PWRINHIBITTRANSFERS_OUT;
wire L0PWRL1STATE_OUT;
wire L0PWRL23READYDEVICE_OUT;
wire L0PWRL23READYSTATE_OUT;
wire L0PWRTURNOFFREQ_OUT;
wire L0PWRTXL0SSTATE_OUT;
wire L0RECEIVEDASSERTINTALEGACYINT_OUT;
wire L0RECEIVEDASSERTINTBLEGACYINT_OUT;
wire L0RECEIVEDASSERTINTCLEGACYINT_OUT;
wire L0RECEIVEDASSERTINTDLEGACYINT_OUT;
wire L0RECEIVEDDEASSERTINTALEGACYINT_OUT;
wire L0RECEIVEDDEASSERTINTBLEGACYINT_OUT;
wire L0RECEIVEDDEASSERTINTCLEGACYINT_OUT;
wire L0RECEIVEDDEASSERTINTDLEGACYINT_OUT;
wire L0RXBEACON_OUT;
wire L0RXDLLPM_OUT;
wire L0RXDLLSBFCUPDATE_OUT;
wire L0RXDLLTLPECRCOK_OUT;
wire L0STATSCFGOTHERRECEIVED_OUT;
wire L0STATSCFGOTHERTRANSMITTED_OUT;
wire L0STATSCFGRECEIVED_OUT;
wire L0STATSCFGTRANSMITTED_OUT;
wire L0STATSDLLPRECEIVED_OUT;
wire L0STATSDLLPTRANSMITTED_OUT;
wire L0STATSOSRECEIVED_OUT;
wire L0STATSOSTRANSMITTED_OUT;
wire L0STATSTLPRECEIVED_OUT;
wire L0STATSTLPTRANSMITTED_OUT;
wire L0TOGGLEELECTROMECHANICALINTERLOCK_OUT;
wire L0TXDLLPMUPDATED_OUT;
wire L0TXDLLSBFCUPDATED_OUT;
wire L0UNLOCKRECEIVED_OUT;
wire LLKRX4DWHEADERN_OUT;
wire LLKRXCHCONFIGAVAILABLEN_OUT;
wire LLKRXCHCONFIGPARTIALN_OUT;
wire LLKRXECRCBADN_OUT;
wire LLKRXEOFN_OUT;
wire LLKRXEOPN_OUT;
wire LLKRXSOFN_OUT;
wire LLKRXSOPN_OUT;
wire LLKRXSRCDSCN_OUT;
wire LLKRXSRCLASTREQN_OUT;
wire LLKRXSRCRDYN_OUT;
wire LLKTXCONFIGREADYN_OUT;
wire LLKTXDSTRDYN_OUT;
wire MEMSPACEENABLE_OUT;
wire MIMDLLBREN_OUT;
wire MIMDLLBWEN_OUT;
wire MIMRXBREN_OUT;
wire MIMRXBWEN_OUT;
wire MIMTXBREN_OUT;
wire MIMTXBWEN_OUT;
wire PARITYERRORRESPONSE_OUT;
wire PIPEDESKEWLANESL0_OUT;
wire PIPEDESKEWLANESL1_OUT;
wire PIPEDESKEWLANESL2_OUT;
wire PIPEDESKEWLANESL3_OUT;
wire PIPEDESKEWLANESL4_OUT;
wire PIPEDESKEWLANESL5_OUT;
wire PIPEDESKEWLANESL6_OUT;
wire PIPEDESKEWLANESL7_OUT;
wire PIPERESETL0_OUT;
wire PIPERESETL1_OUT;
wire PIPERESETL2_OUT;
wire PIPERESETL3_OUT;
wire PIPERESETL4_OUT;
wire PIPERESETL5_OUT;
wire PIPERESETL6_OUT;
wire PIPERESETL7_OUT;
wire PIPERXPOLARITYL0_OUT;
wire PIPERXPOLARITYL1_OUT;
wire PIPERXPOLARITYL2_OUT;
wire PIPERXPOLARITYL3_OUT;
wire PIPERXPOLARITYL4_OUT;
wire PIPERXPOLARITYL5_OUT;
wire PIPERXPOLARITYL6_OUT;
wire PIPERXPOLARITYL7_OUT;
wire PIPETXCOMPLIANCEL0_OUT;
wire PIPETXCOMPLIANCEL1_OUT;
wire PIPETXCOMPLIANCEL2_OUT;
wire PIPETXCOMPLIANCEL3_OUT;
wire PIPETXCOMPLIANCEL4_OUT;
wire PIPETXCOMPLIANCEL5_OUT;
wire PIPETXCOMPLIANCEL6_OUT;
wire PIPETXCOMPLIANCEL7_OUT;
wire PIPETXDATAKL0_OUT;
wire PIPETXDATAKL1_OUT;
wire PIPETXDATAKL2_OUT;
wire PIPETXDATAKL3_OUT;
wire PIPETXDATAKL4_OUT;
wire PIPETXDATAKL5_OUT;
wire PIPETXDATAKL6_OUT;
wire PIPETXDATAKL7_OUT;
wire PIPETXDETECTRXLOOPBACKL0_OUT;
wire PIPETXDETECTRXLOOPBACKL1_OUT;
wire PIPETXDETECTRXLOOPBACKL2_OUT;
wire PIPETXDETECTRXLOOPBACKL3_OUT;
wire PIPETXDETECTRXLOOPBACKL4_OUT;
wire PIPETXDETECTRXLOOPBACKL5_OUT;
wire PIPETXDETECTRXLOOPBACKL6_OUT;
wire PIPETXDETECTRXLOOPBACKL7_OUT;
wire PIPETXELECIDLEL0_OUT;
wire PIPETXELECIDLEL1_OUT;
wire PIPETXELECIDLEL2_OUT;
wire PIPETXELECIDLEL3_OUT;
wire PIPETXELECIDLEL4_OUT;
wire PIPETXELECIDLEL5_OUT;
wire PIPETXELECIDLEL6_OUT;
wire PIPETXELECIDLEL7_OUT;
wire SERRENABLE_OUT;
wire URREPORTINGENABLE_OUT;
wire [11:0] MGMTSTATSCREDIT_OUT;
wire [11:0] MIMDLLBRADD_OUT;
wire [11:0] MIMDLLBWADD_OUT;
wire [12:0] L0COMPLETERID_OUT;
wire [12:0] MIMRXBRADD_OUT;
wire [12:0] MIMRXBWADD_OUT;
wire [12:0] MIMTXBRADD_OUT;
wire [12:0] MIMTXBWADD_OUT;
wire [15:0] L0ERRMSGREQID_OUT;
wire [15:0] LLKRXPREFERREDTYPE_OUT;
wire [16:0] MGMTPSO_OUT;
wire [18:0] L0RXDLLSBFCDATA_OUT;
wire [19:0] L0RXDLLFCNPOSTBYPCRED_OUT;
wire [1:0] L0ATTENTIONINDICATORCONTROL_OUT;
wire [1:0] L0DLLASRXSTATE_OUT;
wire [1:0] L0POWERINDICATORCONTROL_OUT;
wire [1:0] L0PWRSTATE0_OUT;
wire [1:0] L0RXDLLTLPEND_OUT;
wire [1:0] L0RXMACLINKERROR_OUT;
wire [1:0] LLKRXVALIDN_OUT;
wire [1:0] PIPEPOWERDOWNL0_OUT;
wire [1:0] PIPEPOWERDOWNL1_OUT;
wire [1:0] PIPEPOWERDOWNL2_OUT;
wire [1:0] PIPEPOWERDOWNL3_OUT;
wire [1:0] PIPEPOWERDOWNL4_OUT;
wire [1:0] PIPEPOWERDOWNL5_OUT;
wire [1:0] PIPEPOWERDOWNL6_OUT;
wire [1:0] PIPEPOWERDOWNL7_OUT;
wire [23:0] L0RXDLLFCCMPLMCCRED_OUT;
wire [23:0] L0RXDLLFCPOSTORDCRED_OUT;
wire [2:0] L0MCFOUND_OUT;
wire [2:0] L0MULTIMSGEN0_OUT;
wire [2:0] L0RXDLLPMTYPE_OUT;
wire [2:0] L0TRANSFORMEDVC_OUT;
wire [2:0] MAXPAYLOADSIZE_OUT;
wire [2:0] MAXREADREQUESTSIZE_OUT;
wire [31:0] MGMTRDATA_OUT;
wire [3:0] L0LTSSMSTATE_OUT;
wire [3:0] L0MACNEGOTIATEDLINKWIDTH_OUT;
wire [3:0] L0UCBYPFOUND_OUT;
wire [3:0] L0UCORDFOUND_OUT;
wire [63:0] LLKRXDATA_OUT;
wire [63:0] MIMDLLBWDATA_OUT;
wire [63:0] MIMRXBWDATA_OUT;
wire [63:0] MIMTXBWDATA_OUT;
wire [6:0] L0DLLERRORVECTOR_OUT;
wire [7:0] L0DLLVCSTATUS_OUT;
wire [7:0] L0DLUPDOWN_OUT;
wire [7:0] L0RXDLLFCCMPLMCUPDATE_OUT;
wire [7:0] L0RXDLLFCNPOSTBYPUPDATE_OUT;
wire [7:0] L0RXDLLFCPOSTORDUPDATE_OUT;
wire [7:0] L0TXDLLFCCMPLMCUPDATED_OUT;
wire [7:0] L0TXDLLFCNPOSTBYPUPDATED_OUT;
wire [7:0] L0TXDLLFCPOSTORDUPDATED_OUT;
wire [7:0] LLKRXCHCOMPLETIONAVAILABLEN_OUT;
wire [7:0] LLKRXCHCOMPLETIONPARTIALN_OUT;
wire [7:0] LLKRXCHNONPOSTEDAVAILABLEN_OUT;
wire [7:0] LLKRXCHNONPOSTEDPARTIALN_OUT;
wire [7:0] LLKRXCHPOSTEDAVAILABLEN_OUT;
wire [7:0] LLKRXCHPOSTEDPARTIALN_OUT;
wire [7:0] LLKTCSTATUS_OUT;
wire [7:0] LLKTXCHCOMPLETIONREADYN_OUT;
wire [7:0] LLKTXCHNONPOSTEDREADYN_OUT;
wire [7:0] LLKTXCHPOSTEDREADYN_OUT;
wire [7:0] PIPETXDATAL0_OUT;
wire [7:0] PIPETXDATAL1_OUT;
wire [7:0] PIPETXDATAL2_OUT;
wire [7:0] PIPETXDATAL3_OUT;
wire [7:0] PIPETXDATAL4_OUT;
wire [7:0] PIPETXDATAL5_OUT;
wire [7:0] PIPETXDATAL6_OUT;
wire [7:0] PIPETXDATAL7_OUT;
wire [9:0] LLKTXCHANSPACE_OUT;

wire AUXPOWER_IN;
wire COMPLIANCEAVOID_IN;
wire CRMCFGBRIDGEHOTRESET_IN;
wire CRMCORECLKDLO_IN;
wire CRMCORECLKRXO_IN;
wire CRMCORECLKTXO_IN;
wire CRMCORECLK_IN;
wire CRMLINKRSTN_IN;
wire CRMMACRSTN_IN;
wire CRMMGMTRSTN_IN;
wire CRMNVRSTN_IN;
wire CRMTXHOTRESETN_IN;
wire CRMURSTN_IN;
wire CRMUSERCFGRSTN_IN;
wire CRMUSERCLKRXO_IN;
wire CRMUSERCLKTXO_IN;
wire CRMUSERCLK_IN;
wire CROSSLINKSEED_IN;
wire L0ALLDOWNPORTSINL1_IN;
wire L0ALLDOWNRXPORTSINL0S_IN;
wire L0ASE_IN;
wire L0ATTENTIONBUTTONPRESSED_IN;
wire L0CFGASSPANTREEOWNEDSTATE_IN;
wire L0CFGDISABLESCRAMBLE_IN;
wire L0CFGEXTENDEDSYNC_IN;
wire L0CFGL0SENTRYENABLE_IN;
wire L0CFGL0SENTRYSUP_IN;
wire L0CFGLINKDISABLE_IN;
wire L0CFGLOOPBACKMASTER_IN;
wire L0DLLHOLDLINKUP_IN;
wire L0ELECTROMECHANICALINTERLOCKENGAGED_IN;
wire L0FWDASSERTINTALEGACYINT_IN;
wire L0FWDASSERTINTBLEGACYINT_IN;
wire L0FWDASSERTINTCLEGACYINT_IN;
wire L0FWDASSERTINTDLEGACYINT_IN;
wire L0FWDCORRERRIN_IN;
wire L0FWDDEASSERTINTALEGACYINT_IN;
wire L0FWDDEASSERTINTBLEGACYINT_IN;
wire L0FWDDEASSERTINTCLEGACYINT_IN;
wire L0FWDDEASSERTINTDLEGACYINT_IN;
wire L0FWDFATALERRIN_IN;
wire L0FWDNONFATALERRIN_IN;
wire L0LEGACYINTFUNCT0_IN;
wire L0MRLSENSORCLOSEDN_IN;
wire L0PMEREQIN_IN;
wire L0POWERFAULTDETECTED_IN;
wire L0PRESENCEDETECTSLOTEMPTYN_IN;
wire L0PWRNEWSTATEREQ_IN;
wire L0ROOTTURNOFFREQ_IN;
wire L0SENDUNLOCKMESSAGE_IN;
wire L0SETCOMPLETERABORTERROR_IN;
wire L0SETCOMPLETIONTIMEOUTCORRERROR_IN;
wire L0SETCOMPLETIONTIMEOUTUNCORRERROR_IN;
wire L0SETDETECTEDCORRERROR_IN;
wire L0SETDETECTEDFATALERROR_IN;
wire L0SETDETECTEDNONFATALERROR_IN;
wire L0SETLINKDETECTEDPARITYERROR_IN;
wire L0SETLINKMASTERDATAPARITY_IN;
wire L0SETLINKRECEIVEDMASTERABORT_IN;
wire L0SETLINKRECEIVEDTARGETABORT_IN;
wire L0SETLINKSIGNALLEDTARGETABORT_IN;
wire L0SETLINKSYSTEMERROR_IN;
wire L0SETUNEXPECTEDCOMPLETIONCORRERROR_IN;
wire L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_IN;
wire L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_IN;
wire L0SETUNSUPPORTEDREQUESTOTHERERROR_IN;
wire L0SETUSERDETECTEDPARITYERROR_IN;
wire L0SETUSERMASTERDATAPARITY_IN;
wire L0SETUSERRECEIVEDMASTERABORT_IN;
wire L0SETUSERRECEIVEDTARGETABORT_IN;
wire L0SETUSERSIGNALLEDTARGETABORT_IN;
wire L0SETUSERSYSTEMERROR_IN;
wire L0TLASFCCREDSTARVATION_IN;
wire L0TLLINKRETRAIN_IN;
wire L0TRANSACTIONSPENDING_IN;
wire L0TXBEACON_IN;
wire L0TXCFGPM_IN;
wire L0TXTLSBFCUPDATE_IN;
wire L0TXTLTLPEDB_IN;
wire L0TXTLTLPREQEND_IN;
wire L0TXTLTLPREQ_IN;
wire L0TXTLTLPWIDTH_IN;
wire L0UPSTREAMRXPORTINL0S_IN;
wire L0VC0PREVIEWEXPAND_IN;
wire L0WAKEN_IN;
wire LLKRXDSTCONTREQN_IN;
wire LLKRXDSTREQN_IN;
wire LLKTX4DWHEADERN_IN;
wire LLKTXCOMPLETEN_IN;
wire LLKTXCREATEECRCN_IN;
wire LLKTXEOFN_IN;
wire LLKTXEOPN_IN;
wire LLKTXSOFN_IN;
wire LLKTXSOPN_IN;
wire LLKTXSRCDSCN_IN;
wire LLKTXSRCRDYN_IN;
wire MAINPOWER_IN;
wire MGMTRDEN_IN;
wire MGMTWREN_IN;
wire PIPEPHYSTATUSL0_IN;
wire PIPEPHYSTATUSL1_IN;
wire PIPEPHYSTATUSL2_IN;
wire PIPEPHYSTATUSL3_IN;
wire PIPEPHYSTATUSL4_IN;
wire PIPEPHYSTATUSL5_IN;
wire PIPEPHYSTATUSL6_IN;
wire PIPEPHYSTATUSL7_IN;
wire PIPERXCHANISALIGNEDL0_IN;
wire PIPERXCHANISALIGNEDL1_IN;
wire PIPERXCHANISALIGNEDL2_IN;
wire PIPERXCHANISALIGNEDL3_IN;
wire PIPERXCHANISALIGNEDL4_IN;
wire PIPERXCHANISALIGNEDL5_IN;
wire PIPERXCHANISALIGNEDL6_IN;
wire PIPERXCHANISALIGNEDL7_IN;
wire PIPERXDATAKL0_IN;
wire PIPERXDATAKL1_IN;
wire PIPERXDATAKL2_IN;
wire PIPERXDATAKL3_IN;
wire PIPERXDATAKL4_IN;
wire PIPERXDATAKL5_IN;
wire PIPERXDATAKL6_IN;
wire PIPERXDATAKL7_IN;
wire PIPERXELECIDLEL0_IN;
wire PIPERXELECIDLEL1_IN;
wire PIPERXELECIDLEL2_IN;
wire PIPERXELECIDLEL3_IN;
wire PIPERXELECIDLEL4_IN;
wire PIPERXELECIDLEL5_IN;
wire PIPERXELECIDLEL6_IN;
wire PIPERXELECIDLEL7_IN;
wire PIPERXVALIDL0_IN;
wire PIPERXVALIDL1_IN;
wire PIPERXVALIDL2_IN;
wire PIPERXVALIDL3_IN;
wire PIPERXVALIDL4_IN;
wire PIPERXVALIDL5_IN;
wire PIPERXVALIDL6_IN;
wire PIPERXVALIDL7_IN;
wire [10:0] MGMTADDR_IN;
wire [11:0] L0ACKNAKTIMERADJUSTMENT_IN;
wire [11:0] L0REPLAYTIMERADJUSTMENT_IN;
wire [127:0] L0PACKETHEADERFROMUSER_IN;
wire [159:0] L0TXTLFCCMPLMCCRED_IN;
wire [159:0] L0TXTLFCPOSTORDCRED_IN;
wire [15:0] L0TXTLFCCMPLMCUPDATE_IN;
wire [15:0] L0TXTLFCNPOSTBYPUPDATE_IN;
wire [15:0] L0TXTLFCPOSTORDUPDATE_IN;
wire [18:0] L0TXTLSBFCDATA_IN;
wire [191:0] L0TXTLFCNPOSTBYPCRED_IN;
wire [1:0] L0PWRNEXTLINKSTATE_IN;
wire [1:0] L0TXTLTLPENABLE_IN;
wire [1:0] L0TXTLTLPEND_IN;
wire [1:0] LLKRXCHFIFO_IN;
wire [1:0] LLKTXCHFIFO_IN;
wire [1:0] LLKTXENABLEN_IN;
wire [23:0] L0CFGVCID_IN;
wire [2:0] L0ASTURNPOOLBITSCONSUMED_IN;
wire [2:0] L0CFGL0SEXITLAT_IN;
wire [2:0] L0CFGNEGOTIATEDMAXP_IN;
wire [2:0] L0TXCFGPMTYPE_IN;
wire [2:0] LLKRXCHTC_IN;
wire [2:0] LLKTXCHTC_IN;
wire [2:0] PIPERXSTATUSL0_IN;
wire [2:0] PIPERXSTATUSL1_IN;
wire [2:0] PIPERXSTATUSL2_IN;
wire [2:0] PIPERXSTATUSL3_IN;
wire [2:0] PIPERXSTATUSL4_IN;
wire [2:0] PIPERXSTATUSL5_IN;
wire [2:0] PIPERXSTATUSL6_IN;
wire [2:0] PIPERXSTATUSL7_IN;
wire [31:0] MGMTWDATA_IN;
wire [3:0] L0CFGASSTATECHANGECMD_IN;
wire [3:0] L0MSIREQUEST0_IN;
wire [3:0] L0TXTLTLPLATENCY_IN;
wire [3:0] MGMTBWREN_IN;
wire [5:0] CFGNEGOTIATEDLINKWIDTH_IN;
wire [63:0] L0TXTLTLPDATA_IN;
wire [63:0] LLKTXDATA_IN;
wire [63:0] MIMDLLBRDATA_IN;
wire [63:0] MIMRXBRDATA_IN;
wire [63:0] MIMTXBRDATA_IN;
wire [6:0] MGMTSTATSCREDITSEL_IN;
wire [7:0] L0ASPORTCOUNT_IN;
wire [7:0] L0CFGVCENABLE_IN;
wire [7:0] L0PORTNUMBER_IN;
wire [7:0] L0RXTLTLPNONINITIALIZEDVC_IN;
wire [7:0] PIPERXDATAL0_IN;
wire [7:0] PIPERXDATAL1_IN;
wire [7:0] PIPERXDATAL2_IN;
wire [7:0] PIPERXDATAL3_IN;
wire [7:0] PIPERXDATAL4_IN;
wire [7:0] PIPERXDATAL5_IN;
wire [7:0] PIPERXDATAL6_IN;
wire [7:0] PIPERXDATAL7_IN;



initial begin
	case (TXTSNFTS)
		0 : TXTSNFTS_BINARY = 8'b00000000;
		1 : TXTSNFTS_BINARY = 8'b00000001;
		2 : TXTSNFTS_BINARY = 8'b00000010;
		3 : TXTSNFTS_BINARY = 8'b00000011;
		4 : TXTSNFTS_BINARY = 8'b00000100;
		5 : TXTSNFTS_BINARY = 8'b00000101;
		6 : TXTSNFTS_BINARY = 8'b00000110;
		7 : TXTSNFTS_BINARY = 8'b00000111;
		8 : TXTSNFTS_BINARY = 8'b00001000;
		9 : TXTSNFTS_BINARY = 8'b00001001;
		10 : TXTSNFTS_BINARY = 8'b00001010;
		11 : TXTSNFTS_BINARY = 8'b00001011;
		12 : TXTSNFTS_BINARY = 8'b00001100;
		13 : TXTSNFTS_BINARY = 8'b00001101;
		14 : TXTSNFTS_BINARY = 8'b00001110;
		15 : TXTSNFTS_BINARY = 8'b00001111;
		16 : TXTSNFTS_BINARY = 8'b00010000;
		17 : TXTSNFTS_BINARY = 8'b00010001;
		18 : TXTSNFTS_BINARY = 8'b00010010;
		19 : TXTSNFTS_BINARY = 8'b00010011;
		20 : TXTSNFTS_BINARY = 8'b00010100;
		21 : TXTSNFTS_BINARY = 8'b00010101;
		22 : TXTSNFTS_BINARY = 8'b00010110;
		23 : TXTSNFTS_BINARY = 8'b00010111;
		24 : TXTSNFTS_BINARY = 8'b00011000;
		25 : TXTSNFTS_BINARY = 8'b00011001;
		26 : TXTSNFTS_BINARY = 8'b00011010;
		27 : TXTSNFTS_BINARY = 8'b00011011;
		28 : TXTSNFTS_BINARY = 8'b00011100;
		29 : TXTSNFTS_BINARY = 8'b00011101;
		30 : TXTSNFTS_BINARY = 8'b00011110;
		31 : TXTSNFTS_BINARY = 8'b00011111;
		32 : TXTSNFTS_BINARY = 8'b00100000;
		33 : TXTSNFTS_BINARY = 8'b00100001;
		34 : TXTSNFTS_BINARY = 8'b00100010;
		35 : TXTSNFTS_BINARY = 8'b00100011;
		36 : TXTSNFTS_BINARY = 8'b00100100;
		37 : TXTSNFTS_BINARY = 8'b00100101;
		38 : TXTSNFTS_BINARY = 8'b00100110;
		39 : TXTSNFTS_BINARY = 8'b00100111;
		40 : TXTSNFTS_BINARY = 8'b00101000;
		41 : TXTSNFTS_BINARY = 8'b00101001;
		42 : TXTSNFTS_BINARY = 8'b00101010;
		43 : TXTSNFTS_BINARY = 8'b00101011;
		44 : TXTSNFTS_BINARY = 8'b00101100;
		45 : TXTSNFTS_BINARY = 8'b00101101;
		46 : TXTSNFTS_BINARY = 8'b00101110;
		47 : TXTSNFTS_BINARY = 8'b00101111;
		48 : TXTSNFTS_BINARY = 8'b00110000;
		49 : TXTSNFTS_BINARY = 8'b00110001;
		50 : TXTSNFTS_BINARY = 8'b00110010;
		51 : TXTSNFTS_BINARY = 8'b00110011;
		52 : TXTSNFTS_BINARY = 8'b00110100;
		53 : TXTSNFTS_BINARY = 8'b00110101;
		54 : TXTSNFTS_BINARY = 8'b00110110;
		55 : TXTSNFTS_BINARY = 8'b00110111;
		56 : TXTSNFTS_BINARY = 8'b00111000;
		57 : TXTSNFTS_BINARY = 8'b00111001;
		58 : TXTSNFTS_BINARY = 8'b00111010;
		59 : TXTSNFTS_BINARY = 8'b00111011;
		60 : TXTSNFTS_BINARY = 8'b00111100;
		61 : TXTSNFTS_BINARY = 8'b00111101;
		62 : TXTSNFTS_BINARY = 8'b00111110;
		63 : TXTSNFTS_BINARY = 8'b00111111;
		64 : TXTSNFTS_BINARY = 8'b01000000;
		65 : TXTSNFTS_BINARY = 8'b01000001;
		66 : TXTSNFTS_BINARY = 8'b01000010;
		67 : TXTSNFTS_BINARY = 8'b01000011;
		68 : TXTSNFTS_BINARY = 8'b01000100;
		69 : TXTSNFTS_BINARY = 8'b01000101;
		70 : TXTSNFTS_BINARY = 8'b01000110;
		71 : TXTSNFTS_BINARY = 8'b01000111;
		72 : TXTSNFTS_BINARY = 8'b01001000;
		73 : TXTSNFTS_BINARY = 8'b01001001;
		74 : TXTSNFTS_BINARY = 8'b01001010;
		75 : TXTSNFTS_BINARY = 8'b01001011;
		76 : TXTSNFTS_BINARY = 8'b01001100;
		77 : TXTSNFTS_BINARY = 8'b01001101;
		78 : TXTSNFTS_BINARY = 8'b01001110;
		79 : TXTSNFTS_BINARY = 8'b01001111;
		80 : TXTSNFTS_BINARY = 8'b01010000;
		81 : TXTSNFTS_BINARY = 8'b01010001;
		82 : TXTSNFTS_BINARY = 8'b01010010;
		83 : TXTSNFTS_BINARY = 8'b01010011;
		84 : TXTSNFTS_BINARY = 8'b01010100;
		85 : TXTSNFTS_BINARY = 8'b01010101;
		86 : TXTSNFTS_BINARY = 8'b01010110;
		87 : TXTSNFTS_BINARY = 8'b01010111;
		88 : TXTSNFTS_BINARY = 8'b01011000;
		89 : TXTSNFTS_BINARY = 8'b01011001;
		90 : TXTSNFTS_BINARY = 8'b01011010;
		91 : TXTSNFTS_BINARY = 8'b01011011;
		92 : TXTSNFTS_BINARY = 8'b01011100;
		93 : TXTSNFTS_BINARY = 8'b01011101;
		94 : TXTSNFTS_BINARY = 8'b01011110;
		95 : TXTSNFTS_BINARY = 8'b01011111;
		96 : TXTSNFTS_BINARY = 8'b01100000;
		97 : TXTSNFTS_BINARY = 8'b01100001;
		98 : TXTSNFTS_BINARY = 8'b01100010;
		99 : TXTSNFTS_BINARY = 8'b01100011;
		100 : TXTSNFTS_BINARY = 8'b01100100;
		101 : TXTSNFTS_BINARY = 8'b01100101;
		102 : TXTSNFTS_BINARY = 8'b01100110;
		103 : TXTSNFTS_BINARY = 8'b01100111;
		104 : TXTSNFTS_BINARY = 8'b01101000;
		105 : TXTSNFTS_BINARY = 8'b01101001;
		106 : TXTSNFTS_BINARY = 8'b01101010;
		107 : TXTSNFTS_BINARY = 8'b01101011;
		108 : TXTSNFTS_BINARY = 8'b01101100;
		109 : TXTSNFTS_BINARY = 8'b01101101;
		110 : TXTSNFTS_BINARY = 8'b01101110;
		111 : TXTSNFTS_BINARY = 8'b01101111;
		112 : TXTSNFTS_BINARY = 8'b01110000;
		113 : TXTSNFTS_BINARY = 8'b01110001;
		114 : TXTSNFTS_BINARY = 8'b01110010;
		115 : TXTSNFTS_BINARY = 8'b01110011;
		116 : TXTSNFTS_BINARY = 8'b01110100;
		117 : TXTSNFTS_BINARY = 8'b01110101;
		118 : TXTSNFTS_BINARY = 8'b01110110;
		119 : TXTSNFTS_BINARY = 8'b01110111;
		120 : TXTSNFTS_BINARY = 8'b01111000;
		121 : TXTSNFTS_BINARY = 8'b01111001;
		122 : TXTSNFTS_BINARY = 8'b01111010;
		123 : TXTSNFTS_BINARY = 8'b01111011;
		124 : TXTSNFTS_BINARY = 8'b01111100;
		125 : TXTSNFTS_BINARY = 8'b01111101;
		126 : TXTSNFTS_BINARY = 8'b01111110;
		127 : TXTSNFTS_BINARY = 8'b01111111;
		128 : TXTSNFTS_BINARY = 8'b10000000;
		129 : TXTSNFTS_BINARY = 8'b10000001;
		130 : TXTSNFTS_BINARY = 8'b10000010;
		131 : TXTSNFTS_BINARY = 8'b10000011;
		132 : TXTSNFTS_BINARY = 8'b10000100;
		133 : TXTSNFTS_BINARY = 8'b10000101;
		134 : TXTSNFTS_BINARY = 8'b10000110;
		135 : TXTSNFTS_BINARY = 8'b10000111;
		136 : TXTSNFTS_BINARY = 8'b10001000;
		137 : TXTSNFTS_BINARY = 8'b10001001;
		138 : TXTSNFTS_BINARY = 8'b10001010;
		139 : TXTSNFTS_BINARY = 8'b10001011;
		140 : TXTSNFTS_BINARY = 8'b10001100;
		141 : TXTSNFTS_BINARY = 8'b10001101;
		142 : TXTSNFTS_BINARY = 8'b10001110;
		143 : TXTSNFTS_BINARY = 8'b10001111;
		144 : TXTSNFTS_BINARY = 8'b10010000;
		145 : TXTSNFTS_BINARY = 8'b10010001;
		146 : TXTSNFTS_BINARY = 8'b10010010;
		147 : TXTSNFTS_BINARY = 8'b10010011;
		148 : TXTSNFTS_BINARY = 8'b10010100;
		149 : TXTSNFTS_BINARY = 8'b10010101;
		150 : TXTSNFTS_BINARY = 8'b10010110;
		151 : TXTSNFTS_BINARY = 8'b10010111;
		152 : TXTSNFTS_BINARY = 8'b10011000;
		153 : TXTSNFTS_BINARY = 8'b10011001;
		154 : TXTSNFTS_BINARY = 8'b10011010;
		155 : TXTSNFTS_BINARY = 8'b10011011;
		156 : TXTSNFTS_BINARY = 8'b10011100;
		157 : TXTSNFTS_BINARY = 8'b10011101;
		158 : TXTSNFTS_BINARY = 8'b10011110;
		159 : TXTSNFTS_BINARY = 8'b10011111;
		160 : TXTSNFTS_BINARY = 8'b10100000;
		161 : TXTSNFTS_BINARY = 8'b10100001;
		162 : TXTSNFTS_BINARY = 8'b10100010;
		163 : TXTSNFTS_BINARY = 8'b10100011;
		164 : TXTSNFTS_BINARY = 8'b10100100;
		165 : TXTSNFTS_BINARY = 8'b10100101;
		166 : TXTSNFTS_BINARY = 8'b10100110;
		167 : TXTSNFTS_BINARY = 8'b10100111;
		168 : TXTSNFTS_BINARY = 8'b10101000;
		169 : TXTSNFTS_BINARY = 8'b10101001;
		170 : TXTSNFTS_BINARY = 8'b10101010;
		171 : TXTSNFTS_BINARY = 8'b10101011;
		172 : TXTSNFTS_BINARY = 8'b10101100;
		173 : TXTSNFTS_BINARY = 8'b10101101;
		174 : TXTSNFTS_BINARY = 8'b10101110;
		175 : TXTSNFTS_BINARY = 8'b10101111;
		176 : TXTSNFTS_BINARY = 8'b10110000;
		177 : TXTSNFTS_BINARY = 8'b10110001;
		178 : TXTSNFTS_BINARY = 8'b10110010;
		179 : TXTSNFTS_BINARY = 8'b10110011;
		180 : TXTSNFTS_BINARY = 8'b10110100;
		181 : TXTSNFTS_BINARY = 8'b10110101;
		182 : TXTSNFTS_BINARY = 8'b10110110;
		183 : TXTSNFTS_BINARY = 8'b10110111;
		184 : TXTSNFTS_BINARY = 8'b10111000;
		185 : TXTSNFTS_BINARY = 8'b10111001;
		186 : TXTSNFTS_BINARY = 8'b10111010;
		187 : TXTSNFTS_BINARY = 8'b10111011;
		188 : TXTSNFTS_BINARY = 8'b10111100;
		189 : TXTSNFTS_BINARY = 8'b10111101;
		190 : TXTSNFTS_BINARY = 8'b10111110;
		191 : TXTSNFTS_BINARY = 8'b10111111;
		192 : TXTSNFTS_BINARY = 8'b11000000;
		193 : TXTSNFTS_BINARY = 8'b11000001;
		194 : TXTSNFTS_BINARY = 8'b11000010;
		195 : TXTSNFTS_BINARY = 8'b11000011;
		196 : TXTSNFTS_BINARY = 8'b11000100;
		197 : TXTSNFTS_BINARY = 8'b11000101;
		198 : TXTSNFTS_BINARY = 8'b11000110;
		199 : TXTSNFTS_BINARY = 8'b11000111;
		200 : TXTSNFTS_BINARY = 8'b11001000;
		201 : TXTSNFTS_BINARY = 8'b11001001;
		202 : TXTSNFTS_BINARY = 8'b11001010;
		203 : TXTSNFTS_BINARY = 8'b11001011;
		204 : TXTSNFTS_BINARY = 8'b11001100;
		205 : TXTSNFTS_BINARY = 8'b11001101;
		206 : TXTSNFTS_BINARY = 8'b11001110;
		207 : TXTSNFTS_BINARY = 8'b11001111;
		208 : TXTSNFTS_BINARY = 8'b11010000;
		209 : TXTSNFTS_BINARY = 8'b11010001;
		210 : TXTSNFTS_BINARY = 8'b11010010;
		211 : TXTSNFTS_BINARY = 8'b11010011;
		212 : TXTSNFTS_BINARY = 8'b11010100;
		213 : TXTSNFTS_BINARY = 8'b11010101;
		214 : TXTSNFTS_BINARY = 8'b11010110;
		215 : TXTSNFTS_BINARY = 8'b11010111;
		216 : TXTSNFTS_BINARY = 8'b11011000;
		217 : TXTSNFTS_BINARY = 8'b11011001;
		218 : TXTSNFTS_BINARY = 8'b11011010;
		219 : TXTSNFTS_BINARY = 8'b11011011;
		220 : TXTSNFTS_BINARY = 8'b11011100;
		221 : TXTSNFTS_BINARY = 8'b11011101;
		222 : TXTSNFTS_BINARY = 8'b11011110;
		223 : TXTSNFTS_BINARY = 8'b11011111;
		224 : TXTSNFTS_BINARY = 8'b11100000;
		225 : TXTSNFTS_BINARY = 8'b11100001;
		226 : TXTSNFTS_BINARY = 8'b11100010;
		227 : TXTSNFTS_BINARY = 8'b11100011;
		228 : TXTSNFTS_BINARY = 8'b11100100;
		229 : TXTSNFTS_BINARY = 8'b11100101;
		230 : TXTSNFTS_BINARY = 8'b11100110;
		231 : TXTSNFTS_BINARY = 8'b11100111;
		232 : TXTSNFTS_BINARY = 8'b11101000;
		233 : TXTSNFTS_BINARY = 8'b11101001;
		234 : TXTSNFTS_BINARY = 8'b11101010;
		235 : TXTSNFTS_BINARY = 8'b11101011;
		236 : TXTSNFTS_BINARY = 8'b11101100;
		237 : TXTSNFTS_BINARY = 8'b11101101;
		238 : TXTSNFTS_BINARY = 8'b11101110;
		239 : TXTSNFTS_BINARY = 8'b11101111;
		240 : TXTSNFTS_BINARY = 8'b11110000;
		241 : TXTSNFTS_BINARY = 8'b11110001;
		242 : TXTSNFTS_BINARY = 8'b11110010;
		243 : TXTSNFTS_BINARY = 8'b11110011;
		244 : TXTSNFTS_BINARY = 8'b11110100;
		245 : TXTSNFTS_BINARY = 8'b11110101;
		246 : TXTSNFTS_BINARY = 8'b11110110;
		247 : TXTSNFTS_BINARY = 8'b11110111;
		248 : TXTSNFTS_BINARY = 8'b11111000;
		249 : TXTSNFTS_BINARY = 8'b11111001;
		250 : TXTSNFTS_BINARY = 8'b11111010;
		251 : TXTSNFTS_BINARY = 8'b11111011;
		252 : TXTSNFTS_BINARY = 8'b11111100;
		253 : TXTSNFTS_BINARY = 8'b11111101;
		254 : TXTSNFTS_BINARY = 8'b11111110;
		255 : TXTSNFTS_BINARY = 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXTSNFTS on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", TXTSNFTS);
			$finish;
		end
	endcase

	case (TXTSNFTSCOMCLK)
		0 : TXTSNFTSCOMCLK_BINARY = 8'b00000000;
		1 : TXTSNFTSCOMCLK_BINARY = 8'b00000001;
		2 : TXTSNFTSCOMCLK_BINARY = 8'b00000010;
		3 : TXTSNFTSCOMCLK_BINARY = 8'b00000011;
		4 : TXTSNFTSCOMCLK_BINARY = 8'b00000100;
		5 : TXTSNFTSCOMCLK_BINARY = 8'b00000101;
		6 : TXTSNFTSCOMCLK_BINARY = 8'b00000110;
		7 : TXTSNFTSCOMCLK_BINARY = 8'b00000111;
		8 : TXTSNFTSCOMCLK_BINARY = 8'b00001000;
		9 : TXTSNFTSCOMCLK_BINARY = 8'b00001001;
		10 : TXTSNFTSCOMCLK_BINARY = 8'b00001010;
		11 : TXTSNFTSCOMCLK_BINARY = 8'b00001011;
		12 : TXTSNFTSCOMCLK_BINARY = 8'b00001100;
		13 : TXTSNFTSCOMCLK_BINARY = 8'b00001101;
		14 : TXTSNFTSCOMCLK_BINARY = 8'b00001110;
		15 : TXTSNFTSCOMCLK_BINARY = 8'b00001111;
		16 : TXTSNFTSCOMCLK_BINARY = 8'b00010000;
		17 : TXTSNFTSCOMCLK_BINARY = 8'b00010001;
		18 : TXTSNFTSCOMCLK_BINARY = 8'b00010010;
		19 : TXTSNFTSCOMCLK_BINARY = 8'b00010011;
		20 : TXTSNFTSCOMCLK_BINARY = 8'b00010100;
		21 : TXTSNFTSCOMCLK_BINARY = 8'b00010101;
		22 : TXTSNFTSCOMCLK_BINARY = 8'b00010110;
		23 : TXTSNFTSCOMCLK_BINARY = 8'b00010111;
		24 : TXTSNFTSCOMCLK_BINARY = 8'b00011000;
		25 : TXTSNFTSCOMCLK_BINARY = 8'b00011001;
		26 : TXTSNFTSCOMCLK_BINARY = 8'b00011010;
		27 : TXTSNFTSCOMCLK_BINARY = 8'b00011011;
		28 : TXTSNFTSCOMCLK_BINARY = 8'b00011100;
		29 : TXTSNFTSCOMCLK_BINARY = 8'b00011101;
		30 : TXTSNFTSCOMCLK_BINARY = 8'b00011110;
		31 : TXTSNFTSCOMCLK_BINARY = 8'b00011111;
		32 : TXTSNFTSCOMCLK_BINARY = 8'b00100000;
		33 : TXTSNFTSCOMCLK_BINARY = 8'b00100001;
		34 : TXTSNFTSCOMCLK_BINARY = 8'b00100010;
		35 : TXTSNFTSCOMCLK_BINARY = 8'b00100011;
		36 : TXTSNFTSCOMCLK_BINARY = 8'b00100100;
		37 : TXTSNFTSCOMCLK_BINARY = 8'b00100101;
		38 : TXTSNFTSCOMCLK_BINARY = 8'b00100110;
		39 : TXTSNFTSCOMCLK_BINARY = 8'b00100111;
		40 : TXTSNFTSCOMCLK_BINARY = 8'b00101000;
		41 : TXTSNFTSCOMCLK_BINARY = 8'b00101001;
		42 : TXTSNFTSCOMCLK_BINARY = 8'b00101010;
		43 : TXTSNFTSCOMCLK_BINARY = 8'b00101011;
		44 : TXTSNFTSCOMCLK_BINARY = 8'b00101100;
		45 : TXTSNFTSCOMCLK_BINARY = 8'b00101101;
		46 : TXTSNFTSCOMCLK_BINARY = 8'b00101110;
		47 : TXTSNFTSCOMCLK_BINARY = 8'b00101111;
		48 : TXTSNFTSCOMCLK_BINARY = 8'b00110000;
		49 : TXTSNFTSCOMCLK_BINARY = 8'b00110001;
		50 : TXTSNFTSCOMCLK_BINARY = 8'b00110010;
		51 : TXTSNFTSCOMCLK_BINARY = 8'b00110011;
		52 : TXTSNFTSCOMCLK_BINARY = 8'b00110100;
		53 : TXTSNFTSCOMCLK_BINARY = 8'b00110101;
		54 : TXTSNFTSCOMCLK_BINARY = 8'b00110110;
		55 : TXTSNFTSCOMCLK_BINARY = 8'b00110111;
		56 : TXTSNFTSCOMCLK_BINARY = 8'b00111000;
		57 : TXTSNFTSCOMCLK_BINARY = 8'b00111001;
		58 : TXTSNFTSCOMCLK_BINARY = 8'b00111010;
		59 : TXTSNFTSCOMCLK_BINARY = 8'b00111011;
		60 : TXTSNFTSCOMCLK_BINARY = 8'b00111100;
		61 : TXTSNFTSCOMCLK_BINARY = 8'b00111101;
		62 : TXTSNFTSCOMCLK_BINARY = 8'b00111110;
		63 : TXTSNFTSCOMCLK_BINARY = 8'b00111111;
		64 : TXTSNFTSCOMCLK_BINARY = 8'b01000000;
		65 : TXTSNFTSCOMCLK_BINARY = 8'b01000001;
		66 : TXTSNFTSCOMCLK_BINARY = 8'b01000010;
		67 : TXTSNFTSCOMCLK_BINARY = 8'b01000011;
		68 : TXTSNFTSCOMCLK_BINARY = 8'b01000100;
		69 : TXTSNFTSCOMCLK_BINARY = 8'b01000101;
		70 : TXTSNFTSCOMCLK_BINARY = 8'b01000110;
		71 : TXTSNFTSCOMCLK_BINARY = 8'b01000111;
		72 : TXTSNFTSCOMCLK_BINARY = 8'b01001000;
		73 : TXTSNFTSCOMCLK_BINARY = 8'b01001001;
		74 : TXTSNFTSCOMCLK_BINARY = 8'b01001010;
		75 : TXTSNFTSCOMCLK_BINARY = 8'b01001011;
		76 : TXTSNFTSCOMCLK_BINARY = 8'b01001100;
		77 : TXTSNFTSCOMCLK_BINARY = 8'b01001101;
		78 : TXTSNFTSCOMCLK_BINARY = 8'b01001110;
		79 : TXTSNFTSCOMCLK_BINARY = 8'b01001111;
		80 : TXTSNFTSCOMCLK_BINARY = 8'b01010000;
		81 : TXTSNFTSCOMCLK_BINARY = 8'b01010001;
		82 : TXTSNFTSCOMCLK_BINARY = 8'b01010010;
		83 : TXTSNFTSCOMCLK_BINARY = 8'b01010011;
		84 : TXTSNFTSCOMCLK_BINARY = 8'b01010100;
		85 : TXTSNFTSCOMCLK_BINARY = 8'b01010101;
		86 : TXTSNFTSCOMCLK_BINARY = 8'b01010110;
		87 : TXTSNFTSCOMCLK_BINARY = 8'b01010111;
		88 : TXTSNFTSCOMCLK_BINARY = 8'b01011000;
		89 : TXTSNFTSCOMCLK_BINARY = 8'b01011001;
		90 : TXTSNFTSCOMCLK_BINARY = 8'b01011010;
		91 : TXTSNFTSCOMCLK_BINARY = 8'b01011011;
		92 : TXTSNFTSCOMCLK_BINARY = 8'b01011100;
		93 : TXTSNFTSCOMCLK_BINARY = 8'b01011101;
		94 : TXTSNFTSCOMCLK_BINARY = 8'b01011110;
		95 : TXTSNFTSCOMCLK_BINARY = 8'b01011111;
		96 : TXTSNFTSCOMCLK_BINARY = 8'b01100000;
		97 : TXTSNFTSCOMCLK_BINARY = 8'b01100001;
		98 : TXTSNFTSCOMCLK_BINARY = 8'b01100010;
		99 : TXTSNFTSCOMCLK_BINARY = 8'b01100011;
		100 : TXTSNFTSCOMCLK_BINARY = 8'b01100100;
		101 : TXTSNFTSCOMCLK_BINARY = 8'b01100101;
		102 : TXTSNFTSCOMCLK_BINARY = 8'b01100110;
		103 : TXTSNFTSCOMCLK_BINARY = 8'b01100111;
		104 : TXTSNFTSCOMCLK_BINARY = 8'b01101000;
		105 : TXTSNFTSCOMCLK_BINARY = 8'b01101001;
		106 : TXTSNFTSCOMCLK_BINARY = 8'b01101010;
		107 : TXTSNFTSCOMCLK_BINARY = 8'b01101011;
		108 : TXTSNFTSCOMCLK_BINARY = 8'b01101100;
		109 : TXTSNFTSCOMCLK_BINARY = 8'b01101101;
		110 : TXTSNFTSCOMCLK_BINARY = 8'b01101110;
		111 : TXTSNFTSCOMCLK_BINARY = 8'b01101111;
		112 : TXTSNFTSCOMCLK_BINARY = 8'b01110000;
		113 : TXTSNFTSCOMCLK_BINARY = 8'b01110001;
		114 : TXTSNFTSCOMCLK_BINARY = 8'b01110010;
		115 : TXTSNFTSCOMCLK_BINARY = 8'b01110011;
		116 : TXTSNFTSCOMCLK_BINARY = 8'b01110100;
		117 : TXTSNFTSCOMCLK_BINARY = 8'b01110101;
		118 : TXTSNFTSCOMCLK_BINARY = 8'b01110110;
		119 : TXTSNFTSCOMCLK_BINARY = 8'b01110111;
		120 : TXTSNFTSCOMCLK_BINARY = 8'b01111000;
		121 : TXTSNFTSCOMCLK_BINARY = 8'b01111001;
		122 : TXTSNFTSCOMCLK_BINARY = 8'b01111010;
		123 : TXTSNFTSCOMCLK_BINARY = 8'b01111011;
		124 : TXTSNFTSCOMCLK_BINARY = 8'b01111100;
		125 : TXTSNFTSCOMCLK_BINARY = 8'b01111101;
		126 : TXTSNFTSCOMCLK_BINARY = 8'b01111110;
		127 : TXTSNFTSCOMCLK_BINARY = 8'b01111111;
		128 : TXTSNFTSCOMCLK_BINARY = 8'b10000000;
		129 : TXTSNFTSCOMCLK_BINARY = 8'b10000001;
		130 : TXTSNFTSCOMCLK_BINARY = 8'b10000010;
		131 : TXTSNFTSCOMCLK_BINARY = 8'b10000011;
		132 : TXTSNFTSCOMCLK_BINARY = 8'b10000100;
		133 : TXTSNFTSCOMCLK_BINARY = 8'b10000101;
		134 : TXTSNFTSCOMCLK_BINARY = 8'b10000110;
		135 : TXTSNFTSCOMCLK_BINARY = 8'b10000111;
		136 : TXTSNFTSCOMCLK_BINARY = 8'b10001000;
		137 : TXTSNFTSCOMCLK_BINARY = 8'b10001001;
		138 : TXTSNFTSCOMCLK_BINARY = 8'b10001010;
		139 : TXTSNFTSCOMCLK_BINARY = 8'b10001011;
		140 : TXTSNFTSCOMCLK_BINARY = 8'b10001100;
		141 : TXTSNFTSCOMCLK_BINARY = 8'b10001101;
		142 : TXTSNFTSCOMCLK_BINARY = 8'b10001110;
		143 : TXTSNFTSCOMCLK_BINARY = 8'b10001111;
		144 : TXTSNFTSCOMCLK_BINARY = 8'b10010000;
		145 : TXTSNFTSCOMCLK_BINARY = 8'b10010001;
		146 : TXTSNFTSCOMCLK_BINARY = 8'b10010010;
		147 : TXTSNFTSCOMCLK_BINARY = 8'b10010011;
		148 : TXTSNFTSCOMCLK_BINARY = 8'b10010100;
		149 : TXTSNFTSCOMCLK_BINARY = 8'b10010101;
		150 : TXTSNFTSCOMCLK_BINARY = 8'b10010110;
		151 : TXTSNFTSCOMCLK_BINARY = 8'b10010111;
		152 : TXTSNFTSCOMCLK_BINARY = 8'b10011000;
		153 : TXTSNFTSCOMCLK_BINARY = 8'b10011001;
		154 : TXTSNFTSCOMCLK_BINARY = 8'b10011010;
		155 : TXTSNFTSCOMCLK_BINARY = 8'b10011011;
		156 : TXTSNFTSCOMCLK_BINARY = 8'b10011100;
		157 : TXTSNFTSCOMCLK_BINARY = 8'b10011101;
		158 : TXTSNFTSCOMCLK_BINARY = 8'b10011110;
		159 : TXTSNFTSCOMCLK_BINARY = 8'b10011111;
		160 : TXTSNFTSCOMCLK_BINARY = 8'b10100000;
		161 : TXTSNFTSCOMCLK_BINARY = 8'b10100001;
		162 : TXTSNFTSCOMCLK_BINARY = 8'b10100010;
		163 : TXTSNFTSCOMCLK_BINARY = 8'b10100011;
		164 : TXTSNFTSCOMCLK_BINARY = 8'b10100100;
		165 : TXTSNFTSCOMCLK_BINARY = 8'b10100101;
		166 : TXTSNFTSCOMCLK_BINARY = 8'b10100110;
		167 : TXTSNFTSCOMCLK_BINARY = 8'b10100111;
		168 : TXTSNFTSCOMCLK_BINARY = 8'b10101000;
		169 : TXTSNFTSCOMCLK_BINARY = 8'b10101001;
		170 : TXTSNFTSCOMCLK_BINARY = 8'b10101010;
		171 : TXTSNFTSCOMCLK_BINARY = 8'b10101011;
		172 : TXTSNFTSCOMCLK_BINARY = 8'b10101100;
		173 : TXTSNFTSCOMCLK_BINARY = 8'b10101101;
		174 : TXTSNFTSCOMCLK_BINARY = 8'b10101110;
		175 : TXTSNFTSCOMCLK_BINARY = 8'b10101111;
		176 : TXTSNFTSCOMCLK_BINARY = 8'b10110000;
		177 : TXTSNFTSCOMCLK_BINARY = 8'b10110001;
		178 : TXTSNFTSCOMCLK_BINARY = 8'b10110010;
		179 : TXTSNFTSCOMCLK_BINARY = 8'b10110011;
		180 : TXTSNFTSCOMCLK_BINARY = 8'b10110100;
		181 : TXTSNFTSCOMCLK_BINARY = 8'b10110101;
		182 : TXTSNFTSCOMCLK_BINARY = 8'b10110110;
		183 : TXTSNFTSCOMCLK_BINARY = 8'b10110111;
		184 : TXTSNFTSCOMCLK_BINARY = 8'b10111000;
		185 : TXTSNFTSCOMCLK_BINARY = 8'b10111001;
		186 : TXTSNFTSCOMCLK_BINARY = 8'b10111010;
		187 : TXTSNFTSCOMCLK_BINARY = 8'b10111011;
		188 : TXTSNFTSCOMCLK_BINARY = 8'b10111100;
		189 : TXTSNFTSCOMCLK_BINARY = 8'b10111101;
		190 : TXTSNFTSCOMCLK_BINARY = 8'b10111110;
		191 : TXTSNFTSCOMCLK_BINARY = 8'b10111111;
		192 : TXTSNFTSCOMCLK_BINARY = 8'b11000000;
		193 : TXTSNFTSCOMCLK_BINARY = 8'b11000001;
		194 : TXTSNFTSCOMCLK_BINARY = 8'b11000010;
		195 : TXTSNFTSCOMCLK_BINARY = 8'b11000011;
		196 : TXTSNFTSCOMCLK_BINARY = 8'b11000100;
		197 : TXTSNFTSCOMCLK_BINARY = 8'b11000101;
		198 : TXTSNFTSCOMCLK_BINARY = 8'b11000110;
		199 : TXTSNFTSCOMCLK_BINARY = 8'b11000111;
		200 : TXTSNFTSCOMCLK_BINARY = 8'b11001000;
		201 : TXTSNFTSCOMCLK_BINARY = 8'b11001001;
		202 : TXTSNFTSCOMCLK_BINARY = 8'b11001010;
		203 : TXTSNFTSCOMCLK_BINARY = 8'b11001011;
		204 : TXTSNFTSCOMCLK_BINARY = 8'b11001100;
		205 : TXTSNFTSCOMCLK_BINARY = 8'b11001101;
		206 : TXTSNFTSCOMCLK_BINARY = 8'b11001110;
		207 : TXTSNFTSCOMCLK_BINARY = 8'b11001111;
		208 : TXTSNFTSCOMCLK_BINARY = 8'b11010000;
		209 : TXTSNFTSCOMCLK_BINARY = 8'b11010001;
		210 : TXTSNFTSCOMCLK_BINARY = 8'b11010010;
		211 : TXTSNFTSCOMCLK_BINARY = 8'b11010011;
		212 : TXTSNFTSCOMCLK_BINARY = 8'b11010100;
		213 : TXTSNFTSCOMCLK_BINARY = 8'b11010101;
		214 : TXTSNFTSCOMCLK_BINARY = 8'b11010110;
		215 : TXTSNFTSCOMCLK_BINARY = 8'b11010111;
		216 : TXTSNFTSCOMCLK_BINARY = 8'b11011000;
		217 : TXTSNFTSCOMCLK_BINARY = 8'b11011001;
		218 : TXTSNFTSCOMCLK_BINARY = 8'b11011010;
		219 : TXTSNFTSCOMCLK_BINARY = 8'b11011011;
		220 : TXTSNFTSCOMCLK_BINARY = 8'b11011100;
		221 : TXTSNFTSCOMCLK_BINARY = 8'b11011101;
		222 : TXTSNFTSCOMCLK_BINARY = 8'b11011110;
		223 : TXTSNFTSCOMCLK_BINARY = 8'b11011111;
		224 : TXTSNFTSCOMCLK_BINARY = 8'b11100000;
		225 : TXTSNFTSCOMCLK_BINARY = 8'b11100001;
		226 : TXTSNFTSCOMCLK_BINARY = 8'b11100010;
		227 : TXTSNFTSCOMCLK_BINARY = 8'b11100011;
		228 : TXTSNFTSCOMCLK_BINARY = 8'b11100100;
		229 : TXTSNFTSCOMCLK_BINARY = 8'b11100101;
		230 : TXTSNFTSCOMCLK_BINARY = 8'b11100110;
		231 : TXTSNFTSCOMCLK_BINARY = 8'b11100111;
		232 : TXTSNFTSCOMCLK_BINARY = 8'b11101000;
		233 : TXTSNFTSCOMCLK_BINARY = 8'b11101001;
		234 : TXTSNFTSCOMCLK_BINARY = 8'b11101010;
		235 : TXTSNFTSCOMCLK_BINARY = 8'b11101011;
		236 : TXTSNFTSCOMCLK_BINARY = 8'b11101100;
		237 : TXTSNFTSCOMCLK_BINARY = 8'b11101101;
		238 : TXTSNFTSCOMCLK_BINARY = 8'b11101110;
		239 : TXTSNFTSCOMCLK_BINARY = 8'b11101111;
		240 : TXTSNFTSCOMCLK_BINARY = 8'b11110000;
		241 : TXTSNFTSCOMCLK_BINARY = 8'b11110001;
		242 : TXTSNFTSCOMCLK_BINARY = 8'b11110010;
		243 : TXTSNFTSCOMCLK_BINARY = 8'b11110011;
		244 : TXTSNFTSCOMCLK_BINARY = 8'b11110100;
		245 : TXTSNFTSCOMCLK_BINARY = 8'b11110101;
		246 : TXTSNFTSCOMCLK_BINARY = 8'b11110110;
		247 : TXTSNFTSCOMCLK_BINARY = 8'b11110111;
		248 : TXTSNFTSCOMCLK_BINARY = 8'b11111000;
		249 : TXTSNFTSCOMCLK_BINARY = 8'b11111001;
		250 : TXTSNFTSCOMCLK_BINARY = 8'b11111010;
		251 : TXTSNFTSCOMCLK_BINARY = 8'b11111011;
		252 : TXTSNFTSCOMCLK_BINARY = 8'b11111100;
		253 : TXTSNFTSCOMCLK_BINARY = 8'b11111101;
		254 : TXTSNFTSCOMCLK_BINARY = 8'b11111110;
		255 : TXTSNFTSCOMCLK_BINARY = 8'b11111111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXTSNFTSCOMCLK on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 255.", TXTSNFTSCOMCLK);
			$finish;
		end
	endcase

	case (RETRYRAMREADLATENCY)
		0 : RETRYRAMREADLATENCY_BINARY = 3'b000;
		1 : RETRYRAMREADLATENCY_BINARY = 3'b001;
		2 : RETRYRAMREADLATENCY_BINARY = 3'b010;
		3 : RETRYRAMREADLATENCY_BINARY = 3'b011;
		4 : RETRYRAMREADLATENCY_BINARY = 3'b100;
		5 : RETRYRAMREADLATENCY_BINARY = 3'b101;
		6 : RETRYRAMREADLATENCY_BINARY = 3'b110;
		7 : RETRYRAMREADLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMREADLATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", RETRYRAMREADLATENCY);
			$finish;
		end
	endcase

	case (RETRYRAMWRITELATENCY)
		0 : RETRYRAMWRITELATENCY_BINARY = 3'b000;
		1 : RETRYRAMWRITELATENCY_BINARY = 3'b001;
		2 : RETRYRAMWRITELATENCY_BINARY = 3'b010;
		3 : RETRYRAMWRITELATENCY_BINARY = 3'b011;
		4 : RETRYRAMWRITELATENCY_BINARY = 3'b100;
		5 : RETRYRAMWRITELATENCY_BINARY = 3'b101;
		6 : RETRYRAMWRITELATENCY_BINARY = 3'b110;
		7 : RETRYRAMWRITELATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMWRITELATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", RETRYRAMWRITELATENCY);
			$finish;
		end
	endcase

	case (RETRYRAMWIDTH)
		0 : RETRYRAMWIDTH_BINARY = 1'b0;
		1 : RETRYRAMWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYRAMWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", RETRYRAMWIDTH);
			$finish;
		end
	endcase

	case (RETRYWRITEPIPE)
		"FALSE" : RETRYWRITEPIPE_BINARY = 1'b0;
		"TRUE" : RETRYWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYWRITEPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYWRITEPIPE);
			$finish;
		end
	endcase

	case (RETRYREADADDRPIPE)
		"FALSE" : RETRYREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : RETRYREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYREADADDRPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYREADADDRPIPE);
			$finish;
		end
	endcase

	case (RETRYREADDATAPIPE)
		"FALSE" : RETRYREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : RETRYREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RETRYREADDATAPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RETRYREADDATAPIPE);
			$finish;
		end
	endcase

	case (XLINKSUPPORTED)
		"FALSE" : XLINKSUPPORTED_BINARY = 1'b0;
		"TRUE" : XLINKSUPPORTED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute XLINKSUPPORTED on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", XLINKSUPPORTED);
			$finish;
		end
	endcase

	case (INFINITECOMPLETIONS)
		"FALSE" : INFINITECOMPLETIONS_BINARY = 1'b0;
		"TRUE" : INFINITECOMPLETIONS_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute INFINITECOMPLETIONS on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", INFINITECOMPLETIONS);
			$finish;
		end
	endcase

	case (TLRAMREADLATENCY)
		0 : TLRAMREADLATENCY_BINARY = 3'b000;
		1 : TLRAMREADLATENCY_BINARY = 3'b001;
		2 : TLRAMREADLATENCY_BINARY = 3'b010;
		3 : TLRAMREADLATENCY_BINARY = 3'b011;
		4 : TLRAMREADLATENCY_BINARY = 3'b100;
		5 : TLRAMREADLATENCY_BINARY = 3'b101;
		6 : TLRAMREADLATENCY_BINARY = 3'b110;
		7 : TLRAMREADLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMREADLATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", TLRAMREADLATENCY);
			$finish;
		end
	endcase

	case (TLRAMWRITELATENCY)
		0 : TLRAMWRITELATENCY_BINARY = 3'b000;
		1 : TLRAMWRITELATENCY_BINARY = 3'b001;
		2 : TLRAMWRITELATENCY_BINARY = 3'b010;
		3 : TLRAMWRITELATENCY_BINARY = 3'b011;
		4 : TLRAMWRITELATENCY_BINARY = 3'b100;
		5 : TLRAMWRITELATENCY_BINARY = 3'b101;
		6 : TLRAMWRITELATENCY_BINARY = 3'b110;
		7 : TLRAMWRITELATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMWRITELATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", TLRAMWRITELATENCY);
			$finish;
		end
	endcase

	case (TLRAMWIDTH)
		0 : TLRAMWIDTH_BINARY = 1'b0;
		1 : TLRAMWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TLRAMWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", TLRAMWIDTH);
			$finish;
		end
	endcase

	case (RAMSHARETXRX)
		"FALSE" : RAMSHARETXRX_BINARY = 1'b0;
		"TRUE" : RAMSHARETXRX_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RAMSHARETXRX on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RAMSHARETXRX);
			$finish;
		end
	endcase

	case (L0SEXITLATENCY)
		0 : L0SEXITLATENCY_BINARY = 3'b000;
		1 : L0SEXITLATENCY_BINARY = 3'b001;
		2 : L0SEXITLATENCY_BINARY = 3'b010;
		3 : L0SEXITLATENCY_BINARY = 3'b011;
		4 : L0SEXITLATENCY_BINARY = 3'b100;
		5 : L0SEXITLATENCY_BINARY = 3'b101;
		6 : L0SEXITLATENCY_BINARY = 3'b110;
		7 : L0SEXITLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L0SEXITLATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L0SEXITLATENCY);
			$finish;
		end
	endcase

	case (L0SEXITLATENCYCOMCLK)
		0 : L0SEXITLATENCYCOMCLK_BINARY = 3'b000;
		1 : L0SEXITLATENCYCOMCLK_BINARY = 3'b001;
		2 : L0SEXITLATENCYCOMCLK_BINARY = 3'b010;
		3 : L0SEXITLATENCYCOMCLK_BINARY = 3'b011;
		4 : L0SEXITLATENCYCOMCLK_BINARY = 3'b100;
		5 : L0SEXITLATENCYCOMCLK_BINARY = 3'b101;
		6 : L0SEXITLATENCYCOMCLK_BINARY = 3'b110;
		7 : L0SEXITLATENCYCOMCLK_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L0SEXITLATENCYCOMCLK on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L0SEXITLATENCYCOMCLK);
			$finish;
		end
	endcase

	case (L1EXITLATENCY)
		0 : L1EXITLATENCY_BINARY = 3'b000;
		1 : L1EXITLATENCY_BINARY = 3'b001;
		2 : L1EXITLATENCY_BINARY = 3'b010;
		3 : L1EXITLATENCY_BINARY = 3'b011;
		4 : L1EXITLATENCY_BINARY = 3'b100;
		5 : L1EXITLATENCY_BINARY = 3'b101;
		6 : L1EXITLATENCY_BINARY = 3'b110;
		7 : L1EXITLATENCY_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L1EXITLATENCY on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L1EXITLATENCY);
			$finish;
		end
	endcase

	case (L1EXITLATENCYCOMCLK)
		0 : L1EXITLATENCYCOMCLK_BINARY = 3'b000;
		1 : L1EXITLATENCYCOMCLK_BINARY = 3'b001;
		2 : L1EXITLATENCYCOMCLK_BINARY = 3'b010;
		3 : L1EXITLATENCYCOMCLK_BINARY = 3'b011;
		4 : L1EXITLATENCYCOMCLK_BINARY = 3'b100;
		5 : L1EXITLATENCYCOMCLK_BINARY = 3'b101;
		6 : L1EXITLATENCYCOMCLK_BINARY = 3'b110;
		7 : L1EXITLATENCYCOMCLK_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute L1EXITLATENCYCOMCLK on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", L1EXITLATENCYCOMCLK);
			$finish;
		end
	endcase

	case (DUALCORESLAVE)
		"FALSE" : DUALCORESLAVE_BINARY = 1'b0;
		"TRUE" : DUALCORESLAVE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALCORESLAVE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DUALCORESLAVE);
			$finish;
		end
	endcase

	case (DUALCOREENABLE)
		"FALSE" : DUALCOREENABLE_BINARY = 1'b0;
		"TRUE" : DUALCOREENABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALCOREENABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DUALCOREENABLE);
			$finish;
		end
	endcase

	case (DUALROLECFGCNTRLROOTEPN)
		0 : DUALROLECFGCNTRLROOTEPN_BINARY = 1'b0;
		1 : DUALROLECFGCNTRLROOTEPN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute DUALROLECFGCNTRLROOTEPN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", DUALROLECFGCNTRLROOTEPN);
			$finish;
		end
	endcase

	case (RXREADADDRPIPE)
		"FALSE" : RXREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : RXREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXREADADDRPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXREADADDRPIPE);
			$finish;
		end
	endcase

	case (RXREADDATAPIPE)
		"FALSE" : RXREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : RXREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXREADDATAPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXREADDATAPIPE);
			$finish;
		end
	endcase

	case (TXWRITEPIPE)
		"FALSE" : TXWRITEPIPE_BINARY = 1'b0;
		"TRUE" : TXWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXWRITEPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXWRITEPIPE);
			$finish;
		end
	endcase

	case (TXREADADDRPIPE)
		"FALSE" : TXREADADDRPIPE_BINARY = 1'b0;
		"TRUE" : TXREADADDRPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXREADADDRPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXREADADDRPIPE);
			$finish;
		end
	endcase

	case (TXREADDATAPIPE)
		"FALSE" : TXREADDATAPIPE_BINARY = 1'b0;
		"TRUE" : TXREADDATAPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute TXREADDATAPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TXREADDATAPIPE);
			$finish;
		end
	endcase

	case (RXWRITEPIPE)
		"FALSE" : RXWRITEPIPE_BINARY = 1'b0;
		"TRUE" : RXWRITEPIPE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RXWRITEPIPE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RXWRITEPIPE);
			$finish;
		end
	endcase

	case (LLKBYPASS)
		"FALSE" : LLKBYPASS_BINARY = 1'b0;
		"TRUE" : LLKBYPASS_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute LLKBYPASS on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LLKBYPASS);
			$finish;
		end
	endcase

	case (PCIEREVISION)
		0 : PCIEREVISION_BINARY = 1'b0;
		1 : PCIEREVISION_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCIEREVISION on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", PCIEREVISION);
			$finish;
		end
	endcase

	case (SELECTDLLIF)
		"FALSE" : SELECTDLLIF_BINARY = 1'b0;
		"TRUE" : SELECTDLLIF_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SELECTDLLIF on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECTDLLIF);
			$finish;
		end
	endcase

	case (SELECTASMODE)
		"FALSE" : SELECTASMODE_BINARY = 1'b0;
		"TRUE" : SELECTASMODE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SELECTASMODE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECTASMODE);
			$finish;
		end
	endcase

	case (ISSWITCH)
		"FALSE" : ISSWITCH_BINARY = 1'b0;
		"TRUE" : ISSWITCH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute ISSWITCH on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ISSWITCH);
			$finish;
		end
	endcase

	case (UPSTREAMFACING)
		"FALSE" : UPSTREAMFACING_BINARY = 1'b0;
		"TRUE" : UPSTREAMFACING_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute UPSTREAMFACING on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPSTREAMFACING);
			$finish;
		end
	endcase

	case (SLOTIMPLEMENTED)
		"FALSE" : SLOTIMPLEMENTED_BINARY = 1'b0;
		"TRUE" : SLOTIMPLEMENTED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTIMPLEMENTED on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTIMPLEMENTED);
			$finish;
		end
	endcase

	case (BAR0EXIST)
		"FALSE" : BAR0EXIST_BINARY = 1'b0;
		"TRUE" : BAR0EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR0EXIST);
			$finish;
		end
	endcase

	case (BAR1EXIST)
		"FALSE" : BAR1EXIST_BINARY = 1'b0;
		"TRUE" : BAR1EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR1EXIST);
			$finish;
		end
	endcase

	case (BAR2EXIST)
		"FALSE" : BAR2EXIST_BINARY = 1'b0;
		"TRUE" : BAR2EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR2EXIST);
			$finish;
		end
	endcase

	case (BAR3EXIST)
		"FALSE" : BAR3EXIST_BINARY = 1'b0;
		"TRUE" : BAR3EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR3EXIST);
			$finish;
		end
	endcase

	case (BAR4EXIST)
		"FALSE" : BAR4EXIST_BINARY = 1'b0;
		"TRUE" : BAR4EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR4EXIST);
			$finish;
		end
	endcase

	case (BAR5EXIST)
		"FALSE" : BAR5EXIST_BINARY = 1'b0;
		"TRUE" : BAR5EXIST_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5EXIST on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR5EXIST);
			$finish;
		end
	endcase

	case (BAR0ADDRWIDTH)
		0 : BAR0ADDRWIDTH_BINARY = 1'b0;
		1 : BAR0ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0ADDRWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR0ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR1ADDRWIDTH)
		0 : BAR1ADDRWIDTH_BINARY = 1'b0;
		1 : BAR1ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1ADDRWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR1ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR2ADDRWIDTH)
		0 : BAR2ADDRWIDTH_BINARY = 1'b0;
		1 : BAR2ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2ADDRWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR2ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR3ADDRWIDTH)
		0 : BAR3ADDRWIDTH_BINARY = 1'b0;
		1 : BAR3ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3ADDRWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR3ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR4ADDRWIDTH)
		0 : BAR4ADDRWIDTH_BINARY = 1'b0;
		1 : BAR4ADDRWIDTH_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4ADDRWIDTH on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR4ADDRWIDTH);
			$finish;
		end
	endcase

	case (BAR0PREFETCHABLE)
		"FALSE" : BAR0PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR0PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR0PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR1PREFETCHABLE)
		"FALSE" : BAR1PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR1PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR1PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR2PREFETCHABLE)
		"FALSE" : BAR2PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR2PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR2PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR3PREFETCHABLE)
		"FALSE" : BAR3PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR3PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR3PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR4PREFETCHABLE)
		"FALSE" : BAR4PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR4PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR4PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR5PREFETCHABLE)
		"FALSE" : BAR5PREFETCHABLE_BINARY = 1'b0;
		"TRUE" : BAR5PREFETCHABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5PREFETCHABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", BAR5PREFETCHABLE);
			$finish;
		end
	endcase

	case (BAR0IOMEMN)
		0 : BAR0IOMEMN_BINARY = 1'b0;
		1 : BAR0IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR0IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR0IOMEMN);
			$finish;
		end
	endcase

	case (BAR1IOMEMN)
		0 : BAR1IOMEMN_BINARY = 1'b0;
		1 : BAR1IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR1IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR1IOMEMN);
			$finish;
		end
	endcase

	case (BAR2IOMEMN)
		0 : BAR2IOMEMN_BINARY = 1'b0;
		1 : BAR2IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR2IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR2IOMEMN);
			$finish;
		end
	endcase

	case (BAR3IOMEMN)
		0 : BAR3IOMEMN_BINARY = 1'b0;
		1 : BAR3IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR3IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR3IOMEMN);
			$finish;
		end
	endcase

	case (BAR4IOMEMN)
		0 : BAR4IOMEMN_BINARY = 1'b0;
		1 : BAR4IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR4IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR4IOMEMN);
			$finish;
		end
	endcase

	case (BAR5IOMEMN)
		0 : BAR5IOMEMN_BINARY = 1'b0;
		1 : BAR5IOMEMN_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute BAR5IOMEMN on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", BAR5IOMEMN);
			$finish;
		end
	endcase

	case (XPMAXPAYLOAD)
		0 : XPMAXPAYLOAD_BINARY = 3'b000;
		1 : XPMAXPAYLOAD_BINARY = 3'b001;
		2 : XPMAXPAYLOAD_BINARY = 3'b010;
		3 : XPMAXPAYLOAD_BINARY = 3'b011;
		4 : XPMAXPAYLOAD_BINARY = 3'b100;
		5 : XPMAXPAYLOAD_BINARY = 3'b101;
		6 : XPMAXPAYLOAD_BINARY = 3'b110;
		7 : XPMAXPAYLOAD_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute XPMAXPAYLOAD on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", XPMAXPAYLOAD);
			$finish;
		end
	endcase

	case (XPRCBCONTROL)
		0 : XPRCBCONTROL_BINARY = 1'b0;
		1 : XPRCBCONTROL_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute XPRCBCONTROL on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 1.", XPRCBCONTROL);
			$finish;
		end
	endcase

	case (LOWPRIORITYVCCOUNT)
		0 : LOWPRIORITYVCCOUNT_BINARY = 3'b000;
		1 : LOWPRIORITYVCCOUNT_BINARY = 3'b001;
		2 : LOWPRIORITYVCCOUNT_BINARY = 3'b010;
		3 : LOWPRIORITYVCCOUNT_BINARY = 3'b011;
		4 : LOWPRIORITYVCCOUNT_BINARY = 3'b100;
		5 : LOWPRIORITYVCCOUNT_BINARY = 3'b101;
		6 : LOWPRIORITYVCCOUNT_BINARY = 3'b110;
		7 : LOWPRIORITYVCCOUNT_BINARY = 3'b111;
		default : begin
			$display("Attribute Syntax Error : The Attribute LOWPRIORITYVCCOUNT on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 7.", LOWPRIORITYVCCOUNT);
			$finish;
		end
	endcase

	case (PMCAPABILITYDSI)
		"FALSE" : PMCAPABILITYDSI_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYDSI_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYDSI on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYDSI);
			$finish;
		end
	endcase

	case (PMCAPABILITYD1SUPPORT)
		"FALSE" : PMCAPABILITYD1SUPPORT_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYD1SUPPORT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYD1SUPPORT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYD1SUPPORT);
			$finish;
		end
	endcase

	case (PMCAPABILITYD2SUPPORT)
		"FALSE" : PMCAPABILITYD2SUPPORT_BINARY = 1'b0;
		"TRUE" : PMCAPABILITYD2SUPPORT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMCAPABILITYD2SUPPORT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PMCAPABILITYD2SUPPORT);
			$finish;
		end
	endcase

	case (PMDATASCALE0)
		0 : PMDATASCALE0_BINARY = 2'b00;
		1 : PMDATASCALE0_BINARY = 2'b01;
		2 : PMDATASCALE0_BINARY = 2'b10;
		3 : PMDATASCALE0_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE0 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE0);
			$finish;
		end
	endcase

	case (PMDATASCALE1)
		0 : PMDATASCALE1_BINARY = 2'b00;
		1 : PMDATASCALE1_BINARY = 2'b01;
		2 : PMDATASCALE1_BINARY = 2'b10;
		3 : PMDATASCALE1_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE1 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE1);
			$finish;
		end
	endcase

	case (PMDATASCALE2)
		0 : PMDATASCALE2_BINARY = 2'b00;
		1 : PMDATASCALE2_BINARY = 2'b01;
		2 : PMDATASCALE2_BINARY = 2'b10;
		3 : PMDATASCALE2_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE2 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE2);
			$finish;
		end
	endcase

	case (PMDATASCALE3)
		0 : PMDATASCALE3_BINARY = 2'b00;
		1 : PMDATASCALE3_BINARY = 2'b01;
		2 : PMDATASCALE3_BINARY = 2'b10;
		3 : PMDATASCALE3_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE3 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE3);
			$finish;
		end
	endcase

	case (PMDATASCALE4)
		0 : PMDATASCALE4_BINARY = 2'b00;
		1 : PMDATASCALE4_BINARY = 2'b01;
		2 : PMDATASCALE4_BINARY = 2'b10;
		3 : PMDATASCALE4_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE4 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE4);
			$finish;
		end
	endcase

	case (PMDATASCALE5)
		0 : PMDATASCALE5_BINARY = 2'b00;
		1 : PMDATASCALE5_BINARY = 2'b01;
		2 : PMDATASCALE5_BINARY = 2'b10;
		3 : PMDATASCALE5_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE5 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE5);
			$finish;
		end
	endcase

	case (PMDATASCALE6)
		0 : PMDATASCALE6_BINARY = 2'b00;
		1 : PMDATASCALE6_BINARY = 2'b01;
		2 : PMDATASCALE6_BINARY = 2'b10;
		3 : PMDATASCALE6_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE6 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE6);
			$finish;
		end
	endcase

	case (PMDATASCALE7)
		0 : PMDATASCALE7_BINARY = 2'b00;
		1 : PMDATASCALE7_BINARY = 2'b01;
		2 : PMDATASCALE7_BINARY = 2'b10;
		3 : PMDATASCALE7_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE7 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE7);
			$finish;
		end
	endcase

	case (PMDATASCALE8)
		0 : PMDATASCALE8_BINARY = 2'b00;
		1 : PMDATASCALE8_BINARY = 2'b01;
		2 : PMDATASCALE8_BINARY = 2'b10;
		3 : PMDATASCALE8_BINARY = 2'b11;
		default : begin
			$display("Attribute Syntax Error : The Attribute PMDATASCALE8 on X_PCIE_INTERNAL_1_1 instance %m is set to %d.  Legal values for this attribute are 0 to 3.", PMDATASCALE8);
			$finish;
		end
	endcase

	case (PCIECAPABILITYSLOTIMPL)
		"FALSE" : PCIECAPABILITYSLOTIMPL_BINARY = 1'b0;
		"TRUE" : PCIECAPABILITYSLOTIMPL_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PCIECAPABILITYSLOTIMPL on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIECAPABILITYSLOTIMPL);
			$finish;
		end
	endcase

	case (LINKSTATUSSLOTCLOCKCONFIG)
		"FALSE" : LINKSTATUSSLOTCLOCKCONFIG_BINARY = 1'b0;
		"TRUE" : LINKSTATUSSLOTCLOCKCONFIG_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute LINKSTATUSSLOTCLOCKCONFIG on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINKSTATUSSLOTCLOCKCONFIG);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYATTBUTTONPRESENT)
		"FALSE" : SLOTCAPABILITYATTBUTTONPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYATTBUTTONPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYATTBUTTONPRESENT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYATTBUTTONPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYPOWERCONTROLLERPRESENT)
		"FALSE" : SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYPOWERCONTROLLERPRESENT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYPOWERCONTROLLERPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYMSLSENSORPRESENT)
		"FALSE" : SLOTCAPABILITYMSLSENSORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYMSLSENSORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYMSLSENSORPRESENT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYMSLSENSORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYATTINDICATORPRESENT)
		"FALSE" : SLOTCAPABILITYATTINDICATORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYATTINDICATORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYATTINDICATORPRESENT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYATTINDICATORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYPOWERINDICATORPRESENT)
		"FALSE" : SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYPOWERINDICATORPRESENT on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYPOWERINDICATORPRESENT);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYHOTPLUGSURPRISE)
		"FALSE" : SLOTCAPABILITYHOTPLUGSURPRISE_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYHOTPLUGSURPRISE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYHOTPLUGSURPRISE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYHOTPLUGSURPRISE);
			$finish;
		end
	endcase

	case (SLOTCAPABILITYHOTPLUGCAPABLE)
		"FALSE" : SLOTCAPABILITYHOTPLUGCAPABLE_BINARY = 1'b0;
		"TRUE" : SLOTCAPABILITYHOTPLUGCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute SLOTCAPABILITYHOTPLUGCAPABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOTCAPABILITYHOTPLUGCAPABLE);
			$finish;
		end
	endcase

	case (AERCAPABILITYECRCGENCAPABLE)
		"FALSE" : AERCAPABILITYECRCGENCAPABLE_BINARY = 1'b0;
		"TRUE" : AERCAPABILITYECRCGENCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute AERCAPABILITYECRCGENCAPABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AERCAPABILITYECRCGENCAPABLE);
			$finish;
		end
	endcase

	case (AERCAPABILITYECRCCHECKCAPABLE)
		"FALSE" : AERCAPABILITYECRCCHECKCAPABLE_BINARY = 1'b0;
		"TRUE" : AERCAPABILITYECRCCHECKCAPABLE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute AERCAPABILITYECRCCHECKCAPABLE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AERCAPABILITYECRCCHECKCAPABLE);
			$finish;
		end
	endcase

	case (PBCAPABILITYSYSTEMALLOCATED)
		"FALSE" : PBCAPABILITYSYSTEMALLOCATED_BINARY = 1'b0;
		"TRUE" : PBCAPABILITYSYSTEMALLOCATED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute PBCAPABILITYSYSTEMALLOCATED on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PBCAPABILITYSYSTEMALLOCATED);
			$finish;
		end
	endcase

	case (RESETMODE)
		"FALSE" : RESETMODE_BINARY = 1'b0;
		"TRUE" : RESETMODE_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute RESETMODE on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RESETMODE);
			$finish;
		end
	endcase

	case (CLKDIVIDED)
		"FALSE" : CLKDIVIDED_BINARY = 1'b0;
		"TRUE" : CLKDIVIDED_BINARY = 1'b1;
		default : begin
			$display("Attribute Syntax Error : The Attribute CLKDIVIDED on X_PCIE_INTERNAL_1_1 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CLKDIVIDED);
			$finish;
		end
	endcase

end

buf B_PIPETXDATAL00 (PIPETXDATAL0[0], PIPETXDATAL0_OUT[0]);
buf B_PIPETXDATAL01 (PIPETXDATAL0[1], PIPETXDATAL0_OUT[1]);
buf B_PIPETXDATAL02 (PIPETXDATAL0[2], PIPETXDATAL0_OUT[2]);
buf B_PIPETXDATAL03 (PIPETXDATAL0[3], PIPETXDATAL0_OUT[3]);
buf B_PIPETXDATAL04 (PIPETXDATAL0[4], PIPETXDATAL0_OUT[4]);
buf B_PIPETXDATAL05 (PIPETXDATAL0[5], PIPETXDATAL0_OUT[5]);
buf B_PIPETXDATAL06 (PIPETXDATAL0[6], PIPETXDATAL0_OUT[6]);
buf B_PIPETXDATAL07 (PIPETXDATAL0[7], PIPETXDATAL0_OUT[7]);
buf B_PIPETXDATAKL0 (PIPETXDATAKL0, PIPETXDATAKL0_OUT);
buf B_PIPETXELECIDLEL0 (PIPETXELECIDLEL0, PIPETXELECIDLEL0_OUT);
buf B_PIPETXDETECTRXLOOPBACKL0 (PIPETXDETECTRXLOOPBACKL0, PIPETXDETECTRXLOOPBACKL0_OUT);
buf B_PIPETXCOMPLIANCEL0 (PIPETXCOMPLIANCEL0, PIPETXCOMPLIANCEL0_OUT);
buf B_PIPERXPOLARITYL0 (PIPERXPOLARITYL0, PIPERXPOLARITYL0_OUT);
buf B_PIPEPOWERDOWNL00 (PIPEPOWERDOWNL0[0], PIPEPOWERDOWNL0_OUT[0]);
buf B_PIPEPOWERDOWNL01 (PIPEPOWERDOWNL0[1], PIPEPOWERDOWNL0_OUT[1]);
buf B_PIPEDESKEWLANESL0 (PIPEDESKEWLANESL0, PIPEDESKEWLANESL0_OUT);
buf B_PIPERESETL0 (PIPERESETL0, PIPERESETL0_OUT);
buf B_PIPETXDATAL10 (PIPETXDATAL1[0], PIPETXDATAL1_OUT[0]);
buf B_PIPETXDATAL11 (PIPETXDATAL1[1], PIPETXDATAL1_OUT[1]);
buf B_PIPETXDATAL12 (PIPETXDATAL1[2], PIPETXDATAL1_OUT[2]);
buf B_PIPETXDATAL13 (PIPETXDATAL1[3], PIPETXDATAL1_OUT[3]);
buf B_PIPETXDATAL14 (PIPETXDATAL1[4], PIPETXDATAL1_OUT[4]);
buf B_PIPETXDATAL15 (PIPETXDATAL1[5], PIPETXDATAL1_OUT[5]);
buf B_PIPETXDATAL16 (PIPETXDATAL1[6], PIPETXDATAL1_OUT[6]);
buf B_PIPETXDATAL17 (PIPETXDATAL1[7], PIPETXDATAL1_OUT[7]);
buf B_PIPETXDATAKL1 (PIPETXDATAKL1, PIPETXDATAKL1_OUT);
buf B_PIPETXELECIDLEL1 (PIPETXELECIDLEL1, PIPETXELECIDLEL1_OUT);
buf B_PIPETXDETECTRXLOOPBACKL1 (PIPETXDETECTRXLOOPBACKL1, PIPETXDETECTRXLOOPBACKL1_OUT);
buf B_PIPETXCOMPLIANCEL1 (PIPETXCOMPLIANCEL1, PIPETXCOMPLIANCEL1_OUT);
buf B_PIPERXPOLARITYL1 (PIPERXPOLARITYL1, PIPERXPOLARITYL1_OUT);
buf B_PIPEPOWERDOWNL10 (PIPEPOWERDOWNL1[0], PIPEPOWERDOWNL1_OUT[0]);
buf B_PIPEPOWERDOWNL11 (PIPEPOWERDOWNL1[1], PIPEPOWERDOWNL1_OUT[1]);
buf B_PIPEDESKEWLANESL1 (PIPEDESKEWLANESL1, PIPEDESKEWLANESL1_OUT);
buf B_PIPERESETL1 (PIPERESETL1, PIPERESETL1_OUT);
buf B_PIPETXDATAL20 (PIPETXDATAL2[0], PIPETXDATAL2_OUT[0]);
buf B_PIPETXDATAL21 (PIPETXDATAL2[1], PIPETXDATAL2_OUT[1]);
buf B_PIPETXDATAL22 (PIPETXDATAL2[2], PIPETXDATAL2_OUT[2]);
buf B_PIPETXDATAL23 (PIPETXDATAL2[3], PIPETXDATAL2_OUT[3]);
buf B_PIPETXDATAL24 (PIPETXDATAL2[4], PIPETXDATAL2_OUT[4]);
buf B_PIPETXDATAL25 (PIPETXDATAL2[5], PIPETXDATAL2_OUT[5]);
buf B_PIPETXDATAL26 (PIPETXDATAL2[6], PIPETXDATAL2_OUT[6]);
buf B_PIPETXDATAL27 (PIPETXDATAL2[7], PIPETXDATAL2_OUT[7]);
buf B_PIPETXDATAKL2 (PIPETXDATAKL2, PIPETXDATAKL2_OUT);
buf B_PIPETXELECIDLEL2 (PIPETXELECIDLEL2, PIPETXELECIDLEL2_OUT);
buf B_PIPETXDETECTRXLOOPBACKL2 (PIPETXDETECTRXLOOPBACKL2, PIPETXDETECTRXLOOPBACKL2_OUT);
buf B_PIPETXCOMPLIANCEL2 (PIPETXCOMPLIANCEL2, PIPETXCOMPLIANCEL2_OUT);
buf B_PIPERXPOLARITYL2 (PIPERXPOLARITYL2, PIPERXPOLARITYL2_OUT);
buf B_PIPEPOWERDOWNL20 (PIPEPOWERDOWNL2[0], PIPEPOWERDOWNL2_OUT[0]);
buf B_PIPEPOWERDOWNL21 (PIPEPOWERDOWNL2[1], PIPEPOWERDOWNL2_OUT[1]);
buf B_PIPEDESKEWLANESL2 (PIPEDESKEWLANESL2, PIPEDESKEWLANESL2_OUT);
buf B_PIPERESETL2 (PIPERESETL2, PIPERESETL2_OUT);
buf B_PIPETXDATAL30 (PIPETXDATAL3[0], PIPETXDATAL3_OUT[0]);
buf B_PIPETXDATAL31 (PIPETXDATAL3[1], PIPETXDATAL3_OUT[1]);
buf B_PIPETXDATAL32 (PIPETXDATAL3[2], PIPETXDATAL3_OUT[2]);
buf B_PIPETXDATAL33 (PIPETXDATAL3[3], PIPETXDATAL3_OUT[3]);
buf B_PIPETXDATAL34 (PIPETXDATAL3[4], PIPETXDATAL3_OUT[4]);
buf B_PIPETXDATAL35 (PIPETXDATAL3[5], PIPETXDATAL3_OUT[5]);
buf B_PIPETXDATAL36 (PIPETXDATAL3[6], PIPETXDATAL3_OUT[6]);
buf B_PIPETXDATAL37 (PIPETXDATAL3[7], PIPETXDATAL3_OUT[7]);
buf B_PIPETXDATAKL3 (PIPETXDATAKL3, PIPETXDATAKL3_OUT);
buf B_PIPETXELECIDLEL3 (PIPETXELECIDLEL3, PIPETXELECIDLEL3_OUT);
buf B_PIPETXDETECTRXLOOPBACKL3 (PIPETXDETECTRXLOOPBACKL3, PIPETXDETECTRXLOOPBACKL3_OUT);
buf B_PIPETXCOMPLIANCEL3 (PIPETXCOMPLIANCEL3, PIPETXCOMPLIANCEL3_OUT);
buf B_PIPERXPOLARITYL3 (PIPERXPOLARITYL3, PIPERXPOLARITYL3_OUT);
buf B_PIPEPOWERDOWNL30 (PIPEPOWERDOWNL3[0], PIPEPOWERDOWNL3_OUT[0]);
buf B_PIPEPOWERDOWNL31 (PIPEPOWERDOWNL3[1], PIPEPOWERDOWNL3_OUT[1]);
buf B_PIPEDESKEWLANESL3 (PIPEDESKEWLANESL3, PIPEDESKEWLANESL3_OUT);
buf B_PIPERESETL3 (PIPERESETL3, PIPERESETL3_OUT);
buf B_PIPETXDATAL40 (PIPETXDATAL4[0], PIPETXDATAL4_OUT[0]);
buf B_PIPETXDATAL41 (PIPETXDATAL4[1], PIPETXDATAL4_OUT[1]);
buf B_PIPETXDATAL42 (PIPETXDATAL4[2], PIPETXDATAL4_OUT[2]);
buf B_PIPETXDATAL43 (PIPETXDATAL4[3], PIPETXDATAL4_OUT[3]);
buf B_PIPETXDATAL44 (PIPETXDATAL4[4], PIPETXDATAL4_OUT[4]);
buf B_PIPETXDATAL45 (PIPETXDATAL4[5], PIPETXDATAL4_OUT[5]);
buf B_PIPETXDATAL46 (PIPETXDATAL4[6], PIPETXDATAL4_OUT[6]);
buf B_PIPETXDATAL47 (PIPETXDATAL4[7], PIPETXDATAL4_OUT[7]);
buf B_PIPETXDATAKL4 (PIPETXDATAKL4, PIPETXDATAKL4_OUT);
buf B_PIPETXELECIDLEL4 (PIPETXELECIDLEL4, PIPETXELECIDLEL4_OUT);
buf B_PIPETXDETECTRXLOOPBACKL4 (PIPETXDETECTRXLOOPBACKL4, PIPETXDETECTRXLOOPBACKL4_OUT);
buf B_PIPETXCOMPLIANCEL4 (PIPETXCOMPLIANCEL4, PIPETXCOMPLIANCEL4_OUT);
buf B_PIPERXPOLARITYL4 (PIPERXPOLARITYL4, PIPERXPOLARITYL4_OUT);
buf B_PIPEPOWERDOWNL40 (PIPEPOWERDOWNL4[0], PIPEPOWERDOWNL4_OUT[0]);
buf B_PIPEPOWERDOWNL41 (PIPEPOWERDOWNL4[1], PIPEPOWERDOWNL4_OUT[1]);
buf B_PIPEDESKEWLANESL4 (PIPEDESKEWLANESL4, PIPEDESKEWLANESL4_OUT);
buf B_PIPERESETL4 (PIPERESETL4, PIPERESETL4_OUT);
buf B_PIPETXDATAL50 (PIPETXDATAL5[0], PIPETXDATAL5_OUT[0]);
buf B_PIPETXDATAL51 (PIPETXDATAL5[1], PIPETXDATAL5_OUT[1]);
buf B_PIPETXDATAL52 (PIPETXDATAL5[2], PIPETXDATAL5_OUT[2]);
buf B_PIPETXDATAL53 (PIPETXDATAL5[3], PIPETXDATAL5_OUT[3]);
buf B_PIPETXDATAL54 (PIPETXDATAL5[4], PIPETXDATAL5_OUT[4]);
buf B_PIPETXDATAL55 (PIPETXDATAL5[5], PIPETXDATAL5_OUT[5]);
buf B_PIPETXDATAL56 (PIPETXDATAL5[6], PIPETXDATAL5_OUT[6]);
buf B_PIPETXDATAL57 (PIPETXDATAL5[7], PIPETXDATAL5_OUT[7]);
buf B_PIPETXDATAKL5 (PIPETXDATAKL5, PIPETXDATAKL5_OUT);
buf B_PIPETXELECIDLEL5 (PIPETXELECIDLEL5, PIPETXELECIDLEL5_OUT);
buf B_PIPETXDETECTRXLOOPBACKL5 (PIPETXDETECTRXLOOPBACKL5, PIPETXDETECTRXLOOPBACKL5_OUT);
buf B_PIPETXCOMPLIANCEL5 (PIPETXCOMPLIANCEL5, PIPETXCOMPLIANCEL5_OUT);
buf B_PIPERXPOLARITYL5 (PIPERXPOLARITYL5, PIPERXPOLARITYL5_OUT);
buf B_PIPEPOWERDOWNL50 (PIPEPOWERDOWNL5[0], PIPEPOWERDOWNL5_OUT[0]);
buf B_PIPEPOWERDOWNL51 (PIPEPOWERDOWNL5[1], PIPEPOWERDOWNL5_OUT[1]);
buf B_PIPEDESKEWLANESL5 (PIPEDESKEWLANESL5, PIPEDESKEWLANESL5_OUT);
buf B_PIPERESETL5 (PIPERESETL5, PIPERESETL5_OUT);
buf B_PIPETXDATAL60 (PIPETXDATAL6[0], PIPETXDATAL6_OUT[0]);
buf B_PIPETXDATAL61 (PIPETXDATAL6[1], PIPETXDATAL6_OUT[1]);
buf B_PIPETXDATAL62 (PIPETXDATAL6[2], PIPETXDATAL6_OUT[2]);
buf B_PIPETXDATAL63 (PIPETXDATAL6[3], PIPETXDATAL6_OUT[3]);
buf B_PIPETXDATAL64 (PIPETXDATAL6[4], PIPETXDATAL6_OUT[4]);
buf B_PIPETXDATAL65 (PIPETXDATAL6[5], PIPETXDATAL6_OUT[5]);
buf B_PIPETXDATAL66 (PIPETXDATAL6[6], PIPETXDATAL6_OUT[6]);
buf B_PIPETXDATAL67 (PIPETXDATAL6[7], PIPETXDATAL6_OUT[7]);
buf B_PIPETXDATAKL6 (PIPETXDATAKL6, PIPETXDATAKL6_OUT);
buf B_PIPETXELECIDLEL6 (PIPETXELECIDLEL6, PIPETXELECIDLEL6_OUT);
buf B_PIPETXDETECTRXLOOPBACKL6 (PIPETXDETECTRXLOOPBACKL6, PIPETXDETECTRXLOOPBACKL6_OUT);
buf B_PIPETXCOMPLIANCEL6 (PIPETXCOMPLIANCEL6, PIPETXCOMPLIANCEL6_OUT);
buf B_PIPERXPOLARITYL6 (PIPERXPOLARITYL6, PIPERXPOLARITYL6_OUT);
buf B_PIPEPOWERDOWNL60 (PIPEPOWERDOWNL6[0], PIPEPOWERDOWNL6_OUT[0]);
buf B_PIPEPOWERDOWNL61 (PIPEPOWERDOWNL6[1], PIPEPOWERDOWNL6_OUT[1]);
buf B_PIPEDESKEWLANESL6 (PIPEDESKEWLANESL6, PIPEDESKEWLANESL6_OUT);
buf B_PIPERESETL6 (PIPERESETL6, PIPERESETL6_OUT);
buf B_PIPETXDATAL70 (PIPETXDATAL7[0], PIPETXDATAL7_OUT[0]);
buf B_PIPETXDATAL71 (PIPETXDATAL7[1], PIPETXDATAL7_OUT[1]);
buf B_PIPETXDATAL72 (PIPETXDATAL7[2], PIPETXDATAL7_OUT[2]);
buf B_PIPETXDATAL73 (PIPETXDATAL7[3], PIPETXDATAL7_OUT[3]);
buf B_PIPETXDATAL74 (PIPETXDATAL7[4], PIPETXDATAL7_OUT[4]);
buf B_PIPETXDATAL75 (PIPETXDATAL7[5], PIPETXDATAL7_OUT[5]);
buf B_PIPETXDATAL76 (PIPETXDATAL7[6], PIPETXDATAL7_OUT[6]);
buf B_PIPETXDATAL77 (PIPETXDATAL7[7], PIPETXDATAL7_OUT[7]);
buf B_PIPETXDATAKL7 (PIPETXDATAKL7, PIPETXDATAKL7_OUT);
buf B_PIPETXELECIDLEL7 (PIPETXELECIDLEL7, PIPETXELECIDLEL7_OUT);
buf B_PIPETXDETECTRXLOOPBACKL7 (PIPETXDETECTRXLOOPBACKL7, PIPETXDETECTRXLOOPBACKL7_OUT);
buf B_PIPETXCOMPLIANCEL7 (PIPETXCOMPLIANCEL7, PIPETXCOMPLIANCEL7_OUT);
buf B_PIPERXPOLARITYL7 (PIPERXPOLARITYL7, PIPERXPOLARITYL7_OUT);
buf B_PIPEPOWERDOWNL70 (PIPEPOWERDOWNL7[0], PIPEPOWERDOWNL7_OUT[0]);
buf B_PIPEPOWERDOWNL71 (PIPEPOWERDOWNL7[1], PIPEPOWERDOWNL7_OUT[1]);
buf B_PIPEDESKEWLANESL7 (PIPEDESKEWLANESL7, PIPEDESKEWLANESL7_OUT);
buf B_PIPERESETL7 (PIPERESETL7, PIPERESETL7_OUT);
buf B_MIMRXBWDATA0 (MIMRXBWDATA[0], MIMRXBWDATA_OUT[0]);
buf B_MIMRXBWDATA1 (MIMRXBWDATA[1], MIMRXBWDATA_OUT[1]);
buf B_MIMRXBWDATA2 (MIMRXBWDATA[2], MIMRXBWDATA_OUT[2]);
buf B_MIMRXBWDATA3 (MIMRXBWDATA[3], MIMRXBWDATA_OUT[3]);
buf B_MIMRXBWDATA4 (MIMRXBWDATA[4], MIMRXBWDATA_OUT[4]);
buf B_MIMRXBWDATA5 (MIMRXBWDATA[5], MIMRXBWDATA_OUT[5]);
buf B_MIMRXBWDATA6 (MIMRXBWDATA[6], MIMRXBWDATA_OUT[6]);
buf B_MIMRXBWDATA7 (MIMRXBWDATA[7], MIMRXBWDATA_OUT[7]);
buf B_MIMRXBWDATA8 (MIMRXBWDATA[8], MIMRXBWDATA_OUT[8]);
buf B_MIMRXBWDATA9 (MIMRXBWDATA[9], MIMRXBWDATA_OUT[9]);
buf B_MIMRXBWDATA10 (MIMRXBWDATA[10], MIMRXBWDATA_OUT[10]);
buf B_MIMRXBWDATA11 (MIMRXBWDATA[11], MIMRXBWDATA_OUT[11]);
buf B_MIMRXBWDATA12 (MIMRXBWDATA[12], MIMRXBWDATA_OUT[12]);
buf B_MIMRXBWDATA13 (MIMRXBWDATA[13], MIMRXBWDATA_OUT[13]);
buf B_MIMRXBWDATA14 (MIMRXBWDATA[14], MIMRXBWDATA_OUT[14]);
buf B_MIMRXBWDATA15 (MIMRXBWDATA[15], MIMRXBWDATA_OUT[15]);
buf B_MIMRXBWDATA16 (MIMRXBWDATA[16], MIMRXBWDATA_OUT[16]);
buf B_MIMRXBWDATA17 (MIMRXBWDATA[17], MIMRXBWDATA_OUT[17]);
buf B_MIMRXBWDATA18 (MIMRXBWDATA[18], MIMRXBWDATA_OUT[18]);
buf B_MIMRXBWDATA19 (MIMRXBWDATA[19], MIMRXBWDATA_OUT[19]);
buf B_MIMRXBWDATA20 (MIMRXBWDATA[20], MIMRXBWDATA_OUT[20]);
buf B_MIMRXBWDATA21 (MIMRXBWDATA[21], MIMRXBWDATA_OUT[21]);
buf B_MIMRXBWDATA22 (MIMRXBWDATA[22], MIMRXBWDATA_OUT[22]);
buf B_MIMRXBWDATA23 (MIMRXBWDATA[23], MIMRXBWDATA_OUT[23]);
buf B_MIMRXBWDATA24 (MIMRXBWDATA[24], MIMRXBWDATA_OUT[24]);
buf B_MIMRXBWDATA25 (MIMRXBWDATA[25], MIMRXBWDATA_OUT[25]);
buf B_MIMRXBWDATA26 (MIMRXBWDATA[26], MIMRXBWDATA_OUT[26]);
buf B_MIMRXBWDATA27 (MIMRXBWDATA[27], MIMRXBWDATA_OUT[27]);
buf B_MIMRXBWDATA28 (MIMRXBWDATA[28], MIMRXBWDATA_OUT[28]);
buf B_MIMRXBWDATA29 (MIMRXBWDATA[29], MIMRXBWDATA_OUT[29]);
buf B_MIMRXBWDATA30 (MIMRXBWDATA[30], MIMRXBWDATA_OUT[30]);
buf B_MIMRXBWDATA31 (MIMRXBWDATA[31], MIMRXBWDATA_OUT[31]);
buf B_MIMRXBWDATA32 (MIMRXBWDATA[32], MIMRXBWDATA_OUT[32]);
buf B_MIMRXBWDATA33 (MIMRXBWDATA[33], MIMRXBWDATA_OUT[33]);
buf B_MIMRXBWDATA34 (MIMRXBWDATA[34], MIMRXBWDATA_OUT[34]);
buf B_MIMRXBWDATA35 (MIMRXBWDATA[35], MIMRXBWDATA_OUT[35]);
buf B_MIMRXBWDATA36 (MIMRXBWDATA[36], MIMRXBWDATA_OUT[36]);
buf B_MIMRXBWDATA37 (MIMRXBWDATA[37], MIMRXBWDATA_OUT[37]);
buf B_MIMRXBWDATA38 (MIMRXBWDATA[38], MIMRXBWDATA_OUT[38]);
buf B_MIMRXBWDATA39 (MIMRXBWDATA[39], MIMRXBWDATA_OUT[39]);
buf B_MIMRXBWDATA40 (MIMRXBWDATA[40], MIMRXBWDATA_OUT[40]);
buf B_MIMRXBWDATA41 (MIMRXBWDATA[41], MIMRXBWDATA_OUT[41]);
buf B_MIMRXBWDATA42 (MIMRXBWDATA[42], MIMRXBWDATA_OUT[42]);
buf B_MIMRXBWDATA43 (MIMRXBWDATA[43], MIMRXBWDATA_OUT[43]);
buf B_MIMRXBWDATA44 (MIMRXBWDATA[44], MIMRXBWDATA_OUT[44]);
buf B_MIMRXBWDATA45 (MIMRXBWDATA[45], MIMRXBWDATA_OUT[45]);
buf B_MIMRXBWDATA46 (MIMRXBWDATA[46], MIMRXBWDATA_OUT[46]);
buf B_MIMRXBWDATA47 (MIMRXBWDATA[47], MIMRXBWDATA_OUT[47]);
buf B_MIMRXBWDATA48 (MIMRXBWDATA[48], MIMRXBWDATA_OUT[48]);
buf B_MIMRXBWDATA49 (MIMRXBWDATA[49], MIMRXBWDATA_OUT[49]);
buf B_MIMRXBWDATA50 (MIMRXBWDATA[50], MIMRXBWDATA_OUT[50]);
buf B_MIMRXBWDATA51 (MIMRXBWDATA[51], MIMRXBWDATA_OUT[51]);
buf B_MIMRXBWDATA52 (MIMRXBWDATA[52], MIMRXBWDATA_OUT[52]);
buf B_MIMRXBWDATA53 (MIMRXBWDATA[53], MIMRXBWDATA_OUT[53]);
buf B_MIMRXBWDATA54 (MIMRXBWDATA[54], MIMRXBWDATA_OUT[54]);
buf B_MIMRXBWDATA55 (MIMRXBWDATA[55], MIMRXBWDATA_OUT[55]);
buf B_MIMRXBWDATA56 (MIMRXBWDATA[56], MIMRXBWDATA_OUT[56]);
buf B_MIMRXBWDATA57 (MIMRXBWDATA[57], MIMRXBWDATA_OUT[57]);
buf B_MIMRXBWDATA58 (MIMRXBWDATA[58], MIMRXBWDATA_OUT[58]);
buf B_MIMRXBWDATA59 (MIMRXBWDATA[59], MIMRXBWDATA_OUT[59]);
buf B_MIMRXBWDATA60 (MIMRXBWDATA[60], MIMRXBWDATA_OUT[60]);
buf B_MIMRXBWDATA61 (MIMRXBWDATA[61], MIMRXBWDATA_OUT[61]);
buf B_MIMRXBWDATA62 (MIMRXBWDATA[62], MIMRXBWDATA_OUT[62]);
buf B_MIMRXBWDATA63 (MIMRXBWDATA[63], MIMRXBWDATA_OUT[63]);
buf B_MIMRXBWADD0 (MIMRXBWADD[0], MIMRXBWADD_OUT[0]);
buf B_MIMRXBWADD1 (MIMRXBWADD[1], MIMRXBWADD_OUT[1]);
buf B_MIMRXBWADD2 (MIMRXBWADD[2], MIMRXBWADD_OUT[2]);
buf B_MIMRXBWADD3 (MIMRXBWADD[3], MIMRXBWADD_OUT[3]);
buf B_MIMRXBWADD4 (MIMRXBWADD[4], MIMRXBWADD_OUT[4]);
buf B_MIMRXBWADD5 (MIMRXBWADD[5], MIMRXBWADD_OUT[5]);
buf B_MIMRXBWADD6 (MIMRXBWADD[6], MIMRXBWADD_OUT[6]);
buf B_MIMRXBWADD7 (MIMRXBWADD[7], MIMRXBWADD_OUT[7]);
buf B_MIMRXBWADD8 (MIMRXBWADD[8], MIMRXBWADD_OUT[8]);
buf B_MIMRXBWADD9 (MIMRXBWADD[9], MIMRXBWADD_OUT[9]);
buf B_MIMRXBWADD10 (MIMRXBWADD[10], MIMRXBWADD_OUT[10]);
buf B_MIMRXBWADD11 (MIMRXBWADD[11], MIMRXBWADD_OUT[11]);
buf B_MIMRXBWADD12 (MIMRXBWADD[12], MIMRXBWADD_OUT[12]);
buf B_MIMRXBRADD0 (MIMRXBRADD[0], MIMRXBRADD_OUT[0]);
buf B_MIMRXBRADD1 (MIMRXBRADD[1], MIMRXBRADD_OUT[1]);
buf B_MIMRXBRADD2 (MIMRXBRADD[2], MIMRXBRADD_OUT[2]);
buf B_MIMRXBRADD3 (MIMRXBRADD[3], MIMRXBRADD_OUT[3]);
buf B_MIMRXBRADD4 (MIMRXBRADD[4], MIMRXBRADD_OUT[4]);
buf B_MIMRXBRADD5 (MIMRXBRADD[5], MIMRXBRADD_OUT[5]);
buf B_MIMRXBRADD6 (MIMRXBRADD[6], MIMRXBRADD_OUT[6]);
buf B_MIMRXBRADD7 (MIMRXBRADD[7], MIMRXBRADD_OUT[7]);
buf B_MIMRXBRADD8 (MIMRXBRADD[8], MIMRXBRADD_OUT[8]);
buf B_MIMRXBRADD9 (MIMRXBRADD[9], MIMRXBRADD_OUT[9]);
buf B_MIMRXBRADD10 (MIMRXBRADD[10], MIMRXBRADD_OUT[10]);
buf B_MIMRXBRADD11 (MIMRXBRADD[11], MIMRXBRADD_OUT[11]);
buf B_MIMRXBRADD12 (MIMRXBRADD[12], MIMRXBRADD_OUT[12]);
buf B_MIMRXBWEN (MIMRXBWEN, MIMRXBWEN_OUT);
buf B_MIMRXBREN (MIMRXBREN, MIMRXBREN_OUT);
buf B_MIMTXBWDATA0 (MIMTXBWDATA[0], MIMTXBWDATA_OUT[0]);
buf B_MIMTXBWDATA1 (MIMTXBWDATA[1], MIMTXBWDATA_OUT[1]);
buf B_MIMTXBWDATA2 (MIMTXBWDATA[2], MIMTXBWDATA_OUT[2]);
buf B_MIMTXBWDATA3 (MIMTXBWDATA[3], MIMTXBWDATA_OUT[3]);
buf B_MIMTXBWDATA4 (MIMTXBWDATA[4], MIMTXBWDATA_OUT[4]);
buf B_MIMTXBWDATA5 (MIMTXBWDATA[5], MIMTXBWDATA_OUT[5]);
buf B_MIMTXBWDATA6 (MIMTXBWDATA[6], MIMTXBWDATA_OUT[6]);
buf B_MIMTXBWDATA7 (MIMTXBWDATA[7], MIMTXBWDATA_OUT[7]);
buf B_MIMTXBWDATA8 (MIMTXBWDATA[8], MIMTXBWDATA_OUT[8]);
buf B_MIMTXBWDATA9 (MIMTXBWDATA[9], MIMTXBWDATA_OUT[9]);
buf B_MIMTXBWDATA10 (MIMTXBWDATA[10], MIMTXBWDATA_OUT[10]);
buf B_MIMTXBWDATA11 (MIMTXBWDATA[11], MIMTXBWDATA_OUT[11]);
buf B_MIMTXBWDATA12 (MIMTXBWDATA[12], MIMTXBWDATA_OUT[12]);
buf B_MIMTXBWDATA13 (MIMTXBWDATA[13], MIMTXBWDATA_OUT[13]);
buf B_MIMTXBWDATA14 (MIMTXBWDATA[14], MIMTXBWDATA_OUT[14]);
buf B_MIMTXBWDATA15 (MIMTXBWDATA[15], MIMTXBWDATA_OUT[15]);
buf B_MIMTXBWDATA16 (MIMTXBWDATA[16], MIMTXBWDATA_OUT[16]);
buf B_MIMTXBWDATA17 (MIMTXBWDATA[17], MIMTXBWDATA_OUT[17]);
buf B_MIMTXBWDATA18 (MIMTXBWDATA[18], MIMTXBWDATA_OUT[18]);
buf B_MIMTXBWDATA19 (MIMTXBWDATA[19], MIMTXBWDATA_OUT[19]);
buf B_MIMTXBWDATA20 (MIMTXBWDATA[20], MIMTXBWDATA_OUT[20]);
buf B_MIMTXBWDATA21 (MIMTXBWDATA[21], MIMTXBWDATA_OUT[21]);
buf B_MIMTXBWDATA22 (MIMTXBWDATA[22], MIMTXBWDATA_OUT[22]);
buf B_MIMTXBWDATA23 (MIMTXBWDATA[23], MIMTXBWDATA_OUT[23]);
buf B_MIMTXBWDATA24 (MIMTXBWDATA[24], MIMTXBWDATA_OUT[24]);
buf B_MIMTXBWDATA25 (MIMTXBWDATA[25], MIMTXBWDATA_OUT[25]);
buf B_MIMTXBWDATA26 (MIMTXBWDATA[26], MIMTXBWDATA_OUT[26]);
buf B_MIMTXBWDATA27 (MIMTXBWDATA[27], MIMTXBWDATA_OUT[27]);
buf B_MIMTXBWDATA28 (MIMTXBWDATA[28], MIMTXBWDATA_OUT[28]);
buf B_MIMTXBWDATA29 (MIMTXBWDATA[29], MIMTXBWDATA_OUT[29]);
buf B_MIMTXBWDATA30 (MIMTXBWDATA[30], MIMTXBWDATA_OUT[30]);
buf B_MIMTXBWDATA31 (MIMTXBWDATA[31], MIMTXBWDATA_OUT[31]);
buf B_MIMTXBWDATA32 (MIMTXBWDATA[32], MIMTXBWDATA_OUT[32]);
buf B_MIMTXBWDATA33 (MIMTXBWDATA[33], MIMTXBWDATA_OUT[33]);
buf B_MIMTXBWDATA34 (MIMTXBWDATA[34], MIMTXBWDATA_OUT[34]);
buf B_MIMTXBWDATA35 (MIMTXBWDATA[35], MIMTXBWDATA_OUT[35]);
buf B_MIMTXBWDATA36 (MIMTXBWDATA[36], MIMTXBWDATA_OUT[36]);
buf B_MIMTXBWDATA37 (MIMTXBWDATA[37], MIMTXBWDATA_OUT[37]);
buf B_MIMTXBWDATA38 (MIMTXBWDATA[38], MIMTXBWDATA_OUT[38]);
buf B_MIMTXBWDATA39 (MIMTXBWDATA[39], MIMTXBWDATA_OUT[39]);
buf B_MIMTXBWDATA40 (MIMTXBWDATA[40], MIMTXBWDATA_OUT[40]);
buf B_MIMTXBWDATA41 (MIMTXBWDATA[41], MIMTXBWDATA_OUT[41]);
buf B_MIMTXBWDATA42 (MIMTXBWDATA[42], MIMTXBWDATA_OUT[42]);
buf B_MIMTXBWDATA43 (MIMTXBWDATA[43], MIMTXBWDATA_OUT[43]);
buf B_MIMTXBWDATA44 (MIMTXBWDATA[44], MIMTXBWDATA_OUT[44]);
buf B_MIMTXBWDATA45 (MIMTXBWDATA[45], MIMTXBWDATA_OUT[45]);
buf B_MIMTXBWDATA46 (MIMTXBWDATA[46], MIMTXBWDATA_OUT[46]);
buf B_MIMTXBWDATA47 (MIMTXBWDATA[47], MIMTXBWDATA_OUT[47]);
buf B_MIMTXBWDATA48 (MIMTXBWDATA[48], MIMTXBWDATA_OUT[48]);
buf B_MIMTXBWDATA49 (MIMTXBWDATA[49], MIMTXBWDATA_OUT[49]);
buf B_MIMTXBWDATA50 (MIMTXBWDATA[50], MIMTXBWDATA_OUT[50]);
buf B_MIMTXBWDATA51 (MIMTXBWDATA[51], MIMTXBWDATA_OUT[51]);
buf B_MIMTXBWDATA52 (MIMTXBWDATA[52], MIMTXBWDATA_OUT[52]);
buf B_MIMTXBWDATA53 (MIMTXBWDATA[53], MIMTXBWDATA_OUT[53]);
buf B_MIMTXBWDATA54 (MIMTXBWDATA[54], MIMTXBWDATA_OUT[54]);
buf B_MIMTXBWDATA55 (MIMTXBWDATA[55], MIMTXBWDATA_OUT[55]);
buf B_MIMTXBWDATA56 (MIMTXBWDATA[56], MIMTXBWDATA_OUT[56]);
buf B_MIMTXBWDATA57 (MIMTXBWDATA[57], MIMTXBWDATA_OUT[57]);
buf B_MIMTXBWDATA58 (MIMTXBWDATA[58], MIMTXBWDATA_OUT[58]);
buf B_MIMTXBWDATA59 (MIMTXBWDATA[59], MIMTXBWDATA_OUT[59]);
buf B_MIMTXBWDATA60 (MIMTXBWDATA[60], MIMTXBWDATA_OUT[60]);
buf B_MIMTXBWDATA61 (MIMTXBWDATA[61], MIMTXBWDATA_OUT[61]);
buf B_MIMTXBWDATA62 (MIMTXBWDATA[62], MIMTXBWDATA_OUT[62]);
buf B_MIMTXBWDATA63 (MIMTXBWDATA[63], MIMTXBWDATA_OUT[63]);
buf B_MIMTXBWADD0 (MIMTXBWADD[0], MIMTXBWADD_OUT[0]);
buf B_MIMTXBWADD1 (MIMTXBWADD[1], MIMTXBWADD_OUT[1]);
buf B_MIMTXBWADD2 (MIMTXBWADD[2], MIMTXBWADD_OUT[2]);
buf B_MIMTXBWADD3 (MIMTXBWADD[3], MIMTXBWADD_OUT[3]);
buf B_MIMTXBWADD4 (MIMTXBWADD[4], MIMTXBWADD_OUT[4]);
buf B_MIMTXBWADD5 (MIMTXBWADD[5], MIMTXBWADD_OUT[5]);
buf B_MIMTXBWADD6 (MIMTXBWADD[6], MIMTXBWADD_OUT[6]);
buf B_MIMTXBWADD7 (MIMTXBWADD[7], MIMTXBWADD_OUT[7]);
buf B_MIMTXBWADD8 (MIMTXBWADD[8], MIMTXBWADD_OUT[8]);
buf B_MIMTXBWADD9 (MIMTXBWADD[9], MIMTXBWADD_OUT[9]);
buf B_MIMTXBWADD10 (MIMTXBWADD[10], MIMTXBWADD_OUT[10]);
buf B_MIMTXBWADD11 (MIMTXBWADD[11], MIMTXBWADD_OUT[11]);
buf B_MIMTXBWADD12 (MIMTXBWADD[12], MIMTXBWADD_OUT[12]);
buf B_MIMTXBRADD0 (MIMTXBRADD[0], MIMTXBRADD_OUT[0]);
buf B_MIMTXBRADD1 (MIMTXBRADD[1], MIMTXBRADD_OUT[1]);
buf B_MIMTXBRADD2 (MIMTXBRADD[2], MIMTXBRADD_OUT[2]);
buf B_MIMTXBRADD3 (MIMTXBRADD[3], MIMTXBRADD_OUT[3]);
buf B_MIMTXBRADD4 (MIMTXBRADD[4], MIMTXBRADD_OUT[4]);
buf B_MIMTXBRADD5 (MIMTXBRADD[5], MIMTXBRADD_OUT[5]);
buf B_MIMTXBRADD6 (MIMTXBRADD[6], MIMTXBRADD_OUT[6]);
buf B_MIMTXBRADD7 (MIMTXBRADD[7], MIMTXBRADD_OUT[7]);
buf B_MIMTXBRADD8 (MIMTXBRADD[8], MIMTXBRADD_OUT[8]);
buf B_MIMTXBRADD9 (MIMTXBRADD[9], MIMTXBRADD_OUT[9]);
buf B_MIMTXBRADD10 (MIMTXBRADD[10], MIMTXBRADD_OUT[10]);
buf B_MIMTXBRADD11 (MIMTXBRADD[11], MIMTXBRADD_OUT[11]);
buf B_MIMTXBRADD12 (MIMTXBRADD[12], MIMTXBRADD_OUT[12]);
buf B_MIMTXBWEN (MIMTXBWEN, MIMTXBWEN_OUT);
buf B_MIMTXBREN (MIMTXBREN, MIMTXBREN_OUT);
buf B_MIMDLLBWDATA0 (MIMDLLBWDATA[0], MIMDLLBWDATA_OUT[0]);
buf B_MIMDLLBWDATA1 (MIMDLLBWDATA[1], MIMDLLBWDATA_OUT[1]);
buf B_MIMDLLBWDATA2 (MIMDLLBWDATA[2], MIMDLLBWDATA_OUT[2]);
buf B_MIMDLLBWDATA3 (MIMDLLBWDATA[3], MIMDLLBWDATA_OUT[3]);
buf B_MIMDLLBWDATA4 (MIMDLLBWDATA[4], MIMDLLBWDATA_OUT[4]);
buf B_MIMDLLBWDATA5 (MIMDLLBWDATA[5], MIMDLLBWDATA_OUT[5]);
buf B_MIMDLLBWDATA6 (MIMDLLBWDATA[6], MIMDLLBWDATA_OUT[6]);
buf B_MIMDLLBWDATA7 (MIMDLLBWDATA[7], MIMDLLBWDATA_OUT[7]);
buf B_MIMDLLBWDATA8 (MIMDLLBWDATA[8], MIMDLLBWDATA_OUT[8]);
buf B_MIMDLLBWDATA9 (MIMDLLBWDATA[9], MIMDLLBWDATA_OUT[9]);
buf B_MIMDLLBWDATA10 (MIMDLLBWDATA[10], MIMDLLBWDATA_OUT[10]);
buf B_MIMDLLBWDATA11 (MIMDLLBWDATA[11], MIMDLLBWDATA_OUT[11]);
buf B_MIMDLLBWDATA12 (MIMDLLBWDATA[12], MIMDLLBWDATA_OUT[12]);
buf B_MIMDLLBWDATA13 (MIMDLLBWDATA[13], MIMDLLBWDATA_OUT[13]);
buf B_MIMDLLBWDATA14 (MIMDLLBWDATA[14], MIMDLLBWDATA_OUT[14]);
buf B_MIMDLLBWDATA15 (MIMDLLBWDATA[15], MIMDLLBWDATA_OUT[15]);
buf B_MIMDLLBWDATA16 (MIMDLLBWDATA[16], MIMDLLBWDATA_OUT[16]);
buf B_MIMDLLBWDATA17 (MIMDLLBWDATA[17], MIMDLLBWDATA_OUT[17]);
buf B_MIMDLLBWDATA18 (MIMDLLBWDATA[18], MIMDLLBWDATA_OUT[18]);
buf B_MIMDLLBWDATA19 (MIMDLLBWDATA[19], MIMDLLBWDATA_OUT[19]);
buf B_MIMDLLBWDATA20 (MIMDLLBWDATA[20], MIMDLLBWDATA_OUT[20]);
buf B_MIMDLLBWDATA21 (MIMDLLBWDATA[21], MIMDLLBWDATA_OUT[21]);
buf B_MIMDLLBWDATA22 (MIMDLLBWDATA[22], MIMDLLBWDATA_OUT[22]);
buf B_MIMDLLBWDATA23 (MIMDLLBWDATA[23], MIMDLLBWDATA_OUT[23]);
buf B_MIMDLLBWDATA24 (MIMDLLBWDATA[24], MIMDLLBWDATA_OUT[24]);
buf B_MIMDLLBWDATA25 (MIMDLLBWDATA[25], MIMDLLBWDATA_OUT[25]);
buf B_MIMDLLBWDATA26 (MIMDLLBWDATA[26], MIMDLLBWDATA_OUT[26]);
buf B_MIMDLLBWDATA27 (MIMDLLBWDATA[27], MIMDLLBWDATA_OUT[27]);
buf B_MIMDLLBWDATA28 (MIMDLLBWDATA[28], MIMDLLBWDATA_OUT[28]);
buf B_MIMDLLBWDATA29 (MIMDLLBWDATA[29], MIMDLLBWDATA_OUT[29]);
buf B_MIMDLLBWDATA30 (MIMDLLBWDATA[30], MIMDLLBWDATA_OUT[30]);
buf B_MIMDLLBWDATA31 (MIMDLLBWDATA[31], MIMDLLBWDATA_OUT[31]);
buf B_MIMDLLBWDATA32 (MIMDLLBWDATA[32], MIMDLLBWDATA_OUT[32]);
buf B_MIMDLLBWDATA33 (MIMDLLBWDATA[33], MIMDLLBWDATA_OUT[33]);
buf B_MIMDLLBWDATA34 (MIMDLLBWDATA[34], MIMDLLBWDATA_OUT[34]);
buf B_MIMDLLBWDATA35 (MIMDLLBWDATA[35], MIMDLLBWDATA_OUT[35]);
buf B_MIMDLLBWDATA36 (MIMDLLBWDATA[36], MIMDLLBWDATA_OUT[36]);
buf B_MIMDLLBWDATA37 (MIMDLLBWDATA[37], MIMDLLBWDATA_OUT[37]);
buf B_MIMDLLBWDATA38 (MIMDLLBWDATA[38], MIMDLLBWDATA_OUT[38]);
buf B_MIMDLLBWDATA39 (MIMDLLBWDATA[39], MIMDLLBWDATA_OUT[39]);
buf B_MIMDLLBWDATA40 (MIMDLLBWDATA[40], MIMDLLBWDATA_OUT[40]);
buf B_MIMDLLBWDATA41 (MIMDLLBWDATA[41], MIMDLLBWDATA_OUT[41]);
buf B_MIMDLLBWDATA42 (MIMDLLBWDATA[42], MIMDLLBWDATA_OUT[42]);
buf B_MIMDLLBWDATA43 (MIMDLLBWDATA[43], MIMDLLBWDATA_OUT[43]);
buf B_MIMDLLBWDATA44 (MIMDLLBWDATA[44], MIMDLLBWDATA_OUT[44]);
buf B_MIMDLLBWDATA45 (MIMDLLBWDATA[45], MIMDLLBWDATA_OUT[45]);
buf B_MIMDLLBWDATA46 (MIMDLLBWDATA[46], MIMDLLBWDATA_OUT[46]);
buf B_MIMDLLBWDATA47 (MIMDLLBWDATA[47], MIMDLLBWDATA_OUT[47]);
buf B_MIMDLLBWDATA48 (MIMDLLBWDATA[48], MIMDLLBWDATA_OUT[48]);
buf B_MIMDLLBWDATA49 (MIMDLLBWDATA[49], MIMDLLBWDATA_OUT[49]);
buf B_MIMDLLBWDATA50 (MIMDLLBWDATA[50], MIMDLLBWDATA_OUT[50]);
buf B_MIMDLLBWDATA51 (MIMDLLBWDATA[51], MIMDLLBWDATA_OUT[51]);
buf B_MIMDLLBWDATA52 (MIMDLLBWDATA[52], MIMDLLBWDATA_OUT[52]);
buf B_MIMDLLBWDATA53 (MIMDLLBWDATA[53], MIMDLLBWDATA_OUT[53]);
buf B_MIMDLLBWDATA54 (MIMDLLBWDATA[54], MIMDLLBWDATA_OUT[54]);
buf B_MIMDLLBWDATA55 (MIMDLLBWDATA[55], MIMDLLBWDATA_OUT[55]);
buf B_MIMDLLBWDATA56 (MIMDLLBWDATA[56], MIMDLLBWDATA_OUT[56]);
buf B_MIMDLLBWDATA57 (MIMDLLBWDATA[57], MIMDLLBWDATA_OUT[57]);
buf B_MIMDLLBWDATA58 (MIMDLLBWDATA[58], MIMDLLBWDATA_OUT[58]);
buf B_MIMDLLBWDATA59 (MIMDLLBWDATA[59], MIMDLLBWDATA_OUT[59]);
buf B_MIMDLLBWDATA60 (MIMDLLBWDATA[60], MIMDLLBWDATA_OUT[60]);
buf B_MIMDLLBWDATA61 (MIMDLLBWDATA[61], MIMDLLBWDATA_OUT[61]);
buf B_MIMDLLBWDATA62 (MIMDLLBWDATA[62], MIMDLLBWDATA_OUT[62]);
buf B_MIMDLLBWDATA63 (MIMDLLBWDATA[63], MIMDLLBWDATA_OUT[63]);
buf B_MIMDLLBWADD0 (MIMDLLBWADD[0], MIMDLLBWADD_OUT[0]);
buf B_MIMDLLBWADD1 (MIMDLLBWADD[1], MIMDLLBWADD_OUT[1]);
buf B_MIMDLLBWADD2 (MIMDLLBWADD[2], MIMDLLBWADD_OUT[2]);
buf B_MIMDLLBWADD3 (MIMDLLBWADD[3], MIMDLLBWADD_OUT[3]);
buf B_MIMDLLBWADD4 (MIMDLLBWADD[4], MIMDLLBWADD_OUT[4]);
buf B_MIMDLLBWADD5 (MIMDLLBWADD[5], MIMDLLBWADD_OUT[5]);
buf B_MIMDLLBWADD6 (MIMDLLBWADD[6], MIMDLLBWADD_OUT[6]);
buf B_MIMDLLBWADD7 (MIMDLLBWADD[7], MIMDLLBWADD_OUT[7]);
buf B_MIMDLLBWADD8 (MIMDLLBWADD[8], MIMDLLBWADD_OUT[8]);
buf B_MIMDLLBWADD9 (MIMDLLBWADD[9], MIMDLLBWADD_OUT[9]);
buf B_MIMDLLBWADD10 (MIMDLLBWADD[10], MIMDLLBWADD_OUT[10]);
buf B_MIMDLLBWADD11 (MIMDLLBWADD[11], MIMDLLBWADD_OUT[11]);
buf B_MIMDLLBRADD0 (MIMDLLBRADD[0], MIMDLLBRADD_OUT[0]);
buf B_MIMDLLBRADD1 (MIMDLLBRADD[1], MIMDLLBRADD_OUT[1]);
buf B_MIMDLLBRADD2 (MIMDLLBRADD[2], MIMDLLBRADD_OUT[2]);
buf B_MIMDLLBRADD3 (MIMDLLBRADD[3], MIMDLLBRADD_OUT[3]);
buf B_MIMDLLBRADD4 (MIMDLLBRADD[4], MIMDLLBRADD_OUT[4]);
buf B_MIMDLLBRADD5 (MIMDLLBRADD[5], MIMDLLBRADD_OUT[5]);
buf B_MIMDLLBRADD6 (MIMDLLBRADD[6], MIMDLLBRADD_OUT[6]);
buf B_MIMDLLBRADD7 (MIMDLLBRADD[7], MIMDLLBRADD_OUT[7]);
buf B_MIMDLLBRADD8 (MIMDLLBRADD[8], MIMDLLBRADD_OUT[8]);
buf B_MIMDLLBRADD9 (MIMDLLBRADD[9], MIMDLLBRADD_OUT[9]);
buf B_MIMDLLBRADD10 (MIMDLLBRADD[10], MIMDLLBRADD_OUT[10]);
buf B_MIMDLLBRADD11 (MIMDLLBRADD[11], MIMDLLBRADD_OUT[11]);
buf B_MIMDLLBWEN (MIMDLLBWEN, MIMDLLBWEN_OUT);
buf B_MIMDLLBREN (MIMDLLBREN, MIMDLLBREN_OUT);
buf B_CRMRXHOTRESETN (CRMRXHOTRESETN, CRMRXHOTRESETN_OUT);
buf B_CRMDOHOTRESETN (CRMDOHOTRESETN, CRMDOHOTRESETN_OUT);
buf B_CRMPWRSOFTRESETN (CRMPWRSOFTRESETN, CRMPWRSOFTRESETN_OUT);
buf B_LLKTCSTATUS0 (LLKTCSTATUS[0], LLKTCSTATUS_OUT[0]);
buf B_LLKTCSTATUS1 (LLKTCSTATUS[1], LLKTCSTATUS_OUT[1]);
buf B_LLKTCSTATUS2 (LLKTCSTATUS[2], LLKTCSTATUS_OUT[2]);
buf B_LLKTCSTATUS3 (LLKTCSTATUS[3], LLKTCSTATUS_OUT[3]);
buf B_LLKTCSTATUS4 (LLKTCSTATUS[4], LLKTCSTATUS_OUT[4]);
buf B_LLKTCSTATUS5 (LLKTCSTATUS[5], LLKTCSTATUS_OUT[5]);
buf B_LLKTCSTATUS6 (LLKTCSTATUS[6], LLKTCSTATUS_OUT[6]);
buf B_LLKTCSTATUS7 (LLKTCSTATUS[7], LLKTCSTATUS_OUT[7]);
buf B_LLKTXDSTRDYN (LLKTXDSTRDYN, LLKTXDSTRDYN_OUT);
buf B_LLKTXCHANSPACE0 (LLKTXCHANSPACE[0], LLKTXCHANSPACE_OUT[0]);
buf B_LLKTXCHANSPACE1 (LLKTXCHANSPACE[1], LLKTXCHANSPACE_OUT[1]);
buf B_LLKTXCHANSPACE2 (LLKTXCHANSPACE[2], LLKTXCHANSPACE_OUT[2]);
buf B_LLKTXCHANSPACE3 (LLKTXCHANSPACE[3], LLKTXCHANSPACE_OUT[3]);
buf B_LLKTXCHANSPACE4 (LLKTXCHANSPACE[4], LLKTXCHANSPACE_OUT[4]);
buf B_LLKTXCHANSPACE5 (LLKTXCHANSPACE[5], LLKTXCHANSPACE_OUT[5]);
buf B_LLKTXCHANSPACE6 (LLKTXCHANSPACE[6], LLKTXCHANSPACE_OUT[6]);
buf B_LLKTXCHANSPACE7 (LLKTXCHANSPACE[7], LLKTXCHANSPACE_OUT[7]);
buf B_LLKTXCHANSPACE8 (LLKTXCHANSPACE[8], LLKTXCHANSPACE_OUT[8]);
buf B_LLKTXCHANSPACE9 (LLKTXCHANSPACE[9], LLKTXCHANSPACE_OUT[9]);
buf B_LLKTXCHPOSTEDREADYN0 (LLKTXCHPOSTEDREADYN[0], LLKTXCHPOSTEDREADYN_OUT[0]);
buf B_LLKTXCHPOSTEDREADYN1 (LLKTXCHPOSTEDREADYN[1], LLKTXCHPOSTEDREADYN_OUT[1]);
buf B_LLKTXCHPOSTEDREADYN2 (LLKTXCHPOSTEDREADYN[2], LLKTXCHPOSTEDREADYN_OUT[2]);
buf B_LLKTXCHPOSTEDREADYN3 (LLKTXCHPOSTEDREADYN[3], LLKTXCHPOSTEDREADYN_OUT[3]);
buf B_LLKTXCHPOSTEDREADYN4 (LLKTXCHPOSTEDREADYN[4], LLKTXCHPOSTEDREADYN_OUT[4]);
buf B_LLKTXCHPOSTEDREADYN5 (LLKTXCHPOSTEDREADYN[5], LLKTXCHPOSTEDREADYN_OUT[5]);
buf B_LLKTXCHPOSTEDREADYN6 (LLKTXCHPOSTEDREADYN[6], LLKTXCHPOSTEDREADYN_OUT[6]);
buf B_LLKTXCHPOSTEDREADYN7 (LLKTXCHPOSTEDREADYN[7], LLKTXCHPOSTEDREADYN_OUT[7]);
buf B_LLKTXCHNONPOSTEDREADYN0 (LLKTXCHNONPOSTEDREADYN[0], LLKTXCHNONPOSTEDREADYN_OUT[0]);
buf B_LLKTXCHNONPOSTEDREADYN1 (LLKTXCHNONPOSTEDREADYN[1], LLKTXCHNONPOSTEDREADYN_OUT[1]);
buf B_LLKTXCHNONPOSTEDREADYN2 (LLKTXCHNONPOSTEDREADYN[2], LLKTXCHNONPOSTEDREADYN_OUT[2]);
buf B_LLKTXCHNONPOSTEDREADYN3 (LLKTXCHNONPOSTEDREADYN[3], LLKTXCHNONPOSTEDREADYN_OUT[3]);
buf B_LLKTXCHNONPOSTEDREADYN4 (LLKTXCHNONPOSTEDREADYN[4], LLKTXCHNONPOSTEDREADYN_OUT[4]);
buf B_LLKTXCHNONPOSTEDREADYN5 (LLKTXCHNONPOSTEDREADYN[5], LLKTXCHNONPOSTEDREADYN_OUT[5]);
buf B_LLKTXCHNONPOSTEDREADYN6 (LLKTXCHNONPOSTEDREADYN[6], LLKTXCHNONPOSTEDREADYN_OUT[6]);
buf B_LLKTXCHNONPOSTEDREADYN7 (LLKTXCHNONPOSTEDREADYN[7], LLKTXCHNONPOSTEDREADYN_OUT[7]);
buf B_LLKTXCHCOMPLETIONREADYN0 (LLKTXCHCOMPLETIONREADYN[0], LLKTXCHCOMPLETIONREADYN_OUT[0]);
buf B_LLKTXCHCOMPLETIONREADYN1 (LLKTXCHCOMPLETIONREADYN[1], LLKTXCHCOMPLETIONREADYN_OUT[1]);
buf B_LLKTXCHCOMPLETIONREADYN2 (LLKTXCHCOMPLETIONREADYN[2], LLKTXCHCOMPLETIONREADYN_OUT[2]);
buf B_LLKTXCHCOMPLETIONREADYN3 (LLKTXCHCOMPLETIONREADYN[3], LLKTXCHCOMPLETIONREADYN_OUT[3]);
buf B_LLKTXCHCOMPLETIONREADYN4 (LLKTXCHCOMPLETIONREADYN[4], LLKTXCHCOMPLETIONREADYN_OUT[4]);
buf B_LLKTXCHCOMPLETIONREADYN5 (LLKTXCHCOMPLETIONREADYN[5], LLKTXCHCOMPLETIONREADYN_OUT[5]);
buf B_LLKTXCHCOMPLETIONREADYN6 (LLKTXCHCOMPLETIONREADYN[6], LLKTXCHCOMPLETIONREADYN_OUT[6]);
buf B_LLKTXCHCOMPLETIONREADYN7 (LLKTXCHCOMPLETIONREADYN[7], LLKTXCHCOMPLETIONREADYN_OUT[7]);
buf B_LLKTXCONFIGREADYN (LLKTXCONFIGREADYN, LLKTXCONFIGREADYN_OUT);
buf B_LLKRXDATA0 (LLKRXDATA[0], LLKRXDATA_OUT[0]);
buf B_LLKRXDATA1 (LLKRXDATA[1], LLKRXDATA_OUT[1]);
buf B_LLKRXDATA2 (LLKRXDATA[2], LLKRXDATA_OUT[2]);
buf B_LLKRXDATA3 (LLKRXDATA[3], LLKRXDATA_OUT[3]);
buf B_LLKRXDATA4 (LLKRXDATA[4], LLKRXDATA_OUT[4]);
buf B_LLKRXDATA5 (LLKRXDATA[5], LLKRXDATA_OUT[5]);
buf B_LLKRXDATA6 (LLKRXDATA[6], LLKRXDATA_OUT[6]);
buf B_LLKRXDATA7 (LLKRXDATA[7], LLKRXDATA_OUT[7]);
buf B_LLKRXDATA8 (LLKRXDATA[8], LLKRXDATA_OUT[8]);
buf B_LLKRXDATA9 (LLKRXDATA[9], LLKRXDATA_OUT[9]);
buf B_LLKRXDATA10 (LLKRXDATA[10], LLKRXDATA_OUT[10]);
buf B_LLKRXDATA11 (LLKRXDATA[11], LLKRXDATA_OUT[11]);
buf B_LLKRXDATA12 (LLKRXDATA[12], LLKRXDATA_OUT[12]);
buf B_LLKRXDATA13 (LLKRXDATA[13], LLKRXDATA_OUT[13]);
buf B_LLKRXDATA14 (LLKRXDATA[14], LLKRXDATA_OUT[14]);
buf B_LLKRXDATA15 (LLKRXDATA[15], LLKRXDATA_OUT[15]);
buf B_LLKRXDATA16 (LLKRXDATA[16], LLKRXDATA_OUT[16]);
buf B_LLKRXDATA17 (LLKRXDATA[17], LLKRXDATA_OUT[17]);
buf B_LLKRXDATA18 (LLKRXDATA[18], LLKRXDATA_OUT[18]);
buf B_LLKRXDATA19 (LLKRXDATA[19], LLKRXDATA_OUT[19]);
buf B_LLKRXDATA20 (LLKRXDATA[20], LLKRXDATA_OUT[20]);
buf B_LLKRXDATA21 (LLKRXDATA[21], LLKRXDATA_OUT[21]);
buf B_LLKRXDATA22 (LLKRXDATA[22], LLKRXDATA_OUT[22]);
buf B_LLKRXDATA23 (LLKRXDATA[23], LLKRXDATA_OUT[23]);
buf B_LLKRXDATA24 (LLKRXDATA[24], LLKRXDATA_OUT[24]);
buf B_LLKRXDATA25 (LLKRXDATA[25], LLKRXDATA_OUT[25]);
buf B_LLKRXDATA26 (LLKRXDATA[26], LLKRXDATA_OUT[26]);
buf B_LLKRXDATA27 (LLKRXDATA[27], LLKRXDATA_OUT[27]);
buf B_LLKRXDATA28 (LLKRXDATA[28], LLKRXDATA_OUT[28]);
buf B_LLKRXDATA29 (LLKRXDATA[29], LLKRXDATA_OUT[29]);
buf B_LLKRXDATA30 (LLKRXDATA[30], LLKRXDATA_OUT[30]);
buf B_LLKRXDATA31 (LLKRXDATA[31], LLKRXDATA_OUT[31]);
buf B_LLKRXDATA32 (LLKRXDATA[32], LLKRXDATA_OUT[32]);
buf B_LLKRXDATA33 (LLKRXDATA[33], LLKRXDATA_OUT[33]);
buf B_LLKRXDATA34 (LLKRXDATA[34], LLKRXDATA_OUT[34]);
buf B_LLKRXDATA35 (LLKRXDATA[35], LLKRXDATA_OUT[35]);
buf B_LLKRXDATA36 (LLKRXDATA[36], LLKRXDATA_OUT[36]);
buf B_LLKRXDATA37 (LLKRXDATA[37], LLKRXDATA_OUT[37]);
buf B_LLKRXDATA38 (LLKRXDATA[38], LLKRXDATA_OUT[38]);
buf B_LLKRXDATA39 (LLKRXDATA[39], LLKRXDATA_OUT[39]);
buf B_LLKRXDATA40 (LLKRXDATA[40], LLKRXDATA_OUT[40]);
buf B_LLKRXDATA41 (LLKRXDATA[41], LLKRXDATA_OUT[41]);
buf B_LLKRXDATA42 (LLKRXDATA[42], LLKRXDATA_OUT[42]);
buf B_LLKRXDATA43 (LLKRXDATA[43], LLKRXDATA_OUT[43]);
buf B_LLKRXDATA44 (LLKRXDATA[44], LLKRXDATA_OUT[44]);
buf B_LLKRXDATA45 (LLKRXDATA[45], LLKRXDATA_OUT[45]);
buf B_LLKRXDATA46 (LLKRXDATA[46], LLKRXDATA_OUT[46]);
buf B_LLKRXDATA47 (LLKRXDATA[47], LLKRXDATA_OUT[47]);
buf B_LLKRXDATA48 (LLKRXDATA[48], LLKRXDATA_OUT[48]);
buf B_LLKRXDATA49 (LLKRXDATA[49], LLKRXDATA_OUT[49]);
buf B_LLKRXDATA50 (LLKRXDATA[50], LLKRXDATA_OUT[50]);
buf B_LLKRXDATA51 (LLKRXDATA[51], LLKRXDATA_OUT[51]);
buf B_LLKRXDATA52 (LLKRXDATA[52], LLKRXDATA_OUT[52]);
buf B_LLKRXDATA53 (LLKRXDATA[53], LLKRXDATA_OUT[53]);
buf B_LLKRXDATA54 (LLKRXDATA[54], LLKRXDATA_OUT[54]);
buf B_LLKRXDATA55 (LLKRXDATA[55], LLKRXDATA_OUT[55]);
buf B_LLKRXDATA56 (LLKRXDATA[56], LLKRXDATA_OUT[56]);
buf B_LLKRXDATA57 (LLKRXDATA[57], LLKRXDATA_OUT[57]);
buf B_LLKRXDATA58 (LLKRXDATA[58], LLKRXDATA_OUT[58]);
buf B_LLKRXDATA59 (LLKRXDATA[59], LLKRXDATA_OUT[59]);
buf B_LLKRXDATA60 (LLKRXDATA[60], LLKRXDATA_OUT[60]);
buf B_LLKRXDATA61 (LLKRXDATA[61], LLKRXDATA_OUT[61]);
buf B_LLKRXDATA62 (LLKRXDATA[62], LLKRXDATA_OUT[62]);
buf B_LLKRXDATA63 (LLKRXDATA[63], LLKRXDATA_OUT[63]);
buf B_LLKRXSRCRDYN (LLKRXSRCRDYN, LLKRXSRCRDYN_OUT);
buf B_LLKRXSRCLASTREQN (LLKRXSRCLASTREQN, LLKRXSRCLASTREQN_OUT);
buf B_LLKRXSRCDSCN (LLKRXSRCDSCN, LLKRXSRCDSCN_OUT);
buf B_LLKRXSOFN (LLKRXSOFN, LLKRXSOFN_OUT);
buf B_LLKRXEOFN (LLKRXEOFN, LLKRXEOFN_OUT);
buf B_LLKRXSOPN (LLKRXSOPN, LLKRXSOPN_OUT);
buf B_LLKRXEOPN (LLKRXEOPN, LLKRXEOPN_OUT);
buf B_LLKRXVALIDN0 (LLKRXVALIDN[0], LLKRXVALIDN_OUT[0]);
buf B_LLKRXVALIDN1 (LLKRXVALIDN[1], LLKRXVALIDN_OUT[1]);
buf B_LLKRXPREFERREDTYPE0 (LLKRXPREFERREDTYPE[0], LLKRXPREFERREDTYPE_OUT[0]);
buf B_LLKRXPREFERREDTYPE1 (LLKRXPREFERREDTYPE[1], LLKRXPREFERREDTYPE_OUT[1]);
buf B_LLKRXPREFERREDTYPE2 (LLKRXPREFERREDTYPE[2], LLKRXPREFERREDTYPE_OUT[2]);
buf B_LLKRXPREFERREDTYPE3 (LLKRXPREFERREDTYPE[3], LLKRXPREFERREDTYPE_OUT[3]);
buf B_LLKRXPREFERREDTYPE4 (LLKRXPREFERREDTYPE[4], LLKRXPREFERREDTYPE_OUT[4]);
buf B_LLKRXPREFERREDTYPE5 (LLKRXPREFERREDTYPE[5], LLKRXPREFERREDTYPE_OUT[5]);
buf B_LLKRXPREFERREDTYPE6 (LLKRXPREFERREDTYPE[6], LLKRXPREFERREDTYPE_OUT[6]);
buf B_LLKRXPREFERREDTYPE7 (LLKRXPREFERREDTYPE[7], LLKRXPREFERREDTYPE_OUT[7]);
buf B_LLKRXPREFERREDTYPE8 (LLKRXPREFERREDTYPE[8], LLKRXPREFERREDTYPE_OUT[8]);
buf B_LLKRXPREFERREDTYPE9 (LLKRXPREFERREDTYPE[9], LLKRXPREFERREDTYPE_OUT[9]);
buf B_LLKRXPREFERREDTYPE10 (LLKRXPREFERREDTYPE[10], LLKRXPREFERREDTYPE_OUT[10]);
buf B_LLKRXPREFERREDTYPE11 (LLKRXPREFERREDTYPE[11], LLKRXPREFERREDTYPE_OUT[11]);
buf B_LLKRXPREFERREDTYPE12 (LLKRXPREFERREDTYPE[12], LLKRXPREFERREDTYPE_OUT[12]);
buf B_LLKRXPREFERREDTYPE13 (LLKRXPREFERREDTYPE[13], LLKRXPREFERREDTYPE_OUT[13]);
buf B_LLKRXPREFERREDTYPE14 (LLKRXPREFERREDTYPE[14], LLKRXPREFERREDTYPE_OUT[14]);
buf B_LLKRXPREFERREDTYPE15 (LLKRXPREFERREDTYPE[15], LLKRXPREFERREDTYPE_OUT[15]);
buf B_LLKRXCHPOSTEDAVAILABLEN0 (LLKRXCHPOSTEDAVAILABLEN[0], LLKRXCHPOSTEDAVAILABLEN_OUT[0]);
buf B_LLKRXCHPOSTEDAVAILABLEN1 (LLKRXCHPOSTEDAVAILABLEN[1], LLKRXCHPOSTEDAVAILABLEN_OUT[1]);
buf B_LLKRXCHPOSTEDAVAILABLEN2 (LLKRXCHPOSTEDAVAILABLEN[2], LLKRXCHPOSTEDAVAILABLEN_OUT[2]);
buf B_LLKRXCHPOSTEDAVAILABLEN3 (LLKRXCHPOSTEDAVAILABLEN[3], LLKRXCHPOSTEDAVAILABLEN_OUT[3]);
buf B_LLKRXCHPOSTEDAVAILABLEN4 (LLKRXCHPOSTEDAVAILABLEN[4], LLKRXCHPOSTEDAVAILABLEN_OUT[4]);
buf B_LLKRXCHPOSTEDAVAILABLEN5 (LLKRXCHPOSTEDAVAILABLEN[5], LLKRXCHPOSTEDAVAILABLEN_OUT[5]);
buf B_LLKRXCHPOSTEDAVAILABLEN6 (LLKRXCHPOSTEDAVAILABLEN[6], LLKRXCHPOSTEDAVAILABLEN_OUT[6]);
buf B_LLKRXCHPOSTEDAVAILABLEN7 (LLKRXCHPOSTEDAVAILABLEN[7], LLKRXCHPOSTEDAVAILABLEN_OUT[7]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN0 (LLKRXCHNONPOSTEDAVAILABLEN[0], LLKRXCHNONPOSTEDAVAILABLEN_OUT[0]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN1 (LLKRXCHNONPOSTEDAVAILABLEN[1], LLKRXCHNONPOSTEDAVAILABLEN_OUT[1]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN2 (LLKRXCHNONPOSTEDAVAILABLEN[2], LLKRXCHNONPOSTEDAVAILABLEN_OUT[2]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN3 (LLKRXCHNONPOSTEDAVAILABLEN[3], LLKRXCHNONPOSTEDAVAILABLEN_OUT[3]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN4 (LLKRXCHNONPOSTEDAVAILABLEN[4], LLKRXCHNONPOSTEDAVAILABLEN_OUT[4]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN5 (LLKRXCHNONPOSTEDAVAILABLEN[5], LLKRXCHNONPOSTEDAVAILABLEN_OUT[5]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN6 (LLKRXCHNONPOSTEDAVAILABLEN[6], LLKRXCHNONPOSTEDAVAILABLEN_OUT[6]);
buf B_LLKRXCHNONPOSTEDAVAILABLEN7 (LLKRXCHNONPOSTEDAVAILABLEN[7], LLKRXCHNONPOSTEDAVAILABLEN_OUT[7]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN0 (LLKRXCHCOMPLETIONAVAILABLEN[0], LLKRXCHCOMPLETIONAVAILABLEN_OUT[0]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN1 (LLKRXCHCOMPLETIONAVAILABLEN[1], LLKRXCHCOMPLETIONAVAILABLEN_OUT[1]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN2 (LLKRXCHCOMPLETIONAVAILABLEN[2], LLKRXCHCOMPLETIONAVAILABLEN_OUT[2]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN3 (LLKRXCHCOMPLETIONAVAILABLEN[3], LLKRXCHCOMPLETIONAVAILABLEN_OUT[3]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN4 (LLKRXCHCOMPLETIONAVAILABLEN[4], LLKRXCHCOMPLETIONAVAILABLEN_OUT[4]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN5 (LLKRXCHCOMPLETIONAVAILABLEN[5], LLKRXCHCOMPLETIONAVAILABLEN_OUT[5]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN6 (LLKRXCHCOMPLETIONAVAILABLEN[6], LLKRXCHCOMPLETIONAVAILABLEN_OUT[6]);
buf B_LLKRXCHCOMPLETIONAVAILABLEN7 (LLKRXCHCOMPLETIONAVAILABLEN[7], LLKRXCHCOMPLETIONAVAILABLEN_OUT[7]);
buf B_LLKRXCHCONFIGAVAILABLEN (LLKRXCHCONFIGAVAILABLEN, LLKRXCHCONFIGAVAILABLEN_OUT);
buf B_LLKRXCHPOSTEDPARTIALN0 (LLKRXCHPOSTEDPARTIALN[0], LLKRXCHPOSTEDPARTIALN_OUT[0]);
buf B_LLKRXCHPOSTEDPARTIALN1 (LLKRXCHPOSTEDPARTIALN[1], LLKRXCHPOSTEDPARTIALN_OUT[1]);
buf B_LLKRXCHPOSTEDPARTIALN2 (LLKRXCHPOSTEDPARTIALN[2], LLKRXCHPOSTEDPARTIALN_OUT[2]);
buf B_LLKRXCHPOSTEDPARTIALN3 (LLKRXCHPOSTEDPARTIALN[3], LLKRXCHPOSTEDPARTIALN_OUT[3]);
buf B_LLKRXCHPOSTEDPARTIALN4 (LLKRXCHPOSTEDPARTIALN[4], LLKRXCHPOSTEDPARTIALN_OUT[4]);
buf B_LLKRXCHPOSTEDPARTIALN5 (LLKRXCHPOSTEDPARTIALN[5], LLKRXCHPOSTEDPARTIALN_OUT[5]);
buf B_LLKRXCHPOSTEDPARTIALN6 (LLKRXCHPOSTEDPARTIALN[6], LLKRXCHPOSTEDPARTIALN_OUT[6]);
buf B_LLKRXCHPOSTEDPARTIALN7 (LLKRXCHPOSTEDPARTIALN[7], LLKRXCHPOSTEDPARTIALN_OUT[7]);
buf B_LLKRXCHNONPOSTEDPARTIALN0 (LLKRXCHNONPOSTEDPARTIALN[0], LLKRXCHNONPOSTEDPARTIALN_OUT[0]);
buf B_LLKRXCHNONPOSTEDPARTIALN1 (LLKRXCHNONPOSTEDPARTIALN[1], LLKRXCHNONPOSTEDPARTIALN_OUT[1]);
buf B_LLKRXCHNONPOSTEDPARTIALN2 (LLKRXCHNONPOSTEDPARTIALN[2], LLKRXCHNONPOSTEDPARTIALN_OUT[2]);
buf B_LLKRXCHNONPOSTEDPARTIALN3 (LLKRXCHNONPOSTEDPARTIALN[3], LLKRXCHNONPOSTEDPARTIALN_OUT[3]);
buf B_LLKRXCHNONPOSTEDPARTIALN4 (LLKRXCHNONPOSTEDPARTIALN[4], LLKRXCHNONPOSTEDPARTIALN_OUT[4]);
buf B_LLKRXCHNONPOSTEDPARTIALN5 (LLKRXCHNONPOSTEDPARTIALN[5], LLKRXCHNONPOSTEDPARTIALN_OUT[5]);
buf B_LLKRXCHNONPOSTEDPARTIALN6 (LLKRXCHNONPOSTEDPARTIALN[6], LLKRXCHNONPOSTEDPARTIALN_OUT[6]);
buf B_LLKRXCHNONPOSTEDPARTIALN7 (LLKRXCHNONPOSTEDPARTIALN[7], LLKRXCHNONPOSTEDPARTIALN_OUT[7]);
buf B_LLKRXCHCOMPLETIONPARTIALN0 (LLKRXCHCOMPLETIONPARTIALN[0], LLKRXCHCOMPLETIONPARTIALN_OUT[0]);
buf B_LLKRXCHCOMPLETIONPARTIALN1 (LLKRXCHCOMPLETIONPARTIALN[1], LLKRXCHCOMPLETIONPARTIALN_OUT[1]);
buf B_LLKRXCHCOMPLETIONPARTIALN2 (LLKRXCHCOMPLETIONPARTIALN[2], LLKRXCHCOMPLETIONPARTIALN_OUT[2]);
buf B_LLKRXCHCOMPLETIONPARTIALN3 (LLKRXCHCOMPLETIONPARTIALN[3], LLKRXCHCOMPLETIONPARTIALN_OUT[3]);
buf B_LLKRXCHCOMPLETIONPARTIALN4 (LLKRXCHCOMPLETIONPARTIALN[4], LLKRXCHCOMPLETIONPARTIALN_OUT[4]);
buf B_LLKRXCHCOMPLETIONPARTIALN5 (LLKRXCHCOMPLETIONPARTIALN[5], LLKRXCHCOMPLETIONPARTIALN_OUT[5]);
buf B_LLKRXCHCOMPLETIONPARTIALN6 (LLKRXCHCOMPLETIONPARTIALN[6], LLKRXCHCOMPLETIONPARTIALN_OUT[6]);
buf B_LLKRXCHCOMPLETIONPARTIALN7 (LLKRXCHCOMPLETIONPARTIALN[7], LLKRXCHCOMPLETIONPARTIALN_OUT[7]);
buf B_LLKRXCHCONFIGPARTIALN (LLKRXCHCONFIGPARTIALN, LLKRXCHCONFIGPARTIALN_OUT);
buf B_LLKRX4DWHEADERN (LLKRX4DWHEADERN, LLKRX4DWHEADERN_OUT);
buf B_LLKRXECRCBADN (LLKRXECRCBADN, LLKRXECRCBADN_OUT);
buf B_MGMTRDATA0 (MGMTRDATA[0], MGMTRDATA_OUT[0]);
buf B_MGMTRDATA1 (MGMTRDATA[1], MGMTRDATA_OUT[1]);
buf B_MGMTRDATA2 (MGMTRDATA[2], MGMTRDATA_OUT[2]);
buf B_MGMTRDATA3 (MGMTRDATA[3], MGMTRDATA_OUT[3]);
buf B_MGMTRDATA4 (MGMTRDATA[4], MGMTRDATA_OUT[4]);
buf B_MGMTRDATA5 (MGMTRDATA[5], MGMTRDATA_OUT[5]);
buf B_MGMTRDATA6 (MGMTRDATA[6], MGMTRDATA_OUT[6]);
buf B_MGMTRDATA7 (MGMTRDATA[7], MGMTRDATA_OUT[7]);
buf B_MGMTRDATA8 (MGMTRDATA[8], MGMTRDATA_OUT[8]);
buf B_MGMTRDATA9 (MGMTRDATA[9], MGMTRDATA_OUT[9]);
buf B_MGMTRDATA10 (MGMTRDATA[10], MGMTRDATA_OUT[10]);
buf B_MGMTRDATA11 (MGMTRDATA[11], MGMTRDATA_OUT[11]);
buf B_MGMTRDATA12 (MGMTRDATA[12], MGMTRDATA_OUT[12]);
buf B_MGMTRDATA13 (MGMTRDATA[13], MGMTRDATA_OUT[13]);
buf B_MGMTRDATA14 (MGMTRDATA[14], MGMTRDATA_OUT[14]);
buf B_MGMTRDATA15 (MGMTRDATA[15], MGMTRDATA_OUT[15]);
buf B_MGMTRDATA16 (MGMTRDATA[16], MGMTRDATA_OUT[16]);
buf B_MGMTRDATA17 (MGMTRDATA[17], MGMTRDATA_OUT[17]);
buf B_MGMTRDATA18 (MGMTRDATA[18], MGMTRDATA_OUT[18]);
buf B_MGMTRDATA19 (MGMTRDATA[19], MGMTRDATA_OUT[19]);
buf B_MGMTRDATA20 (MGMTRDATA[20], MGMTRDATA_OUT[20]);
buf B_MGMTRDATA21 (MGMTRDATA[21], MGMTRDATA_OUT[21]);
buf B_MGMTRDATA22 (MGMTRDATA[22], MGMTRDATA_OUT[22]);
buf B_MGMTRDATA23 (MGMTRDATA[23], MGMTRDATA_OUT[23]);
buf B_MGMTRDATA24 (MGMTRDATA[24], MGMTRDATA_OUT[24]);
buf B_MGMTRDATA25 (MGMTRDATA[25], MGMTRDATA_OUT[25]);
buf B_MGMTRDATA26 (MGMTRDATA[26], MGMTRDATA_OUT[26]);
buf B_MGMTRDATA27 (MGMTRDATA[27], MGMTRDATA_OUT[27]);
buf B_MGMTRDATA28 (MGMTRDATA[28], MGMTRDATA_OUT[28]);
buf B_MGMTRDATA29 (MGMTRDATA[29], MGMTRDATA_OUT[29]);
buf B_MGMTRDATA30 (MGMTRDATA[30], MGMTRDATA_OUT[30]);
buf B_MGMTRDATA31 (MGMTRDATA[31], MGMTRDATA_OUT[31]);
buf B_MGMTPSO0 (MGMTPSO[0], MGMTPSO_OUT[0]);
buf B_MGMTPSO1 (MGMTPSO[1], MGMTPSO_OUT[1]);
buf B_MGMTPSO2 (MGMTPSO[2], MGMTPSO_OUT[2]);
buf B_MGMTPSO3 (MGMTPSO[3], MGMTPSO_OUT[3]);
buf B_MGMTPSO4 (MGMTPSO[4], MGMTPSO_OUT[4]);
buf B_MGMTPSO5 (MGMTPSO[5], MGMTPSO_OUT[5]);
buf B_MGMTPSO6 (MGMTPSO[6], MGMTPSO_OUT[6]);
buf B_MGMTPSO7 (MGMTPSO[7], MGMTPSO_OUT[7]);
buf B_MGMTPSO8 (MGMTPSO[8], MGMTPSO_OUT[8]);
buf B_MGMTPSO9 (MGMTPSO[9], MGMTPSO_OUT[9]);
buf B_MGMTPSO10 (MGMTPSO[10], MGMTPSO_OUT[10]);
buf B_MGMTPSO11 (MGMTPSO[11], MGMTPSO_OUT[11]);
buf B_MGMTPSO12 (MGMTPSO[12], MGMTPSO_OUT[12]);
buf B_MGMTPSO13 (MGMTPSO[13], MGMTPSO_OUT[13]);
buf B_MGMTPSO14 (MGMTPSO[14], MGMTPSO_OUT[14]);
buf B_MGMTPSO15 (MGMTPSO[15], MGMTPSO_OUT[15]);
buf B_MGMTPSO16 (MGMTPSO[16], MGMTPSO_OUT[16]);
buf B_MGMTSTATSCREDIT0 (MGMTSTATSCREDIT[0], MGMTSTATSCREDIT_OUT[0]);
buf B_MGMTSTATSCREDIT1 (MGMTSTATSCREDIT[1], MGMTSTATSCREDIT_OUT[1]);
buf B_MGMTSTATSCREDIT2 (MGMTSTATSCREDIT[2], MGMTSTATSCREDIT_OUT[2]);
buf B_MGMTSTATSCREDIT3 (MGMTSTATSCREDIT[3], MGMTSTATSCREDIT_OUT[3]);
buf B_MGMTSTATSCREDIT4 (MGMTSTATSCREDIT[4], MGMTSTATSCREDIT_OUT[4]);
buf B_MGMTSTATSCREDIT5 (MGMTSTATSCREDIT[5], MGMTSTATSCREDIT_OUT[5]);
buf B_MGMTSTATSCREDIT6 (MGMTSTATSCREDIT[6], MGMTSTATSCREDIT_OUT[6]);
buf B_MGMTSTATSCREDIT7 (MGMTSTATSCREDIT[7], MGMTSTATSCREDIT_OUT[7]);
buf B_MGMTSTATSCREDIT8 (MGMTSTATSCREDIT[8], MGMTSTATSCREDIT_OUT[8]);
buf B_MGMTSTATSCREDIT9 (MGMTSTATSCREDIT[9], MGMTSTATSCREDIT_OUT[9]);
buf B_MGMTSTATSCREDIT10 (MGMTSTATSCREDIT[10], MGMTSTATSCREDIT_OUT[10]);
buf B_MGMTSTATSCREDIT11 (MGMTSTATSCREDIT[11], MGMTSTATSCREDIT_OUT[11]);
buf B_L0RXDLLTLPECRCOK (L0RXDLLTLPECRCOK, L0RXDLLTLPECRCOK_OUT);
buf B_DLLTXPMDLLPOUTSTANDING (DLLTXPMDLLPOUTSTANDING, DLLTXPMDLLPOUTSTANDING_OUT);
buf B_L0FIRSTCFGWRITEOCCURRED (L0FIRSTCFGWRITEOCCURRED, L0FIRSTCFGWRITEOCCURRED_OUT);
buf B_L0CFGLOOPBACKACK (L0CFGLOOPBACKACK, L0CFGLOOPBACKACK_OUT);
buf B_L0MACUPSTREAMDOWNSTREAM (L0MACUPSTREAMDOWNSTREAM, L0MACUPSTREAMDOWNSTREAM_OUT);
buf B_L0RXMACLINKERROR0 (L0RXMACLINKERROR[0], L0RXMACLINKERROR_OUT[0]);
buf B_L0RXMACLINKERROR1 (L0RXMACLINKERROR[1], L0RXMACLINKERROR_OUT[1]);
buf B_L0MACLINKUP (L0MACLINKUP, L0MACLINKUP_OUT);
buf B_L0MACNEGOTIATEDLINKWIDTH0 (L0MACNEGOTIATEDLINKWIDTH[0], L0MACNEGOTIATEDLINKWIDTH_OUT[0]);
buf B_L0MACNEGOTIATEDLINKWIDTH1 (L0MACNEGOTIATEDLINKWIDTH[1], L0MACNEGOTIATEDLINKWIDTH_OUT[1]);
buf B_L0MACNEGOTIATEDLINKWIDTH2 (L0MACNEGOTIATEDLINKWIDTH[2], L0MACNEGOTIATEDLINKWIDTH_OUT[2]);
buf B_L0MACNEGOTIATEDLINKWIDTH3 (L0MACNEGOTIATEDLINKWIDTH[3], L0MACNEGOTIATEDLINKWIDTH_OUT[3]);
buf B_L0MACLINKTRAINING (L0MACLINKTRAINING, L0MACLINKTRAINING_OUT);
buf B_L0LTSSMSTATE0 (L0LTSSMSTATE[0], L0LTSSMSTATE_OUT[0]);
buf B_L0LTSSMSTATE1 (L0LTSSMSTATE[1], L0LTSSMSTATE_OUT[1]);
buf B_L0LTSSMSTATE2 (L0LTSSMSTATE[2], L0LTSSMSTATE_OUT[2]);
buf B_L0LTSSMSTATE3 (L0LTSSMSTATE[3], L0LTSSMSTATE_OUT[3]);
buf B_L0DLLVCSTATUS0 (L0DLLVCSTATUS[0], L0DLLVCSTATUS_OUT[0]);
buf B_L0DLLVCSTATUS1 (L0DLLVCSTATUS[1], L0DLLVCSTATUS_OUT[1]);
buf B_L0DLLVCSTATUS2 (L0DLLVCSTATUS[2], L0DLLVCSTATUS_OUT[2]);
buf B_L0DLLVCSTATUS3 (L0DLLVCSTATUS[3], L0DLLVCSTATUS_OUT[3]);
buf B_L0DLLVCSTATUS4 (L0DLLVCSTATUS[4], L0DLLVCSTATUS_OUT[4]);
buf B_L0DLLVCSTATUS5 (L0DLLVCSTATUS[5], L0DLLVCSTATUS_OUT[5]);
buf B_L0DLLVCSTATUS6 (L0DLLVCSTATUS[6], L0DLLVCSTATUS_OUT[6]);
buf B_L0DLLVCSTATUS7 (L0DLLVCSTATUS[7], L0DLLVCSTATUS_OUT[7]);
buf B_L0DLUPDOWN0 (L0DLUPDOWN[0], L0DLUPDOWN_OUT[0]);
buf B_L0DLUPDOWN1 (L0DLUPDOWN[1], L0DLUPDOWN_OUT[1]);
buf B_L0DLUPDOWN2 (L0DLUPDOWN[2], L0DLUPDOWN_OUT[2]);
buf B_L0DLUPDOWN3 (L0DLUPDOWN[3], L0DLUPDOWN_OUT[3]);
buf B_L0DLUPDOWN4 (L0DLUPDOWN[4], L0DLUPDOWN_OUT[4]);
buf B_L0DLUPDOWN5 (L0DLUPDOWN[5], L0DLUPDOWN_OUT[5]);
buf B_L0DLUPDOWN6 (L0DLUPDOWN[6], L0DLUPDOWN_OUT[6]);
buf B_L0DLUPDOWN7 (L0DLUPDOWN[7], L0DLUPDOWN_OUT[7]);
buf B_L0DLLERRORVECTOR0 (L0DLLERRORVECTOR[0], L0DLLERRORVECTOR_OUT[0]);
buf B_L0DLLERRORVECTOR1 (L0DLLERRORVECTOR[1], L0DLLERRORVECTOR_OUT[1]);
buf B_L0DLLERRORVECTOR2 (L0DLLERRORVECTOR[2], L0DLLERRORVECTOR_OUT[2]);
buf B_L0DLLERRORVECTOR3 (L0DLLERRORVECTOR[3], L0DLLERRORVECTOR_OUT[3]);
buf B_L0DLLERRORVECTOR4 (L0DLLERRORVECTOR[4], L0DLLERRORVECTOR_OUT[4]);
buf B_L0DLLERRORVECTOR5 (L0DLLERRORVECTOR[5], L0DLLERRORVECTOR_OUT[5]);
buf B_L0DLLERRORVECTOR6 (L0DLLERRORVECTOR[6], L0DLLERRORVECTOR_OUT[6]);
buf B_L0DLLASRXSTATE0 (L0DLLASRXSTATE[0], L0DLLASRXSTATE_OUT[0]);
buf B_L0DLLASRXSTATE1 (L0DLLASRXSTATE[1], L0DLLASRXSTATE_OUT[1]);
buf B_L0DLLASTXSTATE (L0DLLASTXSTATE, L0DLLASTXSTATE_OUT);
buf B_L0ASAUTONOMOUSINITCOMPLETED (L0ASAUTONOMOUSINITCOMPLETED, L0ASAUTONOMOUSINITCOMPLETED_OUT);
buf B_L0COMPLETERID0 (L0COMPLETERID[0], L0COMPLETERID_OUT[0]);
buf B_L0COMPLETERID1 (L0COMPLETERID[1], L0COMPLETERID_OUT[1]);
buf B_L0COMPLETERID2 (L0COMPLETERID[2], L0COMPLETERID_OUT[2]);
buf B_L0COMPLETERID3 (L0COMPLETERID[3], L0COMPLETERID_OUT[3]);
buf B_L0COMPLETERID4 (L0COMPLETERID[4], L0COMPLETERID_OUT[4]);
buf B_L0COMPLETERID5 (L0COMPLETERID[5], L0COMPLETERID_OUT[5]);
buf B_L0COMPLETERID6 (L0COMPLETERID[6], L0COMPLETERID_OUT[6]);
buf B_L0COMPLETERID7 (L0COMPLETERID[7], L0COMPLETERID_OUT[7]);
buf B_L0COMPLETERID8 (L0COMPLETERID[8], L0COMPLETERID_OUT[8]);
buf B_L0COMPLETERID9 (L0COMPLETERID[9], L0COMPLETERID_OUT[9]);
buf B_L0COMPLETERID10 (L0COMPLETERID[10], L0COMPLETERID_OUT[10]);
buf B_L0COMPLETERID11 (L0COMPLETERID[11], L0COMPLETERID_OUT[11]);
buf B_L0COMPLETERID12 (L0COMPLETERID[12], L0COMPLETERID_OUT[12]);
buf B_L0UNLOCKRECEIVED (L0UNLOCKRECEIVED, L0UNLOCKRECEIVED_OUT);
buf B_L0CORRERRMSGRCVD (L0CORRERRMSGRCVD, L0CORRERRMSGRCVD_OUT);
buf B_L0FATALERRMSGRCVD (L0FATALERRMSGRCVD, L0FATALERRMSGRCVD_OUT);
buf B_L0NONFATALERRMSGRCVD (L0NONFATALERRMSGRCVD, L0NONFATALERRMSGRCVD_OUT);
buf B_L0ERRMSGREQID0 (L0ERRMSGREQID[0], L0ERRMSGREQID_OUT[0]);
buf B_L0ERRMSGREQID1 (L0ERRMSGREQID[1], L0ERRMSGREQID_OUT[1]);
buf B_L0ERRMSGREQID2 (L0ERRMSGREQID[2], L0ERRMSGREQID_OUT[2]);
buf B_L0ERRMSGREQID3 (L0ERRMSGREQID[3], L0ERRMSGREQID_OUT[3]);
buf B_L0ERRMSGREQID4 (L0ERRMSGREQID[4], L0ERRMSGREQID_OUT[4]);
buf B_L0ERRMSGREQID5 (L0ERRMSGREQID[5], L0ERRMSGREQID_OUT[5]);
buf B_L0ERRMSGREQID6 (L0ERRMSGREQID[6], L0ERRMSGREQID_OUT[6]);
buf B_L0ERRMSGREQID7 (L0ERRMSGREQID[7], L0ERRMSGREQID_OUT[7]);
buf B_L0ERRMSGREQID8 (L0ERRMSGREQID[8], L0ERRMSGREQID_OUT[8]);
buf B_L0ERRMSGREQID9 (L0ERRMSGREQID[9], L0ERRMSGREQID_OUT[9]);
buf B_L0ERRMSGREQID10 (L0ERRMSGREQID[10], L0ERRMSGREQID_OUT[10]);
buf B_L0ERRMSGREQID11 (L0ERRMSGREQID[11], L0ERRMSGREQID_OUT[11]);
buf B_L0ERRMSGREQID12 (L0ERRMSGREQID[12], L0ERRMSGREQID_OUT[12]);
buf B_L0ERRMSGREQID13 (L0ERRMSGREQID[13], L0ERRMSGREQID_OUT[13]);
buf B_L0ERRMSGREQID14 (L0ERRMSGREQID[14], L0ERRMSGREQID_OUT[14]);
buf B_L0ERRMSGREQID15 (L0ERRMSGREQID[15], L0ERRMSGREQID_OUT[15]);
buf B_L0FWDCORRERROUT (L0FWDCORRERROUT, L0FWDCORRERROUT_OUT);
buf B_L0FWDFATALERROUT (L0FWDFATALERROUT, L0FWDFATALERROUT_OUT);
buf B_L0FWDNONFATALERROUT (L0FWDNONFATALERROUT, L0FWDNONFATALERROUT_OUT);
buf B_L0RECEIVEDASSERTINTALEGACYINT (L0RECEIVEDASSERTINTALEGACYINT, L0RECEIVEDASSERTINTALEGACYINT_OUT);
buf B_L0RECEIVEDASSERTINTBLEGACYINT (L0RECEIVEDASSERTINTBLEGACYINT, L0RECEIVEDASSERTINTBLEGACYINT_OUT);
buf B_L0RECEIVEDASSERTINTCLEGACYINT (L0RECEIVEDASSERTINTCLEGACYINT, L0RECEIVEDASSERTINTCLEGACYINT_OUT);
buf B_L0RECEIVEDASSERTINTDLEGACYINT (L0RECEIVEDASSERTINTDLEGACYINT, L0RECEIVEDASSERTINTDLEGACYINT_OUT);
buf B_L0RECEIVEDDEASSERTINTALEGACYINT (L0RECEIVEDDEASSERTINTALEGACYINT, L0RECEIVEDDEASSERTINTALEGACYINT_OUT);
buf B_L0RECEIVEDDEASSERTINTBLEGACYINT (L0RECEIVEDDEASSERTINTBLEGACYINT, L0RECEIVEDDEASSERTINTBLEGACYINT_OUT);
buf B_L0RECEIVEDDEASSERTINTCLEGACYINT (L0RECEIVEDDEASSERTINTCLEGACYINT, L0RECEIVEDDEASSERTINTCLEGACYINT_OUT);
buf B_L0RECEIVEDDEASSERTINTDLEGACYINT (L0RECEIVEDDEASSERTINTDLEGACYINT, L0RECEIVEDDEASSERTINTDLEGACYINT_OUT);
buf B_L0MSIENABLE0 (L0MSIENABLE0, L0MSIENABLE0_OUT);
buf B_L0MULTIMSGEN00 (L0MULTIMSGEN0[0], L0MULTIMSGEN0_OUT[0]);
buf B_L0MULTIMSGEN01 (L0MULTIMSGEN0[1], L0MULTIMSGEN0_OUT[1]);
buf B_L0MULTIMSGEN02 (L0MULTIMSGEN0[2], L0MULTIMSGEN0_OUT[2]);
buf B_L0STATSDLLPRECEIVED (L0STATSDLLPRECEIVED, L0STATSDLLPRECEIVED_OUT);
buf B_L0STATSDLLPTRANSMITTED (L0STATSDLLPTRANSMITTED, L0STATSDLLPTRANSMITTED_OUT);
buf B_L0STATSOSRECEIVED (L0STATSOSRECEIVED, L0STATSOSRECEIVED_OUT);
buf B_L0STATSOSTRANSMITTED (L0STATSOSTRANSMITTED, L0STATSOSTRANSMITTED_OUT);
buf B_L0STATSTLPRECEIVED (L0STATSTLPRECEIVED, L0STATSTLPRECEIVED_OUT);
buf B_L0STATSTLPTRANSMITTED (L0STATSTLPTRANSMITTED, L0STATSTLPTRANSMITTED_OUT);
buf B_L0STATSCFGRECEIVED (L0STATSCFGRECEIVED, L0STATSCFGRECEIVED_OUT);
buf B_L0STATSCFGTRANSMITTED (L0STATSCFGTRANSMITTED, L0STATSCFGTRANSMITTED_OUT);
buf B_L0STATSCFGOTHERRECEIVED (L0STATSCFGOTHERRECEIVED, L0STATSCFGOTHERRECEIVED_OUT);
buf B_L0STATSCFGOTHERTRANSMITTED (L0STATSCFGOTHERTRANSMITTED, L0STATSCFGOTHERTRANSMITTED_OUT);
buf B_MAXPAYLOADSIZE0 (MAXPAYLOADSIZE[0], MAXPAYLOADSIZE_OUT[0]);
buf B_MAXPAYLOADSIZE1 (MAXPAYLOADSIZE[1], MAXPAYLOADSIZE_OUT[1]);
buf B_MAXPAYLOADSIZE2 (MAXPAYLOADSIZE[2], MAXPAYLOADSIZE_OUT[2]);
buf B_MAXREADREQUESTSIZE0 (MAXREADREQUESTSIZE[0], MAXREADREQUESTSIZE_OUT[0]);
buf B_MAXREADREQUESTSIZE1 (MAXREADREQUESTSIZE[1], MAXREADREQUESTSIZE_OUT[1]);
buf B_MAXREADREQUESTSIZE2 (MAXREADREQUESTSIZE[2], MAXREADREQUESTSIZE_OUT[2]);
buf B_IOSPACEENABLE (IOSPACEENABLE, IOSPACEENABLE_OUT);
buf B_MEMSPACEENABLE (MEMSPACEENABLE, MEMSPACEENABLE_OUT);
buf B_L0ATTENTIONINDICATORCONTROL0 (L0ATTENTIONINDICATORCONTROL[0], L0ATTENTIONINDICATORCONTROL_OUT[0]);
buf B_L0ATTENTIONINDICATORCONTROL1 (L0ATTENTIONINDICATORCONTROL[1], L0ATTENTIONINDICATORCONTROL_OUT[1]);
buf B_L0POWERINDICATORCONTROL0 (L0POWERINDICATORCONTROL[0], L0POWERINDICATORCONTROL_OUT[0]);
buf B_L0POWERINDICATORCONTROL1 (L0POWERINDICATORCONTROL[1], L0POWERINDICATORCONTROL_OUT[1]);
buf B_L0POWERCONTROLLERCONTROL (L0POWERCONTROLLERCONTROL, L0POWERCONTROLLERCONTROL_OUT);
buf B_L0TOGGLEELECTROMECHANICALINTERLOCK (L0TOGGLEELECTROMECHANICALINTERLOCK, L0TOGGLEELECTROMECHANICALINTERLOCK_OUT);
buf B_L0RXBEACON (L0RXBEACON, L0RXBEACON_OUT);
buf B_L0PWRSTATE00 (L0PWRSTATE0[0], L0PWRSTATE0_OUT[0]);
buf B_L0PWRSTATE01 (L0PWRSTATE0[1], L0PWRSTATE0_OUT[1]);
buf B_L0PMEACK (L0PMEACK, L0PMEACK_OUT);
buf B_L0PMEREQOUT (L0PMEREQOUT, L0PMEREQOUT_OUT);
buf B_L0PMEEN (L0PMEEN, L0PMEEN_OUT);
buf B_L0PWRINHIBITTRANSFERS (L0PWRINHIBITTRANSFERS, L0PWRINHIBITTRANSFERS_OUT);
buf B_L0PWRL1STATE (L0PWRL1STATE, L0PWRL1STATE_OUT);
buf B_L0PWRL23READYDEVICE (L0PWRL23READYDEVICE, L0PWRL23READYDEVICE_OUT);
buf B_L0PWRL23READYSTATE (L0PWRL23READYSTATE, L0PWRL23READYSTATE_OUT);
buf B_L0PWRTXL0SSTATE (L0PWRTXL0SSTATE, L0PWRTXL0SSTATE_OUT);
buf B_L0PWRTURNOFFREQ (L0PWRTURNOFFREQ, L0PWRTURNOFFREQ_OUT);
buf B_L0RXDLLPM (L0RXDLLPM, L0RXDLLPM_OUT);
buf B_L0RXDLLPMTYPE0 (L0RXDLLPMTYPE[0], L0RXDLLPMTYPE_OUT[0]);
buf B_L0RXDLLPMTYPE1 (L0RXDLLPMTYPE[1], L0RXDLLPMTYPE_OUT[1]);
buf B_L0RXDLLPMTYPE2 (L0RXDLLPMTYPE[2], L0RXDLLPMTYPE_OUT[2]);
buf B_L0TXDLLPMUPDATED (L0TXDLLPMUPDATED, L0TXDLLPMUPDATED_OUT);
buf B_L0MACNEWSTATEACK (L0MACNEWSTATEACK, L0MACNEWSTATEACK_OUT);
buf B_L0MACRXL0SSTATE (L0MACRXL0SSTATE, L0MACRXL0SSTATE_OUT);
buf B_L0MACENTEREDL0 (L0MACENTEREDL0, L0MACENTEREDL0_OUT);
buf B_L0DLLRXACKOUTSTANDING (L0DLLRXACKOUTSTANDING, L0DLLRXACKOUTSTANDING_OUT);
buf B_L0DLLTXOUTSTANDING (L0DLLTXOUTSTANDING, L0DLLTXOUTSTANDING_OUT);
buf B_L0DLLTXNONFCOUTSTANDING (L0DLLTXNONFCOUTSTANDING, L0DLLTXNONFCOUTSTANDING_OUT);
buf B_L0RXDLLTLPEND0 (L0RXDLLTLPEND[0], L0RXDLLTLPEND_OUT[0]);
buf B_L0RXDLLTLPEND1 (L0RXDLLTLPEND[1], L0RXDLLTLPEND_OUT[1]);
buf B_L0TXDLLSBFCUPDATED (L0TXDLLSBFCUPDATED, L0TXDLLSBFCUPDATED_OUT);
buf B_L0RXDLLSBFCDATA0 (L0RXDLLSBFCDATA[0], L0RXDLLSBFCDATA_OUT[0]);
buf B_L0RXDLLSBFCDATA1 (L0RXDLLSBFCDATA[1], L0RXDLLSBFCDATA_OUT[1]);
buf B_L0RXDLLSBFCDATA2 (L0RXDLLSBFCDATA[2], L0RXDLLSBFCDATA_OUT[2]);
buf B_L0RXDLLSBFCDATA3 (L0RXDLLSBFCDATA[3], L0RXDLLSBFCDATA_OUT[3]);
buf B_L0RXDLLSBFCDATA4 (L0RXDLLSBFCDATA[4], L0RXDLLSBFCDATA_OUT[4]);
buf B_L0RXDLLSBFCDATA5 (L0RXDLLSBFCDATA[5], L0RXDLLSBFCDATA_OUT[5]);
buf B_L0RXDLLSBFCDATA6 (L0RXDLLSBFCDATA[6], L0RXDLLSBFCDATA_OUT[6]);
buf B_L0RXDLLSBFCDATA7 (L0RXDLLSBFCDATA[7], L0RXDLLSBFCDATA_OUT[7]);
buf B_L0RXDLLSBFCDATA8 (L0RXDLLSBFCDATA[8], L0RXDLLSBFCDATA_OUT[8]);
buf B_L0RXDLLSBFCDATA9 (L0RXDLLSBFCDATA[9], L0RXDLLSBFCDATA_OUT[9]);
buf B_L0RXDLLSBFCDATA10 (L0RXDLLSBFCDATA[10], L0RXDLLSBFCDATA_OUT[10]);
buf B_L0RXDLLSBFCDATA11 (L0RXDLLSBFCDATA[11], L0RXDLLSBFCDATA_OUT[11]);
buf B_L0RXDLLSBFCDATA12 (L0RXDLLSBFCDATA[12], L0RXDLLSBFCDATA_OUT[12]);
buf B_L0RXDLLSBFCDATA13 (L0RXDLLSBFCDATA[13], L0RXDLLSBFCDATA_OUT[13]);
buf B_L0RXDLLSBFCDATA14 (L0RXDLLSBFCDATA[14], L0RXDLLSBFCDATA_OUT[14]);
buf B_L0RXDLLSBFCDATA15 (L0RXDLLSBFCDATA[15], L0RXDLLSBFCDATA_OUT[15]);
buf B_L0RXDLLSBFCDATA16 (L0RXDLLSBFCDATA[16], L0RXDLLSBFCDATA_OUT[16]);
buf B_L0RXDLLSBFCDATA17 (L0RXDLLSBFCDATA[17], L0RXDLLSBFCDATA_OUT[17]);
buf B_L0RXDLLSBFCDATA18 (L0RXDLLSBFCDATA[18], L0RXDLLSBFCDATA_OUT[18]);
buf B_L0RXDLLSBFCUPDATE (L0RXDLLSBFCUPDATE, L0RXDLLSBFCUPDATE_OUT);
buf B_L0TXDLLFCNPOSTBYPUPDATED0 (L0TXDLLFCNPOSTBYPUPDATED[0], L0TXDLLFCNPOSTBYPUPDATED_OUT[0]);
buf B_L0TXDLLFCNPOSTBYPUPDATED1 (L0TXDLLFCNPOSTBYPUPDATED[1], L0TXDLLFCNPOSTBYPUPDATED_OUT[1]);
buf B_L0TXDLLFCNPOSTBYPUPDATED2 (L0TXDLLFCNPOSTBYPUPDATED[2], L0TXDLLFCNPOSTBYPUPDATED_OUT[2]);
buf B_L0TXDLLFCNPOSTBYPUPDATED3 (L0TXDLLFCNPOSTBYPUPDATED[3], L0TXDLLFCNPOSTBYPUPDATED_OUT[3]);
buf B_L0TXDLLFCNPOSTBYPUPDATED4 (L0TXDLLFCNPOSTBYPUPDATED[4], L0TXDLLFCNPOSTBYPUPDATED_OUT[4]);
buf B_L0TXDLLFCNPOSTBYPUPDATED5 (L0TXDLLFCNPOSTBYPUPDATED[5], L0TXDLLFCNPOSTBYPUPDATED_OUT[5]);
buf B_L0TXDLLFCNPOSTBYPUPDATED6 (L0TXDLLFCNPOSTBYPUPDATED[6], L0TXDLLFCNPOSTBYPUPDATED_OUT[6]);
buf B_L0TXDLLFCNPOSTBYPUPDATED7 (L0TXDLLFCNPOSTBYPUPDATED[7], L0TXDLLFCNPOSTBYPUPDATED_OUT[7]);
buf B_L0TXDLLFCPOSTORDUPDATED0 (L0TXDLLFCPOSTORDUPDATED[0], L0TXDLLFCPOSTORDUPDATED_OUT[0]);
buf B_L0TXDLLFCPOSTORDUPDATED1 (L0TXDLLFCPOSTORDUPDATED[1], L0TXDLLFCPOSTORDUPDATED_OUT[1]);
buf B_L0TXDLLFCPOSTORDUPDATED2 (L0TXDLLFCPOSTORDUPDATED[2], L0TXDLLFCPOSTORDUPDATED_OUT[2]);
buf B_L0TXDLLFCPOSTORDUPDATED3 (L0TXDLLFCPOSTORDUPDATED[3], L0TXDLLFCPOSTORDUPDATED_OUT[3]);
buf B_L0TXDLLFCPOSTORDUPDATED4 (L0TXDLLFCPOSTORDUPDATED[4], L0TXDLLFCPOSTORDUPDATED_OUT[4]);
buf B_L0TXDLLFCPOSTORDUPDATED5 (L0TXDLLFCPOSTORDUPDATED[5], L0TXDLLFCPOSTORDUPDATED_OUT[5]);
buf B_L0TXDLLFCPOSTORDUPDATED6 (L0TXDLLFCPOSTORDUPDATED[6], L0TXDLLFCPOSTORDUPDATED_OUT[6]);
buf B_L0TXDLLFCPOSTORDUPDATED7 (L0TXDLLFCPOSTORDUPDATED[7], L0TXDLLFCPOSTORDUPDATED_OUT[7]);
buf B_L0TXDLLFCCMPLMCUPDATED0 (L0TXDLLFCCMPLMCUPDATED[0], L0TXDLLFCCMPLMCUPDATED_OUT[0]);
buf B_L0TXDLLFCCMPLMCUPDATED1 (L0TXDLLFCCMPLMCUPDATED[1], L0TXDLLFCCMPLMCUPDATED_OUT[1]);
buf B_L0TXDLLFCCMPLMCUPDATED2 (L0TXDLLFCCMPLMCUPDATED[2], L0TXDLLFCCMPLMCUPDATED_OUT[2]);
buf B_L0TXDLLFCCMPLMCUPDATED3 (L0TXDLLFCCMPLMCUPDATED[3], L0TXDLLFCCMPLMCUPDATED_OUT[3]);
buf B_L0TXDLLFCCMPLMCUPDATED4 (L0TXDLLFCCMPLMCUPDATED[4], L0TXDLLFCCMPLMCUPDATED_OUT[4]);
buf B_L0TXDLLFCCMPLMCUPDATED5 (L0TXDLLFCCMPLMCUPDATED[5], L0TXDLLFCCMPLMCUPDATED_OUT[5]);
buf B_L0TXDLLFCCMPLMCUPDATED6 (L0TXDLLFCCMPLMCUPDATED[6], L0TXDLLFCCMPLMCUPDATED_OUT[6]);
buf B_L0TXDLLFCCMPLMCUPDATED7 (L0TXDLLFCCMPLMCUPDATED[7], L0TXDLLFCCMPLMCUPDATED_OUT[7]);
buf B_L0RXDLLFCNPOSTBYPCRED0 (L0RXDLLFCNPOSTBYPCRED[0], L0RXDLLFCNPOSTBYPCRED_OUT[0]);
buf B_L0RXDLLFCNPOSTBYPCRED1 (L0RXDLLFCNPOSTBYPCRED[1], L0RXDLLFCNPOSTBYPCRED_OUT[1]);
buf B_L0RXDLLFCNPOSTBYPCRED2 (L0RXDLLFCNPOSTBYPCRED[2], L0RXDLLFCNPOSTBYPCRED_OUT[2]);
buf B_L0RXDLLFCNPOSTBYPCRED3 (L0RXDLLFCNPOSTBYPCRED[3], L0RXDLLFCNPOSTBYPCRED_OUT[3]);
buf B_L0RXDLLFCNPOSTBYPCRED4 (L0RXDLLFCNPOSTBYPCRED[4], L0RXDLLFCNPOSTBYPCRED_OUT[4]);
buf B_L0RXDLLFCNPOSTBYPCRED5 (L0RXDLLFCNPOSTBYPCRED[5], L0RXDLLFCNPOSTBYPCRED_OUT[5]);
buf B_L0RXDLLFCNPOSTBYPCRED6 (L0RXDLLFCNPOSTBYPCRED[6], L0RXDLLFCNPOSTBYPCRED_OUT[6]);
buf B_L0RXDLLFCNPOSTBYPCRED7 (L0RXDLLFCNPOSTBYPCRED[7], L0RXDLLFCNPOSTBYPCRED_OUT[7]);
buf B_L0RXDLLFCNPOSTBYPCRED8 (L0RXDLLFCNPOSTBYPCRED[8], L0RXDLLFCNPOSTBYPCRED_OUT[8]);
buf B_L0RXDLLFCNPOSTBYPCRED9 (L0RXDLLFCNPOSTBYPCRED[9], L0RXDLLFCNPOSTBYPCRED_OUT[9]);
buf B_L0RXDLLFCNPOSTBYPCRED10 (L0RXDLLFCNPOSTBYPCRED[10], L0RXDLLFCNPOSTBYPCRED_OUT[10]);
buf B_L0RXDLLFCNPOSTBYPCRED11 (L0RXDLLFCNPOSTBYPCRED[11], L0RXDLLFCNPOSTBYPCRED_OUT[11]);
buf B_L0RXDLLFCNPOSTBYPCRED12 (L0RXDLLFCNPOSTBYPCRED[12], L0RXDLLFCNPOSTBYPCRED_OUT[12]);
buf B_L0RXDLLFCNPOSTBYPCRED13 (L0RXDLLFCNPOSTBYPCRED[13], L0RXDLLFCNPOSTBYPCRED_OUT[13]);
buf B_L0RXDLLFCNPOSTBYPCRED14 (L0RXDLLFCNPOSTBYPCRED[14], L0RXDLLFCNPOSTBYPCRED_OUT[14]);
buf B_L0RXDLLFCNPOSTBYPCRED15 (L0RXDLLFCNPOSTBYPCRED[15], L0RXDLLFCNPOSTBYPCRED_OUT[15]);
buf B_L0RXDLLFCNPOSTBYPCRED16 (L0RXDLLFCNPOSTBYPCRED[16], L0RXDLLFCNPOSTBYPCRED_OUT[16]);
buf B_L0RXDLLFCNPOSTBYPCRED17 (L0RXDLLFCNPOSTBYPCRED[17], L0RXDLLFCNPOSTBYPCRED_OUT[17]);
buf B_L0RXDLLFCNPOSTBYPCRED18 (L0RXDLLFCNPOSTBYPCRED[18], L0RXDLLFCNPOSTBYPCRED_OUT[18]);
buf B_L0RXDLLFCNPOSTBYPCRED19 (L0RXDLLFCNPOSTBYPCRED[19], L0RXDLLFCNPOSTBYPCRED_OUT[19]);
buf B_L0RXDLLFCNPOSTBYPUPDATE0 (L0RXDLLFCNPOSTBYPUPDATE[0], L0RXDLLFCNPOSTBYPUPDATE_OUT[0]);
buf B_L0RXDLLFCNPOSTBYPUPDATE1 (L0RXDLLFCNPOSTBYPUPDATE[1], L0RXDLLFCNPOSTBYPUPDATE_OUT[1]);
buf B_L0RXDLLFCNPOSTBYPUPDATE2 (L0RXDLLFCNPOSTBYPUPDATE[2], L0RXDLLFCNPOSTBYPUPDATE_OUT[2]);
buf B_L0RXDLLFCNPOSTBYPUPDATE3 (L0RXDLLFCNPOSTBYPUPDATE[3], L0RXDLLFCNPOSTBYPUPDATE_OUT[3]);
buf B_L0RXDLLFCNPOSTBYPUPDATE4 (L0RXDLLFCNPOSTBYPUPDATE[4], L0RXDLLFCNPOSTBYPUPDATE_OUT[4]);
buf B_L0RXDLLFCNPOSTBYPUPDATE5 (L0RXDLLFCNPOSTBYPUPDATE[5], L0RXDLLFCNPOSTBYPUPDATE_OUT[5]);
buf B_L0RXDLLFCNPOSTBYPUPDATE6 (L0RXDLLFCNPOSTBYPUPDATE[6], L0RXDLLFCNPOSTBYPUPDATE_OUT[6]);
buf B_L0RXDLLFCNPOSTBYPUPDATE7 (L0RXDLLFCNPOSTBYPUPDATE[7], L0RXDLLFCNPOSTBYPUPDATE_OUT[7]);
buf B_L0RXDLLFCPOSTORDCRED0 (L0RXDLLFCPOSTORDCRED[0], L0RXDLLFCPOSTORDCRED_OUT[0]);
buf B_L0RXDLLFCPOSTORDCRED1 (L0RXDLLFCPOSTORDCRED[1], L0RXDLLFCPOSTORDCRED_OUT[1]);
buf B_L0RXDLLFCPOSTORDCRED2 (L0RXDLLFCPOSTORDCRED[2], L0RXDLLFCPOSTORDCRED_OUT[2]);
buf B_L0RXDLLFCPOSTORDCRED3 (L0RXDLLFCPOSTORDCRED[3], L0RXDLLFCPOSTORDCRED_OUT[3]);
buf B_L0RXDLLFCPOSTORDCRED4 (L0RXDLLFCPOSTORDCRED[4], L0RXDLLFCPOSTORDCRED_OUT[4]);
buf B_L0RXDLLFCPOSTORDCRED5 (L0RXDLLFCPOSTORDCRED[5], L0RXDLLFCPOSTORDCRED_OUT[5]);
buf B_L0RXDLLFCPOSTORDCRED6 (L0RXDLLFCPOSTORDCRED[6], L0RXDLLFCPOSTORDCRED_OUT[6]);
buf B_L0RXDLLFCPOSTORDCRED7 (L0RXDLLFCPOSTORDCRED[7], L0RXDLLFCPOSTORDCRED_OUT[7]);
buf B_L0RXDLLFCPOSTORDCRED8 (L0RXDLLFCPOSTORDCRED[8], L0RXDLLFCPOSTORDCRED_OUT[8]);
buf B_L0RXDLLFCPOSTORDCRED9 (L0RXDLLFCPOSTORDCRED[9], L0RXDLLFCPOSTORDCRED_OUT[9]);
buf B_L0RXDLLFCPOSTORDCRED10 (L0RXDLLFCPOSTORDCRED[10], L0RXDLLFCPOSTORDCRED_OUT[10]);
buf B_L0RXDLLFCPOSTORDCRED11 (L0RXDLLFCPOSTORDCRED[11], L0RXDLLFCPOSTORDCRED_OUT[11]);
buf B_L0RXDLLFCPOSTORDCRED12 (L0RXDLLFCPOSTORDCRED[12], L0RXDLLFCPOSTORDCRED_OUT[12]);
buf B_L0RXDLLFCPOSTORDCRED13 (L0RXDLLFCPOSTORDCRED[13], L0RXDLLFCPOSTORDCRED_OUT[13]);
buf B_L0RXDLLFCPOSTORDCRED14 (L0RXDLLFCPOSTORDCRED[14], L0RXDLLFCPOSTORDCRED_OUT[14]);
buf B_L0RXDLLFCPOSTORDCRED15 (L0RXDLLFCPOSTORDCRED[15], L0RXDLLFCPOSTORDCRED_OUT[15]);
buf B_L0RXDLLFCPOSTORDCRED16 (L0RXDLLFCPOSTORDCRED[16], L0RXDLLFCPOSTORDCRED_OUT[16]);
buf B_L0RXDLLFCPOSTORDCRED17 (L0RXDLLFCPOSTORDCRED[17], L0RXDLLFCPOSTORDCRED_OUT[17]);
buf B_L0RXDLLFCPOSTORDCRED18 (L0RXDLLFCPOSTORDCRED[18], L0RXDLLFCPOSTORDCRED_OUT[18]);
buf B_L0RXDLLFCPOSTORDCRED19 (L0RXDLLFCPOSTORDCRED[19], L0RXDLLFCPOSTORDCRED_OUT[19]);
buf B_L0RXDLLFCPOSTORDCRED20 (L0RXDLLFCPOSTORDCRED[20], L0RXDLLFCPOSTORDCRED_OUT[20]);
buf B_L0RXDLLFCPOSTORDCRED21 (L0RXDLLFCPOSTORDCRED[21], L0RXDLLFCPOSTORDCRED_OUT[21]);
buf B_L0RXDLLFCPOSTORDCRED22 (L0RXDLLFCPOSTORDCRED[22], L0RXDLLFCPOSTORDCRED_OUT[22]);
buf B_L0RXDLLFCPOSTORDCRED23 (L0RXDLLFCPOSTORDCRED[23], L0RXDLLFCPOSTORDCRED_OUT[23]);
buf B_L0RXDLLFCPOSTORDUPDATE0 (L0RXDLLFCPOSTORDUPDATE[0], L0RXDLLFCPOSTORDUPDATE_OUT[0]);
buf B_L0RXDLLFCPOSTORDUPDATE1 (L0RXDLLFCPOSTORDUPDATE[1], L0RXDLLFCPOSTORDUPDATE_OUT[1]);
buf B_L0RXDLLFCPOSTORDUPDATE2 (L0RXDLLFCPOSTORDUPDATE[2], L0RXDLLFCPOSTORDUPDATE_OUT[2]);
buf B_L0RXDLLFCPOSTORDUPDATE3 (L0RXDLLFCPOSTORDUPDATE[3], L0RXDLLFCPOSTORDUPDATE_OUT[3]);
buf B_L0RXDLLFCPOSTORDUPDATE4 (L0RXDLLFCPOSTORDUPDATE[4], L0RXDLLFCPOSTORDUPDATE_OUT[4]);
buf B_L0RXDLLFCPOSTORDUPDATE5 (L0RXDLLFCPOSTORDUPDATE[5], L0RXDLLFCPOSTORDUPDATE_OUT[5]);
buf B_L0RXDLLFCPOSTORDUPDATE6 (L0RXDLLFCPOSTORDUPDATE[6], L0RXDLLFCPOSTORDUPDATE_OUT[6]);
buf B_L0RXDLLFCPOSTORDUPDATE7 (L0RXDLLFCPOSTORDUPDATE[7], L0RXDLLFCPOSTORDUPDATE_OUT[7]);
buf B_L0RXDLLFCCMPLMCCRED0 (L0RXDLLFCCMPLMCCRED[0], L0RXDLLFCCMPLMCCRED_OUT[0]);
buf B_L0RXDLLFCCMPLMCCRED1 (L0RXDLLFCCMPLMCCRED[1], L0RXDLLFCCMPLMCCRED_OUT[1]);
buf B_L0RXDLLFCCMPLMCCRED2 (L0RXDLLFCCMPLMCCRED[2], L0RXDLLFCCMPLMCCRED_OUT[2]);
buf B_L0RXDLLFCCMPLMCCRED3 (L0RXDLLFCCMPLMCCRED[3], L0RXDLLFCCMPLMCCRED_OUT[3]);
buf B_L0RXDLLFCCMPLMCCRED4 (L0RXDLLFCCMPLMCCRED[4], L0RXDLLFCCMPLMCCRED_OUT[4]);
buf B_L0RXDLLFCCMPLMCCRED5 (L0RXDLLFCCMPLMCCRED[5], L0RXDLLFCCMPLMCCRED_OUT[5]);
buf B_L0RXDLLFCCMPLMCCRED6 (L0RXDLLFCCMPLMCCRED[6], L0RXDLLFCCMPLMCCRED_OUT[6]);
buf B_L0RXDLLFCCMPLMCCRED7 (L0RXDLLFCCMPLMCCRED[7], L0RXDLLFCCMPLMCCRED_OUT[7]);
buf B_L0RXDLLFCCMPLMCCRED8 (L0RXDLLFCCMPLMCCRED[8], L0RXDLLFCCMPLMCCRED_OUT[8]);
buf B_L0RXDLLFCCMPLMCCRED9 (L0RXDLLFCCMPLMCCRED[9], L0RXDLLFCCMPLMCCRED_OUT[9]);
buf B_L0RXDLLFCCMPLMCCRED10 (L0RXDLLFCCMPLMCCRED[10], L0RXDLLFCCMPLMCCRED_OUT[10]);
buf B_L0RXDLLFCCMPLMCCRED11 (L0RXDLLFCCMPLMCCRED[11], L0RXDLLFCCMPLMCCRED_OUT[11]);
buf B_L0RXDLLFCCMPLMCCRED12 (L0RXDLLFCCMPLMCCRED[12], L0RXDLLFCCMPLMCCRED_OUT[12]);
buf B_L0RXDLLFCCMPLMCCRED13 (L0RXDLLFCCMPLMCCRED[13], L0RXDLLFCCMPLMCCRED_OUT[13]);
buf B_L0RXDLLFCCMPLMCCRED14 (L0RXDLLFCCMPLMCCRED[14], L0RXDLLFCCMPLMCCRED_OUT[14]);
buf B_L0RXDLLFCCMPLMCCRED15 (L0RXDLLFCCMPLMCCRED[15], L0RXDLLFCCMPLMCCRED_OUT[15]);
buf B_L0RXDLLFCCMPLMCCRED16 (L0RXDLLFCCMPLMCCRED[16], L0RXDLLFCCMPLMCCRED_OUT[16]);
buf B_L0RXDLLFCCMPLMCCRED17 (L0RXDLLFCCMPLMCCRED[17], L0RXDLLFCCMPLMCCRED_OUT[17]);
buf B_L0RXDLLFCCMPLMCCRED18 (L0RXDLLFCCMPLMCCRED[18], L0RXDLLFCCMPLMCCRED_OUT[18]);
buf B_L0RXDLLFCCMPLMCCRED19 (L0RXDLLFCCMPLMCCRED[19], L0RXDLLFCCMPLMCCRED_OUT[19]);
buf B_L0RXDLLFCCMPLMCCRED20 (L0RXDLLFCCMPLMCCRED[20], L0RXDLLFCCMPLMCCRED_OUT[20]);
buf B_L0RXDLLFCCMPLMCCRED21 (L0RXDLLFCCMPLMCCRED[21], L0RXDLLFCCMPLMCCRED_OUT[21]);
buf B_L0RXDLLFCCMPLMCCRED22 (L0RXDLLFCCMPLMCCRED[22], L0RXDLLFCCMPLMCCRED_OUT[22]);
buf B_L0RXDLLFCCMPLMCCRED23 (L0RXDLLFCCMPLMCCRED[23], L0RXDLLFCCMPLMCCRED_OUT[23]);
buf B_L0RXDLLFCCMPLMCUPDATE0 (L0RXDLLFCCMPLMCUPDATE[0], L0RXDLLFCCMPLMCUPDATE_OUT[0]);
buf B_L0RXDLLFCCMPLMCUPDATE1 (L0RXDLLFCCMPLMCUPDATE[1], L0RXDLLFCCMPLMCUPDATE_OUT[1]);
buf B_L0RXDLLFCCMPLMCUPDATE2 (L0RXDLLFCCMPLMCUPDATE[2], L0RXDLLFCCMPLMCUPDATE_OUT[2]);
buf B_L0RXDLLFCCMPLMCUPDATE3 (L0RXDLLFCCMPLMCUPDATE[3], L0RXDLLFCCMPLMCUPDATE_OUT[3]);
buf B_L0RXDLLFCCMPLMCUPDATE4 (L0RXDLLFCCMPLMCUPDATE[4], L0RXDLLFCCMPLMCUPDATE_OUT[4]);
buf B_L0RXDLLFCCMPLMCUPDATE5 (L0RXDLLFCCMPLMCUPDATE[5], L0RXDLLFCCMPLMCUPDATE_OUT[5]);
buf B_L0RXDLLFCCMPLMCUPDATE6 (L0RXDLLFCCMPLMCUPDATE[6], L0RXDLLFCCMPLMCUPDATE_OUT[6]);
buf B_L0RXDLLFCCMPLMCUPDATE7 (L0RXDLLFCCMPLMCUPDATE[7], L0RXDLLFCCMPLMCUPDATE_OUT[7]);
buf B_L0UCBYPFOUND0 (L0UCBYPFOUND[0], L0UCBYPFOUND_OUT[0]);
buf B_L0UCBYPFOUND1 (L0UCBYPFOUND[1], L0UCBYPFOUND_OUT[1]);
buf B_L0UCBYPFOUND2 (L0UCBYPFOUND[2], L0UCBYPFOUND_OUT[2]);
buf B_L0UCBYPFOUND3 (L0UCBYPFOUND[3], L0UCBYPFOUND_OUT[3]);
buf B_L0UCORDFOUND0 (L0UCORDFOUND[0], L0UCORDFOUND_OUT[0]);
buf B_L0UCORDFOUND1 (L0UCORDFOUND[1], L0UCORDFOUND_OUT[1]);
buf B_L0UCORDFOUND2 (L0UCORDFOUND[2], L0UCORDFOUND_OUT[2]);
buf B_L0UCORDFOUND3 (L0UCORDFOUND[3], L0UCORDFOUND_OUT[3]);
buf B_L0MCFOUND0 (L0MCFOUND[0], L0MCFOUND_OUT[0]);
buf B_L0MCFOUND1 (L0MCFOUND[1], L0MCFOUND_OUT[1]);
buf B_L0MCFOUND2 (L0MCFOUND[2], L0MCFOUND_OUT[2]);
buf B_L0TRANSFORMEDVC0 (L0TRANSFORMEDVC[0], L0TRANSFORMEDVC_OUT[0]);
buf B_L0TRANSFORMEDVC1 (L0TRANSFORMEDVC[1], L0TRANSFORMEDVC_OUT[1]);
buf B_L0TRANSFORMEDVC2 (L0TRANSFORMEDVC[2], L0TRANSFORMEDVC_OUT[2]);
buf B_BUSMASTERENABLE (BUSMASTERENABLE, BUSMASTERENABLE_OUT);
buf B_PARITYERRORRESPONSE (PARITYERRORRESPONSE, PARITYERRORRESPONSE_OUT);
buf B_SERRENABLE (SERRENABLE, SERRENABLE_OUT);
buf B_INTERRUPTDISABLE (INTERRUPTDISABLE, INTERRUPTDISABLE_OUT);
buf B_URREPORTINGENABLE (URREPORTINGENABLE, URREPORTINGENABLE_OUT);

buf B_PIPERXELECIDLEL0 (PIPERXELECIDLEL0_IN, PIPERXELECIDLEL0);
buf B_PIPERXSTATUSL00 (PIPERXSTATUSL0_IN[0], PIPERXSTATUSL0[0]);
buf B_PIPERXSTATUSL01 (PIPERXSTATUSL0_IN[1], PIPERXSTATUSL0[1]);
buf B_PIPERXSTATUSL02 (PIPERXSTATUSL0_IN[2], PIPERXSTATUSL0[2]);
buf B_PIPERXDATAL00 (PIPERXDATAL0_IN[0], PIPERXDATAL0[0]);
buf B_PIPERXDATAL01 (PIPERXDATAL0_IN[1], PIPERXDATAL0[1]);
buf B_PIPERXDATAL02 (PIPERXDATAL0_IN[2], PIPERXDATAL0[2]);
buf B_PIPERXDATAL03 (PIPERXDATAL0_IN[3], PIPERXDATAL0[3]);
buf B_PIPERXDATAL04 (PIPERXDATAL0_IN[4], PIPERXDATAL0[4]);
buf B_PIPERXDATAL05 (PIPERXDATAL0_IN[5], PIPERXDATAL0[5]);
buf B_PIPERXDATAL06 (PIPERXDATAL0_IN[6], PIPERXDATAL0[6]);
buf B_PIPERXDATAL07 (PIPERXDATAL0_IN[7], PIPERXDATAL0[7]);
buf B_PIPEPHYSTATUSL0 (PIPEPHYSTATUSL0_IN, PIPEPHYSTATUSL0);
buf B_PIPERXDATAKL0 (PIPERXDATAKL0_IN, PIPERXDATAKL0);
buf B_PIPERXVALIDL0 (PIPERXVALIDL0_IN, PIPERXVALIDL0);
buf B_PIPERXCHANISALIGNEDL0 (PIPERXCHANISALIGNEDL0_IN, PIPERXCHANISALIGNEDL0);
buf B_PIPERXELECIDLEL1 (PIPERXELECIDLEL1_IN, PIPERXELECIDLEL1);
buf B_PIPERXSTATUSL10 (PIPERXSTATUSL1_IN[0], PIPERXSTATUSL1[0]);
buf B_PIPERXSTATUSL11 (PIPERXSTATUSL1_IN[1], PIPERXSTATUSL1[1]);
buf B_PIPERXSTATUSL12 (PIPERXSTATUSL1_IN[2], PIPERXSTATUSL1[2]);
buf B_PIPERXDATAL10 (PIPERXDATAL1_IN[0], PIPERXDATAL1[0]);
buf B_PIPERXDATAL11 (PIPERXDATAL1_IN[1], PIPERXDATAL1[1]);
buf B_PIPERXDATAL12 (PIPERXDATAL1_IN[2], PIPERXDATAL1[2]);
buf B_PIPERXDATAL13 (PIPERXDATAL1_IN[3], PIPERXDATAL1[3]);
buf B_PIPERXDATAL14 (PIPERXDATAL1_IN[4], PIPERXDATAL1[4]);
buf B_PIPERXDATAL15 (PIPERXDATAL1_IN[5], PIPERXDATAL1[5]);
buf B_PIPERXDATAL16 (PIPERXDATAL1_IN[6], PIPERXDATAL1[6]);
buf B_PIPERXDATAL17 (PIPERXDATAL1_IN[7], PIPERXDATAL1[7]);
buf B_PIPEPHYSTATUSL1 (PIPEPHYSTATUSL1_IN, PIPEPHYSTATUSL1);
buf B_PIPERXDATAKL1 (PIPERXDATAKL1_IN, PIPERXDATAKL1);
buf B_PIPERXVALIDL1 (PIPERXVALIDL1_IN, PIPERXVALIDL1);
buf B_PIPERXCHANISALIGNEDL1 (PIPERXCHANISALIGNEDL1_IN, PIPERXCHANISALIGNEDL1);
buf B_PIPERXELECIDLEL2 (PIPERXELECIDLEL2_IN, PIPERXELECIDLEL2);
buf B_PIPERXSTATUSL20 (PIPERXSTATUSL2_IN[0], PIPERXSTATUSL2[0]);
buf B_PIPERXSTATUSL21 (PIPERXSTATUSL2_IN[1], PIPERXSTATUSL2[1]);
buf B_PIPERXSTATUSL22 (PIPERXSTATUSL2_IN[2], PIPERXSTATUSL2[2]);
buf B_PIPERXDATAL20 (PIPERXDATAL2_IN[0], PIPERXDATAL2[0]);
buf B_PIPERXDATAL21 (PIPERXDATAL2_IN[1], PIPERXDATAL2[1]);
buf B_PIPERXDATAL22 (PIPERXDATAL2_IN[2], PIPERXDATAL2[2]);
buf B_PIPERXDATAL23 (PIPERXDATAL2_IN[3], PIPERXDATAL2[3]);
buf B_PIPERXDATAL24 (PIPERXDATAL2_IN[4], PIPERXDATAL2[4]);
buf B_PIPERXDATAL25 (PIPERXDATAL2_IN[5], PIPERXDATAL2[5]);
buf B_PIPERXDATAL26 (PIPERXDATAL2_IN[6], PIPERXDATAL2[6]);
buf B_PIPERXDATAL27 (PIPERXDATAL2_IN[7], PIPERXDATAL2[7]);
buf B_PIPEPHYSTATUSL2 (PIPEPHYSTATUSL2_IN, PIPEPHYSTATUSL2);
buf B_PIPERXDATAKL2 (PIPERXDATAKL2_IN, PIPERXDATAKL2);
buf B_PIPERXVALIDL2 (PIPERXVALIDL2_IN, PIPERXVALIDL2);
buf B_PIPERXCHANISALIGNEDL2 (PIPERXCHANISALIGNEDL2_IN, PIPERXCHANISALIGNEDL2);
buf B_PIPERXELECIDLEL3 (PIPERXELECIDLEL3_IN, PIPERXELECIDLEL3);
buf B_PIPERXSTATUSL30 (PIPERXSTATUSL3_IN[0], PIPERXSTATUSL3[0]);
buf B_PIPERXSTATUSL31 (PIPERXSTATUSL3_IN[1], PIPERXSTATUSL3[1]);
buf B_PIPERXSTATUSL32 (PIPERXSTATUSL3_IN[2], PIPERXSTATUSL3[2]);
buf B_PIPERXDATAL30 (PIPERXDATAL3_IN[0], PIPERXDATAL3[0]);
buf B_PIPERXDATAL31 (PIPERXDATAL3_IN[1], PIPERXDATAL3[1]);
buf B_PIPERXDATAL32 (PIPERXDATAL3_IN[2], PIPERXDATAL3[2]);
buf B_PIPERXDATAL33 (PIPERXDATAL3_IN[3], PIPERXDATAL3[3]);
buf B_PIPERXDATAL34 (PIPERXDATAL3_IN[4], PIPERXDATAL3[4]);
buf B_PIPERXDATAL35 (PIPERXDATAL3_IN[5], PIPERXDATAL3[5]);
buf B_PIPERXDATAL36 (PIPERXDATAL3_IN[6], PIPERXDATAL3[6]);
buf B_PIPERXDATAL37 (PIPERXDATAL3_IN[7], PIPERXDATAL3[7]);
buf B_PIPEPHYSTATUSL3 (PIPEPHYSTATUSL3_IN, PIPEPHYSTATUSL3);
buf B_PIPERXDATAKL3 (PIPERXDATAKL3_IN, PIPERXDATAKL3);
buf B_PIPERXVALIDL3 (PIPERXVALIDL3_IN, PIPERXVALIDL3);
buf B_PIPERXCHANISALIGNEDL3 (PIPERXCHANISALIGNEDL3_IN, PIPERXCHANISALIGNEDL3);
buf B_PIPERXELECIDLEL4 (PIPERXELECIDLEL4_IN, PIPERXELECIDLEL4);
buf B_PIPERXSTATUSL40 (PIPERXSTATUSL4_IN[0], PIPERXSTATUSL4[0]);
buf B_PIPERXSTATUSL41 (PIPERXSTATUSL4_IN[1], PIPERXSTATUSL4[1]);
buf B_PIPERXSTATUSL42 (PIPERXSTATUSL4_IN[2], PIPERXSTATUSL4[2]);
buf B_PIPERXDATAL40 (PIPERXDATAL4_IN[0], PIPERXDATAL4[0]);
buf B_PIPERXDATAL41 (PIPERXDATAL4_IN[1], PIPERXDATAL4[1]);
buf B_PIPERXDATAL42 (PIPERXDATAL4_IN[2], PIPERXDATAL4[2]);
buf B_PIPERXDATAL43 (PIPERXDATAL4_IN[3], PIPERXDATAL4[3]);
buf B_PIPERXDATAL44 (PIPERXDATAL4_IN[4], PIPERXDATAL4[4]);
buf B_PIPERXDATAL45 (PIPERXDATAL4_IN[5], PIPERXDATAL4[5]);
buf B_PIPERXDATAL46 (PIPERXDATAL4_IN[6], PIPERXDATAL4[6]);
buf B_PIPERXDATAL47 (PIPERXDATAL4_IN[7], PIPERXDATAL4[7]);
buf B_PIPEPHYSTATUSL4 (PIPEPHYSTATUSL4_IN, PIPEPHYSTATUSL4);
buf B_PIPERXDATAKL4 (PIPERXDATAKL4_IN, PIPERXDATAKL4);
buf B_PIPERXVALIDL4 (PIPERXVALIDL4_IN, PIPERXVALIDL4);
buf B_PIPERXCHANISALIGNEDL4 (PIPERXCHANISALIGNEDL4_IN, PIPERXCHANISALIGNEDL4);
buf B_PIPERXELECIDLEL5 (PIPERXELECIDLEL5_IN, PIPERXELECIDLEL5);
buf B_PIPERXSTATUSL50 (PIPERXSTATUSL5_IN[0], PIPERXSTATUSL5[0]);
buf B_PIPERXSTATUSL51 (PIPERXSTATUSL5_IN[1], PIPERXSTATUSL5[1]);
buf B_PIPERXSTATUSL52 (PIPERXSTATUSL5_IN[2], PIPERXSTATUSL5[2]);
buf B_PIPERXDATAL50 (PIPERXDATAL5_IN[0], PIPERXDATAL5[0]);
buf B_PIPERXDATAL51 (PIPERXDATAL5_IN[1], PIPERXDATAL5[1]);
buf B_PIPERXDATAL52 (PIPERXDATAL5_IN[2], PIPERXDATAL5[2]);
buf B_PIPERXDATAL53 (PIPERXDATAL5_IN[3], PIPERXDATAL5[3]);
buf B_PIPERXDATAL54 (PIPERXDATAL5_IN[4], PIPERXDATAL5[4]);
buf B_PIPERXDATAL55 (PIPERXDATAL5_IN[5], PIPERXDATAL5[5]);
buf B_PIPERXDATAL56 (PIPERXDATAL5_IN[6], PIPERXDATAL5[6]);
buf B_PIPERXDATAL57 (PIPERXDATAL5_IN[7], PIPERXDATAL5[7]);
buf B_PIPEPHYSTATUSL5 (PIPEPHYSTATUSL5_IN, PIPEPHYSTATUSL5);
buf B_PIPERXDATAKL5 (PIPERXDATAKL5_IN, PIPERXDATAKL5);
buf B_PIPERXVALIDL5 (PIPERXVALIDL5_IN, PIPERXVALIDL5);
buf B_PIPERXCHANISALIGNEDL5 (PIPERXCHANISALIGNEDL5_IN, PIPERXCHANISALIGNEDL5);
buf B_PIPERXELECIDLEL6 (PIPERXELECIDLEL6_IN, PIPERXELECIDLEL6);
buf B_PIPERXSTATUSL60 (PIPERXSTATUSL6_IN[0], PIPERXSTATUSL6[0]);
buf B_PIPERXSTATUSL61 (PIPERXSTATUSL6_IN[1], PIPERXSTATUSL6[1]);
buf B_PIPERXSTATUSL62 (PIPERXSTATUSL6_IN[2], PIPERXSTATUSL6[2]);
buf B_PIPERXDATAL60 (PIPERXDATAL6_IN[0], PIPERXDATAL6[0]);
buf B_PIPERXDATAL61 (PIPERXDATAL6_IN[1], PIPERXDATAL6[1]);
buf B_PIPERXDATAL62 (PIPERXDATAL6_IN[2], PIPERXDATAL6[2]);
buf B_PIPERXDATAL63 (PIPERXDATAL6_IN[3], PIPERXDATAL6[3]);
buf B_PIPERXDATAL64 (PIPERXDATAL6_IN[4], PIPERXDATAL6[4]);
buf B_PIPERXDATAL65 (PIPERXDATAL6_IN[5], PIPERXDATAL6[5]);
buf B_PIPERXDATAL66 (PIPERXDATAL6_IN[6], PIPERXDATAL6[6]);
buf B_PIPERXDATAL67 (PIPERXDATAL6_IN[7], PIPERXDATAL6[7]);
buf B_PIPEPHYSTATUSL6 (PIPEPHYSTATUSL6_IN, PIPEPHYSTATUSL6);
buf B_PIPERXDATAKL6 (PIPERXDATAKL6_IN, PIPERXDATAKL6);
buf B_PIPERXVALIDL6 (PIPERXVALIDL6_IN, PIPERXVALIDL6);
buf B_PIPERXCHANISALIGNEDL6 (PIPERXCHANISALIGNEDL6_IN, PIPERXCHANISALIGNEDL6);
buf B_PIPERXELECIDLEL7 (PIPERXELECIDLEL7_IN, PIPERXELECIDLEL7);
buf B_PIPERXSTATUSL70 (PIPERXSTATUSL7_IN[0], PIPERXSTATUSL7[0]);
buf B_PIPERXSTATUSL71 (PIPERXSTATUSL7_IN[1], PIPERXSTATUSL7[1]);
buf B_PIPERXSTATUSL72 (PIPERXSTATUSL7_IN[2], PIPERXSTATUSL7[2]);
buf B_PIPERXDATAL70 (PIPERXDATAL7_IN[0], PIPERXDATAL7[0]);
buf B_PIPERXDATAL71 (PIPERXDATAL7_IN[1], PIPERXDATAL7[1]);
buf B_PIPERXDATAL72 (PIPERXDATAL7_IN[2], PIPERXDATAL7[2]);
buf B_PIPERXDATAL73 (PIPERXDATAL7_IN[3], PIPERXDATAL7[3]);
buf B_PIPERXDATAL74 (PIPERXDATAL7_IN[4], PIPERXDATAL7[4]);
buf B_PIPERXDATAL75 (PIPERXDATAL7_IN[5], PIPERXDATAL7[5]);
buf B_PIPERXDATAL76 (PIPERXDATAL7_IN[6], PIPERXDATAL7[6]);
buf B_PIPERXDATAL77 (PIPERXDATAL7_IN[7], PIPERXDATAL7[7]);
buf B_PIPEPHYSTATUSL7 (PIPEPHYSTATUSL7_IN, PIPEPHYSTATUSL7);
buf B_PIPERXDATAKL7 (PIPERXDATAKL7_IN, PIPERXDATAKL7);
buf B_PIPERXVALIDL7 (PIPERXVALIDL7_IN, PIPERXVALIDL7);
buf B_PIPERXCHANISALIGNEDL7 (PIPERXCHANISALIGNEDL7_IN, PIPERXCHANISALIGNEDL7);
buf B_MIMRXBRDATA0 (MIMRXBRDATA_IN[0], MIMRXBRDATA[0]);
buf B_MIMRXBRDATA1 (MIMRXBRDATA_IN[1], MIMRXBRDATA[1]);
buf B_MIMRXBRDATA2 (MIMRXBRDATA_IN[2], MIMRXBRDATA[2]);
buf B_MIMRXBRDATA3 (MIMRXBRDATA_IN[3], MIMRXBRDATA[3]);
buf B_MIMRXBRDATA4 (MIMRXBRDATA_IN[4], MIMRXBRDATA[4]);
buf B_MIMRXBRDATA5 (MIMRXBRDATA_IN[5], MIMRXBRDATA[5]);
buf B_MIMRXBRDATA6 (MIMRXBRDATA_IN[6], MIMRXBRDATA[6]);
buf B_MIMRXBRDATA7 (MIMRXBRDATA_IN[7], MIMRXBRDATA[7]);
buf B_MIMRXBRDATA8 (MIMRXBRDATA_IN[8], MIMRXBRDATA[8]);
buf B_MIMRXBRDATA9 (MIMRXBRDATA_IN[9], MIMRXBRDATA[9]);
buf B_MIMRXBRDATA10 (MIMRXBRDATA_IN[10], MIMRXBRDATA[10]);
buf B_MIMRXBRDATA11 (MIMRXBRDATA_IN[11], MIMRXBRDATA[11]);
buf B_MIMRXBRDATA12 (MIMRXBRDATA_IN[12], MIMRXBRDATA[12]);
buf B_MIMRXBRDATA13 (MIMRXBRDATA_IN[13], MIMRXBRDATA[13]);
buf B_MIMRXBRDATA14 (MIMRXBRDATA_IN[14], MIMRXBRDATA[14]);
buf B_MIMRXBRDATA15 (MIMRXBRDATA_IN[15], MIMRXBRDATA[15]);
buf B_MIMRXBRDATA16 (MIMRXBRDATA_IN[16], MIMRXBRDATA[16]);
buf B_MIMRXBRDATA17 (MIMRXBRDATA_IN[17], MIMRXBRDATA[17]);
buf B_MIMRXBRDATA18 (MIMRXBRDATA_IN[18], MIMRXBRDATA[18]);
buf B_MIMRXBRDATA19 (MIMRXBRDATA_IN[19], MIMRXBRDATA[19]);
buf B_MIMRXBRDATA20 (MIMRXBRDATA_IN[20], MIMRXBRDATA[20]);
buf B_MIMRXBRDATA21 (MIMRXBRDATA_IN[21], MIMRXBRDATA[21]);
buf B_MIMRXBRDATA22 (MIMRXBRDATA_IN[22], MIMRXBRDATA[22]);
buf B_MIMRXBRDATA23 (MIMRXBRDATA_IN[23], MIMRXBRDATA[23]);
buf B_MIMRXBRDATA24 (MIMRXBRDATA_IN[24], MIMRXBRDATA[24]);
buf B_MIMRXBRDATA25 (MIMRXBRDATA_IN[25], MIMRXBRDATA[25]);
buf B_MIMRXBRDATA26 (MIMRXBRDATA_IN[26], MIMRXBRDATA[26]);
buf B_MIMRXBRDATA27 (MIMRXBRDATA_IN[27], MIMRXBRDATA[27]);
buf B_MIMRXBRDATA28 (MIMRXBRDATA_IN[28], MIMRXBRDATA[28]);
buf B_MIMRXBRDATA29 (MIMRXBRDATA_IN[29], MIMRXBRDATA[29]);
buf B_MIMRXBRDATA30 (MIMRXBRDATA_IN[30], MIMRXBRDATA[30]);
buf B_MIMRXBRDATA31 (MIMRXBRDATA_IN[31], MIMRXBRDATA[31]);
buf B_MIMRXBRDATA32 (MIMRXBRDATA_IN[32], MIMRXBRDATA[32]);
buf B_MIMRXBRDATA33 (MIMRXBRDATA_IN[33], MIMRXBRDATA[33]);
buf B_MIMRXBRDATA34 (MIMRXBRDATA_IN[34], MIMRXBRDATA[34]);
buf B_MIMRXBRDATA35 (MIMRXBRDATA_IN[35], MIMRXBRDATA[35]);
buf B_MIMRXBRDATA36 (MIMRXBRDATA_IN[36], MIMRXBRDATA[36]);
buf B_MIMRXBRDATA37 (MIMRXBRDATA_IN[37], MIMRXBRDATA[37]);
buf B_MIMRXBRDATA38 (MIMRXBRDATA_IN[38], MIMRXBRDATA[38]);
buf B_MIMRXBRDATA39 (MIMRXBRDATA_IN[39], MIMRXBRDATA[39]);
buf B_MIMRXBRDATA40 (MIMRXBRDATA_IN[40], MIMRXBRDATA[40]);
buf B_MIMRXBRDATA41 (MIMRXBRDATA_IN[41], MIMRXBRDATA[41]);
buf B_MIMRXBRDATA42 (MIMRXBRDATA_IN[42], MIMRXBRDATA[42]);
buf B_MIMRXBRDATA43 (MIMRXBRDATA_IN[43], MIMRXBRDATA[43]);
buf B_MIMRXBRDATA44 (MIMRXBRDATA_IN[44], MIMRXBRDATA[44]);
buf B_MIMRXBRDATA45 (MIMRXBRDATA_IN[45], MIMRXBRDATA[45]);
buf B_MIMRXBRDATA46 (MIMRXBRDATA_IN[46], MIMRXBRDATA[46]);
buf B_MIMRXBRDATA47 (MIMRXBRDATA_IN[47], MIMRXBRDATA[47]);
buf B_MIMRXBRDATA48 (MIMRXBRDATA_IN[48], MIMRXBRDATA[48]);
buf B_MIMRXBRDATA49 (MIMRXBRDATA_IN[49], MIMRXBRDATA[49]);
buf B_MIMRXBRDATA50 (MIMRXBRDATA_IN[50], MIMRXBRDATA[50]);
buf B_MIMRXBRDATA51 (MIMRXBRDATA_IN[51], MIMRXBRDATA[51]);
buf B_MIMRXBRDATA52 (MIMRXBRDATA_IN[52], MIMRXBRDATA[52]);
buf B_MIMRXBRDATA53 (MIMRXBRDATA_IN[53], MIMRXBRDATA[53]);
buf B_MIMRXBRDATA54 (MIMRXBRDATA_IN[54], MIMRXBRDATA[54]);
buf B_MIMRXBRDATA55 (MIMRXBRDATA_IN[55], MIMRXBRDATA[55]);
buf B_MIMRXBRDATA56 (MIMRXBRDATA_IN[56], MIMRXBRDATA[56]);
buf B_MIMRXBRDATA57 (MIMRXBRDATA_IN[57], MIMRXBRDATA[57]);
buf B_MIMRXBRDATA58 (MIMRXBRDATA_IN[58], MIMRXBRDATA[58]);
buf B_MIMRXBRDATA59 (MIMRXBRDATA_IN[59], MIMRXBRDATA[59]);
buf B_MIMRXBRDATA60 (MIMRXBRDATA_IN[60], MIMRXBRDATA[60]);
buf B_MIMRXBRDATA61 (MIMRXBRDATA_IN[61], MIMRXBRDATA[61]);
buf B_MIMRXBRDATA62 (MIMRXBRDATA_IN[62], MIMRXBRDATA[62]);
buf B_MIMRXBRDATA63 (MIMRXBRDATA_IN[63], MIMRXBRDATA[63]);
buf B_CRMCORECLKRXO (CRMCORECLKRXO_IN, CRMCORECLKRXO);
buf B_CRMUSERCLKRXO (CRMUSERCLKRXO_IN, CRMUSERCLKRXO);
buf B_MIMTXBRDATA0 (MIMTXBRDATA_IN[0], MIMTXBRDATA[0]);
buf B_MIMTXBRDATA1 (MIMTXBRDATA_IN[1], MIMTXBRDATA[1]);
buf B_MIMTXBRDATA2 (MIMTXBRDATA_IN[2], MIMTXBRDATA[2]);
buf B_MIMTXBRDATA3 (MIMTXBRDATA_IN[3], MIMTXBRDATA[3]);
buf B_MIMTXBRDATA4 (MIMTXBRDATA_IN[4], MIMTXBRDATA[4]);
buf B_MIMTXBRDATA5 (MIMTXBRDATA_IN[5], MIMTXBRDATA[5]);
buf B_MIMTXBRDATA6 (MIMTXBRDATA_IN[6], MIMTXBRDATA[6]);
buf B_MIMTXBRDATA7 (MIMTXBRDATA_IN[7], MIMTXBRDATA[7]);
buf B_MIMTXBRDATA8 (MIMTXBRDATA_IN[8], MIMTXBRDATA[8]);
buf B_MIMTXBRDATA9 (MIMTXBRDATA_IN[9], MIMTXBRDATA[9]);
buf B_MIMTXBRDATA10 (MIMTXBRDATA_IN[10], MIMTXBRDATA[10]);
buf B_MIMTXBRDATA11 (MIMTXBRDATA_IN[11], MIMTXBRDATA[11]);
buf B_MIMTXBRDATA12 (MIMTXBRDATA_IN[12], MIMTXBRDATA[12]);
buf B_MIMTXBRDATA13 (MIMTXBRDATA_IN[13], MIMTXBRDATA[13]);
buf B_MIMTXBRDATA14 (MIMTXBRDATA_IN[14], MIMTXBRDATA[14]);
buf B_MIMTXBRDATA15 (MIMTXBRDATA_IN[15], MIMTXBRDATA[15]);
buf B_MIMTXBRDATA16 (MIMTXBRDATA_IN[16], MIMTXBRDATA[16]);
buf B_MIMTXBRDATA17 (MIMTXBRDATA_IN[17], MIMTXBRDATA[17]);
buf B_MIMTXBRDATA18 (MIMTXBRDATA_IN[18], MIMTXBRDATA[18]);
buf B_MIMTXBRDATA19 (MIMTXBRDATA_IN[19], MIMTXBRDATA[19]);
buf B_MIMTXBRDATA20 (MIMTXBRDATA_IN[20], MIMTXBRDATA[20]);
buf B_MIMTXBRDATA21 (MIMTXBRDATA_IN[21], MIMTXBRDATA[21]);
buf B_MIMTXBRDATA22 (MIMTXBRDATA_IN[22], MIMTXBRDATA[22]);
buf B_MIMTXBRDATA23 (MIMTXBRDATA_IN[23], MIMTXBRDATA[23]);
buf B_MIMTXBRDATA24 (MIMTXBRDATA_IN[24], MIMTXBRDATA[24]);
buf B_MIMTXBRDATA25 (MIMTXBRDATA_IN[25], MIMTXBRDATA[25]);
buf B_MIMTXBRDATA26 (MIMTXBRDATA_IN[26], MIMTXBRDATA[26]);
buf B_MIMTXBRDATA27 (MIMTXBRDATA_IN[27], MIMTXBRDATA[27]);
buf B_MIMTXBRDATA28 (MIMTXBRDATA_IN[28], MIMTXBRDATA[28]);
buf B_MIMTXBRDATA29 (MIMTXBRDATA_IN[29], MIMTXBRDATA[29]);
buf B_MIMTXBRDATA30 (MIMTXBRDATA_IN[30], MIMTXBRDATA[30]);
buf B_MIMTXBRDATA31 (MIMTXBRDATA_IN[31], MIMTXBRDATA[31]);
buf B_MIMTXBRDATA32 (MIMTXBRDATA_IN[32], MIMTXBRDATA[32]);
buf B_MIMTXBRDATA33 (MIMTXBRDATA_IN[33], MIMTXBRDATA[33]);
buf B_MIMTXBRDATA34 (MIMTXBRDATA_IN[34], MIMTXBRDATA[34]);
buf B_MIMTXBRDATA35 (MIMTXBRDATA_IN[35], MIMTXBRDATA[35]);
buf B_MIMTXBRDATA36 (MIMTXBRDATA_IN[36], MIMTXBRDATA[36]);
buf B_MIMTXBRDATA37 (MIMTXBRDATA_IN[37], MIMTXBRDATA[37]);
buf B_MIMTXBRDATA38 (MIMTXBRDATA_IN[38], MIMTXBRDATA[38]);
buf B_MIMTXBRDATA39 (MIMTXBRDATA_IN[39], MIMTXBRDATA[39]);
buf B_MIMTXBRDATA40 (MIMTXBRDATA_IN[40], MIMTXBRDATA[40]);
buf B_MIMTXBRDATA41 (MIMTXBRDATA_IN[41], MIMTXBRDATA[41]);
buf B_MIMTXBRDATA42 (MIMTXBRDATA_IN[42], MIMTXBRDATA[42]);
buf B_MIMTXBRDATA43 (MIMTXBRDATA_IN[43], MIMTXBRDATA[43]);
buf B_MIMTXBRDATA44 (MIMTXBRDATA_IN[44], MIMTXBRDATA[44]);
buf B_MIMTXBRDATA45 (MIMTXBRDATA_IN[45], MIMTXBRDATA[45]);
buf B_MIMTXBRDATA46 (MIMTXBRDATA_IN[46], MIMTXBRDATA[46]);
buf B_MIMTXBRDATA47 (MIMTXBRDATA_IN[47], MIMTXBRDATA[47]);
buf B_MIMTXBRDATA48 (MIMTXBRDATA_IN[48], MIMTXBRDATA[48]);
buf B_MIMTXBRDATA49 (MIMTXBRDATA_IN[49], MIMTXBRDATA[49]);
buf B_MIMTXBRDATA50 (MIMTXBRDATA_IN[50], MIMTXBRDATA[50]);
buf B_MIMTXBRDATA51 (MIMTXBRDATA_IN[51], MIMTXBRDATA[51]);
buf B_MIMTXBRDATA52 (MIMTXBRDATA_IN[52], MIMTXBRDATA[52]);
buf B_MIMTXBRDATA53 (MIMTXBRDATA_IN[53], MIMTXBRDATA[53]);
buf B_MIMTXBRDATA54 (MIMTXBRDATA_IN[54], MIMTXBRDATA[54]);
buf B_MIMTXBRDATA55 (MIMTXBRDATA_IN[55], MIMTXBRDATA[55]);
buf B_MIMTXBRDATA56 (MIMTXBRDATA_IN[56], MIMTXBRDATA[56]);
buf B_MIMTXBRDATA57 (MIMTXBRDATA_IN[57], MIMTXBRDATA[57]);
buf B_MIMTXBRDATA58 (MIMTXBRDATA_IN[58], MIMTXBRDATA[58]);
buf B_MIMTXBRDATA59 (MIMTXBRDATA_IN[59], MIMTXBRDATA[59]);
buf B_MIMTXBRDATA60 (MIMTXBRDATA_IN[60], MIMTXBRDATA[60]);
buf B_MIMTXBRDATA61 (MIMTXBRDATA_IN[61], MIMTXBRDATA[61]);
buf B_MIMTXBRDATA62 (MIMTXBRDATA_IN[62], MIMTXBRDATA[62]);
buf B_MIMTXBRDATA63 (MIMTXBRDATA_IN[63], MIMTXBRDATA[63]);
buf B_CRMCORECLKTXO (CRMCORECLKTXO_IN, CRMCORECLKTXO);
buf B_CRMUSERCLKTXO (CRMUSERCLKTXO_IN, CRMUSERCLKTXO);
buf B_MIMDLLBRDATA0 (MIMDLLBRDATA_IN[0], MIMDLLBRDATA[0]);
buf B_MIMDLLBRDATA1 (MIMDLLBRDATA_IN[1], MIMDLLBRDATA[1]);
buf B_MIMDLLBRDATA2 (MIMDLLBRDATA_IN[2], MIMDLLBRDATA[2]);
buf B_MIMDLLBRDATA3 (MIMDLLBRDATA_IN[3], MIMDLLBRDATA[3]);
buf B_MIMDLLBRDATA4 (MIMDLLBRDATA_IN[4], MIMDLLBRDATA[4]);
buf B_MIMDLLBRDATA5 (MIMDLLBRDATA_IN[5], MIMDLLBRDATA[5]);
buf B_MIMDLLBRDATA6 (MIMDLLBRDATA_IN[6], MIMDLLBRDATA[6]);
buf B_MIMDLLBRDATA7 (MIMDLLBRDATA_IN[7], MIMDLLBRDATA[7]);
buf B_MIMDLLBRDATA8 (MIMDLLBRDATA_IN[8], MIMDLLBRDATA[8]);
buf B_MIMDLLBRDATA9 (MIMDLLBRDATA_IN[9], MIMDLLBRDATA[9]);
buf B_MIMDLLBRDATA10 (MIMDLLBRDATA_IN[10], MIMDLLBRDATA[10]);
buf B_MIMDLLBRDATA11 (MIMDLLBRDATA_IN[11], MIMDLLBRDATA[11]);
buf B_MIMDLLBRDATA12 (MIMDLLBRDATA_IN[12], MIMDLLBRDATA[12]);
buf B_MIMDLLBRDATA13 (MIMDLLBRDATA_IN[13], MIMDLLBRDATA[13]);
buf B_MIMDLLBRDATA14 (MIMDLLBRDATA_IN[14], MIMDLLBRDATA[14]);
buf B_MIMDLLBRDATA15 (MIMDLLBRDATA_IN[15], MIMDLLBRDATA[15]);
buf B_MIMDLLBRDATA16 (MIMDLLBRDATA_IN[16], MIMDLLBRDATA[16]);
buf B_MIMDLLBRDATA17 (MIMDLLBRDATA_IN[17], MIMDLLBRDATA[17]);
buf B_MIMDLLBRDATA18 (MIMDLLBRDATA_IN[18], MIMDLLBRDATA[18]);
buf B_MIMDLLBRDATA19 (MIMDLLBRDATA_IN[19], MIMDLLBRDATA[19]);
buf B_MIMDLLBRDATA20 (MIMDLLBRDATA_IN[20], MIMDLLBRDATA[20]);
buf B_MIMDLLBRDATA21 (MIMDLLBRDATA_IN[21], MIMDLLBRDATA[21]);
buf B_MIMDLLBRDATA22 (MIMDLLBRDATA_IN[22], MIMDLLBRDATA[22]);
buf B_MIMDLLBRDATA23 (MIMDLLBRDATA_IN[23], MIMDLLBRDATA[23]);
buf B_MIMDLLBRDATA24 (MIMDLLBRDATA_IN[24], MIMDLLBRDATA[24]);
buf B_MIMDLLBRDATA25 (MIMDLLBRDATA_IN[25], MIMDLLBRDATA[25]);
buf B_MIMDLLBRDATA26 (MIMDLLBRDATA_IN[26], MIMDLLBRDATA[26]);
buf B_MIMDLLBRDATA27 (MIMDLLBRDATA_IN[27], MIMDLLBRDATA[27]);
buf B_MIMDLLBRDATA28 (MIMDLLBRDATA_IN[28], MIMDLLBRDATA[28]);
buf B_MIMDLLBRDATA29 (MIMDLLBRDATA_IN[29], MIMDLLBRDATA[29]);
buf B_MIMDLLBRDATA30 (MIMDLLBRDATA_IN[30], MIMDLLBRDATA[30]);
buf B_MIMDLLBRDATA31 (MIMDLLBRDATA_IN[31], MIMDLLBRDATA[31]);
buf B_MIMDLLBRDATA32 (MIMDLLBRDATA_IN[32], MIMDLLBRDATA[32]);
buf B_MIMDLLBRDATA33 (MIMDLLBRDATA_IN[33], MIMDLLBRDATA[33]);
buf B_MIMDLLBRDATA34 (MIMDLLBRDATA_IN[34], MIMDLLBRDATA[34]);
buf B_MIMDLLBRDATA35 (MIMDLLBRDATA_IN[35], MIMDLLBRDATA[35]);
buf B_MIMDLLBRDATA36 (MIMDLLBRDATA_IN[36], MIMDLLBRDATA[36]);
buf B_MIMDLLBRDATA37 (MIMDLLBRDATA_IN[37], MIMDLLBRDATA[37]);
buf B_MIMDLLBRDATA38 (MIMDLLBRDATA_IN[38], MIMDLLBRDATA[38]);
buf B_MIMDLLBRDATA39 (MIMDLLBRDATA_IN[39], MIMDLLBRDATA[39]);
buf B_MIMDLLBRDATA40 (MIMDLLBRDATA_IN[40], MIMDLLBRDATA[40]);
buf B_MIMDLLBRDATA41 (MIMDLLBRDATA_IN[41], MIMDLLBRDATA[41]);
buf B_MIMDLLBRDATA42 (MIMDLLBRDATA_IN[42], MIMDLLBRDATA[42]);
buf B_MIMDLLBRDATA43 (MIMDLLBRDATA_IN[43], MIMDLLBRDATA[43]);
buf B_MIMDLLBRDATA44 (MIMDLLBRDATA_IN[44], MIMDLLBRDATA[44]);
buf B_MIMDLLBRDATA45 (MIMDLLBRDATA_IN[45], MIMDLLBRDATA[45]);
buf B_MIMDLLBRDATA46 (MIMDLLBRDATA_IN[46], MIMDLLBRDATA[46]);
buf B_MIMDLLBRDATA47 (MIMDLLBRDATA_IN[47], MIMDLLBRDATA[47]);
buf B_MIMDLLBRDATA48 (MIMDLLBRDATA_IN[48], MIMDLLBRDATA[48]);
buf B_MIMDLLBRDATA49 (MIMDLLBRDATA_IN[49], MIMDLLBRDATA[49]);
buf B_MIMDLLBRDATA50 (MIMDLLBRDATA_IN[50], MIMDLLBRDATA[50]);
buf B_MIMDLLBRDATA51 (MIMDLLBRDATA_IN[51], MIMDLLBRDATA[51]);
buf B_MIMDLLBRDATA52 (MIMDLLBRDATA_IN[52], MIMDLLBRDATA[52]);
buf B_MIMDLLBRDATA53 (MIMDLLBRDATA_IN[53], MIMDLLBRDATA[53]);
buf B_MIMDLLBRDATA54 (MIMDLLBRDATA_IN[54], MIMDLLBRDATA[54]);
buf B_MIMDLLBRDATA55 (MIMDLLBRDATA_IN[55], MIMDLLBRDATA[55]);
buf B_MIMDLLBRDATA56 (MIMDLLBRDATA_IN[56], MIMDLLBRDATA[56]);
buf B_MIMDLLBRDATA57 (MIMDLLBRDATA_IN[57], MIMDLLBRDATA[57]);
buf B_MIMDLLBRDATA58 (MIMDLLBRDATA_IN[58], MIMDLLBRDATA[58]);
buf B_MIMDLLBRDATA59 (MIMDLLBRDATA_IN[59], MIMDLLBRDATA[59]);
buf B_MIMDLLBRDATA60 (MIMDLLBRDATA_IN[60], MIMDLLBRDATA[60]);
buf B_MIMDLLBRDATA61 (MIMDLLBRDATA_IN[61], MIMDLLBRDATA[61]);
buf B_MIMDLLBRDATA62 (MIMDLLBRDATA_IN[62], MIMDLLBRDATA[62]);
buf B_MIMDLLBRDATA63 (MIMDLLBRDATA_IN[63], MIMDLLBRDATA[63]);
buf B_CRMCORECLKDLO (CRMCORECLKDLO_IN, CRMCORECLKDLO);
buf B_CRMCORECLK (CRMCORECLK_IN, CRMCORECLK);
buf B_CRMUSERCLK (CRMUSERCLK_IN, CRMUSERCLK);
buf B_CRMURSTN (CRMURSTN_IN, CRMURSTN);
buf B_CRMNVRSTN (CRMNVRSTN_IN, CRMNVRSTN);
buf B_CRMMGMTRSTN (CRMMGMTRSTN_IN, CRMMGMTRSTN);
buf B_CRMUSERCFGRSTN (CRMUSERCFGRSTN_IN, CRMUSERCFGRSTN);
buf B_CRMMACRSTN (CRMMACRSTN_IN, CRMMACRSTN);
buf B_CRMLINKRSTN (CRMLINKRSTN_IN, CRMLINKRSTN);
buf B_CRMTXHOTRESETN (CRMTXHOTRESETN_IN, CRMTXHOTRESETN);
buf B_CRMCFGBRIDGEHOTRESET (CRMCFGBRIDGEHOTRESET_IN, CRMCFGBRIDGEHOTRESET);
buf B_LLKTXDATA0 (LLKTXDATA_IN[0], LLKTXDATA[0]);
buf B_LLKTXDATA1 (LLKTXDATA_IN[1], LLKTXDATA[1]);
buf B_LLKTXDATA2 (LLKTXDATA_IN[2], LLKTXDATA[2]);
buf B_LLKTXDATA3 (LLKTXDATA_IN[3], LLKTXDATA[3]);
buf B_LLKTXDATA4 (LLKTXDATA_IN[4], LLKTXDATA[4]);
buf B_LLKTXDATA5 (LLKTXDATA_IN[5], LLKTXDATA[5]);
buf B_LLKTXDATA6 (LLKTXDATA_IN[6], LLKTXDATA[6]);
buf B_LLKTXDATA7 (LLKTXDATA_IN[7], LLKTXDATA[7]);
buf B_LLKTXDATA8 (LLKTXDATA_IN[8], LLKTXDATA[8]);
buf B_LLKTXDATA9 (LLKTXDATA_IN[9], LLKTXDATA[9]);
buf B_LLKTXDATA10 (LLKTXDATA_IN[10], LLKTXDATA[10]);
buf B_LLKTXDATA11 (LLKTXDATA_IN[11], LLKTXDATA[11]);
buf B_LLKTXDATA12 (LLKTXDATA_IN[12], LLKTXDATA[12]);
buf B_LLKTXDATA13 (LLKTXDATA_IN[13], LLKTXDATA[13]);
buf B_LLKTXDATA14 (LLKTXDATA_IN[14], LLKTXDATA[14]);
buf B_LLKTXDATA15 (LLKTXDATA_IN[15], LLKTXDATA[15]);
buf B_LLKTXDATA16 (LLKTXDATA_IN[16], LLKTXDATA[16]);
buf B_LLKTXDATA17 (LLKTXDATA_IN[17], LLKTXDATA[17]);
buf B_LLKTXDATA18 (LLKTXDATA_IN[18], LLKTXDATA[18]);
buf B_LLKTXDATA19 (LLKTXDATA_IN[19], LLKTXDATA[19]);
buf B_LLKTXDATA20 (LLKTXDATA_IN[20], LLKTXDATA[20]);
buf B_LLKTXDATA21 (LLKTXDATA_IN[21], LLKTXDATA[21]);
buf B_LLKTXDATA22 (LLKTXDATA_IN[22], LLKTXDATA[22]);
buf B_LLKTXDATA23 (LLKTXDATA_IN[23], LLKTXDATA[23]);
buf B_LLKTXDATA24 (LLKTXDATA_IN[24], LLKTXDATA[24]);
buf B_LLKTXDATA25 (LLKTXDATA_IN[25], LLKTXDATA[25]);
buf B_LLKTXDATA26 (LLKTXDATA_IN[26], LLKTXDATA[26]);
buf B_LLKTXDATA27 (LLKTXDATA_IN[27], LLKTXDATA[27]);
buf B_LLKTXDATA28 (LLKTXDATA_IN[28], LLKTXDATA[28]);
buf B_LLKTXDATA29 (LLKTXDATA_IN[29], LLKTXDATA[29]);
buf B_LLKTXDATA30 (LLKTXDATA_IN[30], LLKTXDATA[30]);
buf B_LLKTXDATA31 (LLKTXDATA_IN[31], LLKTXDATA[31]);
buf B_LLKTXDATA32 (LLKTXDATA_IN[32], LLKTXDATA[32]);
buf B_LLKTXDATA33 (LLKTXDATA_IN[33], LLKTXDATA[33]);
buf B_LLKTXDATA34 (LLKTXDATA_IN[34], LLKTXDATA[34]);
buf B_LLKTXDATA35 (LLKTXDATA_IN[35], LLKTXDATA[35]);
buf B_LLKTXDATA36 (LLKTXDATA_IN[36], LLKTXDATA[36]);
buf B_LLKTXDATA37 (LLKTXDATA_IN[37], LLKTXDATA[37]);
buf B_LLKTXDATA38 (LLKTXDATA_IN[38], LLKTXDATA[38]);
buf B_LLKTXDATA39 (LLKTXDATA_IN[39], LLKTXDATA[39]);
buf B_LLKTXDATA40 (LLKTXDATA_IN[40], LLKTXDATA[40]);
buf B_LLKTXDATA41 (LLKTXDATA_IN[41], LLKTXDATA[41]);
buf B_LLKTXDATA42 (LLKTXDATA_IN[42], LLKTXDATA[42]);
buf B_LLKTXDATA43 (LLKTXDATA_IN[43], LLKTXDATA[43]);
buf B_LLKTXDATA44 (LLKTXDATA_IN[44], LLKTXDATA[44]);
buf B_LLKTXDATA45 (LLKTXDATA_IN[45], LLKTXDATA[45]);
buf B_LLKTXDATA46 (LLKTXDATA_IN[46], LLKTXDATA[46]);
buf B_LLKTXDATA47 (LLKTXDATA_IN[47], LLKTXDATA[47]);
buf B_LLKTXDATA48 (LLKTXDATA_IN[48], LLKTXDATA[48]);
buf B_LLKTXDATA49 (LLKTXDATA_IN[49], LLKTXDATA[49]);
buf B_LLKTXDATA50 (LLKTXDATA_IN[50], LLKTXDATA[50]);
buf B_LLKTXDATA51 (LLKTXDATA_IN[51], LLKTXDATA[51]);
buf B_LLKTXDATA52 (LLKTXDATA_IN[52], LLKTXDATA[52]);
buf B_LLKTXDATA53 (LLKTXDATA_IN[53], LLKTXDATA[53]);
buf B_LLKTXDATA54 (LLKTXDATA_IN[54], LLKTXDATA[54]);
buf B_LLKTXDATA55 (LLKTXDATA_IN[55], LLKTXDATA[55]);
buf B_LLKTXDATA56 (LLKTXDATA_IN[56], LLKTXDATA[56]);
buf B_LLKTXDATA57 (LLKTXDATA_IN[57], LLKTXDATA[57]);
buf B_LLKTXDATA58 (LLKTXDATA_IN[58], LLKTXDATA[58]);
buf B_LLKTXDATA59 (LLKTXDATA_IN[59], LLKTXDATA[59]);
buf B_LLKTXDATA60 (LLKTXDATA_IN[60], LLKTXDATA[60]);
buf B_LLKTXDATA61 (LLKTXDATA_IN[61], LLKTXDATA[61]);
buf B_LLKTXDATA62 (LLKTXDATA_IN[62], LLKTXDATA[62]);
buf B_LLKTXDATA63 (LLKTXDATA_IN[63], LLKTXDATA[63]);
buf B_LLKTXSRCRDYN (LLKTXSRCRDYN_IN, LLKTXSRCRDYN);
buf B_LLKTXSRCDSCN (LLKTXSRCDSCN_IN, LLKTXSRCDSCN);
buf B_LLKTXCOMPLETEN (LLKTXCOMPLETEN_IN, LLKTXCOMPLETEN);
buf B_LLKTXSOFN (LLKTXSOFN_IN, LLKTXSOFN);
buf B_LLKTXEOFN (LLKTXEOFN_IN, LLKTXEOFN);
buf B_LLKTXSOPN (LLKTXSOPN_IN, LLKTXSOPN);
buf B_LLKTXEOPN (LLKTXEOPN_IN, LLKTXEOPN);
buf B_LLKTXENABLEN0 (LLKTXENABLEN_IN[0], LLKTXENABLEN[0]);
buf B_LLKTXENABLEN1 (LLKTXENABLEN_IN[1], LLKTXENABLEN[1]);
buf B_LLKTXCHTC0 (LLKTXCHTC_IN[0], LLKTXCHTC[0]);
buf B_LLKTXCHTC1 (LLKTXCHTC_IN[1], LLKTXCHTC[1]);
buf B_LLKTXCHTC2 (LLKTXCHTC_IN[2], LLKTXCHTC[2]);
buf B_LLKTXCHFIFO0 (LLKTXCHFIFO_IN[0], LLKTXCHFIFO[0]);
buf B_LLKTXCHFIFO1 (LLKTXCHFIFO_IN[1], LLKTXCHFIFO[1]);
buf B_LLKTXCREATEECRCN (LLKTXCREATEECRCN_IN, LLKTXCREATEECRCN);
buf B_LLKTX4DWHEADERN (LLKTX4DWHEADERN_IN, LLKTX4DWHEADERN);
buf B_LLKRXDSTREQN (LLKRXDSTREQN_IN, LLKRXDSTREQN);
buf B_LLKRXCHTC0 (LLKRXCHTC_IN[0], LLKRXCHTC[0]);
buf B_LLKRXCHTC1 (LLKRXCHTC_IN[1], LLKRXCHTC[1]);
buf B_LLKRXCHTC2 (LLKRXCHTC_IN[2], LLKRXCHTC[2]);
buf B_LLKRXCHFIFO0 (LLKRXCHFIFO_IN[0], LLKRXCHFIFO[0]);
buf B_LLKRXCHFIFO1 (LLKRXCHFIFO_IN[1], LLKRXCHFIFO[1]);
buf B_LLKRXDSTCONTREQN (LLKRXDSTCONTREQN_IN, LLKRXDSTCONTREQN);
buf B_MGMTWDATA0 (MGMTWDATA_IN[0], MGMTWDATA[0]);
buf B_MGMTWDATA1 (MGMTWDATA_IN[1], MGMTWDATA[1]);
buf B_MGMTWDATA2 (MGMTWDATA_IN[2], MGMTWDATA[2]);
buf B_MGMTWDATA3 (MGMTWDATA_IN[3], MGMTWDATA[3]);
buf B_MGMTWDATA4 (MGMTWDATA_IN[4], MGMTWDATA[4]);
buf B_MGMTWDATA5 (MGMTWDATA_IN[5], MGMTWDATA[5]);
buf B_MGMTWDATA6 (MGMTWDATA_IN[6], MGMTWDATA[6]);
buf B_MGMTWDATA7 (MGMTWDATA_IN[7], MGMTWDATA[7]);
buf B_MGMTWDATA8 (MGMTWDATA_IN[8], MGMTWDATA[8]);
buf B_MGMTWDATA9 (MGMTWDATA_IN[9], MGMTWDATA[9]);
buf B_MGMTWDATA10 (MGMTWDATA_IN[10], MGMTWDATA[10]);
buf B_MGMTWDATA11 (MGMTWDATA_IN[11], MGMTWDATA[11]);
buf B_MGMTWDATA12 (MGMTWDATA_IN[12], MGMTWDATA[12]);
buf B_MGMTWDATA13 (MGMTWDATA_IN[13], MGMTWDATA[13]);
buf B_MGMTWDATA14 (MGMTWDATA_IN[14], MGMTWDATA[14]);
buf B_MGMTWDATA15 (MGMTWDATA_IN[15], MGMTWDATA[15]);
buf B_MGMTWDATA16 (MGMTWDATA_IN[16], MGMTWDATA[16]);
buf B_MGMTWDATA17 (MGMTWDATA_IN[17], MGMTWDATA[17]);
buf B_MGMTWDATA18 (MGMTWDATA_IN[18], MGMTWDATA[18]);
buf B_MGMTWDATA19 (MGMTWDATA_IN[19], MGMTWDATA[19]);
buf B_MGMTWDATA20 (MGMTWDATA_IN[20], MGMTWDATA[20]);
buf B_MGMTWDATA21 (MGMTWDATA_IN[21], MGMTWDATA[21]);
buf B_MGMTWDATA22 (MGMTWDATA_IN[22], MGMTWDATA[22]);
buf B_MGMTWDATA23 (MGMTWDATA_IN[23], MGMTWDATA[23]);
buf B_MGMTWDATA24 (MGMTWDATA_IN[24], MGMTWDATA[24]);
buf B_MGMTWDATA25 (MGMTWDATA_IN[25], MGMTWDATA[25]);
buf B_MGMTWDATA26 (MGMTWDATA_IN[26], MGMTWDATA[26]);
buf B_MGMTWDATA27 (MGMTWDATA_IN[27], MGMTWDATA[27]);
buf B_MGMTWDATA28 (MGMTWDATA_IN[28], MGMTWDATA[28]);
buf B_MGMTWDATA29 (MGMTWDATA_IN[29], MGMTWDATA[29]);
buf B_MGMTWDATA30 (MGMTWDATA_IN[30], MGMTWDATA[30]);
buf B_MGMTWDATA31 (MGMTWDATA_IN[31], MGMTWDATA[31]);
buf B_MGMTBWREN0 (MGMTBWREN_IN[0], MGMTBWREN[0]);
buf B_MGMTBWREN1 (MGMTBWREN_IN[1], MGMTBWREN[1]);
buf B_MGMTBWREN2 (MGMTBWREN_IN[2], MGMTBWREN[2]);
buf B_MGMTBWREN3 (MGMTBWREN_IN[3], MGMTBWREN[3]);
buf B_MGMTWREN (MGMTWREN_IN, MGMTWREN);
buf B_MGMTADDR0 (MGMTADDR_IN[0], MGMTADDR[0]);
buf B_MGMTADDR1 (MGMTADDR_IN[1], MGMTADDR[1]);
buf B_MGMTADDR2 (MGMTADDR_IN[2], MGMTADDR[2]);
buf B_MGMTADDR3 (MGMTADDR_IN[3], MGMTADDR[3]);
buf B_MGMTADDR4 (MGMTADDR_IN[4], MGMTADDR[4]);
buf B_MGMTADDR5 (MGMTADDR_IN[5], MGMTADDR[5]);
buf B_MGMTADDR6 (MGMTADDR_IN[6], MGMTADDR[6]);
buf B_MGMTADDR7 (MGMTADDR_IN[7], MGMTADDR[7]);
buf B_MGMTADDR8 (MGMTADDR_IN[8], MGMTADDR[8]);
buf B_MGMTADDR9 (MGMTADDR_IN[9], MGMTADDR[9]);
buf B_MGMTADDR10 (MGMTADDR_IN[10], MGMTADDR[10]);
buf B_MGMTRDEN (MGMTRDEN_IN, MGMTRDEN);
buf B_MGMTSTATSCREDITSEL0 (MGMTSTATSCREDITSEL_IN[0], MGMTSTATSCREDITSEL[0]);
buf B_MGMTSTATSCREDITSEL1 (MGMTSTATSCREDITSEL_IN[1], MGMTSTATSCREDITSEL[1]);
buf B_MGMTSTATSCREDITSEL2 (MGMTSTATSCREDITSEL_IN[2], MGMTSTATSCREDITSEL[2]);
buf B_MGMTSTATSCREDITSEL3 (MGMTSTATSCREDITSEL_IN[3], MGMTSTATSCREDITSEL[3]);
buf B_MGMTSTATSCREDITSEL4 (MGMTSTATSCREDITSEL_IN[4], MGMTSTATSCREDITSEL[4]);
buf B_MGMTSTATSCREDITSEL5 (MGMTSTATSCREDITSEL_IN[5], MGMTSTATSCREDITSEL[5]);
buf B_MGMTSTATSCREDITSEL6 (MGMTSTATSCREDITSEL_IN[6], MGMTSTATSCREDITSEL[6]);
buf B_MAINPOWER (MAINPOWER_IN, MAINPOWER);
buf B_AUXPOWER (AUXPOWER_IN, AUXPOWER);
buf B_L0TLLINKRETRAIN (L0TLLINKRETRAIN_IN, L0TLLINKRETRAIN);
buf B_CFGNEGOTIATEDLINKWIDTH0 (CFGNEGOTIATEDLINKWIDTH_IN[0], CFGNEGOTIATEDLINKWIDTH[0]);
buf B_CFGNEGOTIATEDLINKWIDTH1 (CFGNEGOTIATEDLINKWIDTH_IN[1], CFGNEGOTIATEDLINKWIDTH[1]);
buf B_CFGNEGOTIATEDLINKWIDTH2 (CFGNEGOTIATEDLINKWIDTH_IN[2], CFGNEGOTIATEDLINKWIDTH[2]);
buf B_CFGNEGOTIATEDLINKWIDTH3 (CFGNEGOTIATEDLINKWIDTH_IN[3], CFGNEGOTIATEDLINKWIDTH[3]);
buf B_CFGNEGOTIATEDLINKWIDTH4 (CFGNEGOTIATEDLINKWIDTH_IN[4], CFGNEGOTIATEDLINKWIDTH[4]);
buf B_CFGNEGOTIATEDLINKWIDTH5 (CFGNEGOTIATEDLINKWIDTH_IN[5], CFGNEGOTIATEDLINKWIDTH[5]);
buf B_CROSSLINKSEED (CROSSLINKSEED_IN, CROSSLINKSEED);
buf B_COMPLIANCEAVOID (COMPLIANCEAVOID_IN, COMPLIANCEAVOID);
buf B_L0VC0PREVIEWEXPAND (L0VC0PREVIEWEXPAND_IN, L0VC0PREVIEWEXPAND);
buf B_L0CFGVCID0 (L0CFGVCID_IN[0], L0CFGVCID[0]);
buf B_L0CFGVCID1 (L0CFGVCID_IN[1], L0CFGVCID[1]);
buf B_L0CFGVCID2 (L0CFGVCID_IN[2], L0CFGVCID[2]);
buf B_L0CFGVCID3 (L0CFGVCID_IN[3], L0CFGVCID[3]);
buf B_L0CFGVCID4 (L0CFGVCID_IN[4], L0CFGVCID[4]);
buf B_L0CFGVCID5 (L0CFGVCID_IN[5], L0CFGVCID[5]);
buf B_L0CFGVCID6 (L0CFGVCID_IN[6], L0CFGVCID[6]);
buf B_L0CFGVCID7 (L0CFGVCID_IN[7], L0CFGVCID[7]);
buf B_L0CFGVCID8 (L0CFGVCID_IN[8], L0CFGVCID[8]);
buf B_L0CFGVCID9 (L0CFGVCID_IN[9], L0CFGVCID[9]);
buf B_L0CFGVCID10 (L0CFGVCID_IN[10], L0CFGVCID[10]);
buf B_L0CFGVCID11 (L0CFGVCID_IN[11], L0CFGVCID[11]);
buf B_L0CFGVCID12 (L0CFGVCID_IN[12], L0CFGVCID[12]);
buf B_L0CFGVCID13 (L0CFGVCID_IN[13], L0CFGVCID[13]);
buf B_L0CFGVCID14 (L0CFGVCID_IN[14], L0CFGVCID[14]);
buf B_L0CFGVCID15 (L0CFGVCID_IN[15], L0CFGVCID[15]);
buf B_L0CFGVCID16 (L0CFGVCID_IN[16], L0CFGVCID[16]);
buf B_L0CFGVCID17 (L0CFGVCID_IN[17], L0CFGVCID[17]);
buf B_L0CFGVCID18 (L0CFGVCID_IN[18], L0CFGVCID[18]);
buf B_L0CFGVCID19 (L0CFGVCID_IN[19], L0CFGVCID[19]);
buf B_L0CFGVCID20 (L0CFGVCID_IN[20], L0CFGVCID[20]);
buf B_L0CFGVCID21 (L0CFGVCID_IN[21], L0CFGVCID[21]);
buf B_L0CFGVCID22 (L0CFGVCID_IN[22], L0CFGVCID[22]);
buf B_L0CFGVCID23 (L0CFGVCID_IN[23], L0CFGVCID[23]);
buf B_L0CFGLOOPBACKMASTER (L0CFGLOOPBACKMASTER_IN, L0CFGLOOPBACKMASTER);
buf B_L0REPLAYTIMERADJUSTMENT0 (L0REPLAYTIMERADJUSTMENT_IN[0], L0REPLAYTIMERADJUSTMENT[0]);
buf B_L0REPLAYTIMERADJUSTMENT1 (L0REPLAYTIMERADJUSTMENT_IN[1], L0REPLAYTIMERADJUSTMENT[1]);
buf B_L0REPLAYTIMERADJUSTMENT2 (L0REPLAYTIMERADJUSTMENT_IN[2], L0REPLAYTIMERADJUSTMENT[2]);
buf B_L0REPLAYTIMERADJUSTMENT3 (L0REPLAYTIMERADJUSTMENT_IN[3], L0REPLAYTIMERADJUSTMENT[3]);
buf B_L0REPLAYTIMERADJUSTMENT4 (L0REPLAYTIMERADJUSTMENT_IN[4], L0REPLAYTIMERADJUSTMENT[4]);
buf B_L0REPLAYTIMERADJUSTMENT5 (L0REPLAYTIMERADJUSTMENT_IN[5], L0REPLAYTIMERADJUSTMENT[5]);
buf B_L0REPLAYTIMERADJUSTMENT6 (L0REPLAYTIMERADJUSTMENT_IN[6], L0REPLAYTIMERADJUSTMENT[6]);
buf B_L0REPLAYTIMERADJUSTMENT7 (L0REPLAYTIMERADJUSTMENT_IN[7], L0REPLAYTIMERADJUSTMENT[7]);
buf B_L0REPLAYTIMERADJUSTMENT8 (L0REPLAYTIMERADJUSTMENT_IN[8], L0REPLAYTIMERADJUSTMENT[8]);
buf B_L0REPLAYTIMERADJUSTMENT9 (L0REPLAYTIMERADJUSTMENT_IN[9], L0REPLAYTIMERADJUSTMENT[9]);
buf B_L0REPLAYTIMERADJUSTMENT10 (L0REPLAYTIMERADJUSTMENT_IN[10], L0REPLAYTIMERADJUSTMENT[10]);
buf B_L0REPLAYTIMERADJUSTMENT11 (L0REPLAYTIMERADJUSTMENT_IN[11], L0REPLAYTIMERADJUSTMENT[11]);
buf B_L0ACKNAKTIMERADJUSTMENT0 (L0ACKNAKTIMERADJUSTMENT_IN[0], L0ACKNAKTIMERADJUSTMENT[0]);
buf B_L0ACKNAKTIMERADJUSTMENT1 (L0ACKNAKTIMERADJUSTMENT_IN[1], L0ACKNAKTIMERADJUSTMENT[1]);
buf B_L0ACKNAKTIMERADJUSTMENT2 (L0ACKNAKTIMERADJUSTMENT_IN[2], L0ACKNAKTIMERADJUSTMENT[2]);
buf B_L0ACKNAKTIMERADJUSTMENT3 (L0ACKNAKTIMERADJUSTMENT_IN[3], L0ACKNAKTIMERADJUSTMENT[3]);
buf B_L0ACKNAKTIMERADJUSTMENT4 (L0ACKNAKTIMERADJUSTMENT_IN[4], L0ACKNAKTIMERADJUSTMENT[4]);
buf B_L0ACKNAKTIMERADJUSTMENT5 (L0ACKNAKTIMERADJUSTMENT_IN[5], L0ACKNAKTIMERADJUSTMENT[5]);
buf B_L0ACKNAKTIMERADJUSTMENT6 (L0ACKNAKTIMERADJUSTMENT_IN[6], L0ACKNAKTIMERADJUSTMENT[6]);
buf B_L0ACKNAKTIMERADJUSTMENT7 (L0ACKNAKTIMERADJUSTMENT_IN[7], L0ACKNAKTIMERADJUSTMENT[7]);
buf B_L0ACKNAKTIMERADJUSTMENT8 (L0ACKNAKTIMERADJUSTMENT_IN[8], L0ACKNAKTIMERADJUSTMENT[8]);
buf B_L0ACKNAKTIMERADJUSTMENT9 (L0ACKNAKTIMERADJUSTMENT_IN[9], L0ACKNAKTIMERADJUSTMENT[9]);
buf B_L0ACKNAKTIMERADJUSTMENT10 (L0ACKNAKTIMERADJUSTMENT_IN[10], L0ACKNAKTIMERADJUSTMENT[10]);
buf B_L0ACKNAKTIMERADJUSTMENT11 (L0ACKNAKTIMERADJUSTMENT_IN[11], L0ACKNAKTIMERADJUSTMENT[11]);
buf B_L0DLLHOLDLINKUP (L0DLLHOLDLINKUP_IN, L0DLLHOLDLINKUP);
buf B_L0CFGASSTATECHANGECMD0 (L0CFGASSTATECHANGECMD_IN[0], L0CFGASSTATECHANGECMD[0]);
buf B_L0CFGASSTATECHANGECMD1 (L0CFGASSTATECHANGECMD_IN[1], L0CFGASSTATECHANGECMD[1]);
buf B_L0CFGASSTATECHANGECMD2 (L0CFGASSTATECHANGECMD_IN[2], L0CFGASSTATECHANGECMD[2]);
buf B_L0CFGASSTATECHANGECMD3 (L0CFGASSTATECHANGECMD_IN[3], L0CFGASSTATECHANGECMD[3]);
buf B_L0CFGASSPANTREEOWNEDSTATE (L0CFGASSPANTREEOWNEDSTATE_IN, L0CFGASSPANTREEOWNEDSTATE);
buf B_L0ASE (L0ASE_IN, L0ASE);
buf B_L0ASTURNPOOLBITSCONSUMED0 (L0ASTURNPOOLBITSCONSUMED_IN[0], L0ASTURNPOOLBITSCONSUMED[0]);
buf B_L0ASTURNPOOLBITSCONSUMED1 (L0ASTURNPOOLBITSCONSUMED_IN[1], L0ASTURNPOOLBITSCONSUMED[1]);
buf B_L0ASTURNPOOLBITSCONSUMED2 (L0ASTURNPOOLBITSCONSUMED_IN[2], L0ASTURNPOOLBITSCONSUMED[2]);
buf B_L0ASPORTCOUNT0 (L0ASPORTCOUNT_IN[0], L0ASPORTCOUNT[0]);
buf B_L0ASPORTCOUNT1 (L0ASPORTCOUNT_IN[1], L0ASPORTCOUNT[1]);
buf B_L0ASPORTCOUNT2 (L0ASPORTCOUNT_IN[2], L0ASPORTCOUNT[2]);
buf B_L0ASPORTCOUNT3 (L0ASPORTCOUNT_IN[3], L0ASPORTCOUNT[3]);
buf B_L0ASPORTCOUNT4 (L0ASPORTCOUNT_IN[4], L0ASPORTCOUNT[4]);
buf B_L0ASPORTCOUNT5 (L0ASPORTCOUNT_IN[5], L0ASPORTCOUNT[5]);
buf B_L0ASPORTCOUNT6 (L0ASPORTCOUNT_IN[6], L0ASPORTCOUNT[6]);
buf B_L0ASPORTCOUNT7 (L0ASPORTCOUNT_IN[7], L0ASPORTCOUNT[7]);
buf B_L0CFGVCENABLE0 (L0CFGVCENABLE_IN[0], L0CFGVCENABLE[0]);
buf B_L0CFGVCENABLE1 (L0CFGVCENABLE_IN[1], L0CFGVCENABLE[1]);
buf B_L0CFGVCENABLE2 (L0CFGVCENABLE_IN[2], L0CFGVCENABLE[2]);
buf B_L0CFGVCENABLE3 (L0CFGVCENABLE_IN[3], L0CFGVCENABLE[3]);
buf B_L0CFGVCENABLE4 (L0CFGVCENABLE_IN[4], L0CFGVCENABLE[4]);
buf B_L0CFGVCENABLE5 (L0CFGVCENABLE_IN[5], L0CFGVCENABLE[5]);
buf B_L0CFGVCENABLE6 (L0CFGVCENABLE_IN[6], L0CFGVCENABLE[6]);
buf B_L0CFGVCENABLE7 (L0CFGVCENABLE_IN[7], L0CFGVCENABLE[7]);
buf B_L0CFGNEGOTIATEDMAXP0 (L0CFGNEGOTIATEDMAXP_IN[0], L0CFGNEGOTIATEDMAXP[0]);
buf B_L0CFGNEGOTIATEDMAXP1 (L0CFGNEGOTIATEDMAXP_IN[1], L0CFGNEGOTIATEDMAXP[1]);
buf B_L0CFGNEGOTIATEDMAXP2 (L0CFGNEGOTIATEDMAXP_IN[2], L0CFGNEGOTIATEDMAXP[2]);
buf B_L0CFGDISABLESCRAMBLE (L0CFGDISABLESCRAMBLE_IN, L0CFGDISABLESCRAMBLE);
buf B_L0CFGEXTENDEDSYNC (L0CFGEXTENDEDSYNC_IN, L0CFGEXTENDEDSYNC);
buf B_L0CFGLINKDISABLE (L0CFGLINKDISABLE_IN, L0CFGLINKDISABLE);
buf B_L0PORTNUMBER0 (L0PORTNUMBER_IN[0], L0PORTNUMBER[0]);
buf B_L0PORTNUMBER1 (L0PORTNUMBER_IN[1], L0PORTNUMBER[1]);
buf B_L0PORTNUMBER2 (L0PORTNUMBER_IN[2], L0PORTNUMBER[2]);
buf B_L0PORTNUMBER3 (L0PORTNUMBER_IN[3], L0PORTNUMBER[3]);
buf B_L0PORTNUMBER4 (L0PORTNUMBER_IN[4], L0PORTNUMBER[4]);
buf B_L0PORTNUMBER5 (L0PORTNUMBER_IN[5], L0PORTNUMBER[5]);
buf B_L0PORTNUMBER6 (L0PORTNUMBER_IN[6], L0PORTNUMBER[6]);
buf B_L0PORTNUMBER7 (L0PORTNUMBER_IN[7], L0PORTNUMBER[7]);
buf B_L0SENDUNLOCKMESSAGE (L0SENDUNLOCKMESSAGE_IN, L0SENDUNLOCKMESSAGE);
buf B_L0ALLDOWNRXPORTSINL0S (L0ALLDOWNRXPORTSINL0S_IN, L0ALLDOWNRXPORTSINL0S);
buf B_L0UPSTREAMRXPORTINL0S (L0UPSTREAMRXPORTINL0S_IN, L0UPSTREAMRXPORTINL0S);
buf B_L0TRANSACTIONSPENDING (L0TRANSACTIONSPENDING_IN, L0TRANSACTIONSPENDING);
buf B_L0ALLDOWNPORTSINL1 (L0ALLDOWNPORTSINL1_IN, L0ALLDOWNPORTSINL1);
buf B_L0FWDCORRERRIN (L0FWDCORRERRIN_IN, L0FWDCORRERRIN);
buf B_L0FWDFATALERRIN (L0FWDFATALERRIN_IN, L0FWDFATALERRIN);
buf B_L0FWDNONFATALERRIN (L0FWDNONFATALERRIN_IN, L0FWDNONFATALERRIN);
buf B_L0SETCOMPLETERABORTERROR (L0SETCOMPLETERABORTERROR_IN, L0SETCOMPLETERABORTERROR);
buf B_L0SETDETECTEDCORRERROR (L0SETDETECTEDCORRERROR_IN, L0SETDETECTEDCORRERROR);
buf B_L0SETDETECTEDFATALERROR (L0SETDETECTEDFATALERROR_IN, L0SETDETECTEDFATALERROR);
buf B_L0SETDETECTEDNONFATALERROR (L0SETDETECTEDNONFATALERROR_IN, L0SETDETECTEDNONFATALERROR);
buf B_L0SETLINKDETECTEDPARITYERROR (L0SETLINKDETECTEDPARITYERROR_IN, L0SETLINKDETECTEDPARITYERROR);
buf B_L0SETLINKMASTERDATAPARITY (L0SETLINKMASTERDATAPARITY_IN, L0SETLINKMASTERDATAPARITY);
buf B_L0SETLINKRECEIVEDMASTERABORT (L0SETLINKRECEIVEDMASTERABORT_IN, L0SETLINKRECEIVEDMASTERABORT);
buf B_L0SETLINKRECEIVEDTARGETABORT (L0SETLINKRECEIVEDTARGETABORT_IN, L0SETLINKRECEIVEDTARGETABORT);
buf B_L0SETLINKSYSTEMERROR (L0SETLINKSYSTEMERROR_IN, L0SETLINKSYSTEMERROR);
buf B_L0SETLINKSIGNALLEDTARGETABORT (L0SETLINKSIGNALLEDTARGETABORT_IN, L0SETLINKSIGNALLEDTARGETABORT);
buf B_L0SETUSERDETECTEDPARITYERROR (L0SETUSERDETECTEDPARITYERROR_IN, L0SETUSERDETECTEDPARITYERROR);
buf B_L0SETUSERMASTERDATAPARITY (L0SETUSERMASTERDATAPARITY_IN, L0SETUSERMASTERDATAPARITY);
buf B_L0SETUSERRECEIVEDMASTERABORT (L0SETUSERRECEIVEDMASTERABORT_IN, L0SETUSERRECEIVEDMASTERABORT);
buf B_L0SETUSERRECEIVEDTARGETABORT (L0SETUSERRECEIVEDTARGETABORT_IN, L0SETUSERRECEIVEDTARGETABORT);
buf B_L0SETUSERSYSTEMERROR (L0SETUSERSYSTEMERROR_IN, L0SETUSERSYSTEMERROR);
buf B_L0SETUSERSIGNALLEDTARGETABORT (L0SETUSERSIGNALLEDTARGETABORT_IN, L0SETUSERSIGNALLEDTARGETABORT);
buf B_L0SETCOMPLETIONTIMEOUTUNCORRERROR (L0SETCOMPLETIONTIMEOUTUNCORRERROR_IN, L0SETCOMPLETIONTIMEOUTUNCORRERROR);
buf B_L0SETCOMPLETIONTIMEOUTCORRERROR (L0SETCOMPLETIONTIMEOUTCORRERROR_IN, L0SETCOMPLETIONTIMEOUTCORRERROR);
buf B_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_IN, L0SETUNEXPECTEDCOMPLETIONUNCORRERROR);
buf B_L0SETUNEXPECTEDCOMPLETIONCORRERROR (L0SETUNEXPECTEDCOMPLETIONCORRERROR_IN, L0SETUNEXPECTEDCOMPLETIONCORRERROR);
buf B_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_IN, L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR);
buf B_L0SETUNSUPPORTEDREQUESTOTHERERROR (L0SETUNSUPPORTEDREQUESTOTHERERROR_IN, L0SETUNSUPPORTEDREQUESTOTHERERROR);
buf B_L0PACKETHEADERFROMUSER0 (L0PACKETHEADERFROMUSER_IN[0], L0PACKETHEADERFROMUSER[0]);
buf B_L0PACKETHEADERFROMUSER1 (L0PACKETHEADERFROMUSER_IN[1], L0PACKETHEADERFROMUSER[1]);
buf B_L0PACKETHEADERFROMUSER2 (L0PACKETHEADERFROMUSER_IN[2], L0PACKETHEADERFROMUSER[2]);
buf B_L0PACKETHEADERFROMUSER3 (L0PACKETHEADERFROMUSER_IN[3], L0PACKETHEADERFROMUSER[3]);
buf B_L0PACKETHEADERFROMUSER4 (L0PACKETHEADERFROMUSER_IN[4], L0PACKETHEADERFROMUSER[4]);
buf B_L0PACKETHEADERFROMUSER5 (L0PACKETHEADERFROMUSER_IN[5], L0PACKETHEADERFROMUSER[5]);
buf B_L0PACKETHEADERFROMUSER6 (L0PACKETHEADERFROMUSER_IN[6], L0PACKETHEADERFROMUSER[6]);
buf B_L0PACKETHEADERFROMUSER7 (L0PACKETHEADERFROMUSER_IN[7], L0PACKETHEADERFROMUSER[7]);
buf B_L0PACKETHEADERFROMUSER8 (L0PACKETHEADERFROMUSER_IN[8], L0PACKETHEADERFROMUSER[8]);
buf B_L0PACKETHEADERFROMUSER9 (L0PACKETHEADERFROMUSER_IN[9], L0PACKETHEADERFROMUSER[9]);
buf B_L0PACKETHEADERFROMUSER10 (L0PACKETHEADERFROMUSER_IN[10], L0PACKETHEADERFROMUSER[10]);
buf B_L0PACKETHEADERFROMUSER11 (L0PACKETHEADERFROMUSER_IN[11], L0PACKETHEADERFROMUSER[11]);
buf B_L0PACKETHEADERFROMUSER12 (L0PACKETHEADERFROMUSER_IN[12], L0PACKETHEADERFROMUSER[12]);
buf B_L0PACKETHEADERFROMUSER13 (L0PACKETHEADERFROMUSER_IN[13], L0PACKETHEADERFROMUSER[13]);
buf B_L0PACKETHEADERFROMUSER14 (L0PACKETHEADERFROMUSER_IN[14], L0PACKETHEADERFROMUSER[14]);
buf B_L0PACKETHEADERFROMUSER15 (L0PACKETHEADERFROMUSER_IN[15], L0PACKETHEADERFROMUSER[15]);
buf B_L0PACKETHEADERFROMUSER16 (L0PACKETHEADERFROMUSER_IN[16], L0PACKETHEADERFROMUSER[16]);
buf B_L0PACKETHEADERFROMUSER17 (L0PACKETHEADERFROMUSER_IN[17], L0PACKETHEADERFROMUSER[17]);
buf B_L0PACKETHEADERFROMUSER18 (L0PACKETHEADERFROMUSER_IN[18], L0PACKETHEADERFROMUSER[18]);
buf B_L0PACKETHEADERFROMUSER19 (L0PACKETHEADERFROMUSER_IN[19], L0PACKETHEADERFROMUSER[19]);
buf B_L0PACKETHEADERFROMUSER20 (L0PACKETHEADERFROMUSER_IN[20], L0PACKETHEADERFROMUSER[20]);
buf B_L0PACKETHEADERFROMUSER21 (L0PACKETHEADERFROMUSER_IN[21], L0PACKETHEADERFROMUSER[21]);
buf B_L0PACKETHEADERFROMUSER22 (L0PACKETHEADERFROMUSER_IN[22], L0PACKETHEADERFROMUSER[22]);
buf B_L0PACKETHEADERFROMUSER23 (L0PACKETHEADERFROMUSER_IN[23], L0PACKETHEADERFROMUSER[23]);
buf B_L0PACKETHEADERFROMUSER24 (L0PACKETHEADERFROMUSER_IN[24], L0PACKETHEADERFROMUSER[24]);
buf B_L0PACKETHEADERFROMUSER25 (L0PACKETHEADERFROMUSER_IN[25], L0PACKETHEADERFROMUSER[25]);
buf B_L0PACKETHEADERFROMUSER26 (L0PACKETHEADERFROMUSER_IN[26], L0PACKETHEADERFROMUSER[26]);
buf B_L0PACKETHEADERFROMUSER27 (L0PACKETHEADERFROMUSER_IN[27], L0PACKETHEADERFROMUSER[27]);
buf B_L0PACKETHEADERFROMUSER28 (L0PACKETHEADERFROMUSER_IN[28], L0PACKETHEADERFROMUSER[28]);
buf B_L0PACKETHEADERFROMUSER29 (L0PACKETHEADERFROMUSER_IN[29], L0PACKETHEADERFROMUSER[29]);
buf B_L0PACKETHEADERFROMUSER30 (L0PACKETHEADERFROMUSER_IN[30], L0PACKETHEADERFROMUSER[30]);
buf B_L0PACKETHEADERFROMUSER31 (L0PACKETHEADERFROMUSER_IN[31], L0PACKETHEADERFROMUSER[31]);
buf B_L0PACKETHEADERFROMUSER32 (L0PACKETHEADERFROMUSER_IN[32], L0PACKETHEADERFROMUSER[32]);
buf B_L0PACKETHEADERFROMUSER33 (L0PACKETHEADERFROMUSER_IN[33], L0PACKETHEADERFROMUSER[33]);
buf B_L0PACKETHEADERFROMUSER34 (L0PACKETHEADERFROMUSER_IN[34], L0PACKETHEADERFROMUSER[34]);
buf B_L0PACKETHEADERFROMUSER35 (L0PACKETHEADERFROMUSER_IN[35], L0PACKETHEADERFROMUSER[35]);
buf B_L0PACKETHEADERFROMUSER36 (L0PACKETHEADERFROMUSER_IN[36], L0PACKETHEADERFROMUSER[36]);
buf B_L0PACKETHEADERFROMUSER37 (L0PACKETHEADERFROMUSER_IN[37], L0PACKETHEADERFROMUSER[37]);
buf B_L0PACKETHEADERFROMUSER38 (L0PACKETHEADERFROMUSER_IN[38], L0PACKETHEADERFROMUSER[38]);
buf B_L0PACKETHEADERFROMUSER39 (L0PACKETHEADERFROMUSER_IN[39], L0PACKETHEADERFROMUSER[39]);
buf B_L0PACKETHEADERFROMUSER40 (L0PACKETHEADERFROMUSER_IN[40], L0PACKETHEADERFROMUSER[40]);
buf B_L0PACKETHEADERFROMUSER41 (L0PACKETHEADERFROMUSER_IN[41], L0PACKETHEADERFROMUSER[41]);
buf B_L0PACKETHEADERFROMUSER42 (L0PACKETHEADERFROMUSER_IN[42], L0PACKETHEADERFROMUSER[42]);
buf B_L0PACKETHEADERFROMUSER43 (L0PACKETHEADERFROMUSER_IN[43], L0PACKETHEADERFROMUSER[43]);
buf B_L0PACKETHEADERFROMUSER44 (L0PACKETHEADERFROMUSER_IN[44], L0PACKETHEADERFROMUSER[44]);
buf B_L0PACKETHEADERFROMUSER45 (L0PACKETHEADERFROMUSER_IN[45], L0PACKETHEADERFROMUSER[45]);
buf B_L0PACKETHEADERFROMUSER46 (L0PACKETHEADERFROMUSER_IN[46], L0PACKETHEADERFROMUSER[46]);
buf B_L0PACKETHEADERFROMUSER47 (L0PACKETHEADERFROMUSER_IN[47], L0PACKETHEADERFROMUSER[47]);
buf B_L0PACKETHEADERFROMUSER48 (L0PACKETHEADERFROMUSER_IN[48], L0PACKETHEADERFROMUSER[48]);
buf B_L0PACKETHEADERFROMUSER49 (L0PACKETHEADERFROMUSER_IN[49], L0PACKETHEADERFROMUSER[49]);
buf B_L0PACKETHEADERFROMUSER50 (L0PACKETHEADERFROMUSER_IN[50], L0PACKETHEADERFROMUSER[50]);
buf B_L0PACKETHEADERFROMUSER51 (L0PACKETHEADERFROMUSER_IN[51], L0PACKETHEADERFROMUSER[51]);
buf B_L0PACKETHEADERFROMUSER52 (L0PACKETHEADERFROMUSER_IN[52], L0PACKETHEADERFROMUSER[52]);
buf B_L0PACKETHEADERFROMUSER53 (L0PACKETHEADERFROMUSER_IN[53], L0PACKETHEADERFROMUSER[53]);
buf B_L0PACKETHEADERFROMUSER54 (L0PACKETHEADERFROMUSER_IN[54], L0PACKETHEADERFROMUSER[54]);
buf B_L0PACKETHEADERFROMUSER55 (L0PACKETHEADERFROMUSER_IN[55], L0PACKETHEADERFROMUSER[55]);
buf B_L0PACKETHEADERFROMUSER56 (L0PACKETHEADERFROMUSER_IN[56], L0PACKETHEADERFROMUSER[56]);
buf B_L0PACKETHEADERFROMUSER57 (L0PACKETHEADERFROMUSER_IN[57], L0PACKETHEADERFROMUSER[57]);
buf B_L0PACKETHEADERFROMUSER58 (L0PACKETHEADERFROMUSER_IN[58], L0PACKETHEADERFROMUSER[58]);
buf B_L0PACKETHEADERFROMUSER59 (L0PACKETHEADERFROMUSER_IN[59], L0PACKETHEADERFROMUSER[59]);
buf B_L0PACKETHEADERFROMUSER60 (L0PACKETHEADERFROMUSER_IN[60], L0PACKETHEADERFROMUSER[60]);
buf B_L0PACKETHEADERFROMUSER61 (L0PACKETHEADERFROMUSER_IN[61], L0PACKETHEADERFROMUSER[61]);
buf B_L0PACKETHEADERFROMUSER62 (L0PACKETHEADERFROMUSER_IN[62], L0PACKETHEADERFROMUSER[62]);
buf B_L0PACKETHEADERFROMUSER63 (L0PACKETHEADERFROMUSER_IN[63], L0PACKETHEADERFROMUSER[63]);
buf B_L0PACKETHEADERFROMUSER64 (L0PACKETHEADERFROMUSER_IN[64], L0PACKETHEADERFROMUSER[64]);
buf B_L0PACKETHEADERFROMUSER65 (L0PACKETHEADERFROMUSER_IN[65], L0PACKETHEADERFROMUSER[65]);
buf B_L0PACKETHEADERFROMUSER66 (L0PACKETHEADERFROMUSER_IN[66], L0PACKETHEADERFROMUSER[66]);
buf B_L0PACKETHEADERFROMUSER67 (L0PACKETHEADERFROMUSER_IN[67], L0PACKETHEADERFROMUSER[67]);
buf B_L0PACKETHEADERFROMUSER68 (L0PACKETHEADERFROMUSER_IN[68], L0PACKETHEADERFROMUSER[68]);
buf B_L0PACKETHEADERFROMUSER69 (L0PACKETHEADERFROMUSER_IN[69], L0PACKETHEADERFROMUSER[69]);
buf B_L0PACKETHEADERFROMUSER70 (L0PACKETHEADERFROMUSER_IN[70], L0PACKETHEADERFROMUSER[70]);
buf B_L0PACKETHEADERFROMUSER71 (L0PACKETHEADERFROMUSER_IN[71], L0PACKETHEADERFROMUSER[71]);
buf B_L0PACKETHEADERFROMUSER72 (L0PACKETHEADERFROMUSER_IN[72], L0PACKETHEADERFROMUSER[72]);
buf B_L0PACKETHEADERFROMUSER73 (L0PACKETHEADERFROMUSER_IN[73], L0PACKETHEADERFROMUSER[73]);
buf B_L0PACKETHEADERFROMUSER74 (L0PACKETHEADERFROMUSER_IN[74], L0PACKETHEADERFROMUSER[74]);
buf B_L0PACKETHEADERFROMUSER75 (L0PACKETHEADERFROMUSER_IN[75], L0PACKETHEADERFROMUSER[75]);
buf B_L0PACKETHEADERFROMUSER76 (L0PACKETHEADERFROMUSER_IN[76], L0PACKETHEADERFROMUSER[76]);
buf B_L0PACKETHEADERFROMUSER77 (L0PACKETHEADERFROMUSER_IN[77], L0PACKETHEADERFROMUSER[77]);
buf B_L0PACKETHEADERFROMUSER78 (L0PACKETHEADERFROMUSER_IN[78], L0PACKETHEADERFROMUSER[78]);
buf B_L0PACKETHEADERFROMUSER79 (L0PACKETHEADERFROMUSER_IN[79], L0PACKETHEADERFROMUSER[79]);
buf B_L0PACKETHEADERFROMUSER80 (L0PACKETHEADERFROMUSER_IN[80], L0PACKETHEADERFROMUSER[80]);
buf B_L0PACKETHEADERFROMUSER81 (L0PACKETHEADERFROMUSER_IN[81], L0PACKETHEADERFROMUSER[81]);
buf B_L0PACKETHEADERFROMUSER82 (L0PACKETHEADERFROMUSER_IN[82], L0PACKETHEADERFROMUSER[82]);
buf B_L0PACKETHEADERFROMUSER83 (L0PACKETHEADERFROMUSER_IN[83], L0PACKETHEADERFROMUSER[83]);
buf B_L0PACKETHEADERFROMUSER84 (L0PACKETHEADERFROMUSER_IN[84], L0PACKETHEADERFROMUSER[84]);
buf B_L0PACKETHEADERFROMUSER85 (L0PACKETHEADERFROMUSER_IN[85], L0PACKETHEADERFROMUSER[85]);
buf B_L0PACKETHEADERFROMUSER86 (L0PACKETHEADERFROMUSER_IN[86], L0PACKETHEADERFROMUSER[86]);
buf B_L0PACKETHEADERFROMUSER87 (L0PACKETHEADERFROMUSER_IN[87], L0PACKETHEADERFROMUSER[87]);
buf B_L0PACKETHEADERFROMUSER88 (L0PACKETHEADERFROMUSER_IN[88], L0PACKETHEADERFROMUSER[88]);
buf B_L0PACKETHEADERFROMUSER89 (L0PACKETHEADERFROMUSER_IN[89], L0PACKETHEADERFROMUSER[89]);
buf B_L0PACKETHEADERFROMUSER90 (L0PACKETHEADERFROMUSER_IN[90], L0PACKETHEADERFROMUSER[90]);
buf B_L0PACKETHEADERFROMUSER91 (L0PACKETHEADERFROMUSER_IN[91], L0PACKETHEADERFROMUSER[91]);
buf B_L0PACKETHEADERFROMUSER92 (L0PACKETHEADERFROMUSER_IN[92], L0PACKETHEADERFROMUSER[92]);
buf B_L0PACKETHEADERFROMUSER93 (L0PACKETHEADERFROMUSER_IN[93], L0PACKETHEADERFROMUSER[93]);
buf B_L0PACKETHEADERFROMUSER94 (L0PACKETHEADERFROMUSER_IN[94], L0PACKETHEADERFROMUSER[94]);
buf B_L0PACKETHEADERFROMUSER95 (L0PACKETHEADERFROMUSER_IN[95], L0PACKETHEADERFROMUSER[95]);
buf B_L0PACKETHEADERFROMUSER96 (L0PACKETHEADERFROMUSER_IN[96], L0PACKETHEADERFROMUSER[96]);
buf B_L0PACKETHEADERFROMUSER97 (L0PACKETHEADERFROMUSER_IN[97], L0PACKETHEADERFROMUSER[97]);
buf B_L0PACKETHEADERFROMUSER98 (L0PACKETHEADERFROMUSER_IN[98], L0PACKETHEADERFROMUSER[98]);
buf B_L0PACKETHEADERFROMUSER99 (L0PACKETHEADERFROMUSER_IN[99], L0PACKETHEADERFROMUSER[99]);
buf B_L0PACKETHEADERFROMUSER100 (L0PACKETHEADERFROMUSER_IN[100], L0PACKETHEADERFROMUSER[100]);
buf B_L0PACKETHEADERFROMUSER101 (L0PACKETHEADERFROMUSER_IN[101], L0PACKETHEADERFROMUSER[101]);
buf B_L0PACKETHEADERFROMUSER102 (L0PACKETHEADERFROMUSER_IN[102], L0PACKETHEADERFROMUSER[102]);
buf B_L0PACKETHEADERFROMUSER103 (L0PACKETHEADERFROMUSER_IN[103], L0PACKETHEADERFROMUSER[103]);
buf B_L0PACKETHEADERFROMUSER104 (L0PACKETHEADERFROMUSER_IN[104], L0PACKETHEADERFROMUSER[104]);
buf B_L0PACKETHEADERFROMUSER105 (L0PACKETHEADERFROMUSER_IN[105], L0PACKETHEADERFROMUSER[105]);
buf B_L0PACKETHEADERFROMUSER106 (L0PACKETHEADERFROMUSER_IN[106], L0PACKETHEADERFROMUSER[106]);
buf B_L0PACKETHEADERFROMUSER107 (L0PACKETHEADERFROMUSER_IN[107], L0PACKETHEADERFROMUSER[107]);
buf B_L0PACKETHEADERFROMUSER108 (L0PACKETHEADERFROMUSER_IN[108], L0PACKETHEADERFROMUSER[108]);
buf B_L0PACKETHEADERFROMUSER109 (L0PACKETHEADERFROMUSER_IN[109], L0PACKETHEADERFROMUSER[109]);
buf B_L0PACKETHEADERFROMUSER110 (L0PACKETHEADERFROMUSER_IN[110], L0PACKETHEADERFROMUSER[110]);
buf B_L0PACKETHEADERFROMUSER111 (L0PACKETHEADERFROMUSER_IN[111], L0PACKETHEADERFROMUSER[111]);
buf B_L0PACKETHEADERFROMUSER112 (L0PACKETHEADERFROMUSER_IN[112], L0PACKETHEADERFROMUSER[112]);
buf B_L0PACKETHEADERFROMUSER113 (L0PACKETHEADERFROMUSER_IN[113], L0PACKETHEADERFROMUSER[113]);
buf B_L0PACKETHEADERFROMUSER114 (L0PACKETHEADERFROMUSER_IN[114], L0PACKETHEADERFROMUSER[114]);
buf B_L0PACKETHEADERFROMUSER115 (L0PACKETHEADERFROMUSER_IN[115], L0PACKETHEADERFROMUSER[115]);
buf B_L0PACKETHEADERFROMUSER116 (L0PACKETHEADERFROMUSER_IN[116], L0PACKETHEADERFROMUSER[116]);
buf B_L0PACKETHEADERFROMUSER117 (L0PACKETHEADERFROMUSER_IN[117], L0PACKETHEADERFROMUSER[117]);
buf B_L0PACKETHEADERFROMUSER118 (L0PACKETHEADERFROMUSER_IN[118], L0PACKETHEADERFROMUSER[118]);
buf B_L0PACKETHEADERFROMUSER119 (L0PACKETHEADERFROMUSER_IN[119], L0PACKETHEADERFROMUSER[119]);
buf B_L0PACKETHEADERFROMUSER120 (L0PACKETHEADERFROMUSER_IN[120], L0PACKETHEADERFROMUSER[120]);
buf B_L0PACKETHEADERFROMUSER121 (L0PACKETHEADERFROMUSER_IN[121], L0PACKETHEADERFROMUSER[121]);
buf B_L0PACKETHEADERFROMUSER122 (L0PACKETHEADERFROMUSER_IN[122], L0PACKETHEADERFROMUSER[122]);
buf B_L0PACKETHEADERFROMUSER123 (L0PACKETHEADERFROMUSER_IN[123], L0PACKETHEADERFROMUSER[123]);
buf B_L0PACKETHEADERFROMUSER124 (L0PACKETHEADERFROMUSER_IN[124], L0PACKETHEADERFROMUSER[124]);
buf B_L0PACKETHEADERFROMUSER125 (L0PACKETHEADERFROMUSER_IN[125], L0PACKETHEADERFROMUSER[125]);
buf B_L0PACKETHEADERFROMUSER126 (L0PACKETHEADERFROMUSER_IN[126], L0PACKETHEADERFROMUSER[126]);
buf B_L0PACKETHEADERFROMUSER127 (L0PACKETHEADERFROMUSER_IN[127], L0PACKETHEADERFROMUSER[127]);
buf B_L0LEGACYINTFUNCT0 (L0LEGACYINTFUNCT0_IN, L0LEGACYINTFUNCT0);
buf B_L0FWDASSERTINTALEGACYINT (L0FWDASSERTINTALEGACYINT_IN, L0FWDASSERTINTALEGACYINT);
buf B_L0FWDASSERTINTBLEGACYINT (L0FWDASSERTINTBLEGACYINT_IN, L0FWDASSERTINTBLEGACYINT);
buf B_L0FWDASSERTINTCLEGACYINT (L0FWDASSERTINTCLEGACYINT_IN, L0FWDASSERTINTCLEGACYINT);
buf B_L0FWDASSERTINTDLEGACYINT (L0FWDASSERTINTDLEGACYINT_IN, L0FWDASSERTINTDLEGACYINT);
buf B_L0FWDDEASSERTINTALEGACYINT (L0FWDDEASSERTINTALEGACYINT_IN, L0FWDDEASSERTINTALEGACYINT);
buf B_L0FWDDEASSERTINTBLEGACYINT (L0FWDDEASSERTINTBLEGACYINT_IN, L0FWDDEASSERTINTBLEGACYINT);
buf B_L0FWDDEASSERTINTCLEGACYINT (L0FWDDEASSERTINTCLEGACYINT_IN, L0FWDDEASSERTINTCLEGACYINT);
buf B_L0FWDDEASSERTINTDLEGACYINT (L0FWDDEASSERTINTDLEGACYINT_IN, L0FWDDEASSERTINTDLEGACYINT);
buf B_L0MSIREQUEST00 (L0MSIREQUEST0_IN[0], L0MSIREQUEST0[0]);
buf B_L0MSIREQUEST01 (L0MSIREQUEST0_IN[1], L0MSIREQUEST0[1]);
buf B_L0MSIREQUEST02 (L0MSIREQUEST0_IN[2], L0MSIREQUEST0[2]);
buf B_L0MSIREQUEST03 (L0MSIREQUEST0_IN[3], L0MSIREQUEST0[3]);
buf B_L0ELECTROMECHANICALINTERLOCKENGAGED (L0ELECTROMECHANICALINTERLOCKENGAGED_IN, L0ELECTROMECHANICALINTERLOCKENGAGED);
buf B_L0MRLSENSORCLOSEDN (L0MRLSENSORCLOSEDN_IN, L0MRLSENSORCLOSEDN);
buf B_L0POWERFAULTDETECTED (L0POWERFAULTDETECTED_IN, L0POWERFAULTDETECTED);
buf B_L0PRESENCEDETECTSLOTEMPTYN (L0PRESENCEDETECTSLOTEMPTYN_IN, L0PRESENCEDETECTSLOTEMPTYN);
buf B_L0ATTENTIONBUTTONPRESSED (L0ATTENTIONBUTTONPRESSED_IN, L0ATTENTIONBUTTONPRESSED);
buf B_L0TXBEACON (L0TXBEACON_IN, L0TXBEACON);
buf B_L0WAKEN (L0WAKEN_IN, L0WAKEN);
buf B_L0PMEREQIN (L0PMEREQIN_IN, L0PMEREQIN);
buf B_L0ROOTTURNOFFREQ (L0ROOTTURNOFFREQ_IN, L0ROOTTURNOFFREQ);
buf B_L0TXCFGPM (L0TXCFGPM_IN, L0TXCFGPM);
buf B_L0TXCFGPMTYPE0 (L0TXCFGPMTYPE_IN[0], L0TXCFGPMTYPE[0]);
buf B_L0TXCFGPMTYPE1 (L0TXCFGPMTYPE_IN[1], L0TXCFGPMTYPE[1]);
buf B_L0TXCFGPMTYPE2 (L0TXCFGPMTYPE_IN[2], L0TXCFGPMTYPE[2]);
buf B_L0PWRNEWSTATEREQ (L0PWRNEWSTATEREQ_IN, L0PWRNEWSTATEREQ);
buf B_L0PWRNEXTLINKSTATE0 (L0PWRNEXTLINKSTATE_IN[0], L0PWRNEXTLINKSTATE[0]);
buf B_L0PWRNEXTLINKSTATE1 (L0PWRNEXTLINKSTATE_IN[1], L0PWRNEXTLINKSTATE[1]);
buf B_L0CFGL0SENTRYSUP (L0CFGL0SENTRYSUP_IN, L0CFGL0SENTRYSUP);
buf B_L0CFGL0SENTRYENABLE (L0CFGL0SENTRYENABLE_IN, L0CFGL0SENTRYENABLE);
buf B_L0CFGL0SEXITLAT0 (L0CFGL0SEXITLAT_IN[0], L0CFGL0SEXITLAT[0]);
buf B_L0CFGL0SEXITLAT1 (L0CFGL0SEXITLAT_IN[1], L0CFGL0SEXITLAT[1]);
buf B_L0CFGL0SEXITLAT2 (L0CFGL0SEXITLAT_IN[2], L0CFGL0SEXITLAT[2]);
buf B_L0TXTLTLPDATA0 (L0TXTLTLPDATA_IN[0], L0TXTLTLPDATA[0]);
buf B_L0TXTLTLPDATA1 (L0TXTLTLPDATA_IN[1], L0TXTLTLPDATA[1]);
buf B_L0TXTLTLPDATA2 (L0TXTLTLPDATA_IN[2], L0TXTLTLPDATA[2]);
buf B_L0TXTLTLPDATA3 (L0TXTLTLPDATA_IN[3], L0TXTLTLPDATA[3]);
buf B_L0TXTLTLPDATA4 (L0TXTLTLPDATA_IN[4], L0TXTLTLPDATA[4]);
buf B_L0TXTLTLPDATA5 (L0TXTLTLPDATA_IN[5], L0TXTLTLPDATA[5]);
buf B_L0TXTLTLPDATA6 (L0TXTLTLPDATA_IN[6], L0TXTLTLPDATA[6]);
buf B_L0TXTLTLPDATA7 (L0TXTLTLPDATA_IN[7], L0TXTLTLPDATA[7]);
buf B_L0TXTLTLPDATA8 (L0TXTLTLPDATA_IN[8], L0TXTLTLPDATA[8]);
buf B_L0TXTLTLPDATA9 (L0TXTLTLPDATA_IN[9], L0TXTLTLPDATA[9]);
buf B_L0TXTLTLPDATA10 (L0TXTLTLPDATA_IN[10], L0TXTLTLPDATA[10]);
buf B_L0TXTLTLPDATA11 (L0TXTLTLPDATA_IN[11], L0TXTLTLPDATA[11]);
buf B_L0TXTLTLPDATA12 (L0TXTLTLPDATA_IN[12], L0TXTLTLPDATA[12]);
buf B_L0TXTLTLPDATA13 (L0TXTLTLPDATA_IN[13], L0TXTLTLPDATA[13]);
buf B_L0TXTLTLPDATA14 (L0TXTLTLPDATA_IN[14], L0TXTLTLPDATA[14]);
buf B_L0TXTLTLPDATA15 (L0TXTLTLPDATA_IN[15], L0TXTLTLPDATA[15]);
buf B_L0TXTLTLPDATA16 (L0TXTLTLPDATA_IN[16], L0TXTLTLPDATA[16]);
buf B_L0TXTLTLPDATA17 (L0TXTLTLPDATA_IN[17], L0TXTLTLPDATA[17]);
buf B_L0TXTLTLPDATA18 (L0TXTLTLPDATA_IN[18], L0TXTLTLPDATA[18]);
buf B_L0TXTLTLPDATA19 (L0TXTLTLPDATA_IN[19], L0TXTLTLPDATA[19]);
buf B_L0TXTLTLPDATA20 (L0TXTLTLPDATA_IN[20], L0TXTLTLPDATA[20]);
buf B_L0TXTLTLPDATA21 (L0TXTLTLPDATA_IN[21], L0TXTLTLPDATA[21]);
buf B_L0TXTLTLPDATA22 (L0TXTLTLPDATA_IN[22], L0TXTLTLPDATA[22]);
buf B_L0TXTLTLPDATA23 (L0TXTLTLPDATA_IN[23], L0TXTLTLPDATA[23]);
buf B_L0TXTLTLPDATA24 (L0TXTLTLPDATA_IN[24], L0TXTLTLPDATA[24]);
buf B_L0TXTLTLPDATA25 (L0TXTLTLPDATA_IN[25], L0TXTLTLPDATA[25]);
buf B_L0TXTLTLPDATA26 (L0TXTLTLPDATA_IN[26], L0TXTLTLPDATA[26]);
buf B_L0TXTLTLPDATA27 (L0TXTLTLPDATA_IN[27], L0TXTLTLPDATA[27]);
buf B_L0TXTLTLPDATA28 (L0TXTLTLPDATA_IN[28], L0TXTLTLPDATA[28]);
buf B_L0TXTLTLPDATA29 (L0TXTLTLPDATA_IN[29], L0TXTLTLPDATA[29]);
buf B_L0TXTLTLPDATA30 (L0TXTLTLPDATA_IN[30], L0TXTLTLPDATA[30]);
buf B_L0TXTLTLPDATA31 (L0TXTLTLPDATA_IN[31], L0TXTLTLPDATA[31]);
buf B_L0TXTLTLPDATA32 (L0TXTLTLPDATA_IN[32], L0TXTLTLPDATA[32]);
buf B_L0TXTLTLPDATA33 (L0TXTLTLPDATA_IN[33], L0TXTLTLPDATA[33]);
buf B_L0TXTLTLPDATA34 (L0TXTLTLPDATA_IN[34], L0TXTLTLPDATA[34]);
buf B_L0TXTLTLPDATA35 (L0TXTLTLPDATA_IN[35], L0TXTLTLPDATA[35]);
buf B_L0TXTLTLPDATA36 (L0TXTLTLPDATA_IN[36], L0TXTLTLPDATA[36]);
buf B_L0TXTLTLPDATA37 (L0TXTLTLPDATA_IN[37], L0TXTLTLPDATA[37]);
buf B_L0TXTLTLPDATA38 (L0TXTLTLPDATA_IN[38], L0TXTLTLPDATA[38]);
buf B_L0TXTLTLPDATA39 (L0TXTLTLPDATA_IN[39], L0TXTLTLPDATA[39]);
buf B_L0TXTLTLPDATA40 (L0TXTLTLPDATA_IN[40], L0TXTLTLPDATA[40]);
buf B_L0TXTLTLPDATA41 (L0TXTLTLPDATA_IN[41], L0TXTLTLPDATA[41]);
buf B_L0TXTLTLPDATA42 (L0TXTLTLPDATA_IN[42], L0TXTLTLPDATA[42]);
buf B_L0TXTLTLPDATA43 (L0TXTLTLPDATA_IN[43], L0TXTLTLPDATA[43]);
buf B_L0TXTLTLPDATA44 (L0TXTLTLPDATA_IN[44], L0TXTLTLPDATA[44]);
buf B_L0TXTLTLPDATA45 (L0TXTLTLPDATA_IN[45], L0TXTLTLPDATA[45]);
buf B_L0TXTLTLPDATA46 (L0TXTLTLPDATA_IN[46], L0TXTLTLPDATA[46]);
buf B_L0TXTLTLPDATA47 (L0TXTLTLPDATA_IN[47], L0TXTLTLPDATA[47]);
buf B_L0TXTLTLPDATA48 (L0TXTLTLPDATA_IN[48], L0TXTLTLPDATA[48]);
buf B_L0TXTLTLPDATA49 (L0TXTLTLPDATA_IN[49], L0TXTLTLPDATA[49]);
buf B_L0TXTLTLPDATA50 (L0TXTLTLPDATA_IN[50], L0TXTLTLPDATA[50]);
buf B_L0TXTLTLPDATA51 (L0TXTLTLPDATA_IN[51], L0TXTLTLPDATA[51]);
buf B_L0TXTLTLPDATA52 (L0TXTLTLPDATA_IN[52], L0TXTLTLPDATA[52]);
buf B_L0TXTLTLPDATA53 (L0TXTLTLPDATA_IN[53], L0TXTLTLPDATA[53]);
buf B_L0TXTLTLPDATA54 (L0TXTLTLPDATA_IN[54], L0TXTLTLPDATA[54]);
buf B_L0TXTLTLPDATA55 (L0TXTLTLPDATA_IN[55], L0TXTLTLPDATA[55]);
buf B_L0TXTLTLPDATA56 (L0TXTLTLPDATA_IN[56], L0TXTLTLPDATA[56]);
buf B_L0TXTLTLPDATA57 (L0TXTLTLPDATA_IN[57], L0TXTLTLPDATA[57]);
buf B_L0TXTLTLPDATA58 (L0TXTLTLPDATA_IN[58], L0TXTLTLPDATA[58]);
buf B_L0TXTLTLPDATA59 (L0TXTLTLPDATA_IN[59], L0TXTLTLPDATA[59]);
buf B_L0TXTLTLPDATA60 (L0TXTLTLPDATA_IN[60], L0TXTLTLPDATA[60]);
buf B_L0TXTLTLPDATA61 (L0TXTLTLPDATA_IN[61], L0TXTLTLPDATA[61]);
buf B_L0TXTLTLPDATA62 (L0TXTLTLPDATA_IN[62], L0TXTLTLPDATA[62]);
buf B_L0TXTLTLPDATA63 (L0TXTLTLPDATA_IN[63], L0TXTLTLPDATA[63]);
buf B_L0TXTLTLPEND0 (L0TXTLTLPEND_IN[0], L0TXTLTLPEND[0]);
buf B_L0TXTLTLPEND1 (L0TXTLTLPEND_IN[1], L0TXTLTLPEND[1]);
buf B_L0TXTLTLPENABLE0 (L0TXTLTLPENABLE_IN[0], L0TXTLTLPENABLE[0]);
buf B_L0TXTLTLPENABLE1 (L0TXTLTLPENABLE_IN[1], L0TXTLTLPENABLE[1]);
buf B_L0TXTLTLPEDB (L0TXTLTLPEDB_IN, L0TXTLTLPEDB);
buf B_L0TXTLTLPREQ (L0TXTLTLPREQ_IN, L0TXTLTLPREQ);
buf B_L0TXTLTLPREQEND (L0TXTLTLPREQEND_IN, L0TXTLTLPREQEND);
buf B_L0TXTLTLPWIDTH (L0TXTLTLPWIDTH_IN, L0TXTLTLPWIDTH);
buf B_L0TXTLTLPLATENCY0 (L0TXTLTLPLATENCY_IN[0], L0TXTLTLPLATENCY[0]);
buf B_L0TXTLTLPLATENCY1 (L0TXTLTLPLATENCY_IN[1], L0TXTLTLPLATENCY[1]);
buf B_L0TXTLTLPLATENCY2 (L0TXTLTLPLATENCY_IN[2], L0TXTLTLPLATENCY[2]);
buf B_L0TXTLTLPLATENCY3 (L0TXTLTLPLATENCY_IN[3], L0TXTLTLPLATENCY[3]);
buf B_L0TLASFCCREDSTARVATION (L0TLASFCCREDSTARVATION_IN, L0TLASFCCREDSTARVATION);
buf B_L0TXTLSBFCDATA0 (L0TXTLSBFCDATA_IN[0], L0TXTLSBFCDATA[0]);
buf B_L0TXTLSBFCDATA1 (L0TXTLSBFCDATA_IN[1], L0TXTLSBFCDATA[1]);
buf B_L0TXTLSBFCDATA2 (L0TXTLSBFCDATA_IN[2], L0TXTLSBFCDATA[2]);
buf B_L0TXTLSBFCDATA3 (L0TXTLSBFCDATA_IN[3], L0TXTLSBFCDATA[3]);
buf B_L0TXTLSBFCDATA4 (L0TXTLSBFCDATA_IN[4], L0TXTLSBFCDATA[4]);
buf B_L0TXTLSBFCDATA5 (L0TXTLSBFCDATA_IN[5], L0TXTLSBFCDATA[5]);
buf B_L0TXTLSBFCDATA6 (L0TXTLSBFCDATA_IN[6], L0TXTLSBFCDATA[6]);
buf B_L0TXTLSBFCDATA7 (L0TXTLSBFCDATA_IN[7], L0TXTLSBFCDATA[7]);
buf B_L0TXTLSBFCDATA8 (L0TXTLSBFCDATA_IN[8], L0TXTLSBFCDATA[8]);
buf B_L0TXTLSBFCDATA9 (L0TXTLSBFCDATA_IN[9], L0TXTLSBFCDATA[9]);
buf B_L0TXTLSBFCDATA10 (L0TXTLSBFCDATA_IN[10], L0TXTLSBFCDATA[10]);
buf B_L0TXTLSBFCDATA11 (L0TXTLSBFCDATA_IN[11], L0TXTLSBFCDATA[11]);
buf B_L0TXTLSBFCDATA12 (L0TXTLSBFCDATA_IN[12], L0TXTLSBFCDATA[12]);
buf B_L0TXTLSBFCDATA13 (L0TXTLSBFCDATA_IN[13], L0TXTLSBFCDATA[13]);
buf B_L0TXTLSBFCDATA14 (L0TXTLSBFCDATA_IN[14], L0TXTLSBFCDATA[14]);
buf B_L0TXTLSBFCDATA15 (L0TXTLSBFCDATA_IN[15], L0TXTLSBFCDATA[15]);
buf B_L0TXTLSBFCDATA16 (L0TXTLSBFCDATA_IN[16], L0TXTLSBFCDATA[16]);
buf B_L0TXTLSBFCDATA17 (L0TXTLSBFCDATA_IN[17], L0TXTLSBFCDATA[17]);
buf B_L0TXTLSBFCDATA18 (L0TXTLSBFCDATA_IN[18], L0TXTLSBFCDATA[18]);
buf B_L0TXTLSBFCUPDATE (L0TXTLSBFCUPDATE_IN, L0TXTLSBFCUPDATE);
buf B_L0TXTLFCNPOSTBYPCRED0 (L0TXTLFCNPOSTBYPCRED_IN[0], L0TXTLFCNPOSTBYPCRED[0]);
buf B_L0TXTLFCNPOSTBYPCRED1 (L0TXTLFCNPOSTBYPCRED_IN[1], L0TXTLFCNPOSTBYPCRED[1]);
buf B_L0TXTLFCNPOSTBYPCRED2 (L0TXTLFCNPOSTBYPCRED_IN[2], L0TXTLFCNPOSTBYPCRED[2]);
buf B_L0TXTLFCNPOSTBYPCRED3 (L0TXTLFCNPOSTBYPCRED_IN[3], L0TXTLFCNPOSTBYPCRED[3]);
buf B_L0TXTLFCNPOSTBYPCRED4 (L0TXTLFCNPOSTBYPCRED_IN[4], L0TXTLFCNPOSTBYPCRED[4]);
buf B_L0TXTLFCNPOSTBYPCRED5 (L0TXTLFCNPOSTBYPCRED_IN[5], L0TXTLFCNPOSTBYPCRED[5]);
buf B_L0TXTLFCNPOSTBYPCRED6 (L0TXTLFCNPOSTBYPCRED_IN[6], L0TXTLFCNPOSTBYPCRED[6]);
buf B_L0TXTLFCNPOSTBYPCRED7 (L0TXTLFCNPOSTBYPCRED_IN[7], L0TXTLFCNPOSTBYPCRED[7]);
buf B_L0TXTLFCNPOSTBYPCRED8 (L0TXTLFCNPOSTBYPCRED_IN[8], L0TXTLFCNPOSTBYPCRED[8]);
buf B_L0TXTLFCNPOSTBYPCRED9 (L0TXTLFCNPOSTBYPCRED_IN[9], L0TXTLFCNPOSTBYPCRED[9]);
buf B_L0TXTLFCNPOSTBYPCRED10 (L0TXTLFCNPOSTBYPCRED_IN[10], L0TXTLFCNPOSTBYPCRED[10]);
buf B_L0TXTLFCNPOSTBYPCRED11 (L0TXTLFCNPOSTBYPCRED_IN[11], L0TXTLFCNPOSTBYPCRED[11]);
buf B_L0TXTLFCNPOSTBYPCRED12 (L0TXTLFCNPOSTBYPCRED_IN[12], L0TXTLFCNPOSTBYPCRED[12]);
buf B_L0TXTLFCNPOSTBYPCRED13 (L0TXTLFCNPOSTBYPCRED_IN[13], L0TXTLFCNPOSTBYPCRED[13]);
buf B_L0TXTLFCNPOSTBYPCRED14 (L0TXTLFCNPOSTBYPCRED_IN[14], L0TXTLFCNPOSTBYPCRED[14]);
buf B_L0TXTLFCNPOSTBYPCRED15 (L0TXTLFCNPOSTBYPCRED_IN[15], L0TXTLFCNPOSTBYPCRED[15]);
buf B_L0TXTLFCNPOSTBYPCRED16 (L0TXTLFCNPOSTBYPCRED_IN[16], L0TXTLFCNPOSTBYPCRED[16]);
buf B_L0TXTLFCNPOSTBYPCRED17 (L0TXTLFCNPOSTBYPCRED_IN[17], L0TXTLFCNPOSTBYPCRED[17]);
buf B_L0TXTLFCNPOSTBYPCRED18 (L0TXTLFCNPOSTBYPCRED_IN[18], L0TXTLFCNPOSTBYPCRED[18]);
buf B_L0TXTLFCNPOSTBYPCRED19 (L0TXTLFCNPOSTBYPCRED_IN[19], L0TXTLFCNPOSTBYPCRED[19]);
buf B_L0TXTLFCNPOSTBYPCRED20 (L0TXTLFCNPOSTBYPCRED_IN[20], L0TXTLFCNPOSTBYPCRED[20]);
buf B_L0TXTLFCNPOSTBYPCRED21 (L0TXTLFCNPOSTBYPCRED_IN[21], L0TXTLFCNPOSTBYPCRED[21]);
buf B_L0TXTLFCNPOSTBYPCRED22 (L0TXTLFCNPOSTBYPCRED_IN[22], L0TXTLFCNPOSTBYPCRED[22]);
buf B_L0TXTLFCNPOSTBYPCRED23 (L0TXTLFCNPOSTBYPCRED_IN[23], L0TXTLFCNPOSTBYPCRED[23]);
buf B_L0TXTLFCNPOSTBYPCRED24 (L0TXTLFCNPOSTBYPCRED_IN[24], L0TXTLFCNPOSTBYPCRED[24]);
buf B_L0TXTLFCNPOSTBYPCRED25 (L0TXTLFCNPOSTBYPCRED_IN[25], L0TXTLFCNPOSTBYPCRED[25]);
buf B_L0TXTLFCNPOSTBYPCRED26 (L0TXTLFCNPOSTBYPCRED_IN[26], L0TXTLFCNPOSTBYPCRED[26]);
buf B_L0TXTLFCNPOSTBYPCRED27 (L0TXTLFCNPOSTBYPCRED_IN[27], L0TXTLFCNPOSTBYPCRED[27]);
buf B_L0TXTLFCNPOSTBYPCRED28 (L0TXTLFCNPOSTBYPCRED_IN[28], L0TXTLFCNPOSTBYPCRED[28]);
buf B_L0TXTLFCNPOSTBYPCRED29 (L0TXTLFCNPOSTBYPCRED_IN[29], L0TXTLFCNPOSTBYPCRED[29]);
buf B_L0TXTLFCNPOSTBYPCRED30 (L0TXTLFCNPOSTBYPCRED_IN[30], L0TXTLFCNPOSTBYPCRED[30]);
buf B_L0TXTLFCNPOSTBYPCRED31 (L0TXTLFCNPOSTBYPCRED_IN[31], L0TXTLFCNPOSTBYPCRED[31]);
buf B_L0TXTLFCNPOSTBYPCRED32 (L0TXTLFCNPOSTBYPCRED_IN[32], L0TXTLFCNPOSTBYPCRED[32]);
buf B_L0TXTLFCNPOSTBYPCRED33 (L0TXTLFCNPOSTBYPCRED_IN[33], L0TXTLFCNPOSTBYPCRED[33]);
buf B_L0TXTLFCNPOSTBYPCRED34 (L0TXTLFCNPOSTBYPCRED_IN[34], L0TXTLFCNPOSTBYPCRED[34]);
buf B_L0TXTLFCNPOSTBYPCRED35 (L0TXTLFCNPOSTBYPCRED_IN[35], L0TXTLFCNPOSTBYPCRED[35]);
buf B_L0TXTLFCNPOSTBYPCRED36 (L0TXTLFCNPOSTBYPCRED_IN[36], L0TXTLFCNPOSTBYPCRED[36]);
buf B_L0TXTLFCNPOSTBYPCRED37 (L0TXTLFCNPOSTBYPCRED_IN[37], L0TXTLFCNPOSTBYPCRED[37]);
buf B_L0TXTLFCNPOSTBYPCRED38 (L0TXTLFCNPOSTBYPCRED_IN[38], L0TXTLFCNPOSTBYPCRED[38]);
buf B_L0TXTLFCNPOSTBYPCRED39 (L0TXTLFCNPOSTBYPCRED_IN[39], L0TXTLFCNPOSTBYPCRED[39]);
buf B_L0TXTLFCNPOSTBYPCRED40 (L0TXTLFCNPOSTBYPCRED_IN[40], L0TXTLFCNPOSTBYPCRED[40]);
buf B_L0TXTLFCNPOSTBYPCRED41 (L0TXTLFCNPOSTBYPCRED_IN[41], L0TXTLFCNPOSTBYPCRED[41]);
buf B_L0TXTLFCNPOSTBYPCRED42 (L0TXTLFCNPOSTBYPCRED_IN[42], L0TXTLFCNPOSTBYPCRED[42]);
buf B_L0TXTLFCNPOSTBYPCRED43 (L0TXTLFCNPOSTBYPCRED_IN[43], L0TXTLFCNPOSTBYPCRED[43]);
buf B_L0TXTLFCNPOSTBYPCRED44 (L0TXTLFCNPOSTBYPCRED_IN[44], L0TXTLFCNPOSTBYPCRED[44]);
buf B_L0TXTLFCNPOSTBYPCRED45 (L0TXTLFCNPOSTBYPCRED_IN[45], L0TXTLFCNPOSTBYPCRED[45]);
buf B_L0TXTLFCNPOSTBYPCRED46 (L0TXTLFCNPOSTBYPCRED_IN[46], L0TXTLFCNPOSTBYPCRED[46]);
buf B_L0TXTLFCNPOSTBYPCRED47 (L0TXTLFCNPOSTBYPCRED_IN[47], L0TXTLFCNPOSTBYPCRED[47]);
buf B_L0TXTLFCNPOSTBYPCRED48 (L0TXTLFCNPOSTBYPCRED_IN[48], L0TXTLFCNPOSTBYPCRED[48]);
buf B_L0TXTLFCNPOSTBYPCRED49 (L0TXTLFCNPOSTBYPCRED_IN[49], L0TXTLFCNPOSTBYPCRED[49]);
buf B_L0TXTLFCNPOSTBYPCRED50 (L0TXTLFCNPOSTBYPCRED_IN[50], L0TXTLFCNPOSTBYPCRED[50]);
buf B_L0TXTLFCNPOSTBYPCRED51 (L0TXTLFCNPOSTBYPCRED_IN[51], L0TXTLFCNPOSTBYPCRED[51]);
buf B_L0TXTLFCNPOSTBYPCRED52 (L0TXTLFCNPOSTBYPCRED_IN[52], L0TXTLFCNPOSTBYPCRED[52]);
buf B_L0TXTLFCNPOSTBYPCRED53 (L0TXTLFCNPOSTBYPCRED_IN[53], L0TXTLFCNPOSTBYPCRED[53]);
buf B_L0TXTLFCNPOSTBYPCRED54 (L0TXTLFCNPOSTBYPCRED_IN[54], L0TXTLFCNPOSTBYPCRED[54]);
buf B_L0TXTLFCNPOSTBYPCRED55 (L0TXTLFCNPOSTBYPCRED_IN[55], L0TXTLFCNPOSTBYPCRED[55]);
buf B_L0TXTLFCNPOSTBYPCRED56 (L0TXTLFCNPOSTBYPCRED_IN[56], L0TXTLFCNPOSTBYPCRED[56]);
buf B_L0TXTLFCNPOSTBYPCRED57 (L0TXTLFCNPOSTBYPCRED_IN[57], L0TXTLFCNPOSTBYPCRED[57]);
buf B_L0TXTLFCNPOSTBYPCRED58 (L0TXTLFCNPOSTBYPCRED_IN[58], L0TXTLFCNPOSTBYPCRED[58]);
buf B_L0TXTLFCNPOSTBYPCRED59 (L0TXTLFCNPOSTBYPCRED_IN[59], L0TXTLFCNPOSTBYPCRED[59]);
buf B_L0TXTLFCNPOSTBYPCRED60 (L0TXTLFCNPOSTBYPCRED_IN[60], L0TXTLFCNPOSTBYPCRED[60]);
buf B_L0TXTLFCNPOSTBYPCRED61 (L0TXTLFCNPOSTBYPCRED_IN[61], L0TXTLFCNPOSTBYPCRED[61]);
buf B_L0TXTLFCNPOSTBYPCRED62 (L0TXTLFCNPOSTBYPCRED_IN[62], L0TXTLFCNPOSTBYPCRED[62]);
buf B_L0TXTLFCNPOSTBYPCRED63 (L0TXTLFCNPOSTBYPCRED_IN[63], L0TXTLFCNPOSTBYPCRED[63]);
buf B_L0TXTLFCNPOSTBYPCRED64 (L0TXTLFCNPOSTBYPCRED_IN[64], L0TXTLFCNPOSTBYPCRED[64]);
buf B_L0TXTLFCNPOSTBYPCRED65 (L0TXTLFCNPOSTBYPCRED_IN[65], L0TXTLFCNPOSTBYPCRED[65]);
buf B_L0TXTLFCNPOSTBYPCRED66 (L0TXTLFCNPOSTBYPCRED_IN[66], L0TXTLFCNPOSTBYPCRED[66]);
buf B_L0TXTLFCNPOSTBYPCRED67 (L0TXTLFCNPOSTBYPCRED_IN[67], L0TXTLFCNPOSTBYPCRED[67]);
buf B_L0TXTLFCNPOSTBYPCRED68 (L0TXTLFCNPOSTBYPCRED_IN[68], L0TXTLFCNPOSTBYPCRED[68]);
buf B_L0TXTLFCNPOSTBYPCRED69 (L0TXTLFCNPOSTBYPCRED_IN[69], L0TXTLFCNPOSTBYPCRED[69]);
buf B_L0TXTLFCNPOSTBYPCRED70 (L0TXTLFCNPOSTBYPCRED_IN[70], L0TXTLFCNPOSTBYPCRED[70]);
buf B_L0TXTLFCNPOSTBYPCRED71 (L0TXTLFCNPOSTBYPCRED_IN[71], L0TXTLFCNPOSTBYPCRED[71]);
buf B_L0TXTLFCNPOSTBYPCRED72 (L0TXTLFCNPOSTBYPCRED_IN[72], L0TXTLFCNPOSTBYPCRED[72]);
buf B_L0TXTLFCNPOSTBYPCRED73 (L0TXTLFCNPOSTBYPCRED_IN[73], L0TXTLFCNPOSTBYPCRED[73]);
buf B_L0TXTLFCNPOSTBYPCRED74 (L0TXTLFCNPOSTBYPCRED_IN[74], L0TXTLFCNPOSTBYPCRED[74]);
buf B_L0TXTLFCNPOSTBYPCRED75 (L0TXTLFCNPOSTBYPCRED_IN[75], L0TXTLFCNPOSTBYPCRED[75]);
buf B_L0TXTLFCNPOSTBYPCRED76 (L0TXTLFCNPOSTBYPCRED_IN[76], L0TXTLFCNPOSTBYPCRED[76]);
buf B_L0TXTLFCNPOSTBYPCRED77 (L0TXTLFCNPOSTBYPCRED_IN[77], L0TXTLFCNPOSTBYPCRED[77]);
buf B_L0TXTLFCNPOSTBYPCRED78 (L0TXTLFCNPOSTBYPCRED_IN[78], L0TXTLFCNPOSTBYPCRED[78]);
buf B_L0TXTLFCNPOSTBYPCRED79 (L0TXTLFCNPOSTBYPCRED_IN[79], L0TXTLFCNPOSTBYPCRED[79]);
buf B_L0TXTLFCNPOSTBYPCRED80 (L0TXTLFCNPOSTBYPCRED_IN[80], L0TXTLFCNPOSTBYPCRED[80]);
buf B_L0TXTLFCNPOSTBYPCRED81 (L0TXTLFCNPOSTBYPCRED_IN[81], L0TXTLFCNPOSTBYPCRED[81]);
buf B_L0TXTLFCNPOSTBYPCRED82 (L0TXTLFCNPOSTBYPCRED_IN[82], L0TXTLFCNPOSTBYPCRED[82]);
buf B_L0TXTLFCNPOSTBYPCRED83 (L0TXTLFCNPOSTBYPCRED_IN[83], L0TXTLFCNPOSTBYPCRED[83]);
buf B_L0TXTLFCNPOSTBYPCRED84 (L0TXTLFCNPOSTBYPCRED_IN[84], L0TXTLFCNPOSTBYPCRED[84]);
buf B_L0TXTLFCNPOSTBYPCRED85 (L0TXTLFCNPOSTBYPCRED_IN[85], L0TXTLFCNPOSTBYPCRED[85]);
buf B_L0TXTLFCNPOSTBYPCRED86 (L0TXTLFCNPOSTBYPCRED_IN[86], L0TXTLFCNPOSTBYPCRED[86]);
buf B_L0TXTLFCNPOSTBYPCRED87 (L0TXTLFCNPOSTBYPCRED_IN[87], L0TXTLFCNPOSTBYPCRED[87]);
buf B_L0TXTLFCNPOSTBYPCRED88 (L0TXTLFCNPOSTBYPCRED_IN[88], L0TXTLFCNPOSTBYPCRED[88]);
buf B_L0TXTLFCNPOSTBYPCRED89 (L0TXTLFCNPOSTBYPCRED_IN[89], L0TXTLFCNPOSTBYPCRED[89]);
buf B_L0TXTLFCNPOSTBYPCRED90 (L0TXTLFCNPOSTBYPCRED_IN[90], L0TXTLFCNPOSTBYPCRED[90]);
buf B_L0TXTLFCNPOSTBYPCRED91 (L0TXTLFCNPOSTBYPCRED_IN[91], L0TXTLFCNPOSTBYPCRED[91]);
buf B_L0TXTLFCNPOSTBYPCRED92 (L0TXTLFCNPOSTBYPCRED_IN[92], L0TXTLFCNPOSTBYPCRED[92]);
buf B_L0TXTLFCNPOSTBYPCRED93 (L0TXTLFCNPOSTBYPCRED_IN[93], L0TXTLFCNPOSTBYPCRED[93]);
buf B_L0TXTLFCNPOSTBYPCRED94 (L0TXTLFCNPOSTBYPCRED_IN[94], L0TXTLFCNPOSTBYPCRED[94]);
buf B_L0TXTLFCNPOSTBYPCRED95 (L0TXTLFCNPOSTBYPCRED_IN[95], L0TXTLFCNPOSTBYPCRED[95]);
buf B_L0TXTLFCNPOSTBYPCRED96 (L0TXTLFCNPOSTBYPCRED_IN[96], L0TXTLFCNPOSTBYPCRED[96]);
buf B_L0TXTLFCNPOSTBYPCRED97 (L0TXTLFCNPOSTBYPCRED_IN[97], L0TXTLFCNPOSTBYPCRED[97]);
buf B_L0TXTLFCNPOSTBYPCRED98 (L0TXTLFCNPOSTBYPCRED_IN[98], L0TXTLFCNPOSTBYPCRED[98]);
buf B_L0TXTLFCNPOSTBYPCRED99 (L0TXTLFCNPOSTBYPCRED_IN[99], L0TXTLFCNPOSTBYPCRED[99]);
buf B_L0TXTLFCNPOSTBYPCRED100 (L0TXTLFCNPOSTBYPCRED_IN[100], L0TXTLFCNPOSTBYPCRED[100]);
buf B_L0TXTLFCNPOSTBYPCRED101 (L0TXTLFCNPOSTBYPCRED_IN[101], L0TXTLFCNPOSTBYPCRED[101]);
buf B_L0TXTLFCNPOSTBYPCRED102 (L0TXTLFCNPOSTBYPCRED_IN[102], L0TXTLFCNPOSTBYPCRED[102]);
buf B_L0TXTLFCNPOSTBYPCRED103 (L0TXTLFCNPOSTBYPCRED_IN[103], L0TXTLFCNPOSTBYPCRED[103]);
buf B_L0TXTLFCNPOSTBYPCRED104 (L0TXTLFCNPOSTBYPCRED_IN[104], L0TXTLFCNPOSTBYPCRED[104]);
buf B_L0TXTLFCNPOSTBYPCRED105 (L0TXTLFCNPOSTBYPCRED_IN[105], L0TXTLFCNPOSTBYPCRED[105]);
buf B_L0TXTLFCNPOSTBYPCRED106 (L0TXTLFCNPOSTBYPCRED_IN[106], L0TXTLFCNPOSTBYPCRED[106]);
buf B_L0TXTLFCNPOSTBYPCRED107 (L0TXTLFCNPOSTBYPCRED_IN[107], L0TXTLFCNPOSTBYPCRED[107]);
buf B_L0TXTLFCNPOSTBYPCRED108 (L0TXTLFCNPOSTBYPCRED_IN[108], L0TXTLFCNPOSTBYPCRED[108]);
buf B_L0TXTLFCNPOSTBYPCRED109 (L0TXTLFCNPOSTBYPCRED_IN[109], L0TXTLFCNPOSTBYPCRED[109]);
buf B_L0TXTLFCNPOSTBYPCRED110 (L0TXTLFCNPOSTBYPCRED_IN[110], L0TXTLFCNPOSTBYPCRED[110]);
buf B_L0TXTLFCNPOSTBYPCRED111 (L0TXTLFCNPOSTBYPCRED_IN[111], L0TXTLFCNPOSTBYPCRED[111]);
buf B_L0TXTLFCNPOSTBYPCRED112 (L0TXTLFCNPOSTBYPCRED_IN[112], L0TXTLFCNPOSTBYPCRED[112]);
buf B_L0TXTLFCNPOSTBYPCRED113 (L0TXTLFCNPOSTBYPCRED_IN[113], L0TXTLFCNPOSTBYPCRED[113]);
buf B_L0TXTLFCNPOSTBYPCRED114 (L0TXTLFCNPOSTBYPCRED_IN[114], L0TXTLFCNPOSTBYPCRED[114]);
buf B_L0TXTLFCNPOSTBYPCRED115 (L0TXTLFCNPOSTBYPCRED_IN[115], L0TXTLFCNPOSTBYPCRED[115]);
buf B_L0TXTLFCNPOSTBYPCRED116 (L0TXTLFCNPOSTBYPCRED_IN[116], L0TXTLFCNPOSTBYPCRED[116]);
buf B_L0TXTLFCNPOSTBYPCRED117 (L0TXTLFCNPOSTBYPCRED_IN[117], L0TXTLFCNPOSTBYPCRED[117]);
buf B_L0TXTLFCNPOSTBYPCRED118 (L0TXTLFCNPOSTBYPCRED_IN[118], L0TXTLFCNPOSTBYPCRED[118]);
buf B_L0TXTLFCNPOSTBYPCRED119 (L0TXTLFCNPOSTBYPCRED_IN[119], L0TXTLFCNPOSTBYPCRED[119]);
buf B_L0TXTLFCNPOSTBYPCRED120 (L0TXTLFCNPOSTBYPCRED_IN[120], L0TXTLFCNPOSTBYPCRED[120]);
buf B_L0TXTLFCNPOSTBYPCRED121 (L0TXTLFCNPOSTBYPCRED_IN[121], L0TXTLFCNPOSTBYPCRED[121]);
buf B_L0TXTLFCNPOSTBYPCRED122 (L0TXTLFCNPOSTBYPCRED_IN[122], L0TXTLFCNPOSTBYPCRED[122]);
buf B_L0TXTLFCNPOSTBYPCRED123 (L0TXTLFCNPOSTBYPCRED_IN[123], L0TXTLFCNPOSTBYPCRED[123]);
buf B_L0TXTLFCNPOSTBYPCRED124 (L0TXTLFCNPOSTBYPCRED_IN[124], L0TXTLFCNPOSTBYPCRED[124]);
buf B_L0TXTLFCNPOSTBYPCRED125 (L0TXTLFCNPOSTBYPCRED_IN[125], L0TXTLFCNPOSTBYPCRED[125]);
buf B_L0TXTLFCNPOSTBYPCRED126 (L0TXTLFCNPOSTBYPCRED_IN[126], L0TXTLFCNPOSTBYPCRED[126]);
buf B_L0TXTLFCNPOSTBYPCRED127 (L0TXTLFCNPOSTBYPCRED_IN[127], L0TXTLFCNPOSTBYPCRED[127]);
buf B_L0TXTLFCNPOSTBYPCRED128 (L0TXTLFCNPOSTBYPCRED_IN[128], L0TXTLFCNPOSTBYPCRED[128]);
buf B_L0TXTLFCNPOSTBYPCRED129 (L0TXTLFCNPOSTBYPCRED_IN[129], L0TXTLFCNPOSTBYPCRED[129]);
buf B_L0TXTLFCNPOSTBYPCRED130 (L0TXTLFCNPOSTBYPCRED_IN[130], L0TXTLFCNPOSTBYPCRED[130]);
buf B_L0TXTLFCNPOSTBYPCRED131 (L0TXTLFCNPOSTBYPCRED_IN[131], L0TXTLFCNPOSTBYPCRED[131]);
buf B_L0TXTLFCNPOSTBYPCRED132 (L0TXTLFCNPOSTBYPCRED_IN[132], L0TXTLFCNPOSTBYPCRED[132]);
buf B_L0TXTLFCNPOSTBYPCRED133 (L0TXTLFCNPOSTBYPCRED_IN[133], L0TXTLFCNPOSTBYPCRED[133]);
buf B_L0TXTLFCNPOSTBYPCRED134 (L0TXTLFCNPOSTBYPCRED_IN[134], L0TXTLFCNPOSTBYPCRED[134]);
buf B_L0TXTLFCNPOSTBYPCRED135 (L0TXTLFCNPOSTBYPCRED_IN[135], L0TXTLFCNPOSTBYPCRED[135]);
buf B_L0TXTLFCNPOSTBYPCRED136 (L0TXTLFCNPOSTBYPCRED_IN[136], L0TXTLFCNPOSTBYPCRED[136]);
buf B_L0TXTLFCNPOSTBYPCRED137 (L0TXTLFCNPOSTBYPCRED_IN[137], L0TXTLFCNPOSTBYPCRED[137]);
buf B_L0TXTLFCNPOSTBYPCRED138 (L0TXTLFCNPOSTBYPCRED_IN[138], L0TXTLFCNPOSTBYPCRED[138]);
buf B_L0TXTLFCNPOSTBYPCRED139 (L0TXTLFCNPOSTBYPCRED_IN[139], L0TXTLFCNPOSTBYPCRED[139]);
buf B_L0TXTLFCNPOSTBYPCRED140 (L0TXTLFCNPOSTBYPCRED_IN[140], L0TXTLFCNPOSTBYPCRED[140]);
buf B_L0TXTLFCNPOSTBYPCRED141 (L0TXTLFCNPOSTBYPCRED_IN[141], L0TXTLFCNPOSTBYPCRED[141]);
buf B_L0TXTLFCNPOSTBYPCRED142 (L0TXTLFCNPOSTBYPCRED_IN[142], L0TXTLFCNPOSTBYPCRED[142]);
buf B_L0TXTLFCNPOSTBYPCRED143 (L0TXTLFCNPOSTBYPCRED_IN[143], L0TXTLFCNPOSTBYPCRED[143]);
buf B_L0TXTLFCNPOSTBYPCRED144 (L0TXTLFCNPOSTBYPCRED_IN[144], L0TXTLFCNPOSTBYPCRED[144]);
buf B_L0TXTLFCNPOSTBYPCRED145 (L0TXTLFCNPOSTBYPCRED_IN[145], L0TXTLFCNPOSTBYPCRED[145]);
buf B_L0TXTLFCNPOSTBYPCRED146 (L0TXTLFCNPOSTBYPCRED_IN[146], L0TXTLFCNPOSTBYPCRED[146]);
buf B_L0TXTLFCNPOSTBYPCRED147 (L0TXTLFCNPOSTBYPCRED_IN[147], L0TXTLFCNPOSTBYPCRED[147]);
buf B_L0TXTLFCNPOSTBYPCRED148 (L0TXTLFCNPOSTBYPCRED_IN[148], L0TXTLFCNPOSTBYPCRED[148]);
buf B_L0TXTLFCNPOSTBYPCRED149 (L0TXTLFCNPOSTBYPCRED_IN[149], L0TXTLFCNPOSTBYPCRED[149]);
buf B_L0TXTLFCNPOSTBYPCRED150 (L0TXTLFCNPOSTBYPCRED_IN[150], L0TXTLFCNPOSTBYPCRED[150]);
buf B_L0TXTLFCNPOSTBYPCRED151 (L0TXTLFCNPOSTBYPCRED_IN[151], L0TXTLFCNPOSTBYPCRED[151]);
buf B_L0TXTLFCNPOSTBYPCRED152 (L0TXTLFCNPOSTBYPCRED_IN[152], L0TXTLFCNPOSTBYPCRED[152]);
buf B_L0TXTLFCNPOSTBYPCRED153 (L0TXTLFCNPOSTBYPCRED_IN[153], L0TXTLFCNPOSTBYPCRED[153]);
buf B_L0TXTLFCNPOSTBYPCRED154 (L0TXTLFCNPOSTBYPCRED_IN[154], L0TXTLFCNPOSTBYPCRED[154]);
buf B_L0TXTLFCNPOSTBYPCRED155 (L0TXTLFCNPOSTBYPCRED_IN[155], L0TXTLFCNPOSTBYPCRED[155]);
buf B_L0TXTLFCNPOSTBYPCRED156 (L0TXTLFCNPOSTBYPCRED_IN[156], L0TXTLFCNPOSTBYPCRED[156]);
buf B_L0TXTLFCNPOSTBYPCRED157 (L0TXTLFCNPOSTBYPCRED_IN[157], L0TXTLFCNPOSTBYPCRED[157]);
buf B_L0TXTLFCNPOSTBYPCRED158 (L0TXTLFCNPOSTBYPCRED_IN[158], L0TXTLFCNPOSTBYPCRED[158]);
buf B_L0TXTLFCNPOSTBYPCRED159 (L0TXTLFCNPOSTBYPCRED_IN[159], L0TXTLFCNPOSTBYPCRED[159]);
buf B_L0TXTLFCNPOSTBYPCRED160 (L0TXTLFCNPOSTBYPCRED_IN[160], L0TXTLFCNPOSTBYPCRED[160]);
buf B_L0TXTLFCNPOSTBYPCRED161 (L0TXTLFCNPOSTBYPCRED_IN[161], L0TXTLFCNPOSTBYPCRED[161]);
buf B_L0TXTLFCNPOSTBYPCRED162 (L0TXTLFCNPOSTBYPCRED_IN[162], L0TXTLFCNPOSTBYPCRED[162]);
buf B_L0TXTLFCNPOSTBYPCRED163 (L0TXTLFCNPOSTBYPCRED_IN[163], L0TXTLFCNPOSTBYPCRED[163]);
buf B_L0TXTLFCNPOSTBYPCRED164 (L0TXTLFCNPOSTBYPCRED_IN[164], L0TXTLFCNPOSTBYPCRED[164]);
buf B_L0TXTLFCNPOSTBYPCRED165 (L0TXTLFCNPOSTBYPCRED_IN[165], L0TXTLFCNPOSTBYPCRED[165]);
buf B_L0TXTLFCNPOSTBYPCRED166 (L0TXTLFCNPOSTBYPCRED_IN[166], L0TXTLFCNPOSTBYPCRED[166]);
buf B_L0TXTLFCNPOSTBYPCRED167 (L0TXTLFCNPOSTBYPCRED_IN[167], L0TXTLFCNPOSTBYPCRED[167]);
buf B_L0TXTLFCNPOSTBYPCRED168 (L0TXTLFCNPOSTBYPCRED_IN[168], L0TXTLFCNPOSTBYPCRED[168]);
buf B_L0TXTLFCNPOSTBYPCRED169 (L0TXTLFCNPOSTBYPCRED_IN[169], L0TXTLFCNPOSTBYPCRED[169]);
buf B_L0TXTLFCNPOSTBYPCRED170 (L0TXTLFCNPOSTBYPCRED_IN[170], L0TXTLFCNPOSTBYPCRED[170]);
buf B_L0TXTLFCNPOSTBYPCRED171 (L0TXTLFCNPOSTBYPCRED_IN[171], L0TXTLFCNPOSTBYPCRED[171]);
buf B_L0TXTLFCNPOSTBYPCRED172 (L0TXTLFCNPOSTBYPCRED_IN[172], L0TXTLFCNPOSTBYPCRED[172]);
buf B_L0TXTLFCNPOSTBYPCRED173 (L0TXTLFCNPOSTBYPCRED_IN[173], L0TXTLFCNPOSTBYPCRED[173]);
buf B_L0TXTLFCNPOSTBYPCRED174 (L0TXTLFCNPOSTBYPCRED_IN[174], L0TXTLFCNPOSTBYPCRED[174]);
buf B_L0TXTLFCNPOSTBYPCRED175 (L0TXTLFCNPOSTBYPCRED_IN[175], L0TXTLFCNPOSTBYPCRED[175]);
buf B_L0TXTLFCNPOSTBYPCRED176 (L0TXTLFCNPOSTBYPCRED_IN[176], L0TXTLFCNPOSTBYPCRED[176]);
buf B_L0TXTLFCNPOSTBYPCRED177 (L0TXTLFCNPOSTBYPCRED_IN[177], L0TXTLFCNPOSTBYPCRED[177]);
buf B_L0TXTLFCNPOSTBYPCRED178 (L0TXTLFCNPOSTBYPCRED_IN[178], L0TXTLFCNPOSTBYPCRED[178]);
buf B_L0TXTLFCNPOSTBYPCRED179 (L0TXTLFCNPOSTBYPCRED_IN[179], L0TXTLFCNPOSTBYPCRED[179]);
buf B_L0TXTLFCNPOSTBYPCRED180 (L0TXTLFCNPOSTBYPCRED_IN[180], L0TXTLFCNPOSTBYPCRED[180]);
buf B_L0TXTLFCNPOSTBYPCRED181 (L0TXTLFCNPOSTBYPCRED_IN[181], L0TXTLFCNPOSTBYPCRED[181]);
buf B_L0TXTLFCNPOSTBYPCRED182 (L0TXTLFCNPOSTBYPCRED_IN[182], L0TXTLFCNPOSTBYPCRED[182]);
buf B_L0TXTLFCNPOSTBYPCRED183 (L0TXTLFCNPOSTBYPCRED_IN[183], L0TXTLFCNPOSTBYPCRED[183]);
buf B_L0TXTLFCNPOSTBYPCRED184 (L0TXTLFCNPOSTBYPCRED_IN[184], L0TXTLFCNPOSTBYPCRED[184]);
buf B_L0TXTLFCNPOSTBYPCRED185 (L0TXTLFCNPOSTBYPCRED_IN[185], L0TXTLFCNPOSTBYPCRED[185]);
buf B_L0TXTLFCNPOSTBYPCRED186 (L0TXTLFCNPOSTBYPCRED_IN[186], L0TXTLFCNPOSTBYPCRED[186]);
buf B_L0TXTLFCNPOSTBYPCRED187 (L0TXTLFCNPOSTBYPCRED_IN[187], L0TXTLFCNPOSTBYPCRED[187]);
buf B_L0TXTLFCNPOSTBYPCRED188 (L0TXTLFCNPOSTBYPCRED_IN[188], L0TXTLFCNPOSTBYPCRED[188]);
buf B_L0TXTLFCNPOSTBYPCRED189 (L0TXTLFCNPOSTBYPCRED_IN[189], L0TXTLFCNPOSTBYPCRED[189]);
buf B_L0TXTLFCNPOSTBYPCRED190 (L0TXTLFCNPOSTBYPCRED_IN[190], L0TXTLFCNPOSTBYPCRED[190]);
buf B_L0TXTLFCNPOSTBYPCRED191 (L0TXTLFCNPOSTBYPCRED_IN[191], L0TXTLFCNPOSTBYPCRED[191]);
buf B_L0TXTLFCNPOSTBYPUPDATE0 (L0TXTLFCNPOSTBYPUPDATE_IN[0], L0TXTLFCNPOSTBYPUPDATE[0]);
buf B_L0TXTLFCNPOSTBYPUPDATE1 (L0TXTLFCNPOSTBYPUPDATE_IN[1], L0TXTLFCNPOSTBYPUPDATE[1]);
buf B_L0TXTLFCNPOSTBYPUPDATE2 (L0TXTLFCNPOSTBYPUPDATE_IN[2], L0TXTLFCNPOSTBYPUPDATE[2]);
buf B_L0TXTLFCNPOSTBYPUPDATE3 (L0TXTLFCNPOSTBYPUPDATE_IN[3], L0TXTLFCNPOSTBYPUPDATE[3]);
buf B_L0TXTLFCNPOSTBYPUPDATE4 (L0TXTLFCNPOSTBYPUPDATE_IN[4], L0TXTLFCNPOSTBYPUPDATE[4]);
buf B_L0TXTLFCNPOSTBYPUPDATE5 (L0TXTLFCNPOSTBYPUPDATE_IN[5], L0TXTLFCNPOSTBYPUPDATE[5]);
buf B_L0TXTLFCNPOSTBYPUPDATE6 (L0TXTLFCNPOSTBYPUPDATE_IN[6], L0TXTLFCNPOSTBYPUPDATE[6]);
buf B_L0TXTLFCNPOSTBYPUPDATE7 (L0TXTLFCNPOSTBYPUPDATE_IN[7], L0TXTLFCNPOSTBYPUPDATE[7]);
buf B_L0TXTLFCNPOSTBYPUPDATE8 (L0TXTLFCNPOSTBYPUPDATE_IN[8], L0TXTLFCNPOSTBYPUPDATE[8]);
buf B_L0TXTLFCNPOSTBYPUPDATE9 (L0TXTLFCNPOSTBYPUPDATE_IN[9], L0TXTLFCNPOSTBYPUPDATE[9]);
buf B_L0TXTLFCNPOSTBYPUPDATE10 (L0TXTLFCNPOSTBYPUPDATE_IN[10], L0TXTLFCNPOSTBYPUPDATE[10]);
buf B_L0TXTLFCNPOSTBYPUPDATE11 (L0TXTLFCNPOSTBYPUPDATE_IN[11], L0TXTLFCNPOSTBYPUPDATE[11]);
buf B_L0TXTLFCNPOSTBYPUPDATE12 (L0TXTLFCNPOSTBYPUPDATE_IN[12], L0TXTLFCNPOSTBYPUPDATE[12]);
buf B_L0TXTLFCNPOSTBYPUPDATE13 (L0TXTLFCNPOSTBYPUPDATE_IN[13], L0TXTLFCNPOSTBYPUPDATE[13]);
buf B_L0TXTLFCNPOSTBYPUPDATE14 (L0TXTLFCNPOSTBYPUPDATE_IN[14], L0TXTLFCNPOSTBYPUPDATE[14]);
buf B_L0TXTLFCNPOSTBYPUPDATE15 (L0TXTLFCNPOSTBYPUPDATE_IN[15], L0TXTLFCNPOSTBYPUPDATE[15]);
buf B_L0TXTLFCPOSTORDCRED0 (L0TXTLFCPOSTORDCRED_IN[0], L0TXTLFCPOSTORDCRED[0]);
buf B_L0TXTLFCPOSTORDCRED1 (L0TXTLFCPOSTORDCRED_IN[1], L0TXTLFCPOSTORDCRED[1]);
buf B_L0TXTLFCPOSTORDCRED2 (L0TXTLFCPOSTORDCRED_IN[2], L0TXTLFCPOSTORDCRED[2]);
buf B_L0TXTLFCPOSTORDCRED3 (L0TXTLFCPOSTORDCRED_IN[3], L0TXTLFCPOSTORDCRED[3]);
buf B_L0TXTLFCPOSTORDCRED4 (L0TXTLFCPOSTORDCRED_IN[4], L0TXTLFCPOSTORDCRED[4]);
buf B_L0TXTLFCPOSTORDCRED5 (L0TXTLFCPOSTORDCRED_IN[5], L0TXTLFCPOSTORDCRED[5]);
buf B_L0TXTLFCPOSTORDCRED6 (L0TXTLFCPOSTORDCRED_IN[6], L0TXTLFCPOSTORDCRED[6]);
buf B_L0TXTLFCPOSTORDCRED7 (L0TXTLFCPOSTORDCRED_IN[7], L0TXTLFCPOSTORDCRED[7]);
buf B_L0TXTLFCPOSTORDCRED8 (L0TXTLFCPOSTORDCRED_IN[8], L0TXTLFCPOSTORDCRED[8]);
buf B_L0TXTLFCPOSTORDCRED9 (L0TXTLFCPOSTORDCRED_IN[9], L0TXTLFCPOSTORDCRED[9]);
buf B_L0TXTLFCPOSTORDCRED10 (L0TXTLFCPOSTORDCRED_IN[10], L0TXTLFCPOSTORDCRED[10]);
buf B_L0TXTLFCPOSTORDCRED11 (L0TXTLFCPOSTORDCRED_IN[11], L0TXTLFCPOSTORDCRED[11]);
buf B_L0TXTLFCPOSTORDCRED12 (L0TXTLFCPOSTORDCRED_IN[12], L0TXTLFCPOSTORDCRED[12]);
buf B_L0TXTLFCPOSTORDCRED13 (L0TXTLFCPOSTORDCRED_IN[13], L0TXTLFCPOSTORDCRED[13]);
buf B_L0TXTLFCPOSTORDCRED14 (L0TXTLFCPOSTORDCRED_IN[14], L0TXTLFCPOSTORDCRED[14]);
buf B_L0TXTLFCPOSTORDCRED15 (L0TXTLFCPOSTORDCRED_IN[15], L0TXTLFCPOSTORDCRED[15]);
buf B_L0TXTLFCPOSTORDCRED16 (L0TXTLFCPOSTORDCRED_IN[16], L0TXTLFCPOSTORDCRED[16]);
buf B_L0TXTLFCPOSTORDCRED17 (L0TXTLFCPOSTORDCRED_IN[17], L0TXTLFCPOSTORDCRED[17]);
buf B_L0TXTLFCPOSTORDCRED18 (L0TXTLFCPOSTORDCRED_IN[18], L0TXTLFCPOSTORDCRED[18]);
buf B_L0TXTLFCPOSTORDCRED19 (L0TXTLFCPOSTORDCRED_IN[19], L0TXTLFCPOSTORDCRED[19]);
buf B_L0TXTLFCPOSTORDCRED20 (L0TXTLFCPOSTORDCRED_IN[20], L0TXTLFCPOSTORDCRED[20]);
buf B_L0TXTLFCPOSTORDCRED21 (L0TXTLFCPOSTORDCRED_IN[21], L0TXTLFCPOSTORDCRED[21]);
buf B_L0TXTLFCPOSTORDCRED22 (L0TXTLFCPOSTORDCRED_IN[22], L0TXTLFCPOSTORDCRED[22]);
buf B_L0TXTLFCPOSTORDCRED23 (L0TXTLFCPOSTORDCRED_IN[23], L0TXTLFCPOSTORDCRED[23]);
buf B_L0TXTLFCPOSTORDCRED24 (L0TXTLFCPOSTORDCRED_IN[24], L0TXTLFCPOSTORDCRED[24]);
buf B_L0TXTLFCPOSTORDCRED25 (L0TXTLFCPOSTORDCRED_IN[25], L0TXTLFCPOSTORDCRED[25]);
buf B_L0TXTLFCPOSTORDCRED26 (L0TXTLFCPOSTORDCRED_IN[26], L0TXTLFCPOSTORDCRED[26]);
buf B_L0TXTLFCPOSTORDCRED27 (L0TXTLFCPOSTORDCRED_IN[27], L0TXTLFCPOSTORDCRED[27]);
buf B_L0TXTLFCPOSTORDCRED28 (L0TXTLFCPOSTORDCRED_IN[28], L0TXTLFCPOSTORDCRED[28]);
buf B_L0TXTLFCPOSTORDCRED29 (L0TXTLFCPOSTORDCRED_IN[29], L0TXTLFCPOSTORDCRED[29]);
buf B_L0TXTLFCPOSTORDCRED30 (L0TXTLFCPOSTORDCRED_IN[30], L0TXTLFCPOSTORDCRED[30]);
buf B_L0TXTLFCPOSTORDCRED31 (L0TXTLFCPOSTORDCRED_IN[31], L0TXTLFCPOSTORDCRED[31]);
buf B_L0TXTLFCPOSTORDCRED32 (L0TXTLFCPOSTORDCRED_IN[32], L0TXTLFCPOSTORDCRED[32]);
buf B_L0TXTLFCPOSTORDCRED33 (L0TXTLFCPOSTORDCRED_IN[33], L0TXTLFCPOSTORDCRED[33]);
buf B_L0TXTLFCPOSTORDCRED34 (L0TXTLFCPOSTORDCRED_IN[34], L0TXTLFCPOSTORDCRED[34]);
buf B_L0TXTLFCPOSTORDCRED35 (L0TXTLFCPOSTORDCRED_IN[35], L0TXTLFCPOSTORDCRED[35]);
buf B_L0TXTLFCPOSTORDCRED36 (L0TXTLFCPOSTORDCRED_IN[36], L0TXTLFCPOSTORDCRED[36]);
buf B_L0TXTLFCPOSTORDCRED37 (L0TXTLFCPOSTORDCRED_IN[37], L0TXTLFCPOSTORDCRED[37]);
buf B_L0TXTLFCPOSTORDCRED38 (L0TXTLFCPOSTORDCRED_IN[38], L0TXTLFCPOSTORDCRED[38]);
buf B_L0TXTLFCPOSTORDCRED39 (L0TXTLFCPOSTORDCRED_IN[39], L0TXTLFCPOSTORDCRED[39]);
buf B_L0TXTLFCPOSTORDCRED40 (L0TXTLFCPOSTORDCRED_IN[40], L0TXTLFCPOSTORDCRED[40]);
buf B_L0TXTLFCPOSTORDCRED41 (L0TXTLFCPOSTORDCRED_IN[41], L0TXTLFCPOSTORDCRED[41]);
buf B_L0TXTLFCPOSTORDCRED42 (L0TXTLFCPOSTORDCRED_IN[42], L0TXTLFCPOSTORDCRED[42]);
buf B_L0TXTLFCPOSTORDCRED43 (L0TXTLFCPOSTORDCRED_IN[43], L0TXTLFCPOSTORDCRED[43]);
buf B_L0TXTLFCPOSTORDCRED44 (L0TXTLFCPOSTORDCRED_IN[44], L0TXTLFCPOSTORDCRED[44]);
buf B_L0TXTLFCPOSTORDCRED45 (L0TXTLFCPOSTORDCRED_IN[45], L0TXTLFCPOSTORDCRED[45]);
buf B_L0TXTLFCPOSTORDCRED46 (L0TXTLFCPOSTORDCRED_IN[46], L0TXTLFCPOSTORDCRED[46]);
buf B_L0TXTLFCPOSTORDCRED47 (L0TXTLFCPOSTORDCRED_IN[47], L0TXTLFCPOSTORDCRED[47]);
buf B_L0TXTLFCPOSTORDCRED48 (L0TXTLFCPOSTORDCRED_IN[48], L0TXTLFCPOSTORDCRED[48]);
buf B_L0TXTLFCPOSTORDCRED49 (L0TXTLFCPOSTORDCRED_IN[49], L0TXTLFCPOSTORDCRED[49]);
buf B_L0TXTLFCPOSTORDCRED50 (L0TXTLFCPOSTORDCRED_IN[50], L0TXTLFCPOSTORDCRED[50]);
buf B_L0TXTLFCPOSTORDCRED51 (L0TXTLFCPOSTORDCRED_IN[51], L0TXTLFCPOSTORDCRED[51]);
buf B_L0TXTLFCPOSTORDCRED52 (L0TXTLFCPOSTORDCRED_IN[52], L0TXTLFCPOSTORDCRED[52]);
buf B_L0TXTLFCPOSTORDCRED53 (L0TXTLFCPOSTORDCRED_IN[53], L0TXTLFCPOSTORDCRED[53]);
buf B_L0TXTLFCPOSTORDCRED54 (L0TXTLFCPOSTORDCRED_IN[54], L0TXTLFCPOSTORDCRED[54]);
buf B_L0TXTLFCPOSTORDCRED55 (L0TXTLFCPOSTORDCRED_IN[55], L0TXTLFCPOSTORDCRED[55]);
buf B_L0TXTLFCPOSTORDCRED56 (L0TXTLFCPOSTORDCRED_IN[56], L0TXTLFCPOSTORDCRED[56]);
buf B_L0TXTLFCPOSTORDCRED57 (L0TXTLFCPOSTORDCRED_IN[57], L0TXTLFCPOSTORDCRED[57]);
buf B_L0TXTLFCPOSTORDCRED58 (L0TXTLFCPOSTORDCRED_IN[58], L0TXTLFCPOSTORDCRED[58]);
buf B_L0TXTLFCPOSTORDCRED59 (L0TXTLFCPOSTORDCRED_IN[59], L0TXTLFCPOSTORDCRED[59]);
buf B_L0TXTLFCPOSTORDCRED60 (L0TXTLFCPOSTORDCRED_IN[60], L0TXTLFCPOSTORDCRED[60]);
buf B_L0TXTLFCPOSTORDCRED61 (L0TXTLFCPOSTORDCRED_IN[61], L0TXTLFCPOSTORDCRED[61]);
buf B_L0TXTLFCPOSTORDCRED62 (L0TXTLFCPOSTORDCRED_IN[62], L0TXTLFCPOSTORDCRED[62]);
buf B_L0TXTLFCPOSTORDCRED63 (L0TXTLFCPOSTORDCRED_IN[63], L0TXTLFCPOSTORDCRED[63]);
buf B_L0TXTLFCPOSTORDCRED64 (L0TXTLFCPOSTORDCRED_IN[64], L0TXTLFCPOSTORDCRED[64]);
buf B_L0TXTLFCPOSTORDCRED65 (L0TXTLFCPOSTORDCRED_IN[65], L0TXTLFCPOSTORDCRED[65]);
buf B_L0TXTLFCPOSTORDCRED66 (L0TXTLFCPOSTORDCRED_IN[66], L0TXTLFCPOSTORDCRED[66]);
buf B_L0TXTLFCPOSTORDCRED67 (L0TXTLFCPOSTORDCRED_IN[67], L0TXTLFCPOSTORDCRED[67]);
buf B_L0TXTLFCPOSTORDCRED68 (L0TXTLFCPOSTORDCRED_IN[68], L0TXTLFCPOSTORDCRED[68]);
buf B_L0TXTLFCPOSTORDCRED69 (L0TXTLFCPOSTORDCRED_IN[69], L0TXTLFCPOSTORDCRED[69]);
buf B_L0TXTLFCPOSTORDCRED70 (L0TXTLFCPOSTORDCRED_IN[70], L0TXTLFCPOSTORDCRED[70]);
buf B_L0TXTLFCPOSTORDCRED71 (L0TXTLFCPOSTORDCRED_IN[71], L0TXTLFCPOSTORDCRED[71]);
buf B_L0TXTLFCPOSTORDCRED72 (L0TXTLFCPOSTORDCRED_IN[72], L0TXTLFCPOSTORDCRED[72]);
buf B_L0TXTLFCPOSTORDCRED73 (L0TXTLFCPOSTORDCRED_IN[73], L0TXTLFCPOSTORDCRED[73]);
buf B_L0TXTLFCPOSTORDCRED74 (L0TXTLFCPOSTORDCRED_IN[74], L0TXTLFCPOSTORDCRED[74]);
buf B_L0TXTLFCPOSTORDCRED75 (L0TXTLFCPOSTORDCRED_IN[75], L0TXTLFCPOSTORDCRED[75]);
buf B_L0TXTLFCPOSTORDCRED76 (L0TXTLFCPOSTORDCRED_IN[76], L0TXTLFCPOSTORDCRED[76]);
buf B_L0TXTLFCPOSTORDCRED77 (L0TXTLFCPOSTORDCRED_IN[77], L0TXTLFCPOSTORDCRED[77]);
buf B_L0TXTLFCPOSTORDCRED78 (L0TXTLFCPOSTORDCRED_IN[78], L0TXTLFCPOSTORDCRED[78]);
buf B_L0TXTLFCPOSTORDCRED79 (L0TXTLFCPOSTORDCRED_IN[79], L0TXTLFCPOSTORDCRED[79]);
buf B_L0TXTLFCPOSTORDCRED80 (L0TXTLFCPOSTORDCRED_IN[80], L0TXTLFCPOSTORDCRED[80]);
buf B_L0TXTLFCPOSTORDCRED81 (L0TXTLFCPOSTORDCRED_IN[81], L0TXTLFCPOSTORDCRED[81]);
buf B_L0TXTLFCPOSTORDCRED82 (L0TXTLFCPOSTORDCRED_IN[82], L0TXTLFCPOSTORDCRED[82]);
buf B_L0TXTLFCPOSTORDCRED83 (L0TXTLFCPOSTORDCRED_IN[83], L0TXTLFCPOSTORDCRED[83]);
buf B_L0TXTLFCPOSTORDCRED84 (L0TXTLFCPOSTORDCRED_IN[84], L0TXTLFCPOSTORDCRED[84]);
buf B_L0TXTLFCPOSTORDCRED85 (L0TXTLFCPOSTORDCRED_IN[85], L0TXTLFCPOSTORDCRED[85]);
buf B_L0TXTLFCPOSTORDCRED86 (L0TXTLFCPOSTORDCRED_IN[86], L0TXTLFCPOSTORDCRED[86]);
buf B_L0TXTLFCPOSTORDCRED87 (L0TXTLFCPOSTORDCRED_IN[87], L0TXTLFCPOSTORDCRED[87]);
buf B_L0TXTLFCPOSTORDCRED88 (L0TXTLFCPOSTORDCRED_IN[88], L0TXTLFCPOSTORDCRED[88]);
buf B_L0TXTLFCPOSTORDCRED89 (L0TXTLFCPOSTORDCRED_IN[89], L0TXTLFCPOSTORDCRED[89]);
buf B_L0TXTLFCPOSTORDCRED90 (L0TXTLFCPOSTORDCRED_IN[90], L0TXTLFCPOSTORDCRED[90]);
buf B_L0TXTLFCPOSTORDCRED91 (L0TXTLFCPOSTORDCRED_IN[91], L0TXTLFCPOSTORDCRED[91]);
buf B_L0TXTLFCPOSTORDCRED92 (L0TXTLFCPOSTORDCRED_IN[92], L0TXTLFCPOSTORDCRED[92]);
buf B_L0TXTLFCPOSTORDCRED93 (L0TXTLFCPOSTORDCRED_IN[93], L0TXTLFCPOSTORDCRED[93]);
buf B_L0TXTLFCPOSTORDCRED94 (L0TXTLFCPOSTORDCRED_IN[94], L0TXTLFCPOSTORDCRED[94]);
buf B_L0TXTLFCPOSTORDCRED95 (L0TXTLFCPOSTORDCRED_IN[95], L0TXTLFCPOSTORDCRED[95]);
buf B_L0TXTLFCPOSTORDCRED96 (L0TXTLFCPOSTORDCRED_IN[96], L0TXTLFCPOSTORDCRED[96]);
buf B_L0TXTLFCPOSTORDCRED97 (L0TXTLFCPOSTORDCRED_IN[97], L0TXTLFCPOSTORDCRED[97]);
buf B_L0TXTLFCPOSTORDCRED98 (L0TXTLFCPOSTORDCRED_IN[98], L0TXTLFCPOSTORDCRED[98]);
buf B_L0TXTLFCPOSTORDCRED99 (L0TXTLFCPOSTORDCRED_IN[99], L0TXTLFCPOSTORDCRED[99]);
buf B_L0TXTLFCPOSTORDCRED100 (L0TXTLFCPOSTORDCRED_IN[100], L0TXTLFCPOSTORDCRED[100]);
buf B_L0TXTLFCPOSTORDCRED101 (L0TXTLFCPOSTORDCRED_IN[101], L0TXTLFCPOSTORDCRED[101]);
buf B_L0TXTLFCPOSTORDCRED102 (L0TXTLFCPOSTORDCRED_IN[102], L0TXTLFCPOSTORDCRED[102]);
buf B_L0TXTLFCPOSTORDCRED103 (L0TXTLFCPOSTORDCRED_IN[103], L0TXTLFCPOSTORDCRED[103]);
buf B_L0TXTLFCPOSTORDCRED104 (L0TXTLFCPOSTORDCRED_IN[104], L0TXTLFCPOSTORDCRED[104]);
buf B_L0TXTLFCPOSTORDCRED105 (L0TXTLFCPOSTORDCRED_IN[105], L0TXTLFCPOSTORDCRED[105]);
buf B_L0TXTLFCPOSTORDCRED106 (L0TXTLFCPOSTORDCRED_IN[106], L0TXTLFCPOSTORDCRED[106]);
buf B_L0TXTLFCPOSTORDCRED107 (L0TXTLFCPOSTORDCRED_IN[107], L0TXTLFCPOSTORDCRED[107]);
buf B_L0TXTLFCPOSTORDCRED108 (L0TXTLFCPOSTORDCRED_IN[108], L0TXTLFCPOSTORDCRED[108]);
buf B_L0TXTLFCPOSTORDCRED109 (L0TXTLFCPOSTORDCRED_IN[109], L0TXTLFCPOSTORDCRED[109]);
buf B_L0TXTLFCPOSTORDCRED110 (L0TXTLFCPOSTORDCRED_IN[110], L0TXTLFCPOSTORDCRED[110]);
buf B_L0TXTLFCPOSTORDCRED111 (L0TXTLFCPOSTORDCRED_IN[111], L0TXTLFCPOSTORDCRED[111]);
buf B_L0TXTLFCPOSTORDCRED112 (L0TXTLFCPOSTORDCRED_IN[112], L0TXTLFCPOSTORDCRED[112]);
buf B_L0TXTLFCPOSTORDCRED113 (L0TXTLFCPOSTORDCRED_IN[113], L0TXTLFCPOSTORDCRED[113]);
buf B_L0TXTLFCPOSTORDCRED114 (L0TXTLFCPOSTORDCRED_IN[114], L0TXTLFCPOSTORDCRED[114]);
buf B_L0TXTLFCPOSTORDCRED115 (L0TXTLFCPOSTORDCRED_IN[115], L0TXTLFCPOSTORDCRED[115]);
buf B_L0TXTLFCPOSTORDCRED116 (L0TXTLFCPOSTORDCRED_IN[116], L0TXTLFCPOSTORDCRED[116]);
buf B_L0TXTLFCPOSTORDCRED117 (L0TXTLFCPOSTORDCRED_IN[117], L0TXTLFCPOSTORDCRED[117]);
buf B_L0TXTLFCPOSTORDCRED118 (L0TXTLFCPOSTORDCRED_IN[118], L0TXTLFCPOSTORDCRED[118]);
buf B_L0TXTLFCPOSTORDCRED119 (L0TXTLFCPOSTORDCRED_IN[119], L0TXTLFCPOSTORDCRED[119]);
buf B_L0TXTLFCPOSTORDCRED120 (L0TXTLFCPOSTORDCRED_IN[120], L0TXTLFCPOSTORDCRED[120]);
buf B_L0TXTLFCPOSTORDCRED121 (L0TXTLFCPOSTORDCRED_IN[121], L0TXTLFCPOSTORDCRED[121]);
buf B_L0TXTLFCPOSTORDCRED122 (L0TXTLFCPOSTORDCRED_IN[122], L0TXTLFCPOSTORDCRED[122]);
buf B_L0TXTLFCPOSTORDCRED123 (L0TXTLFCPOSTORDCRED_IN[123], L0TXTLFCPOSTORDCRED[123]);
buf B_L0TXTLFCPOSTORDCRED124 (L0TXTLFCPOSTORDCRED_IN[124], L0TXTLFCPOSTORDCRED[124]);
buf B_L0TXTLFCPOSTORDCRED125 (L0TXTLFCPOSTORDCRED_IN[125], L0TXTLFCPOSTORDCRED[125]);
buf B_L0TXTLFCPOSTORDCRED126 (L0TXTLFCPOSTORDCRED_IN[126], L0TXTLFCPOSTORDCRED[126]);
buf B_L0TXTLFCPOSTORDCRED127 (L0TXTLFCPOSTORDCRED_IN[127], L0TXTLFCPOSTORDCRED[127]);
buf B_L0TXTLFCPOSTORDCRED128 (L0TXTLFCPOSTORDCRED_IN[128], L0TXTLFCPOSTORDCRED[128]);
buf B_L0TXTLFCPOSTORDCRED129 (L0TXTLFCPOSTORDCRED_IN[129], L0TXTLFCPOSTORDCRED[129]);
buf B_L0TXTLFCPOSTORDCRED130 (L0TXTLFCPOSTORDCRED_IN[130], L0TXTLFCPOSTORDCRED[130]);
buf B_L0TXTLFCPOSTORDCRED131 (L0TXTLFCPOSTORDCRED_IN[131], L0TXTLFCPOSTORDCRED[131]);
buf B_L0TXTLFCPOSTORDCRED132 (L0TXTLFCPOSTORDCRED_IN[132], L0TXTLFCPOSTORDCRED[132]);
buf B_L0TXTLFCPOSTORDCRED133 (L0TXTLFCPOSTORDCRED_IN[133], L0TXTLFCPOSTORDCRED[133]);
buf B_L0TXTLFCPOSTORDCRED134 (L0TXTLFCPOSTORDCRED_IN[134], L0TXTLFCPOSTORDCRED[134]);
buf B_L0TXTLFCPOSTORDCRED135 (L0TXTLFCPOSTORDCRED_IN[135], L0TXTLFCPOSTORDCRED[135]);
buf B_L0TXTLFCPOSTORDCRED136 (L0TXTLFCPOSTORDCRED_IN[136], L0TXTLFCPOSTORDCRED[136]);
buf B_L0TXTLFCPOSTORDCRED137 (L0TXTLFCPOSTORDCRED_IN[137], L0TXTLFCPOSTORDCRED[137]);
buf B_L0TXTLFCPOSTORDCRED138 (L0TXTLFCPOSTORDCRED_IN[138], L0TXTLFCPOSTORDCRED[138]);
buf B_L0TXTLFCPOSTORDCRED139 (L0TXTLFCPOSTORDCRED_IN[139], L0TXTLFCPOSTORDCRED[139]);
buf B_L0TXTLFCPOSTORDCRED140 (L0TXTLFCPOSTORDCRED_IN[140], L0TXTLFCPOSTORDCRED[140]);
buf B_L0TXTLFCPOSTORDCRED141 (L0TXTLFCPOSTORDCRED_IN[141], L0TXTLFCPOSTORDCRED[141]);
buf B_L0TXTLFCPOSTORDCRED142 (L0TXTLFCPOSTORDCRED_IN[142], L0TXTLFCPOSTORDCRED[142]);
buf B_L0TXTLFCPOSTORDCRED143 (L0TXTLFCPOSTORDCRED_IN[143], L0TXTLFCPOSTORDCRED[143]);
buf B_L0TXTLFCPOSTORDCRED144 (L0TXTLFCPOSTORDCRED_IN[144], L0TXTLFCPOSTORDCRED[144]);
buf B_L0TXTLFCPOSTORDCRED145 (L0TXTLFCPOSTORDCRED_IN[145], L0TXTLFCPOSTORDCRED[145]);
buf B_L0TXTLFCPOSTORDCRED146 (L0TXTLFCPOSTORDCRED_IN[146], L0TXTLFCPOSTORDCRED[146]);
buf B_L0TXTLFCPOSTORDCRED147 (L0TXTLFCPOSTORDCRED_IN[147], L0TXTLFCPOSTORDCRED[147]);
buf B_L0TXTLFCPOSTORDCRED148 (L0TXTLFCPOSTORDCRED_IN[148], L0TXTLFCPOSTORDCRED[148]);
buf B_L0TXTLFCPOSTORDCRED149 (L0TXTLFCPOSTORDCRED_IN[149], L0TXTLFCPOSTORDCRED[149]);
buf B_L0TXTLFCPOSTORDCRED150 (L0TXTLFCPOSTORDCRED_IN[150], L0TXTLFCPOSTORDCRED[150]);
buf B_L0TXTLFCPOSTORDCRED151 (L0TXTLFCPOSTORDCRED_IN[151], L0TXTLFCPOSTORDCRED[151]);
buf B_L0TXTLFCPOSTORDCRED152 (L0TXTLFCPOSTORDCRED_IN[152], L0TXTLFCPOSTORDCRED[152]);
buf B_L0TXTLFCPOSTORDCRED153 (L0TXTLFCPOSTORDCRED_IN[153], L0TXTLFCPOSTORDCRED[153]);
buf B_L0TXTLFCPOSTORDCRED154 (L0TXTLFCPOSTORDCRED_IN[154], L0TXTLFCPOSTORDCRED[154]);
buf B_L0TXTLFCPOSTORDCRED155 (L0TXTLFCPOSTORDCRED_IN[155], L0TXTLFCPOSTORDCRED[155]);
buf B_L0TXTLFCPOSTORDCRED156 (L0TXTLFCPOSTORDCRED_IN[156], L0TXTLFCPOSTORDCRED[156]);
buf B_L0TXTLFCPOSTORDCRED157 (L0TXTLFCPOSTORDCRED_IN[157], L0TXTLFCPOSTORDCRED[157]);
buf B_L0TXTLFCPOSTORDCRED158 (L0TXTLFCPOSTORDCRED_IN[158], L0TXTLFCPOSTORDCRED[158]);
buf B_L0TXTLFCPOSTORDCRED159 (L0TXTLFCPOSTORDCRED_IN[159], L0TXTLFCPOSTORDCRED[159]);
buf B_L0TXTLFCPOSTORDUPDATE0 (L0TXTLFCPOSTORDUPDATE_IN[0], L0TXTLFCPOSTORDUPDATE[0]);
buf B_L0TXTLFCPOSTORDUPDATE1 (L0TXTLFCPOSTORDUPDATE_IN[1], L0TXTLFCPOSTORDUPDATE[1]);
buf B_L0TXTLFCPOSTORDUPDATE2 (L0TXTLFCPOSTORDUPDATE_IN[2], L0TXTLFCPOSTORDUPDATE[2]);
buf B_L0TXTLFCPOSTORDUPDATE3 (L0TXTLFCPOSTORDUPDATE_IN[3], L0TXTLFCPOSTORDUPDATE[3]);
buf B_L0TXTLFCPOSTORDUPDATE4 (L0TXTLFCPOSTORDUPDATE_IN[4], L0TXTLFCPOSTORDUPDATE[4]);
buf B_L0TXTLFCPOSTORDUPDATE5 (L0TXTLFCPOSTORDUPDATE_IN[5], L0TXTLFCPOSTORDUPDATE[5]);
buf B_L0TXTLFCPOSTORDUPDATE6 (L0TXTLFCPOSTORDUPDATE_IN[6], L0TXTLFCPOSTORDUPDATE[6]);
buf B_L0TXTLFCPOSTORDUPDATE7 (L0TXTLFCPOSTORDUPDATE_IN[7], L0TXTLFCPOSTORDUPDATE[7]);
buf B_L0TXTLFCPOSTORDUPDATE8 (L0TXTLFCPOSTORDUPDATE_IN[8], L0TXTLFCPOSTORDUPDATE[8]);
buf B_L0TXTLFCPOSTORDUPDATE9 (L0TXTLFCPOSTORDUPDATE_IN[9], L0TXTLFCPOSTORDUPDATE[9]);
buf B_L0TXTLFCPOSTORDUPDATE10 (L0TXTLFCPOSTORDUPDATE_IN[10], L0TXTLFCPOSTORDUPDATE[10]);
buf B_L0TXTLFCPOSTORDUPDATE11 (L0TXTLFCPOSTORDUPDATE_IN[11], L0TXTLFCPOSTORDUPDATE[11]);
buf B_L0TXTLFCPOSTORDUPDATE12 (L0TXTLFCPOSTORDUPDATE_IN[12], L0TXTLFCPOSTORDUPDATE[12]);
buf B_L0TXTLFCPOSTORDUPDATE13 (L0TXTLFCPOSTORDUPDATE_IN[13], L0TXTLFCPOSTORDUPDATE[13]);
buf B_L0TXTLFCPOSTORDUPDATE14 (L0TXTLFCPOSTORDUPDATE_IN[14], L0TXTLFCPOSTORDUPDATE[14]);
buf B_L0TXTLFCPOSTORDUPDATE15 (L0TXTLFCPOSTORDUPDATE_IN[15], L0TXTLFCPOSTORDUPDATE[15]);
buf B_L0TXTLFCCMPLMCCRED0 (L0TXTLFCCMPLMCCRED_IN[0], L0TXTLFCCMPLMCCRED[0]);
buf B_L0TXTLFCCMPLMCCRED1 (L0TXTLFCCMPLMCCRED_IN[1], L0TXTLFCCMPLMCCRED[1]);
buf B_L0TXTLFCCMPLMCCRED2 (L0TXTLFCCMPLMCCRED_IN[2], L0TXTLFCCMPLMCCRED[2]);
buf B_L0TXTLFCCMPLMCCRED3 (L0TXTLFCCMPLMCCRED_IN[3], L0TXTLFCCMPLMCCRED[3]);
buf B_L0TXTLFCCMPLMCCRED4 (L0TXTLFCCMPLMCCRED_IN[4], L0TXTLFCCMPLMCCRED[4]);
buf B_L0TXTLFCCMPLMCCRED5 (L0TXTLFCCMPLMCCRED_IN[5], L0TXTLFCCMPLMCCRED[5]);
buf B_L0TXTLFCCMPLMCCRED6 (L0TXTLFCCMPLMCCRED_IN[6], L0TXTLFCCMPLMCCRED[6]);
buf B_L0TXTLFCCMPLMCCRED7 (L0TXTLFCCMPLMCCRED_IN[7], L0TXTLFCCMPLMCCRED[7]);
buf B_L0TXTLFCCMPLMCCRED8 (L0TXTLFCCMPLMCCRED_IN[8], L0TXTLFCCMPLMCCRED[8]);
buf B_L0TXTLFCCMPLMCCRED9 (L0TXTLFCCMPLMCCRED_IN[9], L0TXTLFCCMPLMCCRED[9]);
buf B_L0TXTLFCCMPLMCCRED10 (L0TXTLFCCMPLMCCRED_IN[10], L0TXTLFCCMPLMCCRED[10]);
buf B_L0TXTLFCCMPLMCCRED11 (L0TXTLFCCMPLMCCRED_IN[11], L0TXTLFCCMPLMCCRED[11]);
buf B_L0TXTLFCCMPLMCCRED12 (L0TXTLFCCMPLMCCRED_IN[12], L0TXTLFCCMPLMCCRED[12]);
buf B_L0TXTLFCCMPLMCCRED13 (L0TXTLFCCMPLMCCRED_IN[13], L0TXTLFCCMPLMCCRED[13]);
buf B_L0TXTLFCCMPLMCCRED14 (L0TXTLFCCMPLMCCRED_IN[14], L0TXTLFCCMPLMCCRED[14]);
buf B_L0TXTLFCCMPLMCCRED15 (L0TXTLFCCMPLMCCRED_IN[15], L0TXTLFCCMPLMCCRED[15]);
buf B_L0TXTLFCCMPLMCCRED16 (L0TXTLFCCMPLMCCRED_IN[16], L0TXTLFCCMPLMCCRED[16]);
buf B_L0TXTLFCCMPLMCCRED17 (L0TXTLFCCMPLMCCRED_IN[17], L0TXTLFCCMPLMCCRED[17]);
buf B_L0TXTLFCCMPLMCCRED18 (L0TXTLFCCMPLMCCRED_IN[18], L0TXTLFCCMPLMCCRED[18]);
buf B_L0TXTLFCCMPLMCCRED19 (L0TXTLFCCMPLMCCRED_IN[19], L0TXTLFCCMPLMCCRED[19]);
buf B_L0TXTLFCCMPLMCCRED20 (L0TXTLFCCMPLMCCRED_IN[20], L0TXTLFCCMPLMCCRED[20]);
buf B_L0TXTLFCCMPLMCCRED21 (L0TXTLFCCMPLMCCRED_IN[21], L0TXTLFCCMPLMCCRED[21]);
buf B_L0TXTLFCCMPLMCCRED22 (L0TXTLFCCMPLMCCRED_IN[22], L0TXTLFCCMPLMCCRED[22]);
buf B_L0TXTLFCCMPLMCCRED23 (L0TXTLFCCMPLMCCRED_IN[23], L0TXTLFCCMPLMCCRED[23]);
buf B_L0TXTLFCCMPLMCCRED24 (L0TXTLFCCMPLMCCRED_IN[24], L0TXTLFCCMPLMCCRED[24]);
buf B_L0TXTLFCCMPLMCCRED25 (L0TXTLFCCMPLMCCRED_IN[25], L0TXTLFCCMPLMCCRED[25]);
buf B_L0TXTLFCCMPLMCCRED26 (L0TXTLFCCMPLMCCRED_IN[26], L0TXTLFCCMPLMCCRED[26]);
buf B_L0TXTLFCCMPLMCCRED27 (L0TXTLFCCMPLMCCRED_IN[27], L0TXTLFCCMPLMCCRED[27]);
buf B_L0TXTLFCCMPLMCCRED28 (L0TXTLFCCMPLMCCRED_IN[28], L0TXTLFCCMPLMCCRED[28]);
buf B_L0TXTLFCCMPLMCCRED29 (L0TXTLFCCMPLMCCRED_IN[29], L0TXTLFCCMPLMCCRED[29]);
buf B_L0TXTLFCCMPLMCCRED30 (L0TXTLFCCMPLMCCRED_IN[30], L0TXTLFCCMPLMCCRED[30]);
buf B_L0TXTLFCCMPLMCCRED31 (L0TXTLFCCMPLMCCRED_IN[31], L0TXTLFCCMPLMCCRED[31]);
buf B_L0TXTLFCCMPLMCCRED32 (L0TXTLFCCMPLMCCRED_IN[32], L0TXTLFCCMPLMCCRED[32]);
buf B_L0TXTLFCCMPLMCCRED33 (L0TXTLFCCMPLMCCRED_IN[33], L0TXTLFCCMPLMCCRED[33]);
buf B_L0TXTLFCCMPLMCCRED34 (L0TXTLFCCMPLMCCRED_IN[34], L0TXTLFCCMPLMCCRED[34]);
buf B_L0TXTLFCCMPLMCCRED35 (L0TXTLFCCMPLMCCRED_IN[35], L0TXTLFCCMPLMCCRED[35]);
buf B_L0TXTLFCCMPLMCCRED36 (L0TXTLFCCMPLMCCRED_IN[36], L0TXTLFCCMPLMCCRED[36]);
buf B_L0TXTLFCCMPLMCCRED37 (L0TXTLFCCMPLMCCRED_IN[37], L0TXTLFCCMPLMCCRED[37]);
buf B_L0TXTLFCCMPLMCCRED38 (L0TXTLFCCMPLMCCRED_IN[38], L0TXTLFCCMPLMCCRED[38]);
buf B_L0TXTLFCCMPLMCCRED39 (L0TXTLFCCMPLMCCRED_IN[39], L0TXTLFCCMPLMCCRED[39]);
buf B_L0TXTLFCCMPLMCCRED40 (L0TXTLFCCMPLMCCRED_IN[40], L0TXTLFCCMPLMCCRED[40]);
buf B_L0TXTLFCCMPLMCCRED41 (L0TXTLFCCMPLMCCRED_IN[41], L0TXTLFCCMPLMCCRED[41]);
buf B_L0TXTLFCCMPLMCCRED42 (L0TXTLFCCMPLMCCRED_IN[42], L0TXTLFCCMPLMCCRED[42]);
buf B_L0TXTLFCCMPLMCCRED43 (L0TXTLFCCMPLMCCRED_IN[43], L0TXTLFCCMPLMCCRED[43]);
buf B_L0TXTLFCCMPLMCCRED44 (L0TXTLFCCMPLMCCRED_IN[44], L0TXTLFCCMPLMCCRED[44]);
buf B_L0TXTLFCCMPLMCCRED45 (L0TXTLFCCMPLMCCRED_IN[45], L0TXTLFCCMPLMCCRED[45]);
buf B_L0TXTLFCCMPLMCCRED46 (L0TXTLFCCMPLMCCRED_IN[46], L0TXTLFCCMPLMCCRED[46]);
buf B_L0TXTLFCCMPLMCCRED47 (L0TXTLFCCMPLMCCRED_IN[47], L0TXTLFCCMPLMCCRED[47]);
buf B_L0TXTLFCCMPLMCCRED48 (L0TXTLFCCMPLMCCRED_IN[48], L0TXTLFCCMPLMCCRED[48]);
buf B_L0TXTLFCCMPLMCCRED49 (L0TXTLFCCMPLMCCRED_IN[49], L0TXTLFCCMPLMCCRED[49]);
buf B_L0TXTLFCCMPLMCCRED50 (L0TXTLFCCMPLMCCRED_IN[50], L0TXTLFCCMPLMCCRED[50]);
buf B_L0TXTLFCCMPLMCCRED51 (L0TXTLFCCMPLMCCRED_IN[51], L0TXTLFCCMPLMCCRED[51]);
buf B_L0TXTLFCCMPLMCCRED52 (L0TXTLFCCMPLMCCRED_IN[52], L0TXTLFCCMPLMCCRED[52]);
buf B_L0TXTLFCCMPLMCCRED53 (L0TXTLFCCMPLMCCRED_IN[53], L0TXTLFCCMPLMCCRED[53]);
buf B_L0TXTLFCCMPLMCCRED54 (L0TXTLFCCMPLMCCRED_IN[54], L0TXTLFCCMPLMCCRED[54]);
buf B_L0TXTLFCCMPLMCCRED55 (L0TXTLFCCMPLMCCRED_IN[55], L0TXTLFCCMPLMCCRED[55]);
buf B_L0TXTLFCCMPLMCCRED56 (L0TXTLFCCMPLMCCRED_IN[56], L0TXTLFCCMPLMCCRED[56]);
buf B_L0TXTLFCCMPLMCCRED57 (L0TXTLFCCMPLMCCRED_IN[57], L0TXTLFCCMPLMCCRED[57]);
buf B_L0TXTLFCCMPLMCCRED58 (L0TXTLFCCMPLMCCRED_IN[58], L0TXTLFCCMPLMCCRED[58]);
buf B_L0TXTLFCCMPLMCCRED59 (L0TXTLFCCMPLMCCRED_IN[59], L0TXTLFCCMPLMCCRED[59]);
buf B_L0TXTLFCCMPLMCCRED60 (L0TXTLFCCMPLMCCRED_IN[60], L0TXTLFCCMPLMCCRED[60]);
buf B_L0TXTLFCCMPLMCCRED61 (L0TXTLFCCMPLMCCRED_IN[61], L0TXTLFCCMPLMCCRED[61]);
buf B_L0TXTLFCCMPLMCCRED62 (L0TXTLFCCMPLMCCRED_IN[62], L0TXTLFCCMPLMCCRED[62]);
buf B_L0TXTLFCCMPLMCCRED63 (L0TXTLFCCMPLMCCRED_IN[63], L0TXTLFCCMPLMCCRED[63]);
buf B_L0TXTLFCCMPLMCCRED64 (L0TXTLFCCMPLMCCRED_IN[64], L0TXTLFCCMPLMCCRED[64]);
buf B_L0TXTLFCCMPLMCCRED65 (L0TXTLFCCMPLMCCRED_IN[65], L0TXTLFCCMPLMCCRED[65]);
buf B_L0TXTLFCCMPLMCCRED66 (L0TXTLFCCMPLMCCRED_IN[66], L0TXTLFCCMPLMCCRED[66]);
buf B_L0TXTLFCCMPLMCCRED67 (L0TXTLFCCMPLMCCRED_IN[67], L0TXTLFCCMPLMCCRED[67]);
buf B_L0TXTLFCCMPLMCCRED68 (L0TXTLFCCMPLMCCRED_IN[68], L0TXTLFCCMPLMCCRED[68]);
buf B_L0TXTLFCCMPLMCCRED69 (L0TXTLFCCMPLMCCRED_IN[69], L0TXTLFCCMPLMCCRED[69]);
buf B_L0TXTLFCCMPLMCCRED70 (L0TXTLFCCMPLMCCRED_IN[70], L0TXTLFCCMPLMCCRED[70]);
buf B_L0TXTLFCCMPLMCCRED71 (L0TXTLFCCMPLMCCRED_IN[71], L0TXTLFCCMPLMCCRED[71]);
buf B_L0TXTLFCCMPLMCCRED72 (L0TXTLFCCMPLMCCRED_IN[72], L0TXTLFCCMPLMCCRED[72]);
buf B_L0TXTLFCCMPLMCCRED73 (L0TXTLFCCMPLMCCRED_IN[73], L0TXTLFCCMPLMCCRED[73]);
buf B_L0TXTLFCCMPLMCCRED74 (L0TXTLFCCMPLMCCRED_IN[74], L0TXTLFCCMPLMCCRED[74]);
buf B_L0TXTLFCCMPLMCCRED75 (L0TXTLFCCMPLMCCRED_IN[75], L0TXTLFCCMPLMCCRED[75]);
buf B_L0TXTLFCCMPLMCCRED76 (L0TXTLFCCMPLMCCRED_IN[76], L0TXTLFCCMPLMCCRED[76]);
buf B_L0TXTLFCCMPLMCCRED77 (L0TXTLFCCMPLMCCRED_IN[77], L0TXTLFCCMPLMCCRED[77]);
buf B_L0TXTLFCCMPLMCCRED78 (L0TXTLFCCMPLMCCRED_IN[78], L0TXTLFCCMPLMCCRED[78]);
buf B_L0TXTLFCCMPLMCCRED79 (L0TXTLFCCMPLMCCRED_IN[79], L0TXTLFCCMPLMCCRED[79]);
buf B_L0TXTLFCCMPLMCCRED80 (L0TXTLFCCMPLMCCRED_IN[80], L0TXTLFCCMPLMCCRED[80]);
buf B_L0TXTLFCCMPLMCCRED81 (L0TXTLFCCMPLMCCRED_IN[81], L0TXTLFCCMPLMCCRED[81]);
buf B_L0TXTLFCCMPLMCCRED82 (L0TXTLFCCMPLMCCRED_IN[82], L0TXTLFCCMPLMCCRED[82]);
buf B_L0TXTLFCCMPLMCCRED83 (L0TXTLFCCMPLMCCRED_IN[83], L0TXTLFCCMPLMCCRED[83]);
buf B_L0TXTLFCCMPLMCCRED84 (L0TXTLFCCMPLMCCRED_IN[84], L0TXTLFCCMPLMCCRED[84]);
buf B_L0TXTLFCCMPLMCCRED85 (L0TXTLFCCMPLMCCRED_IN[85], L0TXTLFCCMPLMCCRED[85]);
buf B_L0TXTLFCCMPLMCCRED86 (L0TXTLFCCMPLMCCRED_IN[86], L0TXTLFCCMPLMCCRED[86]);
buf B_L0TXTLFCCMPLMCCRED87 (L0TXTLFCCMPLMCCRED_IN[87], L0TXTLFCCMPLMCCRED[87]);
buf B_L0TXTLFCCMPLMCCRED88 (L0TXTLFCCMPLMCCRED_IN[88], L0TXTLFCCMPLMCCRED[88]);
buf B_L0TXTLFCCMPLMCCRED89 (L0TXTLFCCMPLMCCRED_IN[89], L0TXTLFCCMPLMCCRED[89]);
buf B_L0TXTLFCCMPLMCCRED90 (L0TXTLFCCMPLMCCRED_IN[90], L0TXTLFCCMPLMCCRED[90]);
buf B_L0TXTLFCCMPLMCCRED91 (L0TXTLFCCMPLMCCRED_IN[91], L0TXTLFCCMPLMCCRED[91]);
buf B_L0TXTLFCCMPLMCCRED92 (L0TXTLFCCMPLMCCRED_IN[92], L0TXTLFCCMPLMCCRED[92]);
buf B_L0TXTLFCCMPLMCCRED93 (L0TXTLFCCMPLMCCRED_IN[93], L0TXTLFCCMPLMCCRED[93]);
buf B_L0TXTLFCCMPLMCCRED94 (L0TXTLFCCMPLMCCRED_IN[94], L0TXTLFCCMPLMCCRED[94]);
buf B_L0TXTLFCCMPLMCCRED95 (L0TXTLFCCMPLMCCRED_IN[95], L0TXTLFCCMPLMCCRED[95]);
buf B_L0TXTLFCCMPLMCCRED96 (L0TXTLFCCMPLMCCRED_IN[96], L0TXTLFCCMPLMCCRED[96]);
buf B_L0TXTLFCCMPLMCCRED97 (L0TXTLFCCMPLMCCRED_IN[97], L0TXTLFCCMPLMCCRED[97]);
buf B_L0TXTLFCCMPLMCCRED98 (L0TXTLFCCMPLMCCRED_IN[98], L0TXTLFCCMPLMCCRED[98]);
buf B_L0TXTLFCCMPLMCCRED99 (L0TXTLFCCMPLMCCRED_IN[99], L0TXTLFCCMPLMCCRED[99]);
buf B_L0TXTLFCCMPLMCCRED100 (L0TXTLFCCMPLMCCRED_IN[100], L0TXTLFCCMPLMCCRED[100]);
buf B_L0TXTLFCCMPLMCCRED101 (L0TXTLFCCMPLMCCRED_IN[101], L0TXTLFCCMPLMCCRED[101]);
buf B_L0TXTLFCCMPLMCCRED102 (L0TXTLFCCMPLMCCRED_IN[102], L0TXTLFCCMPLMCCRED[102]);
buf B_L0TXTLFCCMPLMCCRED103 (L0TXTLFCCMPLMCCRED_IN[103], L0TXTLFCCMPLMCCRED[103]);
buf B_L0TXTLFCCMPLMCCRED104 (L0TXTLFCCMPLMCCRED_IN[104], L0TXTLFCCMPLMCCRED[104]);
buf B_L0TXTLFCCMPLMCCRED105 (L0TXTLFCCMPLMCCRED_IN[105], L0TXTLFCCMPLMCCRED[105]);
buf B_L0TXTLFCCMPLMCCRED106 (L0TXTLFCCMPLMCCRED_IN[106], L0TXTLFCCMPLMCCRED[106]);
buf B_L0TXTLFCCMPLMCCRED107 (L0TXTLFCCMPLMCCRED_IN[107], L0TXTLFCCMPLMCCRED[107]);
buf B_L0TXTLFCCMPLMCCRED108 (L0TXTLFCCMPLMCCRED_IN[108], L0TXTLFCCMPLMCCRED[108]);
buf B_L0TXTLFCCMPLMCCRED109 (L0TXTLFCCMPLMCCRED_IN[109], L0TXTLFCCMPLMCCRED[109]);
buf B_L0TXTLFCCMPLMCCRED110 (L0TXTLFCCMPLMCCRED_IN[110], L0TXTLFCCMPLMCCRED[110]);
buf B_L0TXTLFCCMPLMCCRED111 (L0TXTLFCCMPLMCCRED_IN[111], L0TXTLFCCMPLMCCRED[111]);
buf B_L0TXTLFCCMPLMCCRED112 (L0TXTLFCCMPLMCCRED_IN[112], L0TXTLFCCMPLMCCRED[112]);
buf B_L0TXTLFCCMPLMCCRED113 (L0TXTLFCCMPLMCCRED_IN[113], L0TXTLFCCMPLMCCRED[113]);
buf B_L0TXTLFCCMPLMCCRED114 (L0TXTLFCCMPLMCCRED_IN[114], L0TXTLFCCMPLMCCRED[114]);
buf B_L0TXTLFCCMPLMCCRED115 (L0TXTLFCCMPLMCCRED_IN[115], L0TXTLFCCMPLMCCRED[115]);
buf B_L0TXTLFCCMPLMCCRED116 (L0TXTLFCCMPLMCCRED_IN[116], L0TXTLFCCMPLMCCRED[116]);
buf B_L0TXTLFCCMPLMCCRED117 (L0TXTLFCCMPLMCCRED_IN[117], L0TXTLFCCMPLMCCRED[117]);
buf B_L0TXTLFCCMPLMCCRED118 (L0TXTLFCCMPLMCCRED_IN[118], L0TXTLFCCMPLMCCRED[118]);
buf B_L0TXTLFCCMPLMCCRED119 (L0TXTLFCCMPLMCCRED_IN[119], L0TXTLFCCMPLMCCRED[119]);
buf B_L0TXTLFCCMPLMCCRED120 (L0TXTLFCCMPLMCCRED_IN[120], L0TXTLFCCMPLMCCRED[120]);
buf B_L0TXTLFCCMPLMCCRED121 (L0TXTLFCCMPLMCCRED_IN[121], L0TXTLFCCMPLMCCRED[121]);
buf B_L0TXTLFCCMPLMCCRED122 (L0TXTLFCCMPLMCCRED_IN[122], L0TXTLFCCMPLMCCRED[122]);
buf B_L0TXTLFCCMPLMCCRED123 (L0TXTLFCCMPLMCCRED_IN[123], L0TXTLFCCMPLMCCRED[123]);
buf B_L0TXTLFCCMPLMCCRED124 (L0TXTLFCCMPLMCCRED_IN[124], L0TXTLFCCMPLMCCRED[124]);
buf B_L0TXTLFCCMPLMCCRED125 (L0TXTLFCCMPLMCCRED_IN[125], L0TXTLFCCMPLMCCRED[125]);
buf B_L0TXTLFCCMPLMCCRED126 (L0TXTLFCCMPLMCCRED_IN[126], L0TXTLFCCMPLMCCRED[126]);
buf B_L0TXTLFCCMPLMCCRED127 (L0TXTLFCCMPLMCCRED_IN[127], L0TXTLFCCMPLMCCRED[127]);
buf B_L0TXTLFCCMPLMCCRED128 (L0TXTLFCCMPLMCCRED_IN[128], L0TXTLFCCMPLMCCRED[128]);
buf B_L0TXTLFCCMPLMCCRED129 (L0TXTLFCCMPLMCCRED_IN[129], L0TXTLFCCMPLMCCRED[129]);
buf B_L0TXTLFCCMPLMCCRED130 (L0TXTLFCCMPLMCCRED_IN[130], L0TXTLFCCMPLMCCRED[130]);
buf B_L0TXTLFCCMPLMCCRED131 (L0TXTLFCCMPLMCCRED_IN[131], L0TXTLFCCMPLMCCRED[131]);
buf B_L0TXTLFCCMPLMCCRED132 (L0TXTLFCCMPLMCCRED_IN[132], L0TXTLFCCMPLMCCRED[132]);
buf B_L0TXTLFCCMPLMCCRED133 (L0TXTLFCCMPLMCCRED_IN[133], L0TXTLFCCMPLMCCRED[133]);
buf B_L0TXTLFCCMPLMCCRED134 (L0TXTLFCCMPLMCCRED_IN[134], L0TXTLFCCMPLMCCRED[134]);
buf B_L0TXTLFCCMPLMCCRED135 (L0TXTLFCCMPLMCCRED_IN[135], L0TXTLFCCMPLMCCRED[135]);
buf B_L0TXTLFCCMPLMCCRED136 (L0TXTLFCCMPLMCCRED_IN[136], L0TXTLFCCMPLMCCRED[136]);
buf B_L0TXTLFCCMPLMCCRED137 (L0TXTLFCCMPLMCCRED_IN[137], L0TXTLFCCMPLMCCRED[137]);
buf B_L0TXTLFCCMPLMCCRED138 (L0TXTLFCCMPLMCCRED_IN[138], L0TXTLFCCMPLMCCRED[138]);
buf B_L0TXTLFCCMPLMCCRED139 (L0TXTLFCCMPLMCCRED_IN[139], L0TXTLFCCMPLMCCRED[139]);
buf B_L0TXTLFCCMPLMCCRED140 (L0TXTLFCCMPLMCCRED_IN[140], L0TXTLFCCMPLMCCRED[140]);
buf B_L0TXTLFCCMPLMCCRED141 (L0TXTLFCCMPLMCCRED_IN[141], L0TXTLFCCMPLMCCRED[141]);
buf B_L0TXTLFCCMPLMCCRED142 (L0TXTLFCCMPLMCCRED_IN[142], L0TXTLFCCMPLMCCRED[142]);
buf B_L0TXTLFCCMPLMCCRED143 (L0TXTLFCCMPLMCCRED_IN[143], L0TXTLFCCMPLMCCRED[143]);
buf B_L0TXTLFCCMPLMCCRED144 (L0TXTLFCCMPLMCCRED_IN[144], L0TXTLFCCMPLMCCRED[144]);
buf B_L0TXTLFCCMPLMCCRED145 (L0TXTLFCCMPLMCCRED_IN[145], L0TXTLFCCMPLMCCRED[145]);
buf B_L0TXTLFCCMPLMCCRED146 (L0TXTLFCCMPLMCCRED_IN[146], L0TXTLFCCMPLMCCRED[146]);
buf B_L0TXTLFCCMPLMCCRED147 (L0TXTLFCCMPLMCCRED_IN[147], L0TXTLFCCMPLMCCRED[147]);
buf B_L0TXTLFCCMPLMCCRED148 (L0TXTLFCCMPLMCCRED_IN[148], L0TXTLFCCMPLMCCRED[148]);
buf B_L0TXTLFCCMPLMCCRED149 (L0TXTLFCCMPLMCCRED_IN[149], L0TXTLFCCMPLMCCRED[149]);
buf B_L0TXTLFCCMPLMCCRED150 (L0TXTLFCCMPLMCCRED_IN[150], L0TXTLFCCMPLMCCRED[150]);
buf B_L0TXTLFCCMPLMCCRED151 (L0TXTLFCCMPLMCCRED_IN[151], L0TXTLFCCMPLMCCRED[151]);
buf B_L0TXTLFCCMPLMCCRED152 (L0TXTLFCCMPLMCCRED_IN[152], L0TXTLFCCMPLMCCRED[152]);
buf B_L0TXTLFCCMPLMCCRED153 (L0TXTLFCCMPLMCCRED_IN[153], L0TXTLFCCMPLMCCRED[153]);
buf B_L0TXTLFCCMPLMCCRED154 (L0TXTLFCCMPLMCCRED_IN[154], L0TXTLFCCMPLMCCRED[154]);
buf B_L0TXTLFCCMPLMCCRED155 (L0TXTLFCCMPLMCCRED_IN[155], L0TXTLFCCMPLMCCRED[155]);
buf B_L0TXTLFCCMPLMCCRED156 (L0TXTLFCCMPLMCCRED_IN[156], L0TXTLFCCMPLMCCRED[156]);
buf B_L0TXTLFCCMPLMCCRED157 (L0TXTLFCCMPLMCCRED_IN[157], L0TXTLFCCMPLMCCRED[157]);
buf B_L0TXTLFCCMPLMCCRED158 (L0TXTLFCCMPLMCCRED_IN[158], L0TXTLFCCMPLMCCRED[158]);
buf B_L0TXTLFCCMPLMCCRED159 (L0TXTLFCCMPLMCCRED_IN[159], L0TXTLFCCMPLMCCRED[159]);
buf B_L0TXTLFCCMPLMCUPDATE0 (L0TXTLFCCMPLMCUPDATE_IN[0], L0TXTLFCCMPLMCUPDATE[0]);
buf B_L0TXTLFCCMPLMCUPDATE1 (L0TXTLFCCMPLMCUPDATE_IN[1], L0TXTLFCCMPLMCUPDATE[1]);
buf B_L0TXTLFCCMPLMCUPDATE2 (L0TXTLFCCMPLMCUPDATE_IN[2], L0TXTLFCCMPLMCUPDATE[2]);
buf B_L0TXTLFCCMPLMCUPDATE3 (L0TXTLFCCMPLMCUPDATE_IN[3], L0TXTLFCCMPLMCUPDATE[3]);
buf B_L0TXTLFCCMPLMCUPDATE4 (L0TXTLFCCMPLMCUPDATE_IN[4], L0TXTLFCCMPLMCUPDATE[4]);
buf B_L0TXTLFCCMPLMCUPDATE5 (L0TXTLFCCMPLMCUPDATE_IN[5], L0TXTLFCCMPLMCUPDATE[5]);
buf B_L0TXTLFCCMPLMCUPDATE6 (L0TXTLFCCMPLMCUPDATE_IN[6], L0TXTLFCCMPLMCUPDATE[6]);
buf B_L0TXTLFCCMPLMCUPDATE7 (L0TXTLFCCMPLMCUPDATE_IN[7], L0TXTLFCCMPLMCUPDATE[7]);
buf B_L0TXTLFCCMPLMCUPDATE8 (L0TXTLFCCMPLMCUPDATE_IN[8], L0TXTLFCCMPLMCUPDATE[8]);
buf B_L0TXTLFCCMPLMCUPDATE9 (L0TXTLFCCMPLMCUPDATE_IN[9], L0TXTLFCCMPLMCUPDATE[9]);
buf B_L0TXTLFCCMPLMCUPDATE10 (L0TXTLFCCMPLMCUPDATE_IN[10], L0TXTLFCCMPLMCUPDATE[10]);
buf B_L0TXTLFCCMPLMCUPDATE11 (L0TXTLFCCMPLMCUPDATE_IN[11], L0TXTLFCCMPLMCUPDATE[11]);
buf B_L0TXTLFCCMPLMCUPDATE12 (L0TXTLFCCMPLMCUPDATE_IN[12], L0TXTLFCCMPLMCUPDATE[12]);
buf B_L0TXTLFCCMPLMCUPDATE13 (L0TXTLFCCMPLMCUPDATE_IN[13], L0TXTLFCCMPLMCUPDATE[13]);
buf B_L0TXTLFCCMPLMCUPDATE14 (L0TXTLFCCMPLMCUPDATE_IN[14], L0TXTLFCCMPLMCUPDATE[14]);
buf B_L0TXTLFCCMPLMCUPDATE15 (L0TXTLFCCMPLMCUPDATE_IN[15], L0TXTLFCCMPLMCUPDATE[15]);
buf B_L0RXTLTLPNONINITIALIZEDVC0 (L0RXTLTLPNONINITIALIZEDVC_IN[0], L0RXTLTLPNONINITIALIZEDVC[0]);
buf B_L0RXTLTLPNONINITIALIZEDVC1 (L0RXTLTLPNONINITIALIZEDVC_IN[1], L0RXTLTLPNONINITIALIZEDVC[1]);
buf B_L0RXTLTLPNONINITIALIZEDVC2 (L0RXTLTLPNONINITIALIZEDVC_IN[2], L0RXTLTLPNONINITIALIZEDVC[2]);
buf B_L0RXTLTLPNONINITIALIZEDVC3 (L0RXTLTLPNONINITIALIZEDVC_IN[3], L0RXTLTLPNONINITIALIZEDVC[3]);
buf B_L0RXTLTLPNONINITIALIZEDVC4 (L0RXTLTLPNONINITIALIZEDVC_IN[4], L0RXTLTLPNONINITIALIZEDVC[4]);
buf B_L0RXTLTLPNONINITIALIZEDVC5 (L0RXTLTLPNONINITIALIZEDVC_IN[5], L0RXTLTLPNONINITIALIZEDVC[5]);
buf B_L0RXTLTLPNONINITIALIZEDVC6 (L0RXTLTLPNONINITIALIZEDVC_IN[6], L0RXTLTLPNONINITIALIZEDVC[6]);
buf B_L0RXTLTLPNONINITIALIZEDVC7 (L0RXTLTLPNONINITIALIZEDVC_IN[7], L0RXTLTLPNONINITIALIZEDVC[7]);

wire BUSMASTERENABLE_delay;
wire CRMDOHOTRESETN_delay;
wire CRMPWRSOFTRESETN_delay;
wire CRMRXHOTRESETN_delay;
wire DLLTXPMDLLPOUTSTANDING_delay;
wire INTERRUPTDISABLE_delay;
wire IOSPACEENABLE_delay;
wire L0ASAUTONOMOUSINITCOMPLETED_delay;
wire L0CFGLOOPBACKACK_delay;
wire L0CORRERRMSGRCVD_delay;
wire L0DLLASTXSTATE_delay;
wire L0DLLRXACKOUTSTANDING_delay;
wire L0DLLTXNONFCOUTSTANDING_delay;
wire L0DLLTXOUTSTANDING_delay;
wire L0FATALERRMSGRCVD_delay;
wire L0FIRSTCFGWRITEOCCURRED_delay;
wire L0FWDCORRERROUT_delay;
wire L0FWDFATALERROUT_delay;
wire L0FWDNONFATALERROUT_delay;
wire L0MACENTEREDL0_delay;
wire L0MACLINKTRAINING_delay;
wire L0MACLINKUP_delay;
wire L0MACNEWSTATEACK_delay;
wire L0MACRXL0SSTATE_delay;
wire L0MACUPSTREAMDOWNSTREAM_delay;
wire L0MSIENABLE0_delay;
wire L0NONFATALERRMSGRCVD_delay;
wire L0PMEACK_delay;
wire L0PMEEN_delay;
wire L0PMEREQOUT_delay;
wire L0POWERCONTROLLERCONTROL_delay;
wire L0PWRINHIBITTRANSFERS_delay;
wire L0PWRL1STATE_delay;
wire L0PWRL23READYDEVICE_delay;
wire L0PWRL23READYSTATE_delay;
wire L0PWRTURNOFFREQ_delay;
wire L0PWRTXL0SSTATE_delay;
wire L0RECEIVEDASSERTINTALEGACYINT_delay;
wire L0RECEIVEDASSERTINTBLEGACYINT_delay;
wire L0RECEIVEDASSERTINTCLEGACYINT_delay;
wire L0RECEIVEDASSERTINTDLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTALEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTBLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTCLEGACYINT_delay;
wire L0RECEIVEDDEASSERTINTDLEGACYINT_delay;
wire L0RXBEACON_delay;
wire L0RXDLLPM_delay;
wire L0RXDLLSBFCUPDATE_delay;
wire L0RXDLLTLPECRCOK_delay;
wire L0STATSCFGOTHERRECEIVED_delay;
wire L0STATSCFGOTHERTRANSMITTED_delay;
wire L0STATSCFGRECEIVED_delay;
wire L0STATSCFGTRANSMITTED_delay;
wire L0STATSDLLPRECEIVED_delay;
wire L0STATSDLLPTRANSMITTED_delay;
wire L0STATSOSRECEIVED_delay;
wire L0STATSOSTRANSMITTED_delay;
wire L0STATSTLPRECEIVED_delay;
wire L0STATSTLPTRANSMITTED_delay;
wire L0TOGGLEELECTROMECHANICALINTERLOCK_delay;
wire L0TXDLLPMUPDATED_delay;
wire L0TXDLLSBFCUPDATED_delay;
wire L0UNLOCKRECEIVED_delay;
wire LLKRX4DWHEADERN_delay;
wire LLKRXCHCONFIGAVAILABLEN_delay;
wire LLKRXCHCONFIGPARTIALN_delay;
wire LLKRXECRCBADN_delay;
wire LLKRXEOFN_delay;
wire LLKRXEOPN_delay;
wire LLKRXSOFN_delay;
wire LLKRXSOPN_delay;
wire LLKRXSRCDSCN_delay;
wire LLKRXSRCLASTREQN_delay;
wire LLKRXSRCRDYN_delay;
wire LLKTXCONFIGREADYN_delay;
wire LLKTXDSTRDYN_delay;
wire MEMSPACEENABLE_delay;
wire MIMDLLBREN_delay;
wire MIMDLLBWEN_delay;
wire MIMRXBREN_delay;
wire MIMRXBWEN_delay;
wire MIMTXBREN_delay;
wire MIMTXBWEN_delay;
wire PARITYERRORRESPONSE_delay;
wire PIPEDESKEWLANESL0_delay;
wire PIPEDESKEWLANESL1_delay;
wire PIPEDESKEWLANESL2_delay;
wire PIPEDESKEWLANESL3_delay;
wire PIPEDESKEWLANESL4_delay;
wire PIPEDESKEWLANESL5_delay;
wire PIPEDESKEWLANESL6_delay;
wire PIPEDESKEWLANESL7_delay;
wire PIPERESETL0_delay;
wire PIPERESETL1_delay;
wire PIPERESETL2_delay;
wire PIPERESETL3_delay;
wire PIPERESETL4_delay;
wire PIPERESETL5_delay;
wire PIPERESETL6_delay;
wire PIPERESETL7_delay;
wire PIPERXPOLARITYL0_delay;
wire PIPERXPOLARITYL1_delay;
wire PIPERXPOLARITYL2_delay;
wire PIPERXPOLARITYL3_delay;
wire PIPERXPOLARITYL4_delay;
wire PIPERXPOLARITYL5_delay;
wire PIPERXPOLARITYL6_delay;
wire PIPERXPOLARITYL7_delay;
wire PIPETXCOMPLIANCEL0_delay;
wire PIPETXCOMPLIANCEL1_delay;
wire PIPETXCOMPLIANCEL2_delay;
wire PIPETXCOMPLIANCEL3_delay;
wire PIPETXCOMPLIANCEL4_delay;
wire PIPETXCOMPLIANCEL5_delay;
wire PIPETXCOMPLIANCEL6_delay;
wire PIPETXCOMPLIANCEL7_delay;
wire PIPETXDATAKL0_delay;
wire PIPETXDATAKL1_delay;
wire PIPETXDATAKL2_delay;
wire PIPETXDATAKL3_delay;
wire PIPETXDATAKL4_delay;
wire PIPETXDATAKL5_delay;
wire PIPETXDATAKL6_delay;
wire PIPETXDATAKL7_delay;
wire PIPETXDETECTRXLOOPBACKL0_delay;
wire PIPETXDETECTRXLOOPBACKL1_delay;
wire PIPETXDETECTRXLOOPBACKL2_delay;
wire PIPETXDETECTRXLOOPBACKL3_delay;
wire PIPETXDETECTRXLOOPBACKL4_delay;
wire PIPETXDETECTRXLOOPBACKL5_delay;
wire PIPETXDETECTRXLOOPBACKL6_delay;
wire PIPETXDETECTRXLOOPBACKL7_delay;
wire PIPETXELECIDLEL0_delay;
wire PIPETXELECIDLEL1_delay;
wire PIPETXELECIDLEL2_delay;
wire PIPETXELECIDLEL3_delay;
wire PIPETXELECIDLEL4_delay;
wire PIPETXELECIDLEL5_delay;
wire PIPETXELECIDLEL6_delay;
wire PIPETXELECIDLEL7_delay;
wire SERRENABLE_delay;
wire URREPORTINGENABLE_delay;
wire [11:0] MGMTSTATSCREDIT_delay;
wire [11:0] MIMDLLBRADD_delay;
wire [11:0] MIMDLLBWADD_delay;
wire [12:0] L0COMPLETERID_delay;
wire [12:0] MIMRXBRADD_delay;
wire [12:0] MIMRXBWADD_delay;
wire [12:0] MIMTXBRADD_delay;
wire [12:0] MIMTXBWADD_delay;
wire [15:0] L0ERRMSGREQID_delay;
wire [15:0] LLKRXPREFERREDTYPE_delay;
wire [16:0] MGMTPSO_delay;
wire [18:0] L0RXDLLSBFCDATA_delay;
wire [19:0] L0RXDLLFCNPOSTBYPCRED_delay;
wire [1:0] L0ATTENTIONINDICATORCONTROL_delay;
wire [1:0] L0DLLASRXSTATE_delay;
wire [1:0] L0POWERINDICATORCONTROL_delay;
wire [1:0] L0PWRSTATE0_delay;
wire [1:0] L0RXDLLTLPEND_delay;
wire [1:0] L0RXMACLINKERROR_delay;
wire [1:0] LLKRXVALIDN_delay;
wire [1:0] PIPEPOWERDOWNL0_delay;
wire [1:0] PIPEPOWERDOWNL1_delay;
wire [1:0] PIPEPOWERDOWNL2_delay;
wire [1:0] PIPEPOWERDOWNL3_delay;
wire [1:0] PIPEPOWERDOWNL4_delay;
wire [1:0] PIPEPOWERDOWNL5_delay;
wire [1:0] PIPEPOWERDOWNL6_delay;
wire [1:0] PIPEPOWERDOWNL7_delay;
wire [23:0] L0RXDLLFCCMPLMCCRED_delay;
wire [23:0] L0RXDLLFCPOSTORDCRED_delay;
wire [2:0] L0MCFOUND_delay;
wire [2:0] L0MULTIMSGEN0_delay;
wire [2:0] L0RXDLLPMTYPE_delay;
wire [2:0] L0TRANSFORMEDVC_delay;
wire [2:0] MAXPAYLOADSIZE_delay;
wire [2:0] MAXREADREQUESTSIZE_delay;
wire [31:0] MGMTRDATA_delay;
wire [3:0] L0LTSSMSTATE_delay;
wire [3:0] L0MACNEGOTIATEDLINKWIDTH_delay;
wire [3:0] L0UCBYPFOUND_delay;
wire [3:0] L0UCORDFOUND_delay;
wire [63:0] LLKRXDATA_delay;
wire [63:0] MIMDLLBWDATA_delay;
wire [63:0] MIMRXBWDATA_delay;
wire [63:0] MIMTXBWDATA_delay;
wire [6:0] L0DLLERRORVECTOR_delay;
wire [7:0] L0DLLVCSTATUS_delay;
wire [7:0] L0DLUPDOWN_delay;
wire [7:0] L0RXDLLFCCMPLMCUPDATE_delay;
wire [7:0] L0RXDLLFCNPOSTBYPUPDATE_delay;
wire [7:0] L0RXDLLFCPOSTORDUPDATE_delay;
wire [7:0] L0TXDLLFCCMPLMCUPDATED_delay;
wire [7:0] L0TXDLLFCNPOSTBYPUPDATED_delay;
wire [7:0] L0TXDLLFCPOSTORDUPDATED_delay;
wire [7:0] LLKRXCHCOMPLETIONAVAILABLEN_delay;
wire [7:0] LLKRXCHCOMPLETIONPARTIALN_delay;
wire [7:0] LLKRXCHNONPOSTEDAVAILABLEN_delay;
wire [7:0] LLKRXCHNONPOSTEDPARTIALN_delay;
wire [7:0] LLKRXCHPOSTEDAVAILABLEN_delay;
wire [7:0] LLKRXCHPOSTEDPARTIALN_delay;
wire [7:0] LLKTCSTATUS_delay;
wire [7:0] LLKTXCHCOMPLETIONREADYN_delay;
wire [7:0] LLKTXCHNONPOSTEDREADYN_delay;
wire [7:0] LLKTXCHPOSTEDREADYN_delay;
wire [7:0] PIPETXDATAL0_delay;
wire [7:0] PIPETXDATAL1_delay;
wire [7:0] PIPETXDATAL2_delay;
wire [7:0] PIPETXDATAL3_delay;
wire [7:0] PIPETXDATAL4_delay;
wire [7:0] PIPETXDATAL5_delay;
wire [7:0] PIPETXDATAL6_delay;
wire [7:0] PIPETXDATAL7_delay;
wire [9:0] LLKTXCHANSPACE_delay;

wire AUXPOWER_delay;
wire COMPLIANCEAVOID_delay;
wire CRMCFGBRIDGEHOTRESET_delay;
wire CRMCORECLKDLO_delay;
wire CRMCORECLKRXO_delay;
wire CRMCORECLKTXO_delay;
wire CRMCORECLK_delay;
wire CRMLINKRSTN_delay;
wire CRMMACRSTN_delay;
wire CRMMGMTRSTN_delay;
wire CRMNVRSTN_delay;
wire CRMTXHOTRESETN_delay;
wire CRMURSTN_delay;
wire CRMUSERCFGRSTN_delay;
wire CRMUSERCLKRXO_delay;
wire CRMUSERCLKTXO_delay;
wire CRMUSERCLK_delay;
wire CROSSLINKSEED_delay;
wire L0ALLDOWNPORTSINL1_delay;
wire L0ALLDOWNRXPORTSINL0S_delay;
wire L0ASE_delay;
wire L0ATTENTIONBUTTONPRESSED_delay;
wire L0CFGASSPANTREEOWNEDSTATE_delay;
wire L0CFGDISABLESCRAMBLE_delay;
wire L0CFGEXTENDEDSYNC_delay;
wire L0CFGL0SENTRYENABLE_delay;
wire L0CFGL0SENTRYSUP_delay;
wire L0CFGLINKDISABLE_delay;
wire L0CFGLOOPBACKMASTER_delay;
wire L0DLLHOLDLINKUP_delay;
wire L0ELECTROMECHANICALINTERLOCKENGAGED_delay;
wire L0FWDASSERTINTALEGACYINT_delay;
wire L0FWDASSERTINTBLEGACYINT_delay;
wire L0FWDASSERTINTCLEGACYINT_delay;
wire L0FWDASSERTINTDLEGACYINT_delay;
wire L0FWDCORRERRIN_delay;
wire L0FWDDEASSERTINTALEGACYINT_delay;
wire L0FWDDEASSERTINTBLEGACYINT_delay;
wire L0FWDDEASSERTINTCLEGACYINT_delay;
wire L0FWDDEASSERTINTDLEGACYINT_delay;
wire L0FWDFATALERRIN_delay;
wire L0FWDNONFATALERRIN_delay;
wire L0LEGACYINTFUNCT0_delay;
wire L0MRLSENSORCLOSEDN_delay;
wire L0PMEREQIN_delay;
wire L0POWERFAULTDETECTED_delay;
wire L0PRESENCEDETECTSLOTEMPTYN_delay;
wire L0PWRNEWSTATEREQ_delay;
wire L0ROOTTURNOFFREQ_delay;
wire L0SENDUNLOCKMESSAGE_delay;
wire L0SETCOMPLETERABORTERROR_delay;
wire L0SETCOMPLETIONTIMEOUTCORRERROR_delay;
wire L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay;
wire L0SETDETECTEDCORRERROR_delay;
wire L0SETDETECTEDFATALERROR_delay;
wire L0SETDETECTEDNONFATALERROR_delay;
wire L0SETLINKDETECTEDPARITYERROR_delay;
wire L0SETLINKMASTERDATAPARITY_delay;
wire L0SETLINKRECEIVEDMASTERABORT_delay;
wire L0SETLINKRECEIVEDTARGETABORT_delay;
wire L0SETLINKSIGNALLEDTARGETABORT_delay;
wire L0SETLINKSYSTEMERROR_delay;
wire L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay;
wire L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay;
wire L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay;
wire L0SETUNSUPPORTEDREQUESTOTHERERROR_delay;
wire L0SETUSERDETECTEDPARITYERROR_delay;
wire L0SETUSERMASTERDATAPARITY_delay;
wire L0SETUSERRECEIVEDMASTERABORT_delay;
wire L0SETUSERRECEIVEDTARGETABORT_delay;
wire L0SETUSERSIGNALLEDTARGETABORT_delay;
wire L0SETUSERSYSTEMERROR_delay;
wire L0TLASFCCREDSTARVATION_delay;
wire L0TLLINKRETRAIN_delay;
wire L0TRANSACTIONSPENDING_delay;
wire L0TXBEACON_delay;
wire L0TXCFGPM_delay;
wire L0TXTLSBFCUPDATE_delay;
wire L0TXTLTLPEDB_delay;
wire L0TXTLTLPREQEND_delay;
wire L0TXTLTLPREQ_delay;
wire L0TXTLTLPWIDTH_delay;
wire L0UPSTREAMRXPORTINL0S_delay;
wire L0VC0PREVIEWEXPAND_delay;
wire L0WAKEN_delay;
wire LLKRXDSTCONTREQN_delay;
wire LLKRXDSTREQN_delay;
wire LLKTX4DWHEADERN_delay;
wire LLKTXCOMPLETEN_delay;
wire LLKTXCREATEECRCN_delay;
wire LLKTXEOFN_delay;
wire LLKTXEOPN_delay;
wire LLKTXSOFN_delay;
wire LLKTXSOPN_delay;
wire LLKTXSRCDSCN_delay;
wire LLKTXSRCRDYN_delay;
wire MAINPOWER_delay;
wire MGMTRDEN_delay;
wire MGMTWREN_delay;
wire PIPEPHYSTATUSL0_delay;
wire PIPEPHYSTATUSL1_delay;
wire PIPEPHYSTATUSL2_delay;
wire PIPEPHYSTATUSL3_delay;
wire PIPEPHYSTATUSL4_delay;
wire PIPEPHYSTATUSL5_delay;
wire PIPEPHYSTATUSL6_delay;
wire PIPEPHYSTATUSL7_delay;
wire PIPERXCHANISALIGNEDL0_delay;
wire PIPERXCHANISALIGNEDL1_delay;
wire PIPERXCHANISALIGNEDL2_delay;
wire PIPERXCHANISALIGNEDL3_delay;
wire PIPERXCHANISALIGNEDL4_delay;
wire PIPERXCHANISALIGNEDL5_delay;
wire PIPERXCHANISALIGNEDL6_delay;
wire PIPERXCHANISALIGNEDL7_delay;
wire PIPERXDATAKL0_delay;
wire PIPERXDATAKL1_delay;
wire PIPERXDATAKL2_delay;
wire PIPERXDATAKL3_delay;
wire PIPERXDATAKL4_delay;
wire PIPERXDATAKL5_delay;
wire PIPERXDATAKL6_delay;
wire PIPERXDATAKL7_delay;
wire PIPERXELECIDLEL0_delay;
wire PIPERXELECIDLEL1_delay;
wire PIPERXELECIDLEL2_delay;
wire PIPERXELECIDLEL3_delay;
wire PIPERXELECIDLEL4_delay;
wire PIPERXELECIDLEL5_delay;
wire PIPERXELECIDLEL6_delay;
wire PIPERXELECIDLEL7_delay;
wire PIPERXVALIDL0_delay;
wire PIPERXVALIDL1_delay;
wire PIPERXVALIDL2_delay;
wire PIPERXVALIDL3_delay;
wire PIPERXVALIDL4_delay;
wire PIPERXVALIDL5_delay;
wire PIPERXVALIDL6_delay;
wire PIPERXVALIDL7_delay;
wire [10:0] MGMTADDR_delay;
wire [11:0] L0ACKNAKTIMERADJUSTMENT_delay;
wire [11:0] L0REPLAYTIMERADJUSTMENT_delay;
wire [127:0] L0PACKETHEADERFROMUSER_delay;
wire [159:0] L0TXTLFCCMPLMCCRED_delay;
wire [159:0] L0TXTLFCPOSTORDCRED_delay;
wire [15:0] L0TXTLFCCMPLMCUPDATE_delay;
wire [15:0] L0TXTLFCNPOSTBYPUPDATE_delay;
wire [15:0] L0TXTLFCPOSTORDUPDATE_delay;
wire [18:0] L0TXTLSBFCDATA_delay;
wire [191:0] L0TXTLFCNPOSTBYPCRED_delay;
wire [1:0] L0PWRNEXTLINKSTATE_delay;
wire [1:0] L0TXTLTLPENABLE_delay;
wire [1:0] L0TXTLTLPEND_delay;
wire [1:0] LLKRXCHFIFO_delay;
wire [1:0] LLKTXCHFIFO_delay;
wire [1:0] LLKTXENABLEN_delay;
wire [23:0] L0CFGVCID_delay;
wire [2:0] L0ASTURNPOOLBITSCONSUMED_delay;
wire [2:0] L0CFGL0SEXITLAT_delay;
wire [2:0] L0CFGNEGOTIATEDMAXP_delay;
wire [2:0] L0TXCFGPMTYPE_delay;
wire [2:0] LLKRXCHTC_delay;
wire [2:0] LLKTXCHTC_delay;
wire [2:0] PIPERXSTATUSL0_delay;
wire [2:0] PIPERXSTATUSL1_delay;
wire [2:0] PIPERXSTATUSL2_delay;
wire [2:0] PIPERXSTATUSL3_delay;
wire [2:0] PIPERXSTATUSL4_delay;
wire [2:0] PIPERXSTATUSL5_delay;
wire [2:0] PIPERXSTATUSL6_delay;
wire [2:0] PIPERXSTATUSL7_delay;
wire [31:0] MGMTWDATA_delay;
wire [3:0] L0CFGASSTATECHANGECMD_delay;
wire [3:0] L0MSIREQUEST0_delay;
wire [3:0] L0TXTLTLPLATENCY_delay;
wire [3:0] MGMTBWREN_delay;
wire [5:0] CFGNEGOTIATEDLINKWIDTH_delay;
wire [63:0] L0TXTLTLPDATA_delay;
wire [63:0] LLKTXDATA_delay;
wire [63:0] MIMDLLBRDATA_delay;
wire [63:0] MIMRXBRDATA_delay;
wire [63:0] MIMTXBRDATA_delay;
wire [6:0] MGMTSTATSCREDITSEL_delay;
wire [7:0] L0ASPORTCOUNT_delay;
wire [7:0] L0CFGVCENABLE_delay;
wire [7:0] L0PORTNUMBER_delay;
wire [7:0] L0RXTLTLPNONINITIALIZEDVC_delay;
wire [7:0] PIPERXDATAL0_delay;
wire [7:0] PIPERXDATAL1_delay;
wire [7:0] PIPERXDATAL2_delay;
wire [7:0] PIPERXDATAL3_delay;
wire [7:0] PIPERXDATAL4_delay;
wire [7:0] PIPERXDATAL5_delay;
wire [7:0] PIPERXDATAL6_delay;
wire [7:0] PIPERXDATAL7_delay;


assign #(out_delay) BUSMASTERENABLE_OUT = BUSMASTERENABLE_delay;
assign #(out_delay) CRMDOHOTRESETN_OUT = CRMDOHOTRESETN_delay;
assign #(out_delay) CRMPWRSOFTRESETN_OUT = CRMPWRSOFTRESETN_delay;
assign #(out_delay) CRMRXHOTRESETN_OUT = CRMRXHOTRESETN_delay;
assign #(out_delay) DLLTXPMDLLPOUTSTANDING_OUT = DLLTXPMDLLPOUTSTANDING_delay;
assign #(out_delay) INTERRUPTDISABLE_OUT = INTERRUPTDISABLE_delay;
assign #(out_delay) IOSPACEENABLE_OUT = IOSPACEENABLE_delay;
assign #(out_delay) L0ASAUTONOMOUSINITCOMPLETED_OUT = L0ASAUTONOMOUSINITCOMPLETED_delay;
assign #(out_delay) L0ATTENTIONINDICATORCONTROL_OUT = L0ATTENTIONINDICATORCONTROL_delay;
assign #(out_delay) L0CFGLOOPBACKACK_OUT = L0CFGLOOPBACKACK_delay;
assign #(out_delay) L0COMPLETERID_OUT = L0COMPLETERID_delay;
assign #(out_delay) L0CORRERRMSGRCVD_OUT = L0CORRERRMSGRCVD_delay;
assign #(out_delay) L0DLLASRXSTATE_OUT = L0DLLASRXSTATE_delay;
assign #(out_delay) L0DLLASTXSTATE_OUT = L0DLLASTXSTATE_delay;
assign #(out_delay) L0DLLERRORVECTOR_OUT = L0DLLERRORVECTOR_delay;
assign #(out_delay) L0DLLRXACKOUTSTANDING_OUT = L0DLLRXACKOUTSTANDING_delay;
assign #(out_delay) L0DLLTXNONFCOUTSTANDING_OUT = L0DLLTXNONFCOUTSTANDING_delay;
assign #(out_delay) L0DLLTXOUTSTANDING_OUT = L0DLLTXOUTSTANDING_delay;
assign #(out_delay) L0DLLVCSTATUS_OUT = L0DLLVCSTATUS_delay;
assign #(out_delay) L0DLUPDOWN_OUT = L0DLUPDOWN_delay;
assign #(out_delay) L0ERRMSGREQID_OUT = L0ERRMSGREQID_delay;
assign #(out_delay) L0FATALERRMSGRCVD_OUT = L0FATALERRMSGRCVD_delay;
assign #(out_delay) L0FIRSTCFGWRITEOCCURRED_OUT = L0FIRSTCFGWRITEOCCURRED_delay;
assign #(out_delay) L0FWDCORRERROUT_OUT = L0FWDCORRERROUT_delay;
assign #(out_delay) L0FWDFATALERROUT_OUT = L0FWDFATALERROUT_delay;
assign #(out_delay) L0FWDNONFATALERROUT_OUT = L0FWDNONFATALERROUT_delay;
assign #(out_delay) L0LTSSMSTATE_OUT = L0LTSSMSTATE_delay;
assign #(out_delay) L0MACENTEREDL0_OUT = L0MACENTEREDL0_delay;
assign #(out_delay) L0MACLINKTRAINING_OUT = L0MACLINKTRAINING_delay;
assign #(out_delay) L0MACLINKUP_OUT = L0MACLINKUP_delay;
assign #(out_delay) L0MACNEGOTIATEDLINKWIDTH_OUT = L0MACNEGOTIATEDLINKWIDTH_delay;
assign #(out_delay) L0MACNEWSTATEACK_OUT = L0MACNEWSTATEACK_delay;
assign #(out_delay) L0MACRXL0SSTATE_OUT = L0MACRXL0SSTATE_delay;
assign #(out_delay) L0MACUPSTREAMDOWNSTREAM_OUT = L0MACUPSTREAMDOWNSTREAM_delay;
assign #(out_delay) L0MCFOUND_OUT = L0MCFOUND_delay;
assign #(out_delay) L0MSIENABLE0_OUT = L0MSIENABLE0_delay;
assign #(out_delay) L0MULTIMSGEN0_OUT = L0MULTIMSGEN0_delay;
assign #(out_delay) L0NONFATALERRMSGRCVD_OUT = L0NONFATALERRMSGRCVD_delay;
assign #(out_delay) L0PMEACK_OUT = L0PMEACK_delay;
assign #(out_delay) L0PMEEN_OUT = L0PMEEN_delay;
assign #(out_delay) L0PMEREQOUT_OUT = L0PMEREQOUT_delay;
assign #(out_delay) L0POWERCONTROLLERCONTROL_OUT = L0POWERCONTROLLERCONTROL_delay;
assign #(out_delay) L0POWERINDICATORCONTROL_OUT = L0POWERINDICATORCONTROL_delay;
assign #(out_delay) L0PWRINHIBITTRANSFERS_OUT = L0PWRINHIBITTRANSFERS_delay;
assign #(out_delay) L0PWRL1STATE_OUT = L0PWRL1STATE_delay;
assign #(out_delay) L0PWRL23READYDEVICE_OUT = L0PWRL23READYDEVICE_delay;
assign #(out_delay) L0PWRL23READYSTATE_OUT = L0PWRL23READYSTATE_delay;
assign #(out_delay) L0PWRSTATE0_OUT = L0PWRSTATE0_delay;
assign #(out_delay) L0PWRTURNOFFREQ_OUT = L0PWRTURNOFFREQ_delay;
assign #(out_delay) L0PWRTXL0SSTATE_OUT = L0PWRTXL0SSTATE_delay;
assign #(out_delay) L0RECEIVEDASSERTINTALEGACYINT_OUT = L0RECEIVEDASSERTINTALEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTBLEGACYINT_OUT = L0RECEIVEDASSERTINTBLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTCLEGACYINT_OUT = L0RECEIVEDASSERTINTCLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDASSERTINTDLEGACYINT_OUT = L0RECEIVEDASSERTINTDLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTALEGACYINT_OUT = L0RECEIVEDDEASSERTINTALEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTBLEGACYINT_OUT = L0RECEIVEDDEASSERTINTBLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTCLEGACYINT_OUT = L0RECEIVEDDEASSERTINTCLEGACYINT_delay;
assign #(out_delay) L0RECEIVEDDEASSERTINTDLEGACYINT_OUT = L0RECEIVEDDEASSERTINTDLEGACYINT_delay;
assign #(out_delay) L0RXBEACON_OUT = L0RXBEACON_delay;
assign #(out_delay) L0RXDLLFCCMPLMCCRED_OUT = L0RXDLLFCCMPLMCCRED_delay;
assign #(out_delay) L0RXDLLFCCMPLMCUPDATE_OUT = L0RXDLLFCCMPLMCUPDATE_delay;
assign #(out_delay) L0RXDLLFCNPOSTBYPCRED_OUT = L0RXDLLFCNPOSTBYPCRED_delay;
assign #(out_delay) L0RXDLLFCNPOSTBYPUPDATE_OUT = L0RXDLLFCNPOSTBYPUPDATE_delay;
assign #(out_delay) L0RXDLLFCPOSTORDCRED_OUT = L0RXDLLFCPOSTORDCRED_delay;
assign #(out_delay) L0RXDLLFCPOSTORDUPDATE_OUT = L0RXDLLFCPOSTORDUPDATE_delay;
assign #(out_delay) L0RXDLLPMTYPE_OUT = L0RXDLLPMTYPE_delay;
assign #(out_delay) L0RXDLLPM_OUT = L0RXDLLPM_delay;
assign #(out_delay) L0RXDLLSBFCDATA_OUT = L0RXDLLSBFCDATA_delay;
assign #(out_delay) L0RXDLLSBFCUPDATE_OUT = L0RXDLLSBFCUPDATE_delay;
assign #(out_delay) L0RXDLLTLPECRCOK_OUT = L0RXDLLTLPECRCOK_delay;
assign #(out_delay) L0RXDLLTLPEND_OUT = L0RXDLLTLPEND_delay;
assign #(out_delay) L0RXMACLINKERROR_OUT = L0RXMACLINKERROR_delay;
assign #(out_delay) L0STATSCFGOTHERRECEIVED_OUT = L0STATSCFGOTHERRECEIVED_delay;
assign #(out_delay) L0STATSCFGOTHERTRANSMITTED_OUT = L0STATSCFGOTHERTRANSMITTED_delay;
assign #(out_delay) L0STATSCFGRECEIVED_OUT = L0STATSCFGRECEIVED_delay;
assign #(out_delay) L0STATSCFGTRANSMITTED_OUT = L0STATSCFGTRANSMITTED_delay;
assign #(out_delay) L0STATSDLLPRECEIVED_OUT = L0STATSDLLPRECEIVED_delay;
assign #(out_delay) L0STATSDLLPTRANSMITTED_OUT = L0STATSDLLPTRANSMITTED_delay;
assign #(out_delay) L0STATSOSRECEIVED_OUT = L0STATSOSRECEIVED_delay;
assign #(out_delay) L0STATSOSTRANSMITTED_OUT = L0STATSOSTRANSMITTED_delay;
assign #(out_delay) L0STATSTLPRECEIVED_OUT = L0STATSTLPRECEIVED_delay;
assign #(out_delay) L0STATSTLPTRANSMITTED_OUT = L0STATSTLPTRANSMITTED_delay;
assign #(out_delay) L0TOGGLEELECTROMECHANICALINTERLOCK_OUT = L0TOGGLEELECTROMECHANICALINTERLOCK_delay;
assign #(out_delay) L0TRANSFORMEDVC_OUT = L0TRANSFORMEDVC_delay;
assign #(out_delay) L0TXDLLFCCMPLMCUPDATED_OUT = L0TXDLLFCCMPLMCUPDATED_delay;
assign #(out_delay) L0TXDLLFCNPOSTBYPUPDATED_OUT = L0TXDLLFCNPOSTBYPUPDATED_delay;
assign #(out_delay) L0TXDLLFCPOSTORDUPDATED_OUT = L0TXDLLFCPOSTORDUPDATED_delay;
assign #(out_delay) L0TXDLLPMUPDATED_OUT = L0TXDLLPMUPDATED_delay;
assign #(out_delay) L0TXDLLSBFCUPDATED_OUT = L0TXDLLSBFCUPDATED_delay;
assign #(out_delay) L0UCBYPFOUND_OUT = L0UCBYPFOUND_delay;
assign #(out_delay) L0UCORDFOUND_OUT = L0UCORDFOUND_delay;
assign #(out_delay) L0UNLOCKRECEIVED_OUT = L0UNLOCKRECEIVED_delay;
assign #(out_delay) LLKRX4DWHEADERN_OUT = LLKRX4DWHEADERN_delay;
assign #(out_delay) LLKRXCHCOMPLETIONAVAILABLEN_OUT = LLKRXCHCOMPLETIONAVAILABLEN_delay;
assign #(out_delay) LLKRXCHCOMPLETIONPARTIALN_OUT = LLKRXCHCOMPLETIONPARTIALN_delay;
assign #(out_delay) LLKRXCHCONFIGAVAILABLEN_OUT = LLKRXCHCONFIGAVAILABLEN_delay;
assign #(out_delay) LLKRXCHCONFIGPARTIALN_OUT = LLKRXCHCONFIGPARTIALN_delay;
assign #(out_delay) LLKRXCHNONPOSTEDAVAILABLEN_OUT = LLKRXCHNONPOSTEDAVAILABLEN_delay;
assign #(out_delay) LLKRXCHNONPOSTEDPARTIALN_OUT = LLKRXCHNONPOSTEDPARTIALN_delay;
assign #(out_delay) LLKRXCHPOSTEDAVAILABLEN_OUT = LLKRXCHPOSTEDAVAILABLEN_delay;
assign #(out_delay) LLKRXCHPOSTEDPARTIALN_OUT = LLKRXCHPOSTEDPARTIALN_delay;
assign #(out_delay) LLKRXDATA_OUT = LLKRXDATA_delay;
assign #(out_delay) LLKRXECRCBADN_OUT = LLKRXECRCBADN_delay;
assign #(out_delay) LLKRXEOFN_OUT = LLKRXEOFN_delay;
assign #(out_delay) LLKRXEOPN_OUT = LLKRXEOPN_delay;
assign #(out_delay) LLKRXPREFERREDTYPE_OUT = LLKRXPREFERREDTYPE_delay;
assign #(out_delay) LLKRXSOFN_OUT = LLKRXSOFN_delay;
assign #(out_delay) LLKRXSOPN_OUT = LLKRXSOPN_delay;
assign #(out_delay) LLKRXSRCDSCN_OUT = LLKRXSRCDSCN_delay;
assign #(out_delay) LLKRXSRCLASTREQN_OUT = LLKRXSRCLASTREQN_delay;
assign #(out_delay) LLKRXSRCRDYN_OUT = LLKRXSRCRDYN_delay;
assign #(out_delay) LLKRXVALIDN_OUT = LLKRXVALIDN_delay;
assign #(out_delay) LLKTCSTATUS_OUT = LLKTCSTATUS_delay;
assign #(out_delay) LLKTXCHANSPACE_OUT = LLKTXCHANSPACE_delay;
assign #(out_delay) LLKTXCHCOMPLETIONREADYN_OUT = LLKTXCHCOMPLETIONREADYN_delay;
assign #(out_delay) LLKTXCHNONPOSTEDREADYN_OUT = LLKTXCHNONPOSTEDREADYN_delay;
assign #(out_delay) LLKTXCHPOSTEDREADYN_OUT = LLKTXCHPOSTEDREADYN_delay;
assign #(out_delay) LLKTXCONFIGREADYN_OUT = LLKTXCONFIGREADYN_delay;
assign #(out_delay) LLKTXDSTRDYN_OUT = LLKTXDSTRDYN_delay;
assign #(out_delay) MAXPAYLOADSIZE_OUT = MAXPAYLOADSIZE_delay;
assign #(out_delay) MAXREADREQUESTSIZE_OUT = MAXREADREQUESTSIZE_delay;
assign #(out_delay) MEMSPACEENABLE_OUT = MEMSPACEENABLE_delay;
assign #(out_delay) MGMTPSO_OUT = MGMTPSO_delay;
assign #(out_delay) MGMTRDATA_OUT = MGMTRDATA_delay;
assign #(out_delay) MGMTSTATSCREDIT_OUT = MGMTSTATSCREDIT_delay;
assign #(out_delay) MIMDLLBRADD_OUT = MIMDLLBRADD_delay;
assign #(out_delay) MIMDLLBREN_OUT = MIMDLLBREN_delay;
assign #(out_delay) MIMDLLBWADD_OUT = MIMDLLBWADD_delay;
assign #(out_delay) MIMDLLBWDATA_OUT = MIMDLLBWDATA_delay;
assign #(out_delay) MIMDLLBWEN_OUT = MIMDLLBWEN_delay;
assign #(out_delay) MIMRXBRADD_OUT = MIMRXBRADD_delay;
assign #(out_delay) MIMRXBREN_OUT = MIMRXBREN_delay;
assign #(out_delay) MIMRXBWADD_OUT = MIMRXBWADD_delay;
assign #(out_delay) MIMRXBWDATA_OUT = MIMRXBWDATA_delay;
assign #(out_delay) MIMRXBWEN_OUT = MIMRXBWEN_delay;
assign #(out_delay) MIMTXBRADD_OUT = MIMTXBRADD_delay;
assign #(out_delay) MIMTXBREN_OUT = MIMTXBREN_delay;
assign #(out_delay) MIMTXBWADD_OUT = MIMTXBWADD_delay;
assign #(out_delay) MIMTXBWDATA_OUT = MIMTXBWDATA_delay;
assign #(out_delay) MIMTXBWEN_OUT = MIMTXBWEN_delay;
assign #(out_delay) PARITYERRORRESPONSE_OUT = PARITYERRORRESPONSE_delay;
assign #(out_delay) PIPEDESKEWLANESL0_OUT = PIPEDESKEWLANESL0_delay;
assign #(out_delay) PIPEDESKEWLANESL1_OUT = PIPEDESKEWLANESL1_delay;
assign #(out_delay) PIPEDESKEWLANESL2_OUT = PIPEDESKEWLANESL2_delay;
assign #(out_delay) PIPEDESKEWLANESL3_OUT = PIPEDESKEWLANESL3_delay;
assign #(out_delay) PIPEDESKEWLANESL4_OUT = PIPEDESKEWLANESL4_delay;
assign #(out_delay) PIPEDESKEWLANESL5_OUT = PIPEDESKEWLANESL5_delay;
assign #(out_delay) PIPEDESKEWLANESL6_OUT = PIPEDESKEWLANESL6_delay;
assign #(out_delay) PIPEDESKEWLANESL7_OUT = PIPEDESKEWLANESL7_delay;
assign #(out_delay) PIPEPOWERDOWNL0_OUT = PIPEPOWERDOWNL0_delay;
assign #(out_delay) PIPEPOWERDOWNL1_OUT = PIPEPOWERDOWNL1_delay;
assign #(out_delay) PIPEPOWERDOWNL2_OUT = PIPEPOWERDOWNL2_delay;
assign #(out_delay) PIPEPOWERDOWNL3_OUT = PIPEPOWERDOWNL3_delay;
assign #(out_delay) PIPEPOWERDOWNL4_OUT = PIPEPOWERDOWNL4_delay;
assign #(out_delay) PIPEPOWERDOWNL5_OUT = PIPEPOWERDOWNL5_delay;
assign #(out_delay) PIPEPOWERDOWNL6_OUT = PIPEPOWERDOWNL6_delay;
assign #(out_delay) PIPEPOWERDOWNL7_OUT = PIPEPOWERDOWNL7_delay;
assign #(out_delay) PIPERESETL0_OUT = PIPERESETL0_delay;
assign #(out_delay) PIPERESETL1_OUT = PIPERESETL1_delay;
assign #(out_delay) PIPERESETL2_OUT = PIPERESETL2_delay;
assign #(out_delay) PIPERESETL3_OUT = PIPERESETL3_delay;
assign #(out_delay) PIPERESETL4_OUT = PIPERESETL4_delay;
assign #(out_delay) PIPERESETL5_OUT = PIPERESETL5_delay;
assign #(out_delay) PIPERESETL6_OUT = PIPERESETL6_delay;
assign #(out_delay) PIPERESETL7_OUT = PIPERESETL7_delay;
assign #(out_delay) PIPERXPOLARITYL0_OUT = PIPERXPOLARITYL0_delay;
assign #(out_delay) PIPERXPOLARITYL1_OUT = PIPERXPOLARITYL1_delay;
assign #(out_delay) PIPERXPOLARITYL2_OUT = PIPERXPOLARITYL2_delay;
assign #(out_delay) PIPERXPOLARITYL3_OUT = PIPERXPOLARITYL3_delay;
assign #(out_delay) PIPERXPOLARITYL4_OUT = PIPERXPOLARITYL4_delay;
assign #(out_delay) PIPERXPOLARITYL5_OUT = PIPERXPOLARITYL5_delay;
assign #(out_delay) PIPERXPOLARITYL6_OUT = PIPERXPOLARITYL6_delay;
assign #(out_delay) PIPERXPOLARITYL7_OUT = PIPERXPOLARITYL7_delay;
assign #(out_delay) PIPETXCOMPLIANCEL0_OUT = PIPETXCOMPLIANCEL0_delay;
assign #(out_delay) PIPETXCOMPLIANCEL1_OUT = PIPETXCOMPLIANCEL1_delay;
assign #(out_delay) PIPETXCOMPLIANCEL2_OUT = PIPETXCOMPLIANCEL2_delay;
assign #(out_delay) PIPETXCOMPLIANCEL3_OUT = PIPETXCOMPLIANCEL3_delay;
assign #(out_delay) PIPETXCOMPLIANCEL4_OUT = PIPETXCOMPLIANCEL4_delay;
assign #(out_delay) PIPETXCOMPLIANCEL5_OUT = PIPETXCOMPLIANCEL5_delay;
assign #(out_delay) PIPETXCOMPLIANCEL6_OUT = PIPETXCOMPLIANCEL6_delay;
assign #(out_delay) PIPETXCOMPLIANCEL7_OUT = PIPETXCOMPLIANCEL7_delay;
assign #(out_delay) PIPETXDATAKL0_OUT = PIPETXDATAKL0_delay;
assign #(out_delay) PIPETXDATAKL1_OUT = PIPETXDATAKL1_delay;
assign #(out_delay) PIPETXDATAKL2_OUT = PIPETXDATAKL2_delay;
assign #(out_delay) PIPETXDATAKL3_OUT = PIPETXDATAKL3_delay;
assign #(out_delay) PIPETXDATAKL4_OUT = PIPETXDATAKL4_delay;
assign #(out_delay) PIPETXDATAKL5_OUT = PIPETXDATAKL5_delay;
assign #(out_delay) PIPETXDATAKL6_OUT = PIPETXDATAKL6_delay;
assign #(out_delay) PIPETXDATAKL7_OUT = PIPETXDATAKL7_delay;
assign #(out_delay) PIPETXDATAL0_OUT = PIPETXDATAL0_delay;
assign #(out_delay) PIPETXDATAL1_OUT = PIPETXDATAL1_delay;
assign #(out_delay) PIPETXDATAL2_OUT = PIPETXDATAL2_delay;
assign #(out_delay) PIPETXDATAL3_OUT = PIPETXDATAL3_delay;
assign #(out_delay) PIPETXDATAL4_OUT = PIPETXDATAL4_delay;
assign #(out_delay) PIPETXDATAL5_OUT = PIPETXDATAL5_delay;
assign #(out_delay) PIPETXDATAL6_OUT = PIPETXDATAL6_delay;
assign #(out_delay) PIPETXDATAL7_OUT = PIPETXDATAL7_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL0_OUT = PIPETXDETECTRXLOOPBACKL0_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL1_OUT = PIPETXDETECTRXLOOPBACKL1_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL2_OUT = PIPETXDETECTRXLOOPBACKL2_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL3_OUT = PIPETXDETECTRXLOOPBACKL3_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL4_OUT = PIPETXDETECTRXLOOPBACKL4_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL5_OUT = PIPETXDETECTRXLOOPBACKL5_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL6_OUT = PIPETXDETECTRXLOOPBACKL6_delay;
assign #(out_delay) PIPETXDETECTRXLOOPBACKL7_OUT = PIPETXDETECTRXLOOPBACKL7_delay;
assign #(out_delay) PIPETXELECIDLEL0_OUT = PIPETXELECIDLEL0_delay;
assign #(out_delay) PIPETXELECIDLEL1_OUT = PIPETXELECIDLEL1_delay;
assign #(out_delay) PIPETXELECIDLEL2_OUT = PIPETXELECIDLEL2_delay;
assign #(out_delay) PIPETXELECIDLEL3_OUT = PIPETXELECIDLEL3_delay;
assign #(out_delay) PIPETXELECIDLEL4_OUT = PIPETXELECIDLEL4_delay;
assign #(out_delay) PIPETXELECIDLEL5_OUT = PIPETXELECIDLEL5_delay;
assign #(out_delay) PIPETXELECIDLEL6_OUT = PIPETXELECIDLEL6_delay;
assign #(out_delay) PIPETXELECIDLEL7_OUT = PIPETXELECIDLEL7_delay;
assign #(out_delay) SERRENABLE_OUT = SERRENABLE_delay;
assign #(out_delay) URREPORTINGENABLE_OUT = URREPORTINGENABLE_delay;

assign #(CLK_DELAY) CRMCORECLKDLO_delay = CRMCORECLKDLO_IN;
assign #(CLK_DELAY) CRMCORECLKRXO_delay = CRMCORECLKRXO_IN;
assign #(CLK_DELAY) CRMCORECLKTXO_delay = CRMCORECLKTXO_IN;
//assign #(CLK_DELAY) CRMCORECLK_delay = CRMCORECLK_IN;
assign #(CLK_DELAY) CRMUSERCLKRXO_delay = CRMUSERCLKRXO_IN;
assign #(CLK_DELAY) CRMUSERCLKTXO_delay = CRMUSERCLKTXO_IN;
//assign #(CLK_DELAY) CRMUSERCLK_delay = CRMUSERCLK_IN;

//assign #(in_delay) AUXPOWER_delay = AUXPOWER_IN;
//assign #(in_delay) CFGNEGOTIATEDLINKWIDTH_delay = CFGNEGOTIATEDLINKWIDTH_IN;
//assign #(in_delay) COMPLIANCEAVOID_delay = COMPLIANCEAVOID_IN;
//assign #(in_delay) CRMCFGBRIDGEHOTRESET_delay = CRMCFGBRIDGEHOTRESET_IN;
assign #(in_delay) CRMLINKRSTN_delay = CRMLINKRSTN_IN;
assign #(in_delay) CRMMACRSTN_delay = CRMMACRSTN_IN;
assign #(in_delay) CRMMGMTRSTN_delay = CRMMGMTRSTN_IN;
assign #(in_delay) CRMNVRSTN_delay = CRMNVRSTN_IN;
//assign #(in_delay) CRMTXHOTRESETN_delay = CRMTXHOTRESETN_IN;
assign #(in_delay) CRMURSTN_delay = CRMURSTN_IN;
assign #(in_delay) CRMUSERCFGRSTN_delay = CRMUSERCFGRSTN_IN;
//assign #(in_delay) CROSSLINKSEED_delay = CROSSLINKSEED_IN;
//assign #(in_delay) L0ACKNAKTIMERADJUSTMENT_delay = L0ACKNAKTIMERADJUSTMENT_IN;
//assign #(in_delay) L0ALLDOWNPORTSINL1_delay = L0ALLDOWNPORTSINL1_IN;
//assign #(in_delay) L0ALLDOWNRXPORTSINL0S_delay = L0ALLDOWNRXPORTSINL0S_IN;
//assign #(in_delay) L0ASE_delay = L0ASE_IN;
//assign #(in_delay) L0ASPORTCOUNT_delay = L0ASPORTCOUNT_IN;
//assign #(in_delay) L0ASTURNPOOLBITSCONSUMED_delay = L0ASTURNPOOLBITSCONSUMED_IN;
//assign #(in_delay) L0ATTENTIONBUTTONPRESSED_delay = L0ATTENTIONBUTTONPRESSED_IN;
//assign #(in_delay) L0CFGASSPANTREEOWNEDSTATE_delay = L0CFGASSPANTREEOWNEDSTATE_IN;
//assign #(in_delay) L0CFGASSTATECHANGECMD_delay = L0CFGASSTATECHANGECMD_IN;
//assign #(in_delay) L0CFGDISABLESCRAMBLE_delay = L0CFGDISABLESCRAMBLE_IN;
//assign #(in_delay) L0CFGEXTENDEDSYNC_delay = L0CFGEXTENDEDSYNC_IN;
//assign #(in_delay) L0CFGL0SENTRYENABLE_delay = L0CFGL0SENTRYENABLE_IN;
//assign #(in_delay) L0CFGL0SENTRYSUP_delay = L0CFGL0SENTRYSUP_IN;
//assign #(in_delay) L0CFGL0SEXITLAT_delay = L0CFGL0SEXITLAT_IN;
//assign #(in_delay) L0CFGLINKDISABLE_delay = L0CFGLINKDISABLE_IN;
//assign #(in_delay) L0CFGLOOPBACKMASTER_delay = L0CFGLOOPBACKMASTER_IN;
//assign #(in_delay) L0CFGNEGOTIATEDMAXP_delay = L0CFGNEGOTIATEDMAXP_IN;
//assign #(in_delay) L0CFGVCENABLE_delay = L0CFGVCENABLE_IN;
//assign #(in_delay) L0CFGVCID_delay = L0CFGVCID_IN;
//assign #(in_delay) L0DLLHOLDLINKUP_delay = L0DLLHOLDLINKUP_IN;
//assign #(in_delay) L0ELECTROMECHANICALINTERLOCKENGAGED_delay = L0ELECTROMECHANICALINTERLOCKENGAGED_IN;
//assign #(in_delay) L0FWDASSERTINTALEGACYINT_delay = L0FWDASSERTINTALEGACYINT_IN;
//assign #(in_delay) L0FWDASSERTINTBLEGACYINT_delay = L0FWDASSERTINTBLEGACYINT_IN;
//assign #(in_delay) L0FWDASSERTINTCLEGACYINT_delay = L0FWDASSERTINTCLEGACYINT_IN;
//assign #(in_delay) L0FWDASSERTINTDLEGACYINT_delay = L0FWDASSERTINTDLEGACYINT_IN;
//assign #(in_delay) L0FWDCORRERRIN_delay = L0FWDCORRERRIN_IN;
//assign #(in_delay) L0FWDDEASSERTINTALEGACYINT_delay = L0FWDDEASSERTINTALEGACYINT_IN;
//assign #(in_delay) L0FWDDEASSERTINTBLEGACYINT_delay = L0FWDDEASSERTINTBLEGACYINT_IN;
//assign #(in_delay) L0FWDDEASSERTINTCLEGACYINT_delay = L0FWDDEASSERTINTCLEGACYINT_IN;
//assign #(in_delay) L0FWDDEASSERTINTDLEGACYINT_delay = L0FWDDEASSERTINTDLEGACYINT_IN;
//assign #(in_delay) L0FWDFATALERRIN_delay = L0FWDFATALERRIN_IN;
//assign #(in_delay) L0FWDNONFATALERRIN_delay = L0FWDNONFATALERRIN_IN;
//assign #(in_delay) L0LEGACYINTFUNCT0_delay = L0LEGACYINTFUNCT0_IN;
//assign #(in_delay) L0MRLSENSORCLOSEDN_delay = L0MRLSENSORCLOSEDN_IN;
//assign #(in_delay) L0MSIREQUEST0_delay = L0MSIREQUEST0_IN;
//assign #(in_delay) L0PACKETHEADERFROMUSER_delay = L0PACKETHEADERFROMUSER_IN;
//assign #(in_delay) L0PMEREQIN_delay = L0PMEREQIN_IN;
//assign #(in_delay) L0PORTNUMBER_delay = L0PORTNUMBER_IN;
//assign #(in_delay) L0POWERFAULTDETECTED_delay = L0POWERFAULTDETECTED_IN;
//assign #(in_delay) L0PRESENCEDETECTSLOTEMPTYN_delay = L0PRESENCEDETECTSLOTEMPTYN_IN;
///assign #(in_delay) L0PWRNEWSTATEREQ_delay = L0PWRNEWSTATEREQ_IN;
//assign #(in_delay) L0PWRNEXTLINKSTATE_delay = L0PWRNEXTLINKSTATE_IN;
//assign #(in_delay) L0REPLAYTIMERADJUSTMENT_delay = L0REPLAYTIMERADJUSTMENT_IN;
//assign #(in_delay) L0ROOTTURNOFFREQ_delay = L0ROOTTURNOFFREQ_IN;
//assign #(in_delay) L0RXTLTLPNONINITIALIZEDVC_delay = L0RXTLTLPNONINITIALIZEDVC_IN;
//assign #(in_delay) L0SENDUNLOCKMESSAGE_delay = L0SENDUNLOCKMESSAGE_IN;
//assign #(in_delay) L0SETCOMPLETERABORTERROR_delay = L0SETCOMPLETERABORTERROR_IN;
//assign #(in_delay) L0SETCOMPLETIONTIMEOUTCORRERROR_delay = L0SETCOMPLETIONTIMEOUTCORRERROR_IN;
//assign #(in_delay) L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay = L0SETCOMPLETIONTIMEOUTUNCORRERROR_IN;
//assign #(in_delay) L0SETDETECTEDCORRERROR_delay = L0SETDETECTEDCORRERROR_IN;
//assign #(in_delay) L0SETDETECTEDFATALERROR_delay = L0SETDETECTEDFATALERROR_IN;
//assign #(in_delay) L0SETDETECTEDNONFATALERROR_delay = L0SETDETECTEDNONFATALERROR_IN;
//assign #(in_delay) L0SETLINKDETECTEDPARITYERROR_delay = L0SETLINKDETECTEDPARITYERROR_IN;
//assign #(in_delay) L0SETLINKMASTERDATAPARITY_delay = L0SETLINKMASTERDATAPARITY_IN;
//assign #(in_delay) L0SETLINKRECEIVEDMASTERABORT_delay = L0SETLINKRECEIVEDMASTERABORT_IN;
//assign #(in_delay) L0SETLINKRECEIVEDTARGETABORT_delay = L0SETLINKRECEIVEDTARGETABORT_IN;
//assign #(in_delay) L0SETLINKSIGNALLEDTARGETABORT_delay = L0SETLINKSIGNALLEDTARGETABORT_IN;
//assign #(in_delay) L0SETLINKSYSTEMERROR_delay = L0SETLINKSYSTEMERROR_IN;
//assign #(in_delay) L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay = L0SETUNEXPECTEDCOMPLETIONCORRERROR_IN;
//assign #(in_delay) L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay = L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_IN;
//assign #(in_delay) L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay = L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_IN;
//assign #(in_delay) L0SETUNSUPPORTEDREQUESTOTHERERROR_delay = L0SETUNSUPPORTEDREQUESTOTHERERROR_IN;
//assign #(in_delay) L0SETUSERDETECTEDPARITYERROR_delay = L0SETUSERDETECTEDPARITYERROR_IN;
//assign #(in_delay) L0SETUSERMASTERDATAPARITY_delay = L0SETUSERMASTERDATAPARITY_IN;
//assign #(in_delay) L0SETUSERRECEIVEDMASTERABORT_delay = L0SETUSERRECEIVEDMASTERABORT_IN;
//assign #(in_delay) L0SETUSERRECEIVEDTARGETABORT_delay = L0SETUSERRECEIVEDTARGETABORT_IN;
//assign #(in_delay) L0SETUSERSIGNALLEDTARGETABORT_delay = L0SETUSERSIGNALLEDTARGETABORT_IN;
//assign #(in_delay) L0SETUSERSYSTEMERROR_delay = L0SETUSERSYSTEMERROR_IN;
//assign #(in_delay) L0TLASFCCREDSTARVATION_delay = L0TLASFCCREDSTARVATION_IN;
//assign #(in_delay) L0TLLINKRETRAIN_delay = L0TLLINKRETRAIN_IN;
//assign #(in_delay) L0TRANSACTIONSPENDING_delay = L0TRANSACTIONSPENDING_IN;
//assign #(in_delay) L0TXBEACON_delay = L0TXBEACON_IN;
//assign #(in_delay) L0TXCFGPMTYPE_delay = L0TXCFGPMTYPE_IN;
//assign #(in_delay) L0TXCFGPM_delay = L0TXCFGPM_IN;
//assign #(in_delay) L0TXTLFCCMPLMCCRED_delay = L0TXTLFCCMPLMCCRED_IN;
//assign #(in_delay) L0TXTLFCCMPLMCUPDATE_delay = L0TXTLFCCMPLMCUPDATE_IN;
//assign #(in_delay) L0TXTLFCNPOSTBYPCRED_delay = L0TXTLFCNPOSTBYPCRED_IN;
//assign #(in_delay) L0TXTLFCNPOSTBYPUPDATE_delay = L0TXTLFCNPOSTBYPUPDATE_IN;
//assign #(in_delay) L0TXTLFCPOSTORDCRED_delay = L0TXTLFCPOSTORDCRED_IN;
//assign #(in_delay) L0TXTLFCPOSTORDUPDATE_delay = L0TXTLFCPOSTORDUPDATE_IN;
//assign #(in_delay) L0TXTLSBFCDATA_delay = L0TXTLSBFCDATA_IN;
//assign #(in_delay) L0TXTLSBFCUPDATE_delay = L0TXTLSBFCUPDATE_IN;
//assign #(in_delay) L0TXTLTLPDATA_delay = L0TXTLTLPDATA_IN;
//assign #(in_delay) L0TXTLTLPEDB_delay = L0TXTLTLPEDB_IN;
//assign #(in_delay) L0TXTLTLPENABLE_delay = L0TXTLTLPENABLE_IN;
//assign #(in_delay) L0TXTLTLPEND_delay = L0TXTLTLPEND_IN;
//assign #(in_delay) L0TXTLTLPLATENCY_delay = L0TXTLTLPLATENCY_IN;
//assign #(in_delay) L0TXTLTLPREQEND_delay = L0TXTLTLPREQEND_IN;
//assign #(in_delay) L0TXTLTLPREQ_delay = L0TXTLTLPREQ_IN;
//assign #(in_delay) L0TXTLTLPWIDTH_delay = L0TXTLTLPWIDTH_IN;
//assign #(in_delay) L0UPSTREAMRXPORTINL0S_delay = L0UPSTREAMRXPORTINL0S_IN;
//assign #(in_delay) L0VC0PREVIEWEXPAND_delay = L0VC0PREVIEWEXPAND_IN;
//assign #(in_delay) L0WAKEN_delay = L0WAKEN_IN;
//assign #(in_delay) LLKRXCHFIFO_delay = LLKRXCHFIFO_IN;
//assign #(in_delay) LLKRXCHTC_delay = LLKRXCHTC_IN;
//assign #(in_delay) LLKRXDSTCONTREQN_delay = LLKRXDSTCONTREQN_IN;
//assign #(in_delay) LLKRXDSTREQN_delay = LLKRXDSTREQN_IN;
//assign #(in_delay) LLKTX4DWHEADERN_delay = LLKTX4DWHEADERN_IN;
//assign #(in_delay) LLKTXCHFIFO_delay = LLKTXCHFIFO_IN;
//assign #(in_delay) LLKTXCHTC_delay = LLKTXCHTC_IN;
//assign #(in_delay) LLKTXCOMPLETEN_delay = LLKTXCOMPLETEN_IN;
//assign #(in_delay) LLKTXCREATEECRCN_delay = LLKTXCREATEECRCN_IN;
//assign #(in_delay) LLKTXDATA_delay = LLKTXDATA_IN;
//assign #(in_delay) LLKTXENABLEN_delay = LLKTXENABLEN_IN;
//assign #(in_delay) LLKTXEOFN_delay = LLKTXEOFN_IN;
//assign #(in_delay) LLKTXEOPN_delay = LLKTXEOPN_IN;
//assign #(in_delay) LLKTXSOFN_delay = LLKTXSOFN_IN;
//assign #(in_delay) LLKTXSOPN_delay = LLKTXSOPN_IN;
//assign #(in_delay) LLKTXSRCDSCN_delay = LLKTXSRCDSCN_IN;
//assign #(in_delay) LLKTXSRCRDYN_delay = LLKTXSRCRDYN_IN;
//assign #(in_delay) MAINPOWER_delay = MAINPOWER_IN;
//assign #(in_delay) MGMTADDR_delay = MGMTADDR_IN;
//assign #(in_delay) MGMTBWREN_delay = MGMTBWREN_IN;
//assign #(in_delay) MGMTRDEN_delay = MGMTRDEN_IN;
//assign #(in_delay) MGMTSTATSCREDITSEL_delay = MGMTSTATSCREDITSEL_IN;
//assign #(in_delay) MGMTWDATA_delay = MGMTWDATA_IN;
//assign #(in_delay) MGMTWREN_delay = MGMTWREN_IN;
//assign #(in_delay) MIMDLLBRDATA_delay = MIMDLLBRDATA_IN;
//assign #(in_delay) MIMRXBRDATA_delay = MIMRXBRDATA_IN;
//assign #(in_delay) MIMTXBRDATA_delay = MIMTXBRDATA_IN;
//assign #(in_delay) PIPEPHYSTATUSL0_delay = PIPEPHYSTATUSL0_IN;
//assign #(in_delay) PIPEPHYSTATUSL1_delay = PIPEPHYSTATUSL1_IN;
//assign #(in_delay) PIPEPHYSTATUSL2_delay = PIPEPHYSTATUSL2_IN;
//assign #(in_delay) PIPEPHYSTATUSL3_delay = PIPEPHYSTATUSL3_IN;
//assign #(in_delay) PIPEPHYSTATUSL4_delay = PIPEPHYSTATUSL4_IN;
//assign #(in_delay) PIPEPHYSTATUSL5_delay = PIPEPHYSTATUSL5_IN;
//assign #(in_delay) PIPEPHYSTATUSL6_delay = PIPEPHYSTATUSL6_IN;
//assign #(in_delay) PIPEPHYSTATUSL7_delay = PIPEPHYSTATUSL7_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL0_delay = PIPERXCHANISALIGNEDL0_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL1_delay = PIPERXCHANISALIGNEDL1_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL2_delay = PIPERXCHANISALIGNEDL2_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL3_delay = PIPERXCHANISALIGNEDL3_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL4_delay = PIPERXCHANISALIGNEDL4_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL5_delay = PIPERXCHANISALIGNEDL5_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL6_delay = PIPERXCHANISALIGNEDL6_IN;
//assign #(in_delay) PIPERXCHANISALIGNEDL7_delay = PIPERXCHANISALIGNEDL7_IN;
//assign #(in_delay) PIPERXDATAKL0_delay = PIPERXDATAKL0_IN;
//assign #(in_delay) PIPERXDATAKL1_delay = PIPERXDATAKL1_IN;
//assign #(in_delay) PIPERXDATAKL2_delay = PIPERXDATAKL2_IN;
//assign #(in_delay) PIPERXDATAKL3_delay = PIPERXDATAKL3_IN;
//assign #(in_delay) PIPERXDATAKL4_delay = PIPERXDATAKL4_IN;
//assign #(in_delay) PIPERXDATAKL5_delay = PIPERXDATAKL5_IN;
//assign #(in_delay) PIPERXDATAKL6_delay = PIPERXDATAKL6_IN;
//assign #(in_delay) PIPERXDATAKL7_delay = PIPERXDATAKL7_IN;
//assign #(in_delay) PIPERXDATAL0_delay = PIPERXDATAL0_IN;
//assign #(in_delay) PIPERXDATAL1_delay = PIPERXDATAL1_IN;
//assign #(in_delay) PIPERXDATAL2_delay = PIPERXDATAL2_IN;
//assign #(in_delay) PIPERXDATAL3_delay = PIPERXDATAL3_IN;
//assign #(in_delay) PIPERXDATAL4_delay = PIPERXDATAL4_IN;
//assign #(in_delay) PIPERXDATAL5_delay = PIPERXDATAL5_IN;
//assign #(in_delay) PIPERXDATAL6_delay = PIPERXDATAL6_IN;
//assign #(in_delay) PIPERXDATAL7_delay = PIPERXDATAL7_IN;
//assign #(in_delay) PIPERXELECIDLEL0_delay = PIPERXELECIDLEL0_IN;
//assign #(in_delay) PIPERXELECIDLEL1_delay = PIPERXELECIDLEL1_IN;
//assign #(in_delay) PIPERXELECIDLEL2_delay = PIPERXELECIDLEL2_IN;
//assign #(in_delay) PIPERXELECIDLEL3_delay = PIPERXELECIDLEL3_IN;
//assign #(in_delay) PIPERXELECIDLEL4_delay = PIPERXELECIDLEL4_IN;
//assign #(in_delay) PIPERXELECIDLEL5_delay = PIPERXELECIDLEL5_IN;
//assign #(in_delay) PIPERXELECIDLEL6_delay = PIPERXELECIDLEL6_IN;
//assign #(in_delay) PIPERXELECIDLEL7_delay = PIPERXELECIDLEL7_IN;
//assign #(in_delay) PIPERXSTATUSL0_delay = PIPERXSTATUSL0_IN;
//assign #(in_delay) PIPERXSTATUSL1_delay = PIPERXSTATUSL1_IN;
//assign #(in_delay) PIPERXSTATUSL2_delay = PIPERXSTATUSL2_IN;
//assign #(in_delay) PIPERXSTATUSL3_delay = PIPERXSTATUSL3_IN;
//assign #(in_delay) PIPERXSTATUSL4_delay = PIPERXSTATUSL4_IN;
//assign #(in_delay) PIPERXSTATUSL5_delay = PIPERXSTATUSL5_IN;
//assign #(in_delay) PIPERXSTATUSL6_delay = PIPERXSTATUSL6_IN;
//assign #(in_delay) PIPERXSTATUSL7_delay = PIPERXSTATUSL7_IN;
//assign #(in_delay) PIPERXVALIDL0_delay = PIPERXVALIDL0_IN;
//assign #(in_delay) PIPERXVALIDL1_delay = PIPERXVALIDL1_IN;
//assign #(in_delay) PIPERXVALIDL2_delay = PIPERXVALIDL2_IN;
//assign #(in_delay) PIPERXVALIDL3_delay = PIPERXVALIDL3_IN;
//assign #(in_delay) PIPERXVALIDL4_delay = PIPERXVALIDL4_IN;
//assign #(in_delay) PIPERXVALIDL5_delay = PIPERXVALIDL5_IN;
//assign #(in_delay) PIPERXVALIDL6_delay = PIPERXVALIDL6_IN;
//assign #(in_delay) PIPERXVALIDL7_delay = PIPERXVALIDL7_IN;


PCIE_INTERNAL_1_1_SWIFT pcie_internal_1_1_swift_1 (
	.MCACTIVELANESIN (ACTIVELANESIN),
	.MCAERBASEPTR (AERBASEPTR),
	.MCAERCAPABILITYECRCCHECKCAPABLE (AERCAPABILITYECRCCHECKCAPABLE_BINARY),
	.MCAERCAPABILITYECRCGENCAPABLE (AERCAPABILITYECRCGENCAPABLE_BINARY),
	.MCAERCAPABILITYNEXTPTR (AERCAPABILITYNEXTPTR),
	.MCBAR0ADDRWIDTH (BAR0ADDRWIDTH_BINARY),
	.MCBAR0EXIST (BAR0EXIST_BINARY),
	.MCBAR0IOMEMN (BAR0IOMEMN_BINARY),
	.MCBAR0MASKWIDTH (BAR0MASKWIDTH),
	.MCBAR0PREFETCHABLE (BAR0PREFETCHABLE_BINARY),
	.MCBAR1ADDRWIDTH (BAR1ADDRWIDTH_BINARY),
	.MCBAR1EXIST (BAR1EXIST_BINARY),
	.MCBAR1IOMEMN (BAR1IOMEMN_BINARY),
	.MCBAR1MASKWIDTH (BAR1MASKWIDTH),
	.MCBAR1PREFETCHABLE (BAR1PREFETCHABLE_BINARY),
	.MCBAR2ADDRWIDTH (BAR2ADDRWIDTH_BINARY),
	.MCBAR2EXIST (BAR2EXIST_BINARY),
	.MCBAR2IOMEMN (BAR2IOMEMN_BINARY),
	.MCBAR2MASKWIDTH (BAR2MASKWIDTH),
	.MCBAR2PREFETCHABLE (BAR2PREFETCHABLE_BINARY),
	.MCBAR3ADDRWIDTH (BAR3ADDRWIDTH_BINARY),
	.MCBAR3EXIST (BAR3EXIST_BINARY),
	.MCBAR3IOMEMN (BAR3IOMEMN_BINARY),
	.MCBAR3MASKWIDTH (BAR3MASKWIDTH),
	.MCBAR3PREFETCHABLE (BAR3PREFETCHABLE_BINARY),
	.MCBAR4ADDRWIDTH (BAR4ADDRWIDTH_BINARY),
	.MCBAR4EXIST (BAR4EXIST_BINARY),
	.MCBAR4IOMEMN (BAR4IOMEMN_BINARY),
	.MCBAR4MASKWIDTH (BAR4MASKWIDTH),
	.MCBAR4PREFETCHABLE (BAR4PREFETCHABLE_BINARY),
	.MCBAR5ADDRWIDTH (1'b0),
	.MCBAR5EXIST (BAR5EXIST_BINARY),
	.MCBAR5IOMEMN (BAR5IOMEMN_BINARY),
	.MCBAR5MASKWIDTH (BAR5MASKWIDTH),
	.MCBAR5PREFETCHABLE (BAR5PREFETCHABLE_BINARY),
	.MCCAPABILITIESPOINTER (CAPABILITIESPOINTER),
	.MCCARDBUSCISPOINTER (CARDBUSCISPOINTER),
	.MCCLASSCODE (CLASSCODE),
	.MCCONFIGROUTING (CONFIGROUTING),
	.MCDEVICECAPABILITYENDPOINTL0SLATENCY (DEVICECAPABILITYENDPOINTL0SLATENCY),
	.MCDEVICECAPABILITYENDPOINTL1LATENCY (DEVICECAPABILITYENDPOINTL1LATENCY),
	.MCDEVICEID (DEVICEID),
	.MCDEVICESERIALNUMBER (DEVICESERIALNUMBER),
	.MCDSNBASEPTR (DSNBASEPTR),
	.MCDSNCAPABILITYNEXTPTR (DSNCAPABILITYNEXTPTR),
	.MCDUALCOREENABLE (DUALCOREENABLE_BINARY),
	.MCDUALCORESLAVE (DUALCORESLAVE_BINARY),
	.MCDUALROLECFGCNTRLROOTEPN (DUALROLECFGCNTRLROOTEPN_BINARY),
	.MCEXTCFGCAPPTR (EXTCFGCAPPTR),
	.MCEXTCFGXPCAPPTR (EXTCFGXPCAPPTR),
	.MCHEADERTYPE (HEADERTYPE),
	.MCINFINITECOMPLETIONS (INFINITECOMPLETIONS_BINARY),
	.MCINTERRUPTPIN (INTERRUPTPIN),
	.MCISSWITCH (ISSWITCH_BINARY),
	.MCL0SEXITLATENCY (L0SEXITLATENCY_BINARY),
	.MCL0SEXITLATENCYCOMCLK (L0SEXITLATENCYCOMCLK_BINARY),
	.MCL1EXITLATENCY (L1EXITLATENCY_BINARY),
	.MCL1EXITLATENCYCOMCLK (L1EXITLATENCYCOMCLK_BINARY),
	.MCLINKCAPABILITYASPMSUPPORT (LINKCAPABILITYASPMSUPPORT),
	.MCLINKCAPABILITYMAXLINKWIDTH (LINKCAPABILITYMAXLINKWIDTH),
	.MCLINKSTATUSSLOTCLOCKCONFIG (LINKSTATUSSLOTCLOCKCONFIG_BINARY),
	.MCLLKBYPASS (LLKBYPASS_BINARY),
	.MCLOWPRIORITYVCCOUNT (LOWPRIORITYVCCOUNT_BINARY),
	.MCMSIBASEPTR (MSIBASEPTR),
	.MCMSICAPABILITYMULTIMSGCAP (MSICAPABILITYMULTIMSGCAP),
	.MCMSICAPABILITYNEXTPTR (MSICAPABILITYNEXTPTR),
	.MCPBBASEPTR (PBBASEPTR),
	.MCPBCAPABILITYDW0BASEPOWER (PBCAPABILITYDW0BASEPOWER),
	.MCPBCAPABILITYDW0DATASCALE (PBCAPABILITYDW0DATASCALE),
	.MCPBCAPABILITYDW0PMSTATE (PBCAPABILITYDW0PMSTATE),
	.MCPBCAPABILITYDW0PMSUBSTATE (PBCAPABILITYDW0PMSUBSTATE),
	.MCPBCAPABILITYDW0POWERRAIL (PBCAPABILITYDW0POWERRAIL),
	.MCPBCAPABILITYDW0TYPE (PBCAPABILITYDW0TYPE),
	.MCPBCAPABILITYDW1BASEPOWER (PBCAPABILITYDW1BASEPOWER),
	.MCPBCAPABILITYDW1DATASCALE (PBCAPABILITYDW1DATASCALE),
	.MCPBCAPABILITYDW1PMSTATE (PBCAPABILITYDW1PMSTATE),
	.MCPBCAPABILITYDW1PMSUBSTATE (PBCAPABILITYDW1PMSUBSTATE),
	.MCPBCAPABILITYDW1POWERRAIL (PBCAPABILITYDW1POWERRAIL),
	.MCPBCAPABILITYDW1TYPE (PBCAPABILITYDW1TYPE),
	.MCPBCAPABILITYDW2BASEPOWER (PBCAPABILITYDW2BASEPOWER),
	.MCPBCAPABILITYDW2DATASCALE (PBCAPABILITYDW2DATASCALE),
	.MCPBCAPABILITYDW2PMSTATE (PBCAPABILITYDW2PMSTATE),
	.MCPBCAPABILITYDW2PMSUBSTATE (PBCAPABILITYDW2PMSUBSTATE),
	.MCPBCAPABILITYDW2POWERRAIL (PBCAPABILITYDW2POWERRAIL),
	.MCPBCAPABILITYDW2TYPE (PBCAPABILITYDW2TYPE),
	.MCPBCAPABILITYDW3BASEPOWER (PBCAPABILITYDW3BASEPOWER),
	.MCPBCAPABILITYDW3DATASCALE (PBCAPABILITYDW3DATASCALE),
	.MCPBCAPABILITYDW3PMSTATE (PBCAPABILITYDW3PMSTATE),
	.MCPBCAPABILITYDW3PMSUBSTATE (PBCAPABILITYDW3PMSUBSTATE),
	.MCPBCAPABILITYDW3POWERRAIL (PBCAPABILITYDW3POWERRAIL),
	.MCPBCAPABILITYDW3TYPE (PBCAPABILITYDW3TYPE),
	.MCPBCAPABILITYNEXTPTR (PBCAPABILITYNEXTPTR),
	.MCPBCAPABILITYSYSTEMALLOCATED (PBCAPABILITYSYSTEMALLOCATED_BINARY),
	.MCPCIECAPABILITYINTMSGNUM (PCIECAPABILITYINTMSGNUM),
	.MCPCIECAPABILITYNEXTPTR (PCIECAPABILITYNEXTPTR),
	.MCPCIECAPABILITYSLOTIMPL (PCIECAPABILITYSLOTIMPL_BINARY),
	.MCPCIEREVISION (PCIEREVISION_BINARY),
	.MCPMBASEPTR (PMBASEPTR),
	.MCPMCAPABILITYAUXCURRENT (PMCAPABILITYAUXCURRENT),
	.MCPMCAPABILITYD1SUPPORT (PMCAPABILITYD1SUPPORT_BINARY),
	.MCPMCAPABILITYD2SUPPORT (PMCAPABILITYD2SUPPORT_BINARY),
	.MCPMCAPABILITYDSI (PMCAPABILITYDSI_BINARY),
	.MCPMCAPABILITYNEXTPTR (PMCAPABILITYNEXTPTR),
	.MCPMCAPABILITYPMESUPPORT (PMCAPABILITYPMESUPPORT),
	.MCPMDATA0 (PMDATA0),
	.MCPMDATA1 (PMDATA1),
	.MCPMDATA2 (PMDATA2),
	.MCPMDATA3 (PMDATA3),
	.MCPMDATA4 (PMDATA4),
	.MCPMDATA5 (PMDATA5),
	.MCPMDATA6 (PMDATA6),
	.MCPMDATA7 (PMDATA7),
	.MCPMDATA8 (PMDATA8),
	.MCPMDATASCALE0 (PMDATASCALE0_BINARY),
	.MCPMDATASCALE1 (PMDATASCALE1_BINARY),
	.MCPMDATASCALE2 (PMDATASCALE2_BINARY),
	.MCPMDATASCALE3 (PMDATASCALE3_BINARY),
	.MCPMDATASCALE4 (PMDATASCALE4_BINARY),
	.MCPMDATASCALE5 (PMDATASCALE5_BINARY),
	.MCPMDATASCALE6 (PMDATASCALE6_BINARY),
	.MCPMDATASCALE7 (PMDATASCALE7_BINARY),
	.MCPMDATASCALE8 (PMDATASCALE8_BINARY),
	.MCPMSTATUSCONTROLDATASCALE (PMSTATUSCONTROLDATASCALE),
	.MCPORTVCCAPABILITYEXTENDEDVCCOUNT (PORTVCCAPABILITYEXTENDEDVCCOUNT),
	.MCPORTVCCAPABILITYVCARBCAP (PORTVCCAPABILITYVCARBCAP),
	.MCPORTVCCAPABILITYVCARBTABLEOFFSET (PORTVCCAPABILITYVCARBTABLEOFFSET),
	.MCRAMSHARETXRX (RAMSHARETXRX_BINARY),
	.MCRESETMODE (RESETMODE_BINARY),
	.MCRETRYRAMREADLATENCY (RETRYRAMREADLATENCY_BINARY),
	.MCRETRYRAMSIZE (RETRYRAMSIZE),
	.MCRETRYRAMWIDTH (RETRYRAMWIDTH_BINARY),
	.MCRETRYRAMWRITELATENCY (RETRYRAMWRITELATENCY_BINARY),
	.MCRETRYREADADDRPIPE (RETRYREADADDRPIPE_BINARY),
	.MCRETRYREADDATAPIPE (RETRYREADDATAPIPE_BINARY),
	.MCRETRYWRITEPIPE (RETRYWRITEPIPE_BINARY),
	.MCREVISIONID (REVISIONID),
	.MCRXREADADDRPIPE (RXREADADDRPIPE_BINARY),
	.MCRXREADDATAPIPE (RXREADDATAPIPE_BINARY),
	.MCRXWRITEPIPE (RXWRITEPIPE_BINARY),
	.MCSELECTASMODE (SELECTASMODE_BINARY),
	.MCSELECTDLLIF (SELECTDLLIF_BINARY),
	.MCSLOTCAPABILITYATTBUTTONPRESENT (SLOTCAPABILITYATTBUTTONPRESENT_BINARY),
	.MCSLOTCAPABILITYATTINDICATORPRESENT (SLOTCAPABILITYATTINDICATORPRESENT_BINARY),
	.MCSLOTCAPABILITYHOTPLUGCAPABLE (SLOTCAPABILITYHOTPLUGCAPABLE_BINARY),
	.MCSLOTCAPABILITYHOTPLUGSURPRISE (SLOTCAPABILITYHOTPLUGSURPRISE_BINARY),
	.MCSLOTCAPABILITYMSLSENSORPRESENT (SLOTCAPABILITYMSLSENSORPRESENT_BINARY),
	.MCSLOTCAPABILITYPHYSICALSLOTNUM (SLOTCAPABILITYPHYSICALSLOTNUM),
	.MCSLOTCAPABILITYPOWERCONTROLLERPRESENT (SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY),
	.MCSLOTCAPABILITYPOWERINDICATORPRESENT (SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY),
	.MCSLOTCAPABILITYSLOTPOWERLIMITSCALE (SLOTCAPABILITYSLOTPOWERLIMITSCALE),
	.MCSLOTCAPABILITYSLOTPOWERLIMITVALUE (SLOTCAPABILITYSLOTPOWERLIMITVALUE),
	.MCSLOTIMPLEMENTED (SLOTIMPLEMENTED_BINARY),
	.MCSUBSYSTEMID (SUBSYSTEMID),
	.MCSUBSYSTEMVENDORID (SUBSYSTEMVENDORID),
	.MCTLRAMREADLATENCY (TLRAMREADLATENCY_BINARY),
	.MCTLRAMWIDTH (TLRAMWIDTH_BINARY),
	.MCTLRAMWRITELATENCY (TLRAMWRITELATENCY_BINARY),
	.MCTXREADADDRPIPE (TXREADADDRPIPE_BINARY),
	.MCTXREADDATAPIPE (TXREADDATAPIPE_BINARY),
	.MCTXTSNFTS (TXTSNFTS_BINARY),
	.MCTXTSNFTSCOMCLK (TXTSNFTSCOMCLK_BINARY),
	.MCTXWRITEPIPE (TXWRITEPIPE_BINARY),
	.MCUPSTREAMFACING (UPSTREAMFACING_BINARY),
	.MCVC0RXFIFOBASEC (VC0RXFIFOBASEC),
	.MCVC0RXFIFOBASENP (VC0RXFIFOBASENP),
	.MCVC0RXFIFOBASEP (VC0RXFIFOBASEP),
	.MCVC0RXFIFOLIMITC (VC0RXFIFOLIMITC),
	.MCVC0RXFIFOLIMITNP (VC0RXFIFOLIMITNP),
	.MCVC0RXFIFOLIMITP (VC0RXFIFOLIMITP),
	.MCVC0TOTALCREDITSCD (VC0TOTALCREDITSCD),
	.MCVC0TOTALCREDITSCH (VC0TOTALCREDITSCH),
	.MCVC0TOTALCREDITSNPH (VC0TOTALCREDITSNPH),
	.MCVC0TOTALCREDITSPD (VC0TOTALCREDITSPD),
	.MCVC0TOTALCREDITSPH (VC0TOTALCREDITSPH),
	.MCVC0TXFIFOBASEC (VC0TXFIFOBASEC),
	.MCVC0TXFIFOBASENP (VC0TXFIFOBASENP),
	.MCVC0TXFIFOBASEP (VC0TXFIFOBASEP),
	.MCVC0TXFIFOLIMITC (VC0TXFIFOLIMITC),
	.MCVC0TXFIFOLIMITNP (VC0TXFIFOLIMITNP),
	.MCVC0TXFIFOLIMITP (VC0TXFIFOLIMITP),
	.MCVC1RXFIFOBASEC (VC1RXFIFOBASEC),
	.MCVC1RXFIFOBASENP (VC1RXFIFOBASENP),
	.MCVC1RXFIFOBASEP (VC1RXFIFOBASEP),
	.MCVC1RXFIFOLIMITC (VC1RXFIFOLIMITC),
	.MCVC1RXFIFOLIMITNP (VC1RXFIFOLIMITNP),
	.MCVC1RXFIFOLIMITP (VC1RXFIFOLIMITP),
	.MCVC1TOTALCREDITSCD (VC1TOTALCREDITSCD),
	.MCVC1TOTALCREDITSCH (VC1TOTALCREDITSCH),
	.MCVC1TOTALCREDITSNPH (VC1TOTALCREDITSNPH),
	.MCVC1TOTALCREDITSPD (VC1TOTALCREDITSPD),
	.MCVC1TOTALCREDITSPH (VC1TOTALCREDITSPH),
	.MCVC1TXFIFOBASEC (VC1TXFIFOBASEC),
	.MCVC1TXFIFOBASENP (VC1TXFIFOBASENP),
	.MCVC1TXFIFOBASEP (VC1TXFIFOBASEP),
	.MCVC1TXFIFOLIMITC (VC1TXFIFOLIMITC),
	.MCVC1TXFIFOLIMITNP (VC1TXFIFOLIMITNP),
	.MCVC1TXFIFOLIMITP (VC1TXFIFOLIMITP),
	.MCVCBASEPTR (VCBASEPTR),
	.MCVCCAPABILITYNEXTPTR (VCCAPABILITYNEXTPTR),
	.MCVENDORID (VENDORID),
	.MCXLINKSUPPORTED (XLINKSUPPORTED_BINARY),
	.MCXPBASEPTR (XPBASEPTR),
	.MCXPDEVICEPORTTYPE (XPDEVICEPORTTYPE),
	.MCXPMAXPAYLOAD (XPMAXPAYLOAD_BINARY),
	.MCXPRCBCONTROL (XPRCBCONTROL_BINARY),

	.BUSMASTERENABLE (BUSMASTERENABLE_delay),
	.CRMDOHOTRESETN (CRMDOHOTRESETN_delay),
	.CRMPWRSOFTRESETN (CRMPWRSOFTRESETN_delay),
	.CRMRXHOTRESETN (CRMRXHOTRESETN_delay),
	.DLLTXPMDLLPOUTSTANDING (DLLTXPMDLLPOUTSTANDING_delay),
	.INTERRUPTDISABLE (INTERRUPTDISABLE_delay),
	.IOSPACEENABLE (IOSPACEENABLE_delay),
	.L0ASAUTONOMOUSINITCOMPLETED (L0ASAUTONOMOUSINITCOMPLETED_delay),
	.L0ATTENTIONINDICATORCONTROL (L0ATTENTIONINDICATORCONTROL_delay),
	.L0CFGLOOPBACKACK (L0CFGLOOPBACKACK_delay),
	.L0COMPLETERID (L0COMPLETERID_delay),
	.L0CORRERRMSGRCVD (L0CORRERRMSGRCVD_delay),
	.L0DLLASRXSTATE (L0DLLASRXSTATE_delay),
	.L0DLLASTXSTATE (L0DLLASTXSTATE_delay),
	.L0DLLERRORVECTOR (L0DLLERRORVECTOR_delay),
	.L0DLLRXACKOUTSTANDING (L0DLLRXACKOUTSTANDING_delay),
	.L0DLLTXNONFCOUTSTANDING (L0DLLTXNONFCOUTSTANDING_delay),
	.L0DLLTXOUTSTANDING (L0DLLTXOUTSTANDING_delay),
	.L0DLLVCSTATUS (L0DLLVCSTATUS_delay),
	.L0DLUPDOWN (L0DLUPDOWN_delay),
	.L0ERRMSGREQID (L0ERRMSGREQID_delay),
	.L0FATALERRMSGRCVD (L0FATALERRMSGRCVD_delay),
	.L0FIRSTCFGWRITEOCCURRED (L0FIRSTCFGWRITEOCCURRED_delay),
	.L0FWDCORRERROUT (L0FWDCORRERROUT_delay),
	.L0FWDFATALERROUT (L0FWDFATALERROUT_delay),
	.L0FWDNONFATALERROUT (L0FWDNONFATALERROUT_delay),
	.L0LTSSMSTATE (L0LTSSMSTATE_delay),
	.L0MACENTEREDL0 (L0MACENTEREDL0_delay),
	.L0MACLINKTRAINING (L0MACLINKTRAINING_delay),
	.L0MACLINKUP (L0MACLINKUP_delay),
	.L0MACNEGOTIATEDLINKWIDTH (L0MACNEGOTIATEDLINKWIDTH_delay),
	.L0MACNEWSTATEACK (L0MACNEWSTATEACK_delay),
	.L0MACRXL0SSTATE (L0MACRXL0SSTATE_delay),
	.L0MACUPSTREAMDOWNSTREAM (L0MACUPSTREAMDOWNSTREAM_delay),
	.L0MCFOUND (L0MCFOUND_delay),
	.L0MSIENABLE0 (L0MSIENABLE0_delay),
	.L0MULTIMSGEN0 (L0MULTIMSGEN0_delay),
	.L0NONFATALERRMSGRCVD (L0NONFATALERRMSGRCVD_delay),
	.L0PMEACK (L0PMEACK_delay),
	.L0PMEEN (L0PMEEN_delay),
	.L0PMEREQOUT (L0PMEREQOUT_delay),
	.L0POWERCONTROLLERCONTROL (L0POWERCONTROLLERCONTROL_delay),
	.L0POWERINDICATORCONTROL (L0POWERINDICATORCONTROL_delay),
	.L0PWRINHIBITTRANSFERS (L0PWRINHIBITTRANSFERS_delay),
	.L0PWRL1STATE (L0PWRL1STATE_delay),
	.L0PWRL23READYDEVICE (L0PWRL23READYDEVICE_delay),
	.L0PWRL23READYSTATE (L0PWRL23READYSTATE_delay),
	.L0PWRSTATE0 (L0PWRSTATE0_delay),
	.L0PWRTURNOFFREQ (L0PWRTURNOFFREQ_delay),
	.L0PWRTXL0SSTATE (L0PWRTXL0SSTATE_delay),
	.L0RECEIVEDASSERTINTALEGACYINT (L0RECEIVEDASSERTINTALEGACYINT_delay),
	.L0RECEIVEDASSERTINTBLEGACYINT (L0RECEIVEDASSERTINTBLEGACYINT_delay),
	.L0RECEIVEDASSERTINTCLEGACYINT (L0RECEIVEDASSERTINTCLEGACYINT_delay),
	.L0RECEIVEDASSERTINTDLEGACYINT (L0RECEIVEDASSERTINTDLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTALEGACYINT (L0RECEIVEDDEASSERTINTALEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTBLEGACYINT (L0RECEIVEDDEASSERTINTBLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTCLEGACYINT (L0RECEIVEDDEASSERTINTCLEGACYINT_delay),
	.L0RECEIVEDDEASSERTINTDLEGACYINT (L0RECEIVEDDEASSERTINTDLEGACYINT_delay),
	.L0RXBEACON (L0RXBEACON_delay),
	.L0RXDLLFCCMPLMCCRED (L0RXDLLFCCMPLMCCRED_delay),
	.L0RXDLLFCCMPLMCUPDATE (L0RXDLLFCCMPLMCUPDATE_delay),
	.L0RXDLLFCNPOSTBYPCRED (L0RXDLLFCNPOSTBYPCRED_delay),
	.L0RXDLLFCNPOSTBYPUPDATE (L0RXDLLFCNPOSTBYPUPDATE_delay),
	.L0RXDLLFCPOSTORDCRED (L0RXDLLFCPOSTORDCRED_delay),
	.L0RXDLLFCPOSTORDUPDATE (L0RXDLLFCPOSTORDUPDATE_delay),
	.L0RXDLLPM (L0RXDLLPM_delay),
	.L0RXDLLPMTYPE (L0RXDLLPMTYPE_delay),
	.L0RXDLLSBFCDATA (L0RXDLLSBFCDATA_delay),
	.L0RXDLLSBFCUPDATE (L0RXDLLSBFCUPDATE_delay),
	.L0RXDLLTLPECRCOK (L0RXDLLTLPECRCOK_delay),
	.L0RXDLLTLPEND (L0RXDLLTLPEND_delay),
	.L0RXMACLINKERROR (L0RXMACLINKERROR_delay),
	.L0STATSCFGOTHERRECEIVED (L0STATSCFGOTHERRECEIVED_delay),
	.L0STATSCFGOTHERTRANSMITTED (L0STATSCFGOTHERTRANSMITTED_delay),
	.L0STATSCFGRECEIVED (L0STATSCFGRECEIVED_delay),
	.L0STATSCFGTRANSMITTED (L0STATSCFGTRANSMITTED_delay),
	.L0STATSDLLPRECEIVED (L0STATSDLLPRECEIVED_delay),
	.L0STATSDLLPTRANSMITTED (L0STATSDLLPTRANSMITTED_delay),
	.L0STATSOSRECEIVED (L0STATSOSRECEIVED_delay),
	.L0STATSOSTRANSMITTED (L0STATSOSTRANSMITTED_delay),
	.L0STATSTLPRECEIVED (L0STATSTLPRECEIVED_delay),
	.L0STATSTLPTRANSMITTED (L0STATSTLPTRANSMITTED_delay),
	.L0TOGGLEELECTROMECHANICALINTERLOCK (L0TOGGLEELECTROMECHANICALINTERLOCK_delay),
	.L0TRANSFORMEDVC (L0TRANSFORMEDVC_delay),
	.L0TXDLLFCCMPLMCUPDATED (L0TXDLLFCCMPLMCUPDATED_delay),
	.L0TXDLLFCNPOSTBYPUPDATED (L0TXDLLFCNPOSTBYPUPDATED_delay),
	.L0TXDLLFCPOSTORDUPDATED (L0TXDLLFCPOSTORDUPDATED_delay),
	.L0TXDLLPMUPDATED (L0TXDLLPMUPDATED_delay),
	.L0TXDLLSBFCUPDATED (L0TXDLLSBFCUPDATED_delay),
	.L0UCBYPFOUND (L0UCBYPFOUND_delay),
	.L0UCORDFOUND (L0UCORDFOUND_delay),
	.L0UNLOCKRECEIVED (L0UNLOCKRECEIVED_delay),
	.LLKRX4DWHEADERN (LLKRX4DWHEADERN_delay),
	.LLKRXCHCOMPLETIONAVAILABLEN (LLKRXCHCOMPLETIONAVAILABLEN_delay),
	.LLKRXCHCOMPLETIONPARTIALN (LLKRXCHCOMPLETIONPARTIALN_delay),
	.LLKRXCHCONFIGAVAILABLEN (LLKRXCHCONFIGAVAILABLEN_delay),
	.LLKRXCHCONFIGPARTIALN (LLKRXCHCONFIGPARTIALN_delay),
	.LLKRXCHNONPOSTEDAVAILABLEN (LLKRXCHNONPOSTEDAVAILABLEN_delay),
	.LLKRXCHNONPOSTEDPARTIALN (LLKRXCHNONPOSTEDPARTIALN_delay),
	.LLKRXCHPOSTEDAVAILABLEN (LLKRXCHPOSTEDAVAILABLEN_delay),
	.LLKRXCHPOSTEDPARTIALN (LLKRXCHPOSTEDPARTIALN_delay),
	.LLKRXDATA (LLKRXDATA_delay),
	.LLKRXECRCBADN (LLKRXECRCBADN_delay),
	.LLKRXEOFN (LLKRXEOFN_delay),
	.LLKRXEOPN (LLKRXEOPN_delay),
	.LLKRXPREFERREDTYPE (LLKRXPREFERREDTYPE_delay),
	.LLKRXSOFN (LLKRXSOFN_delay),
	.LLKRXSOPN (LLKRXSOPN_delay),
	.LLKRXSRCDSCN (LLKRXSRCDSCN_delay),
	.LLKRXSRCLASTREQN (LLKRXSRCLASTREQN_delay),
	.LLKRXSRCRDYN (LLKRXSRCRDYN_delay),
	.LLKRXVALIDN (LLKRXVALIDN_delay),
	.LLKTCSTATUS (LLKTCSTATUS_delay),
	.LLKTXCHANSPACE (LLKTXCHANSPACE_delay),
	.LLKTXCHCOMPLETIONREADYN (LLKTXCHCOMPLETIONREADYN_delay),
	.LLKTXCHNONPOSTEDREADYN (LLKTXCHNONPOSTEDREADYN_delay),
	.LLKTXCHPOSTEDREADYN (LLKTXCHPOSTEDREADYN_delay),
	.LLKTXCONFIGREADYN (LLKTXCONFIGREADYN_delay),
	.LLKTXDSTRDYN (LLKTXDSTRDYN_delay),
	.MAXPAYLOADSIZE (MAXPAYLOADSIZE_delay),
	.MAXREADREQUESTSIZE (MAXREADREQUESTSIZE_delay),
	.MEMSPACEENABLE (MEMSPACEENABLE_delay),
	.MGMTPSO (MGMTPSO_delay),
	.MGMTRDATA (MGMTRDATA_delay),
	.MGMTSTATSCREDIT (MGMTSTATSCREDIT_delay),
	.MIMDLLBRADD (MIMDLLBRADD_delay),
	.MIMDLLBREN (MIMDLLBREN_delay),
	.MIMDLLBWADD (MIMDLLBWADD_delay),
	.MIMDLLBWDATA (MIMDLLBWDATA_delay),
	.MIMDLLBWEN (MIMDLLBWEN_delay),
	.MIMRXBRADD (MIMRXBRADD_delay),
	.MIMRXBREN (MIMRXBREN_delay),
	.MIMRXBWADD (MIMRXBWADD_delay),
	.MIMRXBWDATA (MIMRXBWDATA_delay),
	.MIMRXBWEN (MIMRXBWEN_delay),
	.MIMTXBRADD (MIMTXBRADD_delay),
	.MIMTXBREN (MIMTXBREN_delay),
	.MIMTXBWADD (MIMTXBWADD_delay),
	.MIMTXBWDATA (MIMTXBWDATA_delay),
	.MIMTXBWEN (MIMTXBWEN_delay),
	.PARITYERRORRESPONSE (PARITYERRORRESPONSE_delay),
	.PIPEDESKEWLANESL0 (PIPEDESKEWLANESL0_delay),
	.PIPEDESKEWLANESL1 (PIPEDESKEWLANESL1_delay),
	.PIPEDESKEWLANESL2 (PIPEDESKEWLANESL2_delay),
	.PIPEDESKEWLANESL3 (PIPEDESKEWLANESL3_delay),
	.PIPEDESKEWLANESL4 (PIPEDESKEWLANESL4_delay),
	.PIPEDESKEWLANESL5 (PIPEDESKEWLANESL5_delay),
	.PIPEDESKEWLANESL6 (PIPEDESKEWLANESL6_delay),
	.PIPEDESKEWLANESL7 (PIPEDESKEWLANESL7_delay),
	.PIPEPOWERDOWNL0 (PIPEPOWERDOWNL0_delay),
	.PIPEPOWERDOWNL1 (PIPEPOWERDOWNL1_delay),
	.PIPEPOWERDOWNL2 (PIPEPOWERDOWNL2_delay),
	.PIPEPOWERDOWNL3 (PIPEPOWERDOWNL3_delay),
	.PIPEPOWERDOWNL4 (PIPEPOWERDOWNL4_delay),
	.PIPEPOWERDOWNL5 (PIPEPOWERDOWNL5_delay),
	.PIPEPOWERDOWNL6 (PIPEPOWERDOWNL6_delay),
	.PIPEPOWERDOWNL7 (PIPEPOWERDOWNL7_delay),
	.PIPERESETL0 (PIPERESETL0_delay),
	.PIPERESETL1 (PIPERESETL1_delay),
	.PIPERESETL2 (PIPERESETL2_delay),
	.PIPERESETL3 (PIPERESETL3_delay),
	.PIPERESETL4 (PIPERESETL4_delay),
	.PIPERESETL5 (PIPERESETL5_delay),
	.PIPERESETL6 (PIPERESETL6_delay),
	.PIPERESETL7 (PIPERESETL7_delay),
	.PIPERXPOLARITYL0 (PIPERXPOLARITYL0_delay),
	.PIPERXPOLARITYL1 (PIPERXPOLARITYL1_delay),
	.PIPERXPOLARITYL2 (PIPERXPOLARITYL2_delay),
	.PIPERXPOLARITYL3 (PIPERXPOLARITYL3_delay),
	.PIPERXPOLARITYL4 (PIPERXPOLARITYL4_delay),
	.PIPERXPOLARITYL5 (PIPERXPOLARITYL5_delay),
	.PIPERXPOLARITYL6 (PIPERXPOLARITYL6_delay),
	.PIPERXPOLARITYL7 (PIPERXPOLARITYL7_delay),
	.PIPETXCOMPLIANCEL0 (PIPETXCOMPLIANCEL0_delay),
	.PIPETXCOMPLIANCEL1 (PIPETXCOMPLIANCEL1_delay),
	.PIPETXCOMPLIANCEL2 (PIPETXCOMPLIANCEL2_delay),
	.PIPETXCOMPLIANCEL3 (PIPETXCOMPLIANCEL3_delay),
	.PIPETXCOMPLIANCEL4 (PIPETXCOMPLIANCEL4_delay),
	.PIPETXCOMPLIANCEL5 (PIPETXCOMPLIANCEL5_delay),
	.PIPETXCOMPLIANCEL6 (PIPETXCOMPLIANCEL6_delay),
	.PIPETXCOMPLIANCEL7 (PIPETXCOMPLIANCEL7_delay),
	.PIPETXDATAKL0 (PIPETXDATAKL0_delay),
	.PIPETXDATAKL1 (PIPETXDATAKL1_delay),
	.PIPETXDATAKL2 (PIPETXDATAKL2_delay),
	.PIPETXDATAKL3 (PIPETXDATAKL3_delay),
	.PIPETXDATAKL4 (PIPETXDATAKL4_delay),
	.PIPETXDATAKL5 (PIPETXDATAKL5_delay),
	.PIPETXDATAKL6 (PIPETXDATAKL6_delay),
	.PIPETXDATAKL7 (PIPETXDATAKL7_delay),
	.PIPETXDATAL0 (PIPETXDATAL0_delay),
	.PIPETXDATAL1 (PIPETXDATAL1_delay),
	.PIPETXDATAL2 (PIPETXDATAL2_delay),
	.PIPETXDATAL3 (PIPETXDATAL3_delay),
	.PIPETXDATAL4 (PIPETXDATAL4_delay),
	.PIPETXDATAL5 (PIPETXDATAL5_delay),
	.PIPETXDATAL6 (PIPETXDATAL6_delay),
	.PIPETXDATAL7 (PIPETXDATAL7_delay),
	.PIPETXDETECTRXLOOPBACKL0 (PIPETXDETECTRXLOOPBACKL0_delay),
	.PIPETXDETECTRXLOOPBACKL1 (PIPETXDETECTRXLOOPBACKL1_delay),
	.PIPETXDETECTRXLOOPBACKL2 (PIPETXDETECTRXLOOPBACKL2_delay),
	.PIPETXDETECTRXLOOPBACKL3 (PIPETXDETECTRXLOOPBACKL3_delay),
	.PIPETXDETECTRXLOOPBACKL4 (PIPETXDETECTRXLOOPBACKL4_delay),
	.PIPETXDETECTRXLOOPBACKL5 (PIPETXDETECTRXLOOPBACKL5_delay),
	.PIPETXDETECTRXLOOPBACKL6 (PIPETXDETECTRXLOOPBACKL6_delay),
	.PIPETXDETECTRXLOOPBACKL7 (PIPETXDETECTRXLOOPBACKL7_delay),
	.PIPETXELECIDLEL0 (PIPETXELECIDLEL0_delay),
	.PIPETXELECIDLEL1 (PIPETXELECIDLEL1_delay),
	.PIPETXELECIDLEL2 (PIPETXELECIDLEL2_delay),
	.PIPETXELECIDLEL3 (PIPETXELECIDLEL3_delay),
	.PIPETXELECIDLEL4 (PIPETXELECIDLEL4_delay),
	.PIPETXELECIDLEL5 (PIPETXELECIDLEL5_delay),
	.PIPETXELECIDLEL6 (PIPETXELECIDLEL6_delay),
	.PIPETXELECIDLEL7 (PIPETXELECIDLEL7_delay),
	.SERRENABLE (SERRENABLE_delay),
	.URREPORTINGENABLE (URREPORTINGENABLE_delay),

	.AUXPOWER (AUXPOWER_delay),
	.CFGNEGOTIATEDLINKWIDTH (CFGNEGOTIATEDLINKWIDTH_delay),
	.COMPLIANCEAVOID (COMPLIANCEAVOID_delay),
	.CRMCFGBRIDGEHOTRESET (CRMCFGBRIDGEHOTRESET_delay),
	.CRMCORECLK (CRMCORECLK_delay),
	.CRMCORECLKDLO (CRMCORECLKDLO_delay),
	.CRMCORECLKRXO (CRMCORECLKRXO_delay),
	.CRMCORECLKTXO (CRMCORECLKTXO_delay),
	.CRMLINKRSTN (CRMLINKRSTN_delay),
	.CRMMACRSTN (CRMMACRSTN_delay),
	.CRMMGMTRSTN (CRMMGMTRSTN_delay),
	.CRMNVRSTN (CRMNVRSTN_delay),
	.CRMTXHOTRESETN (CRMTXHOTRESETN_delay),
	.CRMURSTN (CRMURSTN_delay),
	.CRMUSERCFGRSTN (CRMUSERCFGRSTN_delay),
	.CRMUSERCLK (CRMUSERCLK_delay),
	.CRMUSERCLKRXO (CRMUSERCLKRXO_delay),
	.CRMUSERCLKTXO (CRMUSERCLKTXO_delay),
	.CROSSLINKSEED (CROSSLINKSEED_delay),
	.L0ACKNAKTIMERADJUSTMENT (L0ACKNAKTIMERADJUSTMENT_delay),
	.L0ALLDOWNPORTSINL1 (L0ALLDOWNPORTSINL1_delay),
	.L0ALLDOWNRXPORTSINL0S (L0ALLDOWNRXPORTSINL0S_delay),
	.L0ASE (L0ASE_delay),
	.L0ASPORTCOUNT (L0ASPORTCOUNT_delay),
	.L0ASTURNPOOLBITSCONSUMED (L0ASTURNPOOLBITSCONSUMED_delay),
	.L0ATTENTIONBUTTONPRESSED (L0ATTENTIONBUTTONPRESSED_delay),
	.L0CFGASSPANTREEOWNEDSTATE (L0CFGASSPANTREEOWNEDSTATE_delay),
	.L0CFGASSTATECHANGECMD (L0CFGASSTATECHANGECMD_delay),
	.L0CFGDISABLESCRAMBLE (L0CFGDISABLESCRAMBLE_delay),
	.L0CFGEXTENDEDSYNC (L0CFGEXTENDEDSYNC_delay),
	.L0CFGL0SENTRYENABLE (L0CFGL0SENTRYENABLE_delay),
	.L0CFGL0SENTRYSUP (L0CFGL0SENTRYSUP_delay),
	.L0CFGL0SEXITLAT (L0CFGL0SEXITLAT_delay),
	.L0CFGLINKDISABLE (L0CFGLINKDISABLE_delay),
	.L0CFGLOOPBACKMASTER (L0CFGLOOPBACKMASTER_delay),
	.L0CFGNEGOTIATEDMAXP (L0CFGNEGOTIATEDMAXP_delay),
	.L0CFGVCENABLE (L0CFGVCENABLE_delay),
	.L0CFGVCID (L0CFGVCID_delay),
	.L0DLLHOLDLINKUP (L0DLLHOLDLINKUP_delay),
	.L0ELECTROMECHANICALINTERLOCKENGAGED (L0ELECTROMECHANICALINTERLOCKENGAGED_delay),
	.L0FWDASSERTINTALEGACYINT (L0FWDASSERTINTALEGACYINT_delay),
	.L0FWDASSERTINTBLEGACYINT (L0FWDASSERTINTBLEGACYINT_delay),
	.L0FWDASSERTINTCLEGACYINT (L0FWDASSERTINTCLEGACYINT_delay),
	.L0FWDASSERTINTDLEGACYINT (L0FWDASSERTINTDLEGACYINT_delay),
	.L0FWDCORRERRIN (L0FWDCORRERRIN_delay),
	.L0FWDDEASSERTINTALEGACYINT (L0FWDDEASSERTINTALEGACYINT_delay),
	.L0FWDDEASSERTINTBLEGACYINT (L0FWDDEASSERTINTBLEGACYINT_delay),
	.L0FWDDEASSERTINTCLEGACYINT (L0FWDDEASSERTINTCLEGACYINT_delay),
	.L0FWDDEASSERTINTDLEGACYINT (L0FWDDEASSERTINTDLEGACYINT_delay),
	.L0FWDFATALERRIN (L0FWDFATALERRIN_delay),
	.L0FWDNONFATALERRIN (L0FWDNONFATALERRIN_delay),
	.L0LEGACYINTFUNCT0 (L0LEGACYINTFUNCT0_delay),
	.L0MRLSENSORCLOSEDN (L0MRLSENSORCLOSEDN_delay),
	.L0MSIREQUEST0 (L0MSIREQUEST0_delay),
	.L0PACKETHEADERFROMUSER (L0PACKETHEADERFROMUSER_delay),
	.L0PMEREQIN (L0PMEREQIN_delay),
	.L0PORTNUMBER (L0PORTNUMBER_delay),
	.L0POWERFAULTDETECTED (L0POWERFAULTDETECTED_delay),
	.L0PRESENCEDETECTSLOTEMPTYN (L0PRESENCEDETECTSLOTEMPTYN_delay),
	.L0PWRNEWSTATEREQ (L0PWRNEWSTATEREQ_delay),
	.L0PWRNEXTLINKSTATE (L0PWRNEXTLINKSTATE_delay),
	.L0REPLAYTIMERADJUSTMENT (L0REPLAYTIMERADJUSTMENT_delay),
	.L0ROOTTURNOFFREQ (L0ROOTTURNOFFREQ_delay),
	.L0RXTLTLPNONINITIALIZEDVC (L0RXTLTLPNONINITIALIZEDVC_delay),
	.L0SENDUNLOCKMESSAGE (L0SENDUNLOCKMESSAGE_delay),
	.L0SETCOMPLETERABORTERROR (L0SETCOMPLETERABORTERROR_delay),
	.L0SETCOMPLETIONTIMEOUTCORRERROR (L0SETCOMPLETIONTIMEOUTCORRERROR_delay),
	.L0SETCOMPLETIONTIMEOUTUNCORRERROR (L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay),
	.L0SETDETECTEDCORRERROR (L0SETDETECTEDCORRERROR_delay),
	.L0SETDETECTEDFATALERROR (L0SETDETECTEDFATALERROR_delay),
	.L0SETDETECTEDNONFATALERROR (L0SETDETECTEDNONFATALERROR_delay),
	.L0SETLINKDETECTEDPARITYERROR (L0SETLINKDETECTEDPARITYERROR_delay),
	.L0SETLINKMASTERDATAPARITY (L0SETLINKMASTERDATAPARITY_delay),
	.L0SETLINKRECEIVEDMASTERABORT (L0SETLINKRECEIVEDMASTERABORT_delay),
	.L0SETLINKRECEIVEDTARGETABORT (L0SETLINKRECEIVEDTARGETABORT_delay),
	.L0SETLINKSIGNALLEDTARGETABORT (L0SETLINKSIGNALLEDTARGETABORT_delay),
	.L0SETLINKSYSTEMERROR (L0SETLINKSYSTEMERROR_delay),
	.L0SETUNEXPECTEDCOMPLETIONCORRERROR (L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay),
	.L0SETUNEXPECTEDCOMPLETIONUNCORRERROR (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay),
	.L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay),
	.L0SETUNSUPPORTEDREQUESTOTHERERROR (L0SETUNSUPPORTEDREQUESTOTHERERROR_delay),
	.L0SETUSERDETECTEDPARITYERROR (L0SETUSERDETECTEDPARITYERROR_delay),
	.L0SETUSERMASTERDATAPARITY (L0SETUSERMASTERDATAPARITY_delay),
	.L0SETUSERRECEIVEDMASTERABORT (L0SETUSERRECEIVEDMASTERABORT_delay),
	.L0SETUSERRECEIVEDTARGETABORT (L0SETUSERRECEIVEDTARGETABORT_delay),
	.L0SETUSERSIGNALLEDTARGETABORT (L0SETUSERSIGNALLEDTARGETABORT_delay),
	.L0SETUSERSYSTEMERROR (L0SETUSERSYSTEMERROR_delay),
	.L0TLASFCCREDSTARVATION (L0TLASFCCREDSTARVATION_delay),
	.L0TLLINKRETRAIN (L0TLLINKRETRAIN_delay),
	.L0TRANSACTIONSPENDING (L0TRANSACTIONSPENDING_delay),
	.L0TXBEACON (L0TXBEACON_delay),
	.L0TXCFGPM (L0TXCFGPM_delay),
	.L0TXCFGPMTYPE (L0TXCFGPMTYPE_delay),
	.L0TXTLFCCMPLMCCRED (L0TXTLFCCMPLMCCRED_delay),
	.L0TXTLFCCMPLMCUPDATE (L0TXTLFCCMPLMCUPDATE_delay),
	.L0TXTLFCNPOSTBYPCRED (L0TXTLFCNPOSTBYPCRED_delay),
	.L0TXTLFCNPOSTBYPUPDATE (L0TXTLFCNPOSTBYPUPDATE_delay),
	.L0TXTLFCPOSTORDCRED (L0TXTLFCPOSTORDCRED_delay),
	.L0TXTLFCPOSTORDUPDATE (L0TXTLFCPOSTORDUPDATE_delay),
	.L0TXTLSBFCDATA (L0TXTLSBFCDATA_delay),
	.L0TXTLSBFCUPDATE (L0TXTLSBFCUPDATE_delay),
	.L0TXTLTLPDATA (L0TXTLTLPDATA_delay),
	.L0TXTLTLPEDB (L0TXTLTLPEDB_delay),
	.L0TXTLTLPENABLE (L0TXTLTLPENABLE_delay),
	.L0TXTLTLPEND (L0TXTLTLPEND_delay),
	.L0TXTLTLPLATENCY (L0TXTLTLPLATENCY_delay),
	.L0TXTLTLPREQ (L0TXTLTLPREQ_delay),
	.L0TXTLTLPREQEND (L0TXTLTLPREQEND_delay),
	.L0TXTLTLPWIDTH (L0TXTLTLPWIDTH_delay),
	.L0UPSTREAMRXPORTINL0S (L0UPSTREAMRXPORTINL0S_delay),
	.L0VC0PREVIEWEXPAND (L0VC0PREVIEWEXPAND_delay),
	.L0WAKEN (L0WAKEN_delay),
	.LLKRXCHFIFO (LLKRXCHFIFO_delay),
	.LLKRXCHTC (LLKRXCHTC_delay),
	.LLKRXDSTCONTREQN (LLKRXDSTCONTREQN_delay),
	.LLKRXDSTREQN (LLKRXDSTREQN_delay),
	.LLKTX4DWHEADERN (LLKTX4DWHEADERN_delay),
	.LLKTXCHFIFO (LLKTXCHFIFO_delay),
	.LLKTXCHTC (LLKTXCHTC_delay),
	.LLKTXCOMPLETEN (LLKTXCOMPLETEN_delay),
	.LLKTXCREATEECRCN (LLKTXCREATEECRCN_delay),
	.LLKTXDATA (LLKTXDATA_delay),
	.LLKTXENABLEN (LLKTXENABLEN_delay),
	.LLKTXEOFN (LLKTXEOFN_delay),
	.LLKTXEOPN (LLKTXEOPN_delay),
	.LLKTXSOFN (LLKTXSOFN_delay),
	.LLKTXSOPN (LLKTXSOPN_delay),
	.LLKTXSRCDSCN (LLKTXSRCDSCN_delay),
	.LLKTXSRCRDYN (LLKTXSRCRDYN_delay),
	.MAINPOWER (MAINPOWER_delay),
	.MGMTADDR (MGMTADDR_delay),
	.MGMTBWREN (MGMTBWREN_delay),
	.MGMTRDEN (MGMTRDEN_delay),
	.MGMTSTATSCREDITSEL (MGMTSTATSCREDITSEL_delay),
	.MGMTWDATA (MGMTWDATA_delay),
	.MGMTWREN (MGMTWREN_delay),
	.MIMDLLBRDATA (MIMDLLBRDATA_delay),
	.MIMRXBRDATA (MIMRXBRDATA_delay),
	.MIMTXBRDATA (MIMTXBRDATA_delay),
	.PIPEPHYSTATUSL0 (PIPEPHYSTATUSL0_delay),
	.PIPEPHYSTATUSL1 (PIPEPHYSTATUSL1_delay),
	.PIPEPHYSTATUSL2 (PIPEPHYSTATUSL2_delay),
	.PIPEPHYSTATUSL3 (PIPEPHYSTATUSL3_delay),
	.PIPEPHYSTATUSL4 (PIPEPHYSTATUSL4_delay),
	.PIPEPHYSTATUSL5 (PIPEPHYSTATUSL5_delay),
	.PIPEPHYSTATUSL6 (PIPEPHYSTATUSL6_delay),
	.PIPEPHYSTATUSL7 (PIPEPHYSTATUSL7_delay),
	.PIPERXCHANISALIGNEDL0 (PIPERXCHANISALIGNEDL0_delay),
	.PIPERXCHANISALIGNEDL1 (PIPERXCHANISALIGNEDL1_delay),
	.PIPERXCHANISALIGNEDL2 (PIPERXCHANISALIGNEDL2_delay),
	.PIPERXCHANISALIGNEDL3 (PIPERXCHANISALIGNEDL3_delay),
	.PIPERXCHANISALIGNEDL4 (PIPERXCHANISALIGNEDL4_delay),
	.PIPERXCHANISALIGNEDL5 (PIPERXCHANISALIGNEDL5_delay),
	.PIPERXCHANISALIGNEDL6 (PIPERXCHANISALIGNEDL6_delay),
	.PIPERXCHANISALIGNEDL7 (PIPERXCHANISALIGNEDL7_delay),
	.PIPERXDATAKL0 (PIPERXDATAKL0_delay),
	.PIPERXDATAKL1 (PIPERXDATAKL1_delay),
	.PIPERXDATAKL2 (PIPERXDATAKL2_delay),
	.PIPERXDATAKL3 (PIPERXDATAKL3_delay),
	.PIPERXDATAKL4 (PIPERXDATAKL4_delay),
	.PIPERXDATAKL5 (PIPERXDATAKL5_delay),
	.PIPERXDATAKL6 (PIPERXDATAKL6_delay),
	.PIPERXDATAKL7 (PIPERXDATAKL7_delay),
	.PIPERXDATAL0 (PIPERXDATAL0_delay),
	.PIPERXDATAL1 (PIPERXDATAL1_delay),
	.PIPERXDATAL2 (PIPERXDATAL2_delay),
	.PIPERXDATAL3 (PIPERXDATAL3_delay),
	.PIPERXDATAL4 (PIPERXDATAL4_delay),
	.PIPERXDATAL5 (PIPERXDATAL5_delay),
	.PIPERXDATAL6 (PIPERXDATAL6_delay),
	.PIPERXDATAL7 (PIPERXDATAL7_delay),
	.PIPERXELECIDLEL0 (PIPERXELECIDLEL0_delay),
	.PIPERXELECIDLEL1 (PIPERXELECIDLEL1_delay),
	.PIPERXELECIDLEL2 (PIPERXELECIDLEL2_delay),
	.PIPERXELECIDLEL3 (PIPERXELECIDLEL3_delay),
	.PIPERXELECIDLEL4 (PIPERXELECIDLEL4_delay),
	.PIPERXELECIDLEL5 (PIPERXELECIDLEL5_delay),
	.PIPERXELECIDLEL6 (PIPERXELECIDLEL6_delay),
	.PIPERXELECIDLEL7 (PIPERXELECIDLEL7_delay),
	.PIPERXSTATUSL0 (PIPERXSTATUSL0_delay),
	.PIPERXSTATUSL1 (PIPERXSTATUSL1_delay),
	.PIPERXSTATUSL2 (PIPERXSTATUSL2_delay),
	.PIPERXSTATUSL3 (PIPERXSTATUSL3_delay),
	.PIPERXSTATUSL4 (PIPERXSTATUSL4_delay),
	.PIPERXSTATUSL5 (PIPERXSTATUSL5_delay),
	.PIPERXSTATUSL6 (PIPERXSTATUSL6_delay),
	.PIPERXSTATUSL7 (PIPERXSTATUSL7_delay),
	.PIPERXVALIDL0 (PIPERXVALIDL0_delay),
	.PIPERXVALIDL1 (PIPERXVALIDL1_delay),
	.PIPERXVALIDL2 (PIPERXVALIDL2_delay),
	.PIPERXVALIDL3 (PIPERXVALIDL3_delay),
	.PIPERXVALIDL4 (PIPERXVALIDL4_delay),
	.PIPERXVALIDL5 (PIPERXVALIDL5_delay),
	.PIPERXVALIDL6 (PIPERXVALIDL6_delay),
	.PIPERXVALIDL7 (PIPERXVALIDL7_delay),

	.GSR(GSR)
);

specify
	$period (posedge CRMCORECLK, 0:0:0);
	$period (posedge CRMCORECLKDLO, 0:0:0);
	$period (posedge CRMCORECLKRXO, 0:0:0);
	$period (posedge CRMCORECLKTXO, 0:0:0);
	$period (posedge CRMUSERCLK, 0:0:0);
	$period (posedge CRMUSERCLKRXO, 0:0:0);
	$period (posedge CRMUSERCLKTXO, 0:0:0);

        $recrem (posedge CRMCORECLK, negedge CRMURSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, negedge CRMNVRSTN, 0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, negedge CRMMGMTRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, negedge CRMUSERCFGRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, negedge CRMMACRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, negedge CRMLINKRSTN,  0:0:0, 0:0:0);

        $recrem (posedge CRMCORECLK, posedge CRMURSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, posedge CRMNVRSTN, 0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, posedge CRMMGMTRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, posedge CRMUSERCFGRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, posedge CRMMACRSTN,  0:0:0, 0:0:0);
        $recrem (posedge CRMCORECLK, posedge CRMLINKRSTN,  0:0:0, 0:0:0);

   
	$setuphold (posedge CRMCORECLK, negedge AUXPOWER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, AUXPOWER_delay);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge CFGNEGOTIATEDLINKWIDTH[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge COMPLIANCEAVOID, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, COMPLIANCEAVOID_delay);
	$setuphold (posedge CRMCORECLK, negedge CRMCFGBRIDGEHOTRESET, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,CRMCFGBRIDGEHOTRESET_delay );
	$setuphold (posedge CRMCORECLK, negedge CRMTXHOTRESETN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CRMTXHOTRESETN_delay);
	$setuphold (posedge CRMCORECLK, negedge CROSSLINKSEED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CROSSLINKSEED_delay);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0ACKNAKTIMERADJUSTMENT[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0ALLDOWNPORTSINL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ALLDOWNPORTSINL1_delay);
	$setuphold (posedge CRMCORECLK, negedge L0ALLDOWNRXPORTSINL0S, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,L0ALLDOWNRXPORTSINL0S_delay);
	$setuphold (posedge CRMCORECLK, negedge L0ASE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0ASPORTCOUNT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0ASTURNPOOLBITSCONSUMED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0ASTURNPOOLBITSCONSUMED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0ASTURNPOOLBITSCONSUMED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0ATTENTIONBUTTONPRESSED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ATTENTIONBUTTONPRESSED_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGASSPANTREEOWNEDSTATE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSPANTREEOWNEDSTATE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGASSTATECHANGECMD[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGASSTATECHANGECMD[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGASSTATECHANGECMD[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGASSTATECHANGECMD[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGDISABLESCRAMBLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGDISABLESCRAMBLE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGEXTENDEDSYNC, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGEXTENDEDSYNC_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGL0SENTRYENABLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SENTRYENABLE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGL0SENTRYSUP, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SENTRYSUP_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGL0SEXITLAT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SEXITLAT_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGL0SEXITLAT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SEXITLAT_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGL0SEXITLAT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,  L0CFGL0SEXITLAT_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGLINKDISABLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGLINKDISABLE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGLOOPBACKMASTER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGLOOPBACKMASTER_delay);
	$setuphold (posedge CRMCORECLK, negedge L0CFGNEGOTIATEDMAXP[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGNEGOTIATEDMAXP[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGNEGOTIATEDMAXP[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCENABLE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0CFGVCID[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0DLLHOLDLINKUP, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0DLLHOLDLINKUP_delay);
	$setuphold (posedge CRMCORECLK, negedge L0ELECTROMECHANICALINTERLOCKENGAGED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ELECTROMECHANICALINTERLOCKENGAGED_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDCORRERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDCORRERRIN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDDEASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDDEASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDDEASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDDEASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDFATALERRIN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0FWDNONFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDNONFATALERRIN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0LEGACYINTFUNCT0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0LEGACYINTFUNCT0_delay);
	$setuphold (posedge CRMCORECLK, negedge L0MRLSENSORCLOSEDN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MRLSENSORCLOSEDN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0MSIREQUEST0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0MSIREQUEST0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0MSIREQUEST0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0MSIREQUEST0[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[100]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[101]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[102]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[103]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[104]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[105]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[106]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[107]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[108]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[109]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[110]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[111]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[112]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[113]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[114]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[115]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[116]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[117]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[118]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[119]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[120]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[121]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[122]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[123]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[124]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[125]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[126]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[127]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[64]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[65]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[66]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[67]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[68]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[69]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[70]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[71]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[72]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[73]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[74]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[75]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[76]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[77]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[78]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[79]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[80]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[81]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[82]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[83]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[84]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[85]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[86]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[87]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[88]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[89]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[90]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[91]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[92]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[93]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[94]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[95]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[96]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[97]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[98]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[99]);
	$setuphold (posedge CRMCORECLK, negedge L0PACKETHEADERFROMUSER[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0PMEREQIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PMEREQIN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0PORTNUMBER[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0POWERFAULTDETECTED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0POWERFAULTDETECTED_delay);
	$setuphold (posedge CRMCORECLK, negedge L0PRESENCEDETECTSLOTEMPTYN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PRESENCEDETECTSLOTEMPTYN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0PWRNEWSTATEREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEWSTATEREQ_delay);
	$setuphold (posedge CRMCORECLK, negedge L0PWRNEXTLINKSTATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEXTLINKSTATE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0PWRNEXTLINKSTATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEXTLINKSTATE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,  L0REPLAYTIMERADJUSTMENT_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0REPLAYTIMERADJUSTMENT[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0ROOTTURNOFFREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ROOTTURNOFFREQ_delay);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0RXTLTLPNONINITIALIZEDVC[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0SENDUNLOCKMESSAGE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SENDUNLOCKMESSAGE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETCOMPLETERABORTERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETERABORTERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETCOMPLETIONTIMEOUTCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETIONTIMEOUTCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETCOMPLETIONTIMEOUTUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETDETECTEDCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETDETECTEDFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDFATALERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETDETECTEDNONFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDNONFATALERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKMASTERDATAPARITY_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETLINKSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKSYSTEMERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUNEXPECTEDCOMPLETIONCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUNEXPECTEDCOMPLETIONUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUNSUPPORTEDREQUESTOTHERERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNSUPPORTEDREQUESTOTHERERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERMASTERDATAPARITY_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, negedge L0SETUSERSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERSYSTEMERROR_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TLASFCCREDSTARVATION, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TLASFCCREDSTARVATION_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TLLINKRETRAIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TLLINKRETRAIN_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TRANSACTIONSPENDING, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TRANSACTIONSPENDING_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXBEACON, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXBEACON_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXCFGPM, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPM_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXCFGPMTYPE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXCFGPMTYPE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXCFGPMTYPE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCCMPLMCUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[160], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[160]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[161], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[161]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[162], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[162]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[163], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[163]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[164], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[164]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[165], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[165]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[166], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[166]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[167], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[167]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[168], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[168]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[169], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[169]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[170], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[170]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[171], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[171]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[172], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[172]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[173], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[173]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[174], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[174]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[175], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[175]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[176], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[176]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[177], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[177]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[178], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[178]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[179], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[179]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[180], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[180]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[181], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[181]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[182], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[182]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[183], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[183]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[184], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[184]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[185], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[185]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[186], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[186]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[187], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[187]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[188], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[188]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[189], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[189]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[190], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[190]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[191], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[191]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCNPOSTBYPUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLFCPOSTORDUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLSBFCUPDATE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCUPDATE_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPEDB, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEDB_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPENABLE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPENABLE_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPENABLE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPENABLE_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPEND[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEND_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPEND[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEND_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPLATENCY[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPLATENCY[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPLATENCY[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPLATENCY[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPREQ_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPREQEND, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPREQEND_delay);
	$setuphold (posedge CRMCORECLK, negedge L0TXTLTLPWIDTH, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPWIDTH_delay);
	$setuphold (posedge CRMCORECLK, negedge L0UPSTREAMRXPORTINL0S, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0UPSTREAMRXPORTINL0S_delay);
	$setuphold (posedge CRMCORECLK, negedge L0VC0PREVIEWEXPAND, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0VC0PREVIEWEXPAND_delay);
	$setuphold (posedge CRMCORECLK, negedge L0WAKEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0WAKEN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKRXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHFIFO_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKRXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHFIFO_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKRXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKRXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKRXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge LLKRXDSTCONTREQN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXDSTCONTREQN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKRXDSTREQN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXDSTREQN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTX4DWHEADERN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTX4DWHEADERN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHFIFO_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHFIFO_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCOMPLETEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCOMPLETEN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXCREATEECRCN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCREATEECRCN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,LLKTXDATA_delay[60] );
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXENABLEN[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXENABLEN_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXENABLEN[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXENABLEN_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge LLKTXEOFN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXEOFN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXEOPN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXEOPN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXSOFN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSOFN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXSOPN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSOPN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXSRCDSCN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSRCDSCN_delay);
	$setuphold (posedge CRMCORECLK, negedge LLKTXSRCRDYN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSRCRDYN_delay);
	$setuphold (posedge CRMCORECLK, negedge MAINPOWER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MAINPOWER_delay);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge MGMTADDR[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge MGMTBWREN[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MGMTBWREN[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MGMTBWREN[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MGMTBWREN[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MGMTRDEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTRDEN_delay);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MGMTSTATSCREDITSEL[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge MGMTWREN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWREN_delay);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,MIMDLLBRDATA_delay[60] );
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge MIMDLLBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge MIMRXBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, negedge MIMTXBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL0_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL1_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL2_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL3_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL4_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL5_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL6_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPEPHYSTATUSL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL7_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL0_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL1_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL2_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL3_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL4_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL5_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL6_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXCHANISALIGNEDL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL7_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL0_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL1_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL2_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL3_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL4_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL5_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL6_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAKL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL7_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL0[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL1[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL2[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL3[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL4[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL5[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL6[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[3]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[4]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[5]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[6]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXDATAL7[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[7]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL0_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL1_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL2_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL3_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL4_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL5_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL6_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXELECIDLEL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL7_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL1[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL1[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL1[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL2[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL2[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL2[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL3[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL3[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL3[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL4[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL4[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL4[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL5[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL5[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL5[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL6[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL6[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL6[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL7[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[0]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL7[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[1]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXSTATUSL7[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[2]);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL0_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL1_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL2_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL3_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL4_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL5_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL6_delay);
	$setuphold (posedge CRMCORECLK, negedge PIPERXVALIDL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL7_delay);
	$setuphold (posedge CRMCORECLK, posedge AUXPOWER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, AUXPOWER_delay);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge CFGNEGOTIATEDLINKWIDTH[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CFGNEGOTIATEDLINKWIDTH_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge COMPLIANCEAVOID, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, COMPLIANCEAVOID_delay);
	$setuphold (posedge CRMCORECLK, posedge CRMCFGBRIDGEHOTRESET, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CRMCFGBRIDGEHOTRESET_delay);
	$setuphold (posedge CRMCORECLK, posedge CRMTXHOTRESETN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CRMTXHOTRESETN_delay);
	$setuphold (posedge CRMCORECLK, posedge CROSSLINKSEED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, CROSSLINKSEED_delay);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0ACKNAKTIMERADJUSTMENT[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ACKNAKTIMERADJUSTMENT_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0ALLDOWNPORTSINL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ALLDOWNPORTSINL1_delay);
	$setuphold (posedge CRMCORECLK, posedge L0ALLDOWNRXPORTSINL0S, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ALLDOWNRXPORTSINL0S_delay);
	$setuphold (posedge CRMCORECLK, posedge L0ASE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0ASPORTCOUNT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASPORTCOUNT_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0ASTURNPOOLBITSCONSUMED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0ASTURNPOOLBITSCONSUMED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0ASTURNPOOLBITSCONSUMED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ASTURNPOOLBITSCONSUMED_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0ATTENTIONBUTTONPRESSED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ATTENTIONBUTTONPRESSED_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGASSPANTREEOWNEDSTATE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSPANTREEOWNEDSTATE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGASSTATECHANGECMD[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGASSTATECHANGECMD[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGASSTATECHANGECMD[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGASSTATECHANGECMD[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGASSTATECHANGECMD_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGDISABLESCRAMBLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGDISABLESCRAMBLE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGEXTENDEDSYNC, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGEXTENDEDSYNC_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGL0SENTRYENABLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SENTRYENABLE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGL0SENTRYSUP, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SENTRYSUP_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGL0SEXITLAT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SEXITLAT_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGL0SEXITLAT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SEXITLAT_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGL0SEXITLAT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGL0SEXITLAT_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGLINKDISABLE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGLINKDISABLE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGLOOPBACKMASTER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGLOOPBACKMASTER_delay);
	$setuphold (posedge CRMCORECLK, posedge L0CFGNEGOTIATEDMAXP[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGNEGOTIATEDMAXP[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGNEGOTIATEDMAXP[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGNEGOTIATEDMAXP_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCENABLE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCENABLE_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0CFGVCID[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0CFGVCID_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0DLLHOLDLINKUP, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0DLLHOLDLINKUP_delay);
	$setuphold (posedge CRMCORECLK, posedge L0ELECTROMECHANICALINTERLOCKENGAGED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ELECTROMECHANICALINTERLOCKENGAGED_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDCORRERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDCORRERRIN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDDEASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDDEASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDDEASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDDEASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDDEASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDFATALERRIN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0FWDNONFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0FWDNONFATALERRIN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0LEGACYINTFUNCT0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0LEGACYINTFUNCT0_delay);
	$setuphold (posedge CRMCORECLK, posedge L0MRLSENSORCLOSEDN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MRLSENSORCLOSEDN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0MSIREQUEST0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0MSIREQUEST0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0MSIREQUEST0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0MSIREQUEST0[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0MSIREQUEST0_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[100]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[101]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[102]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[103]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[104]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[105]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[106]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[107]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[108]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[109]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[110]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[111]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[112]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[113]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[114]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[115]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[116]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[117]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[118]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[119]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[120]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[121]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[122]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[123]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[124]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[125]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[126]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[127]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay,  L0PACKETHEADERFROMUSER_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[64]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[65]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[66]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[67]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[68]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[69]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[70]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[71]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[72]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[73]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[74]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[75]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[76]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[77]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[78]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[79]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[80]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[81]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[82]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[83]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[84]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[85]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[86]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[87]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[88]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[89]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[90]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[91]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[92]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[93]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[94]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[95]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[96]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[97]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[98]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[99]);
	$setuphold (posedge CRMCORECLK, posedge L0PACKETHEADERFROMUSER[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PACKETHEADERFROMUSER_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0PMEREQIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PMEREQIN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0PORTNUMBER[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PORTNUMBER_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0POWERFAULTDETECTED, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0POWERFAULTDETECTED_delay);
	$setuphold (posedge CRMCORECLK, posedge L0PRESENCEDETECTSLOTEMPTYN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PRESENCEDETECTSLOTEMPTYN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0PWRNEWSTATEREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEWSTATEREQ_delay);
	$setuphold (posedge CRMCORECLK, posedge L0PWRNEXTLINKSTATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEXTLINKSTATE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0PWRNEXTLINKSTATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0PWRNEXTLINKSTATE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0REPLAYTIMERADJUSTMENT[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0REPLAYTIMERADJUSTMENT_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0ROOTTURNOFFREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0ROOTTURNOFFREQ_delay);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0RXTLTLPNONINITIALIZEDVC[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0RXTLTLPNONINITIALIZEDVC_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0SENDUNLOCKMESSAGE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SENDUNLOCKMESSAGE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETCOMPLETERABORTERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETERABORTERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETCOMPLETIONTIMEOUTCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETIONTIMEOUTCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETCOMPLETIONTIMEOUTUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETDETECTEDCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETDETECTEDFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDFATALERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETDETECTEDNONFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETDETECTEDNONFATALERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKMASTERDATAPARITY_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETLINKSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETLINKSYSTEMERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUNEXPECTEDCOMPLETIONCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUNEXPECTEDCOMPLETIONUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUNSUPPORTEDREQUESTOTHERERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUNSUPPORTEDREQUESTOTHERERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERMASTERDATAPARITY_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMCORECLK, posedge L0SETUSERSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0SETUSERSYSTEMERROR_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TLASFCCREDSTARVATION, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TLASFCCREDSTARVATION_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TLLINKRETRAIN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TLLINKRETRAIN_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TRANSACTIONSPENDING, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TRANSACTIONSPENDING_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXBEACON, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXBEACON_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXCFGPM, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPM_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXCFGPMTYPE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXCFGPMTYPE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXCFGPMTYPE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXCFGPMTYPE_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCCMPLMCUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCCMPLMCUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[160], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[160]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[161], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[161]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[162], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[162]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[163], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[163]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[164], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[164]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[165], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[165]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[166], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[166]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[167], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[167]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[168], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[168]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[169], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[169]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[170], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[170]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[171], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[171]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[172], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[172]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[173], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[173]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[174], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[174]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[175], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[175]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[176], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[176]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[177], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[177]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[178], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[178]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[179], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[179]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[180], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[180]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[181], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[181]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[182], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[182]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[183], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[183]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[184], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[184]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[185], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[185]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[186], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[186]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[187], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[187]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[188], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[188]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[189], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[189]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[190], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[190]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[191], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[191]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCNPOSTBYPUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCNPOSTBYPUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[100], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[100]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[101], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[101]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[102], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[102]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[103], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[103]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[104], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[104]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[105], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[105]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[106], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[106]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[107], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[107]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[108], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[108]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[109], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[109]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[110], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[110]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[111], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[111]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[112], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[112]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[113], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[113]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[114], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[114]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[115], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[115]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[116], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[116]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[117], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[117]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[118], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[118]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[119], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[119]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[120], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[120]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[121], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[121]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[122], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[122]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[123], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[123]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[124], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[124]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[125], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[125]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[126], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[126]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[127], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[127]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[128], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[128]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[129], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[129]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[130], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[130]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[131], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[131]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[132], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[132]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[133], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[133]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[134], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[134]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[135], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[135]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[136], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[136]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[137], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[137]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[138], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[138]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[139], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[139]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[140], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[140]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[141], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[141]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[142], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[142]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[143], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[143]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[144], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[144]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[145], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[145]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[146], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[146]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[147], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[147]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[148], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[148]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[149], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[149]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[150], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[150]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[151], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[151]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[152], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[152]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[153], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[153]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[154], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[154]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[155], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[155]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[156], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[156]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[157], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[157]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[158], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[158]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[159], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[159]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[64], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[64]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[65], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[65]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[66], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[66]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[67], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[67]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[68], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[68]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[69], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[69]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[70], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[70]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[71], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[71]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[72], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[72]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[73], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[73]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[74], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[74]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[75], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[75]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[76], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[76]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[77], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[77]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[78], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[78]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[79], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[79]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[80], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[80]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[81], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[81]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[82], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[82]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[83], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[83]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[84], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[84]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[85], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[85]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[86], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[86]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[87], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[87]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[88], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[88]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[89], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[89]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[90], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[90]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[91], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[91]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[92], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[92]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[93], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[93]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[94], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[94]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[95], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[95]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[96], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[96]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[97], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[97]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[98], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[98]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[99], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[99]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDCRED[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDCRED_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLFCPOSTORDUPDATE[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLFCPOSTORDUPDATE_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLSBFCUPDATE, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLSBFCUPDATE_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPEDB, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEDB_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPENABLE[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPENABLE_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPENABLE[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPENABLE_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPEND[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEND_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPEND[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPEND_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPLATENCY[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPLATENCY[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPLATENCY[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPLATENCY[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPLATENCY_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPREQ, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPREQ_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPREQEND, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPREQEND_delay);
	$setuphold (posedge CRMCORECLK, posedge L0TXTLTLPWIDTH, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0TXTLTLPWIDTH_delay);
	$setuphold (posedge CRMCORECLK, posedge L0UPSTREAMRXPORTINL0S, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0UPSTREAMRXPORTINL0S_delay);
	$setuphold (posedge CRMCORECLK, posedge L0VC0PREVIEWEXPAND, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0VC0PREVIEWEXPAND_delay);
	$setuphold (posedge CRMCORECLK, posedge L0WAKEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, L0WAKEN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKRXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHFIFO_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKRXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHFIFO_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKRXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKRXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKRXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXCHTC_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge LLKRXDSTCONTREQN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXDSTCONTREQN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKRXDSTREQN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKRXDSTREQN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTX4DWHEADERN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTX4DWHEADERN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHFIFO_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHFIFO_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCHTC_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCOMPLETEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCOMPLETEN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXCREATEECRCN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXCREATEECRCN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXENABLEN[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXENABLEN_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXENABLEN[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXENABLEN_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge LLKTXEOFN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXEOFN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXEOPN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXEOPN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXSOFN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSOFN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXSOPN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSOPN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXSRCDSCN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSRCDSCN_delay);
	$setuphold (posedge CRMCORECLK, posedge LLKTXSRCRDYN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, LLKTXSRCRDYN_delay);
	$setuphold (posedge CRMCORECLK, posedge MAINPOWER, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MAINPOWER_delay);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge MGMTADDR[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTADDR_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge MGMTBWREN[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MGMTBWREN[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MGMTBWREN[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MGMTBWREN[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTBWREN_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MGMTRDEN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTRDEN_delay);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MGMTSTATSCREDITSEL[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTSTATSCREDITSEL_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge MGMTWREN, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MGMTWREN_delay);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge MIMDLLBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMDLLBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge MIMRXBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMRXBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[10], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[10]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[11], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[11]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[12], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[12]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[13], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[13]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[14], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[14]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[15], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[15]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[16], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[16]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[17], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[17]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[18], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[18]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[19], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[19]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[20], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[20]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[21], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[21]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[22], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[22]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[23], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[23]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[24], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[24]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[25], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[25]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[26], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[26]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[27], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[27]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[28], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[28]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[29], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[29]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[30], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[30]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[31], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[31]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[32], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[32]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[33], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[33]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[34], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[34]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[35], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[35]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[36], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[36]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[37], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[37]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[38], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[38]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[39], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[39]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[40], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[40]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[41], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[41]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[42], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[42]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[43], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[43]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[44], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[44]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[45], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[45]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[46], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[46]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[47], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[47]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[48], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[48]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[49], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[49]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[50], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[50]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[51], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[51]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[52], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[52]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[53], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[53]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[54], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[54]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[55], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[55]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[56], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[56]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[57], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[57]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[58], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[58]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[59], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[59]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[60], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[60]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[61], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[61]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[62], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[62]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[63], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[63]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[8], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[8]);
	$setuphold (posedge CRMCORECLK, posedge MIMTXBRDATA[9], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, MIMTXBRDATA_delay[9]);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL0_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL1_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL2_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL3_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL4_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL5_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL6_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPEPHYSTATUSL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPEPHYSTATUSL7_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL0_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL1_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL2_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL3_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL4_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL5_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL6_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXCHANISALIGNEDL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXCHANISALIGNEDL7_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL0_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL1_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL2_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL3_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL4_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL5_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL6_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAKL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAKL7_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL0[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL0_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL1[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL1_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL2[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL2_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL3[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL3_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL4[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL4_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL5[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL5_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL6[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL6_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[3], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[3]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[4], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[4]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[5], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[5]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[6], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[6]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXDATAL7[7], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXDATAL7_delay[7]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL0_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL1_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL2_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL3_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL4_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL5_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL6_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXELECIDLEL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXELECIDLEL7_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL0[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL0[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL0[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL0_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL1[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL1[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL1[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL1_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL2[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL2[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL2[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL2_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL3[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL3[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL3[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL3_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL4[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL4[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL4[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL4_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL5[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL5[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL5[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL5_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL6[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL6[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL6[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL6_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL7[0], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[0]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL7[1], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[1]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXSTATUSL7[2], 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXSTATUSL7_delay[2]);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL0, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL0_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL1, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL1_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL2, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL2_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL3, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL3_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL4, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL4_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL5, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL5_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL6, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL6_delay);
	$setuphold (posedge CRMCORECLK, posedge PIPERXVALIDL7, 0:0:0, 0:0:0, notifier,,, CRMCORECLK_delay, PIPERXVALIDL7_delay);
	$setuphold (posedge CRMUSERCLK, negedge AUXPOWER, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, AUXPOWER_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0ALLDOWNPORTSINL1, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ALLDOWNPORTSINL1_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0ALLDOWNRXPORTSINL0S, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ALLDOWNRXPORTSINL0S_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0ATTENTIONBUTTONPRESSED, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ATTENTIONBUTTONPRESSED_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0ELECTROMECHANICALINTERLOCKENGAGED, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ELECTROMECHANICALINTERLOCKENGAGED_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDCORRERRIN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDCORRERRIN_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDDEASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDDEASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDDEASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDDEASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDDEASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDDEASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDDEASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDDEASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDFATALERRIN_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0FWDNONFATALERRIN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0FWDNONFATALERRIN_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0LEGACYINTFUNCT0, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0LEGACYINTFUNCT0_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0MRLSENSORCLOSEDN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0MRLSENSORCLOSEDN_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0MSIREQUEST0[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0MSIREQUEST0_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge L0MSIREQUEST0[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0MSIREQUEST0_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge L0MSIREQUEST0[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0MSIREQUEST0_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge L0MSIREQUEST0[3], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0MSIREQUEST0_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[100], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[100]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[101], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[101]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[102], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[102]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[103], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[103]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[104], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[104]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[105], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[105]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[106], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[106]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[107], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[107]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[108], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[108]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[109], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[109]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[10], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[10]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[110], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[110]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[111], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[111]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[112], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[112]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[113], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[113]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[114], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[114]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[115], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[115]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[116], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[116]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[117], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[117]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[118], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[118]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[119], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[119]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[11], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[11]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[120], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[120]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[121], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[121]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[122], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[122]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[123], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[123]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[124], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[124]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[125], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[125]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[126], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[126]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[127], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[127]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[12], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[12]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[13], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[13]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[14], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[14]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[15], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[15]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[16], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[16]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[17], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[17]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[18], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[18]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[19], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[19]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[20], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[20]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[21], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[21]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[22], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[22]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[23], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[23]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[24], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[24]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[25], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[25]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[26], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[26]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[27], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[27]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[28], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[28]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[29], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[29]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[30], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[30]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[31], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[31]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[32], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[32]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[33], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[33]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[34], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[34]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[35], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[35]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[36], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[36]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[37], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[37]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[38], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[38]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[39], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[39]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[3], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[40], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[40]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[41], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[41]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[42], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[42]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[43], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[43]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[44], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[44]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[45], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[45]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[46], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[46]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[47], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[47]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[48], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[48]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[49], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[49]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[4], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[50], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[50]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[51], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[51]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[52], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[52]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[53], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[53]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[54], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[54]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[55], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[55]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[56], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[56]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[57], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[57]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[58], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[58]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[59], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[59]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[5], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[60], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[60]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[61], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[61]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[62], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[62]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[63], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[63]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[64], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[64]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[65], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[65]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[66], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[66]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[67], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[67]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[68], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[68]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[69], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[69]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[6], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[70], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[70]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[71], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[71]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[72], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[72]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[73], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[73]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[74], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[74]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[75], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[75]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[76], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[76]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[77], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[77]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[78], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[78]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[79], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[79]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[7], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[80], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[80]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[81], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[81]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[82], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[82]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[83], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[83]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[84], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[84]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[85], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[85]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[86], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[86]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[87], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[87]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[88], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[88]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[89], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[89]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[8], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[8]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[90], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[90]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[91], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[91]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[92], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[92]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[93], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[93]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[94], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[94]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[95], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[95]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[96], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[96]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[97], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[97]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[98], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[98]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[99], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[99]);
	$setuphold (posedge CRMUSERCLK, negedge L0PACKETHEADERFROMUSER[9], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[9]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[3], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[4], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[5], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[6], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge L0PORTNUMBER[7], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PORTNUMBER_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge L0POWERFAULTDETECTED, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0POWERFAULTDETECTED_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0PRESENCEDETECTSLOTEMPTYN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0PRESENCEDETECTSLOTEMPTYN_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0ROOTTURNOFFREQ, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ROOTTURNOFFREQ_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SENDUNLOCKMESSAGE, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SENDUNLOCKMESSAGE_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETCOMPLETERABORTERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETCOMPLETERABORTERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETCOMPLETIONTIMEOUTCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETCOMPLETIONTIMEOUTCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETCOMPLETIONTIMEOUTUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETDETECTEDCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETDETECTEDCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETDETECTEDFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETDETECTEDFATALERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETDETECTEDNONFATALERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETDETECTEDNONFATALERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKMASTERDATAPARITY_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETLINKSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETLINKSYSTEMERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUNEXPECTEDCOMPLETIONCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUNEXPECTEDCOMPLETIONUNCORRERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUNSUPPORTEDREQUESTOTHERERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUNSUPPORTEDREQUESTOTHERERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERMASTERDATAPARITY_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0SETUSERSYSTEMERROR, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0SETUSERSYSTEMERROR_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0TRANSACTIONSPENDING, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0TRANSACTIONSPENDING_delay);
	$setuphold (posedge CRMUSERCLK, negedge L0UPSTREAMRXPORTINL0S, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0UPSTREAMRXPORTINL0S_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXCHFIFO_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXCHFIFO_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXCHTC_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXCHTC_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXCHTC_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXDSTCONTREQN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXDSTCONTREQN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKRXDSTREQN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKRXDSTREQN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTX4DWHEADERN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTX4DWHEADERN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCHFIFO[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCHFIFO_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCHFIFO[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCHFIFO_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCHTC[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCHTC_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCHTC[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCHTC_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCHTC[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCHTC_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCOMPLETEN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCOMPLETEN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXCREATEECRCN, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXCREATEECRCN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[0], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[10], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[11], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[12], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[13], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[14], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[15], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[16], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[17], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[18], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[19], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[1], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[20], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[21], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[22], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[23], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[24], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[25], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[26], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[27], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[28], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[29], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[2], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[30], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[31], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[32], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[32]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[33], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[33]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[34], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[34]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[35], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[35]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[36], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[36]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[37], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[37]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[38], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[38]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[39], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[39]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[3], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[40], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[40]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[41], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[41]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[42], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[42]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[43], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[43]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[44], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[44]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[45], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[45]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[46], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[46]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[47], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[47]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[48], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[48]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[49], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[49]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[4], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[50], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[50]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[51], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[51]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[52], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[52]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[53], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[53]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[54], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[54]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[55], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[55]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[56], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[56]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[57], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[57]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[58], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[58]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[59], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[59]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[5], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[60], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[60]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[61], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[61]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[62], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[62]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[63], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[63]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[7], 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, LLKTXDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[9]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXENABLEN[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXENABLEN_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXENABLEN[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXENABLEN_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXEOFN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXEOFN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXEOPN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXEOPN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXSOFN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSOFN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXSOPN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSOPN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXSRCDSCN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSRCDSCN_delay);
	$setuphold (posedge CRMUSERCLK, negedge LLKTXSRCRDYN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSRCRDYN_delay);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[10]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[8]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTADDR[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[9]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTBWREN[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTBWREN[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTBWREN[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTBWREN[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTRDEN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTRDEN_delay);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTSTATSCREDITSEL[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[9]);
	$setuphold (posedge CRMUSERCLK, negedge MGMTWREN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWREN_delay);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[32], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[32]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[33], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[33]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[34], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[34]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[35], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[35]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[36], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[36]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[37], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[37]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[38], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[38]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[39], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[39]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[40], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[40]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[41], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[41]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[42], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[42]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[43], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[43]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[44], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[44]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[45], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[45]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[46], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[46]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[47], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[47]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[48], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[48]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[49], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[49]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[50], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[50]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[51], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[51]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[52], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[52]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[53], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[53]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[54], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[54]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[55], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[55]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[56], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[56]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[57], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[57]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[58], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[58]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[59], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[59]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[60], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[60]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[61], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[61]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[62], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[62]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[63], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay,  MIMRXBRDATA_delay[63]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, negedge MIMRXBRDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[9]);
	$setuphold (posedge CRMUSERCLK, posedge AUXPOWER, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, AUXPOWER_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0ALLDOWNPORTSINL1, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0ALLDOWNPORTSINL1_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0ALLDOWNRXPORTSINL0S, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0ALLDOWNRXPORTSINL0S_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0ATTENTIONBUTTONPRESSED, 0:0:0, 0:0:0, notifier,,, CRMUSERCLK_delay, L0ATTENTIONBUTTONPRESSED_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0ELECTROMECHANICALINTERLOCKENGAGED, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0ELECTROMECHANICALINTERLOCKENGAGED_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDCORRERRIN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDCORRERRIN_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDDEASSERTINTALEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDDEASSERTINTALEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDDEASSERTINTBLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDDEASSERTINTBLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDDEASSERTINTCLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDDEASSERTINTCLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDDEASSERTINTDLEGACYINT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDDEASSERTINTDLEGACYINT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDFATALERRIN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDFATALERRIN_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0FWDNONFATALERRIN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0FWDNONFATALERRIN_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0LEGACYINTFUNCT0, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0LEGACYINTFUNCT0_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0MRLSENSORCLOSEDN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0MRLSENSORCLOSEDN_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0MSIREQUEST0[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0MSIREQUEST0_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge L0MSIREQUEST0[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0MSIREQUEST0_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge L0MSIREQUEST0[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0MSIREQUEST0_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge L0MSIREQUEST0[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0MSIREQUEST0_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[100], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[100]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[101], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[101]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[102], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[102]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[103], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[103]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[104], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[104]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[105], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[105]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[106], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[106]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[107], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[107]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[108], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[108]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[109], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[109]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[10]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[110], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[110]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[111], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[111]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[112], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[112]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[113], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[113]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[114], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[114]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[115], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[115]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[116], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[116]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[117], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[117]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[118], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[118]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[119], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[119]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[11]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[120], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[120]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[121], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[121]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[122], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[122]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[123], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[123]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[124], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[124]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[125], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[125]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[126], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[126]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[127], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[127]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[12]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[13]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[14]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[15]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[16]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[17]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[18]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[19]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[20]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[21]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[22]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[23]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[24]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[25]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[26]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[27]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[28]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[29]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[30]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[31]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[32], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[32]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[33], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[33]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[34], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[34]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[35], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[35]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[36], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[36]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[37], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[37]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[38], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[38]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[39], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[39]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[40], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[40]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[41], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[41]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[42], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[42]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[43], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[43]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[44], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[44]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[45], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[45]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[46], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[46]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[47], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[47]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[48], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[48]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[49], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[49]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[50], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[50]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[51], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[51]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[52], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[52]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[53], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[53]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[54], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[54]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[55], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[55]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[56], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[56]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[57], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[57]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[58], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[58]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[59], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[59]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[60], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[60]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[61], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[61]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[62], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[62]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[63], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[63]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[64], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[64]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[65], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[65]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[66], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[66]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[67], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[67]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[68], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[68]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[69], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[69]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[70], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[70]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[71], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[71]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[72], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[72]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[73], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[73]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[74], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[74]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[75], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[75]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[76], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[76]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[77], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[77]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[78], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[78]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[79], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[79]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[80], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[80]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[81], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[81]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[82], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[82]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[83], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[83]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[84], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[84]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[85], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[85]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[86], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[86]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[87], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[87]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[88], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[88]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[89], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[89]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[8]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[90], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[90]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[91], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[91]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[92], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[92]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[93], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[93]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[94], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[94]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[95], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[95]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[96], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[96]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[97], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[97]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[98], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[98]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[99], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[99]);
	$setuphold (posedge CRMUSERCLK, posedge L0PACKETHEADERFROMUSER[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PACKETHEADERFROMUSER_delay[9]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge L0PORTNUMBER[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PORTNUMBER_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge L0POWERFAULTDETECTED, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0POWERFAULTDETECTED_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0PRESENCEDETECTSLOTEMPTYN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0PRESENCEDETECTSLOTEMPTYN_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0ROOTTURNOFFREQ, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0ROOTTURNOFFREQ_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SENDUNLOCKMESSAGE, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SENDUNLOCKMESSAGE_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETCOMPLETERABORTERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETCOMPLETERABORTERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETCOMPLETIONTIMEOUTCORRERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETCOMPLETIONTIMEOUTCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETCOMPLETIONTIMEOUTUNCORRERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETCOMPLETIONTIMEOUTUNCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETDETECTEDCORRERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETDETECTEDCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETDETECTEDFATALERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETDETECTEDFATALERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETDETECTEDNONFATALERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETDETECTEDNONFATALERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKMASTERDATAPARITY_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETLINKSYSTEMERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETLINKSYSTEMERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUNEXPECTEDCOMPLETIONCORRERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUNEXPECTEDCOMPLETIONCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUNEXPECTEDCOMPLETIONUNCORRERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUNSUPPORTEDREQUESTOTHERERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUNSUPPORTEDREQUESTOTHERERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERDETECTEDPARITYERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERDETECTEDPARITYERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERMASTERDATAPARITY, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERMASTERDATAPARITY_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERRECEIVEDMASTERABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERRECEIVEDMASTERABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERRECEIVEDTARGETABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERRECEIVEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERSIGNALLEDTARGETABORT, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERSIGNALLEDTARGETABORT_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0SETUSERSYSTEMERROR, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0SETUSERSYSTEMERROR_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0TRANSACTIONSPENDING, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0TRANSACTIONSPENDING_delay);
	$setuphold (posedge CRMUSERCLK, posedge L0UPSTREAMRXPORTINL0S, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, L0UPSTREAMRXPORTINL0S_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXCHFIFO[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXCHFIFO_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXCHFIFO[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXCHFIFO_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXCHTC[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXCHTC_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXCHTC[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXCHTC_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXCHTC[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXCHTC_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXDSTCONTREQN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXDSTCONTREQN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKRXDSTREQN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKRXDSTREQN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTX4DWHEADERN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTX4DWHEADERN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCHFIFO[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCHFIFO_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCHFIFO[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCHFIFO_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCHTC[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCHTC_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCHTC[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCHTC_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCHTC[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCHTC_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCOMPLETEN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCOMPLETEN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXCREATEECRCN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXCREATEECRCN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[32], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[32]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[33], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[33]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[34], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[34]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[35], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[35]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[36], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[36]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[37], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[37]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[38], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[38]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[39], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[39]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[40], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[40]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[41], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[41]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[42], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[42]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[43], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[43]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[44], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[44]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[45], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[45]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[46], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[46]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[47], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[47]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[48], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[48]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[49], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[49]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[50], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[50]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[51], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[51]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[52], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[52]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[53], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[53]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[54], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[54]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[55], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[55]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[56], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[56]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[57], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[57]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[58], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[58]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[59], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[59]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[60], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[60]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[61], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[61]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[62], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[62]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[63], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[63]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXDATA_delay[9]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXENABLEN[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXENABLEN_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXENABLEN[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXENABLEN_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXEOFN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXEOFN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXEOPN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXEOPN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXSOFN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSOFN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXSOPN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSOPN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXSRCDSCN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSRCDSCN_delay);
	$setuphold (posedge CRMUSERCLK, posedge LLKTXSRCRDYN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, LLKTXSRCRDYN_delay);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[10]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[8]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTADDR[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTADDR_delay[9]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTBWREN[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTBWREN[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTBWREN[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTBWREN[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTBWREN_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTRDEN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTRDEN_delay);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTSTATSCREDITSEL[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTSTATSCREDITSEL_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWDATA_delay[9]);
	$setuphold (posedge CRMUSERCLK, posedge MGMTWREN, 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MGMTWREN_delay);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[0], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[0]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[10], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[10]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[11], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[11]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[12], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[12]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[13], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[13]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[14], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[14]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[15], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[15]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[16], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[16]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[17], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[17]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[18], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[18]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[19], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[19]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[1], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[1]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[20], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[20]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[21], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[21]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[22], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[22]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[23], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[23]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[24], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[24]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[25], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[25]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[26], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[26]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[27], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[27]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[28], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[28]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[29], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[29]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[2], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[2]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[30], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[30]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[31], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[31]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[32], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[32]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[33], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[33]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[34], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[34]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[35], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[35]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[36], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[36]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[37], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[37]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[38], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[38]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[39], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[39]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[3], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[3]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[40], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[40]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[41], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[41]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[42], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[42]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[43], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[43]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[44], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[44]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[45], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[45]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[46], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[46]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[47], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[47]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[48], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[48]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[49], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[49]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[4], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[4]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[50], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[50]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[51], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[51]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[52], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[52]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[53], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[53]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[54], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[54]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[55], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[55]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[56], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[56]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[57], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[57]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[58], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[58]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[59], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[59]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[5], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[5]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[60], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[60]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[61], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[61]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[62], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[62]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[63], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[63]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[6], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[6]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[7], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[7]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[8], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[8]);
	$setuphold (posedge CRMUSERCLK, posedge MIMRXBRDATA[9], 0:0:0, 0:0:0, notifier,,,  CRMUSERCLK_delay, MIMRXBRDATA_delay[9]);
       
	(CRMCORECLK => BUSMASTERENABLE) = (100:100:100, 100:100:100);
	(CRMCORECLK => CRMDOHOTRESETN) = (100:100:100, 100:100:100);
	(CRMCORECLK => CRMPWRSOFTRESETN) = (100:100:100, 100:100:100);
	(CRMCORECLK => CRMRXHOTRESETN) = (100:100:100, 100:100:100);
	(CRMCORECLK => DLLTXPMDLLPOUTSTANDING) = (100:100:100, 100:100:100);
	(CRMCORECLK => INTERRUPTDISABLE) = (100:100:100, 100:100:100);
	(CRMCORECLK => IOSPACEENABLE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ASAUTONOMOUSINITCOMPLETED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ATTENTIONINDICATORCONTROL[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ATTENTIONINDICATORCONTROL[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0CFGLOOPBACKACK) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0COMPLETERID[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0CORRERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLASRXSTATE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLASRXSTATE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLASTXSTATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLERRORVECTOR[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLRXACKOUTSTANDING) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLTXNONFCOUTSTANDING) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLTXOUTSTANDING) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLLVCSTATUS[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0DLUPDOWN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0ERRMSGREQID[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0FATALERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0FIRSTCFGWRITEOCCURRED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0FWDCORRERROUT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0FWDFATALERROUT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0FWDNONFATALERROUT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0LTSSMSTATE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0LTSSMSTATE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0LTSSMSTATE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0LTSSMSTATE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACENTEREDL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACLINKTRAINING) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACLINKUP) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACNEGOTIATEDLINKWIDTH[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACNEGOTIATEDLINKWIDTH[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACNEGOTIATEDLINKWIDTH[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACNEGOTIATEDLINKWIDTH[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACNEWSTATEACK) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACRXL0SSTATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MACUPSTREAMDOWNSTREAM) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MCFOUND[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MCFOUND[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MCFOUND[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MSIENABLE0) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MULTIMSGEN0[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MULTIMSGEN0[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0MULTIMSGEN0[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0NONFATALERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PMEACK) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PMEEN) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PMEREQOUT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0POWERCONTROLLERCONTROL) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0POWERINDICATORCONTROL[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0POWERINDICATORCONTROL[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRINHIBITTRANSFERS) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRL1STATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRL23READYDEVICE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRL23READYSTATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRSTATE0[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRSTATE0[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRTURNOFFREQ) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0PWRTXL0SSTATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDASSERTINTALEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDASSERTINTBLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDASSERTINTCLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDASSERTINTDLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTALEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTBLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTCLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RECEIVEDDEASSERTINTDLEGACYINT) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXBEACON) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[19]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[20]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[21]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[22]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[23]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCCRED[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCCMPLMCUPDATE[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[19]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPCRED[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCNPOSTBYPUPDATE[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[19]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[20]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[21]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[22]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[23]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDCRED[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLFCPOSTORDUPDATE[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLPM) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLPMTYPE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLPMTYPE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLPMTYPE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLSBFCUPDATE) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLTLPECRCOK) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLTLPEND[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXDLLTLPEND[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXMACLINKERROR[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0RXMACLINKERROR[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSCFGOTHERRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSCFGOTHERTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSCFGRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSCFGTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSDLLPRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSDLLPTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSOSRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSOSTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSTLPRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0STATSTLPTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TOGGLEELECTROMECHANICALINTERLOCK) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TRANSFORMEDVC[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TRANSFORMEDVC[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TRANSFORMEDVC[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCCMPLMCUPDATED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCNPOSTBYPUPDATED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLFCPOSTORDUPDATED[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLPMUPDATED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0TXDLLSBFCUPDATED) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCBYPFOUND[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCBYPFOUND[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCBYPFOUND[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCBYPFOUND[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCORDFOUND[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCORDFOUND[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCORDFOUND[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UCORDFOUND[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => L0UNLOCKRECEIVED) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRX4DWHEADERN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCOMPLETIONPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCONFIGAVAILABLEN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHCONFIGPARTIALN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHNONPOSTEDPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXCHPOSTEDPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[19]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[20]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[21]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[22]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[23]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[24]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[25]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[26]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[27]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[28]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[29]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[30]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[31]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[32]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[33]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[34]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[35]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[36]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[37]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[38]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[39]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[40]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[41]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[42]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[43]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[44]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[45]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[46]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[47]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[48]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[49]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[50]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[51]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[52]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[53]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[54]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[55]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[56]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[57]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[58]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[59]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[60]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[61]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[62]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[63]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXECRCBADN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXEOFN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXEOPN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXPREFERREDTYPE[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXSOFN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXSOPN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXSRCDSCN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXSRCLASTREQN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXSRCRDYN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXVALIDN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKRXVALIDN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTCSTATUS[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHANSPACE[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHCOMPLETIONREADYN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHNONPOSTEDREADYN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCHPOSTEDREADYN[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXCONFIGREADYN) = (100:100:100, 100:100:100);
	(CRMCORECLK => LLKTXDSTRDYN) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXPAYLOADSIZE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXPAYLOADSIZE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXPAYLOADSIZE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXREADREQUESTSIZE[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXREADREQUESTSIZE[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MAXREADREQUESTSIZE[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MEMSPACEENABLE) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTPSO[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[19]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[20]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[21]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[22]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[23]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[24]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[25]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[26]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[27]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[28]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[29]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[30]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[31]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTRDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[10]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[11]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[8]) = (100:100:100, 100:100:100);
	(CRMCORECLK => MGMTSTATSCREDIT[9]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PARITYERRORRESPONSE) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEDESKEWLANESL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL0[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL0[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL1[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL1[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL2[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL2[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL3[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL3[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL4[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL4[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL5[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL5[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL6[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL6[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL7[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPEPOWERDOWNL7[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERESETL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPERXPOLARITYL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXCOMPLIANCEL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAKL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL0[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL1[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL2[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL3[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL4[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL5[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL6[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[0]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[1]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[2]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[3]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[4]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[5]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[6]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDATAL7[7]) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXDETECTRXLOOPBACKL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL0) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL1) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL2) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL3) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL4) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL5) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL6) = (100:100:100, 100:100:100);
	(CRMCORECLK => PIPETXELECIDLEL7) = (100:100:100, 100:100:100);
	(CRMCORECLK => SERRENABLE) = (100:100:100, 100:100:100);
	(CRMCORECLK => URREPORTINGENABLE) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBRADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBREN) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[19]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[20]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[21]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[22]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[23]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[24]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[25]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[26]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[27]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[28]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[29]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[30]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[31]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[32]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[33]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[34]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[35]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[36]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[37]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[38]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[39]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[40]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[41]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[42]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[43]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[44]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[45]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[46]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[47]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[48]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[49]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[50]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[51]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[52]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[53]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[54]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[55]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[56]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[57]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[58]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[59]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[60]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[61]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[62]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[63]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKDLO => MIMDLLBWEN) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBRADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBREN) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[19]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[20]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[21]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[22]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[23]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[24]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[25]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[26]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[27]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[28]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[29]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[30]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[31]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[32]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[33]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[34]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[35]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[36]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[37]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[38]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[39]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[40]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[41]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[42]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[43]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[44]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[45]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[46]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[47]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[48]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[49]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[50]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[51]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[52]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[53]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[54]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[55]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[56]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[57]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[58]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[59]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[60]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[61]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[62]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[63]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKRXO => MIMRXBWEN) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBRADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBREN) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWADD[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[0]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[10]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[11]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[12]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[13]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[14]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[15]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[16]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[17]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[18]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[19]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[1]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[20]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[21]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[22]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[23]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[24]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[25]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[26]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[27]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[28]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[29]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[2]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[30]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[31]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[32]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[33]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[34]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[35]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[36]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[37]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[38]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[39]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[3]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[40]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[41]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[42]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[43]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[44]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[45]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[46]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[47]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[48]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[49]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[4]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[50]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[51]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[52]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[53]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[54]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[55]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[56]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[57]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[58]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[59]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[5]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[60]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[61]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[62]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[63]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[6]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[7]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[8]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWDATA[9]) = (100:100:100, 100:100:100);
	(CRMCORECLKTXO => MIMTXBWEN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => BUSMASTERENABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => INTERRUPTDISABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => IOSPACEENABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ATTENTIONINDICATORCONTROL[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ATTENTIONINDICATORCONTROL[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0COMPLETERID[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0CORRERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0ERRMSGREQID[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0FATALERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0FIRSTCFGWRITEOCCURRED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0FWDCORRERROUT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0FWDFATALERROUT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0FWDNONFATALERROUT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0MSIENABLE0) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0MULTIMSGEN0[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0MULTIMSGEN0[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0MULTIMSGEN0[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0NONFATALERRMSGRCVD) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PMEACK) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PMEEN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PMEREQOUT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0POWERCONTROLLERCONTROL) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0POWERINDICATORCONTROL[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0POWERINDICATORCONTROL[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRL1STATE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRL23READYDEVICE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRL23READYSTATE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRSTATE0[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRSTATE0[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRTURNOFFREQ) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0PWRTXL0SSTATE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTALEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTBLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTCLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDASSERTINTDLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTALEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTBLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTCLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0RECEIVEDDEASSERTINTDLEGACYINT) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0STATSCFGOTHERRECEIVED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0STATSCFGOTHERTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0STATSCFGRECEIVED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0STATSCFGTRANSMITTED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0TOGGLEELECTROMECHANICALINTERLOCK) = (100:100:100, 100:100:100);
	(CRMUSERCLK => L0UNLOCKRECEIVED) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRX4DWHEADERN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCOMPLETIONPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCONFIGAVAILABLEN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHCONFIGPARTIALN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHNONPOSTEDPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDAVAILABLEN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXCHPOSTEDPARTIALN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[16]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[17]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[18]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[19]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[20]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[21]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[22]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[23]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[24]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[25]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[26]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[27]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[28]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[29]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[30]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[31]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[32]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[33]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[34]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[35]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[36]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[37]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[38]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[39]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[40]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[41]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[42]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[43]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[44]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[45]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[46]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[47]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[48]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[49]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[50]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[51]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[52]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[53]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[54]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[55]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[56]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[57]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[58]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[59]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[60]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[61]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[62]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[63]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXDATA[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXECRCBADN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXEOFN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXEOPN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXPREFERREDTYPE[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXSOFN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXSOPN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXSRCDSCN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXSRCLASTREQN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXSRCRDYN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXVALIDN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKRXVALIDN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTCSTATUS[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHANSPACE[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHCOMPLETIONREADYN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHNONPOSTEDREADYN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCHPOSTEDREADYN[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXCONFIGREADYN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => LLKTXDSTRDYN) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXPAYLOADSIZE[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXPAYLOADSIZE[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXPAYLOADSIZE[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXREADREQUESTSIZE[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXREADREQUESTSIZE[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MAXREADREQUESTSIZE[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MEMSPACEENABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[16]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTPSO[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[16]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[17]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[18]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[19]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[20]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[21]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[22]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[23]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[24]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[25]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[26]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[27]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[28]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[29]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[30]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[31]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTRDATA[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => MGMTSTATSCREDIT[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLK => PARITYERRORRESPONSE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => SERRENABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLK => URREPORTINGENABLE) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBRADD[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLKRXO => MIMRXBREN) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWADD[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[0]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[10]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[11]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[12]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[13]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[14]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[15]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[16]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[17]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[18]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[19]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[1]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[20]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[21]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[22]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[23]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[24]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[25]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[26]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[27]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[28]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[29]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[2]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[30]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[31]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[32]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[33]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[34]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[35]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[36]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[37]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[38]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[39]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[3]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[40]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[41]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[42]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[43]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[44]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[45]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[46]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[47]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[48]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[49]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[4]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[50]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[51]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[52]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[53]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[54]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[55]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[56]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[57]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[58]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[59]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[5]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[60]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[61]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[62]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[63]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[6]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[7]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[8]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWDATA[9]) = (100:100:100, 100:100:100);
	(CRMUSERCLKTXO => MIMTXBWEN) = (100:100:100, 100:100:100);
	(L0WAKEN => L0RXBEACON) = (0:0:0, 0:0:0);
	(MAINPOWER => L0PMEEN) = (0:0:0, 0:0:0);
	(MAINPOWER => L0PMEREQOUT) = (0:0:0, 0:0:0);
	(MAINPOWER => L0RXBEACON) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL0[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL0[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL1[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL1[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL2[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL2[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL3[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL3[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL4[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL4[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL5[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL5[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL6[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL6[1]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL7[0]) = (0:0:0, 0:0:0);
	(MAINPOWER => PIPEPOWERDOWNL7[1]) = (0:0:0, 0:0:0);

	specparam PATHPULSE$ = 0;
endspecify
endmodule
